package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyRequest;
import odata.msgraph.client.beta.enums.WindowsDefenderApplicationControlSupplementalPolicyStatuses;


/**
 * <i>“Contains properties for the deployment state of a
 * WindowsDefenderApplicationControl supplemental policy for a device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceName", 
    "deviceId", 
    "lastSyncDateTime", 
    "osVersion", 
    "osDescription", 
    "deploymentStatus", 
    "userName", 
    "userPrincipalName", 
    "policyVersion"})
@JsonInclude(Include.NON_NULL)
public class WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus";
    }

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("osVersion")
    protected String osVersion;

    @JsonProperty("osDescription")
    protected String osDescription;

    @JsonProperty("deploymentStatus")
    protected WindowsDefenderApplicationControlSupplementalPolicyStatuses deploymentStatus;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("policyVersion")
    protected String policyVersion;

    protected WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceName;
        private String deviceId;
        private OffsetDateTime lastSyncDateTime;
        private String osVersion;
        private String osDescription;
        private WindowsDefenderApplicationControlSupplementalPolicyStatuses deploymentStatus;
        private String userName;
        private String userPrincipalName;
        private String policyVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Device ID.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“Last sync date time.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Windows OS Version.”</i>
         * 
         * @param osVersion
         *            value of {@code osVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        /**
         * <i>“Windows OS Version Description.”</i>
         * 
         * @param osDescription
         *            value of {@code osDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osDescription(String osDescription) {
            this.osDescription = osDescription;
            this.changedFields = changedFields.add("osDescription");
            return this;
        }

        /**
         * <i>“The deployment state of the policy.”</i>
         * 
         * @param deploymentStatus
         *            value of {@code deploymentStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentStatus(WindowsDefenderApplicationControlSupplementalPolicyStatuses deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            this.changedFields = changedFields.add("deploymentStatus");
            return this;
        }

        /**
         * <i>“The name of the user of this device.”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“User Principal Name.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Human readable version of the WindowsDefenderApplicationControl supplemental
         * policy.”</i>
         * 
         * @param policyVersion
         *            value of {@code policyVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            this.changedFields = changedFields.add("policyVersion");
            return this;
        }

        public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus build() {
            WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus";
            _x.id = id;
            _x.deviceName = deviceName;
            _x.deviceId = deviceId;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.osVersion = osVersion;
            _x.osDescription = osDescription;
            _x.deploymentStatus = deploymentStatus;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            _x.policyVersion = policyVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withDeviceName(String deviceName) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Device ID.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device ID.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withDeviceId(String deviceId) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“Last sync date time.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last sync date time.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Windows OS Version.”</i>
     * 
     * @return property osVersion
     */
    @Property(name="osVersion")
    @JsonIgnore
    public Optional<String> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows OS Version.”</i>
     * 
     * @param osVersion
     *            new value of {@code osVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osVersion} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withOsVersion(String osVersion) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.osVersion = osVersion;
        return _x;
    }

    /**
     * <i>“Windows OS Version Description.”</i>
     * 
     * @return property osDescription
     */
    @Property(name="osDescription")
    @JsonIgnore
    public Optional<String> getOsDescription() {
        return Optional.ofNullable(osDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Windows OS Version Description.”</i>
     * 
     * @param osDescription
     *            new value of {@code osDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osDescription} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withOsDescription(String osDescription) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("osDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.osDescription = osDescription;
        return _x;
    }

    /**
     * <i>“The deployment state of the policy.”</i>
     * 
     * @return property deploymentStatus
     */
    @Property(name="deploymentStatus")
    @JsonIgnore
    public Optional<WindowsDefenderApplicationControlSupplementalPolicyStatuses> getDeploymentStatus() {
        return Optional.ofNullable(deploymentStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deploymentStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The deployment state of the policy.”</i>
     * 
     * @param deploymentStatus
     *            new value of {@code deploymentStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentStatus} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withDeploymentStatus(WindowsDefenderApplicationControlSupplementalPolicyStatuses deploymentStatus) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("deploymentStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.deploymentStatus = deploymentStatus;
        return _x;
    }

    /**
     * <i>“The name of the user of this device.”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the user of this device.”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withUserName(String userName) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“User Principal Name.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withUserPrincipalName(String userPrincipalName) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Human readable version of the WindowsDefenderApplicationControl supplemental
     * policy.”</i>
     * 
     * @return property policyVersion
     */
    @Property(name="policyVersion")
    @JsonIgnore
    public Optional<String> getPolicyVersion() {
        return Optional.ofNullable(policyVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Human readable version of the WindowsDefenderApplicationControl supplemental
     * policy.”</i>
     * 
     * @param policyVersion
     *            new value of {@code policyVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyVersion} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus withPolicyVersion(String policyVersion) {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = changedFields.add("policyVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyDeploymentStatus");
        _x.policyVersion = policyVersion;
        return _x;
    }

    /**
     * <i>“The navigation link to the WindowsDefenderApplicationControl supplemental policy
     * .”</i>
     * 
     * @return navigational property policy
     */
    @NavigationProperty(name="policy")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyRequest getPolicy() {
        return new WindowsDefenderApplicationControlSupplementalPolicyRequest(contextPath.addSegment("policy"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _copy() {
        WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus _x = new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceName = deviceName;
        _x.deviceId = deviceId;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.osVersion = osVersion;
        _x.osDescription = osDescription;
        _x.deploymentStatus = deploymentStatus;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        _x.policyVersion = policyVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("osDescription=");
        b.append(this.osDescription);
        b.append(", ");
        b.append("deploymentStatus=");
        b.append(this.deploymentStatus);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("policyVersion=");
        b.append(this.policyVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
