package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "content", 
    "contentFileName", 
    "version", 
    "creationDateTime", 
    "lastModifiedDateTime", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class WindowsDefenderApplicationControlSupplementalPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("content")
    protected byte[] content;

    @JsonProperty("contentFileName")
    protected String contentFileName;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected WindowsDefenderApplicationControlSupplementalPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDefenderApplicationControlSupplementalPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private byte[] content;
        private String contentFileName;
        private String version;
        private OffsetDateTime creationDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The display name of WindowsDefenderApplicationControl supplemental policy.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The description of WindowsDefenderApplicationControl supplemental policy.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The WindowsDefenderApplicationControl supplemental policy content in byte array
         * format.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(byte[] content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        /**
         * <i>“The WindowsDefenderApplicationControl supplemental policy content's file name.”</i>
         * 
         * @param contentFileName
         *            value of {@code contentFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contentFileName(String contentFileName) {
            this.contentFileName = contentFileName;
            this.changedFields = changedFields.add("contentFileName");
            return this;
        }

        /**
         * <i>“The WindowsDefenderApplicationControl supplemental policy's version.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
         * was uploaded.”</i>
         * 
         * @param creationDateTime
         *            value of {@code creationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        /**
         * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
         * was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this WindowsDefenderApplicationControl supplemental
         * policy entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this WindowsDefenderApplicationControl supplemental
         * policy entity.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this WindowsDefenderApplicationControl supplemental
         * policy entity.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public WindowsDefenderApplicationControlSupplementalPolicy build() {
            WindowsDefenderApplicationControlSupplementalPolicy _x = new WindowsDefenderApplicationControlSupplementalPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.content = content;
            _x.contentFileName = contentFileName;
            _x.version = version;
            _x.creationDateTime = creationDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The display name of WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withDisplayName(String displayName) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The description of WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of WindowsDefenderApplicationControl supplemental policy.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withDescription(String description) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The WindowsDefenderApplicationControl supplemental policy content in byte array
     * format.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<byte[]> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The WindowsDefenderApplicationControl supplemental policy content in byte array
     * format.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withContent(byte[] content) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.content = content;
        return _x;
    }

    /**
     * <i>“The WindowsDefenderApplicationControl supplemental policy content's file name.”</i>
     * 
     * @return property contentFileName
     */
    @Property(name="contentFileName")
    @JsonIgnore
    public Optional<String> getContentFileName() {
        return Optional.ofNullable(contentFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contentFileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The WindowsDefenderApplicationControl supplemental policy content's file name.”</i>
     * 
     * @param contentFileName
     *            new value of {@code contentFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contentFileName} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withContentFileName(String contentFileName) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("contentFileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.contentFileName = contentFileName;
        return _x;
    }

    /**
     * <i>“The WindowsDefenderApplicationControl supplemental policy's version.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The WindowsDefenderApplicationControl supplemental policy's version.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withVersion(String version) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
     * was uploaded.”</i>
     * 
     * @return property creationDateTime
     */
    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creationDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
     * was uploaded.”</i>
     * 
     * @param creationDateTime
     *            new value of {@code creationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creationDateTime} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withCreationDateTime(OffsetDateTime creationDateTime) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    /**
     * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
     * was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time when the WindowsDefenderApplicationControl supplemental policy
     * was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public WindowsDefenderApplicationControlSupplementalPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderApplicationControlSupplementalPolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this WindowsDefenderApplicationControl supplemental
     * policy entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this WindowsDefenderApplicationControl supplemental
     * policy entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The associated group assignments for this WindowsDefenderApplicationControl
     * supplemental policy.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest getAssignments() {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“WindowsDefenderApplicationControl supplemental policy deployment summary.”</i>
     * 
     * @return navigational property deploySummary
     */
    @NavigationProperty(name="deploySummary")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest getDeploySummary() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest(contextPath.addSegment("deploySummary"));
    }

    /**
     * <i>“The list of device deployment states for this WindowsDefenderApplicationControl
     * supplemental policy.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest getDeviceStatuses() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderApplicationControlSupplementalPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderApplicationControlSupplementalPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDefenderApplicationControlSupplementalPolicy _copy() {
        WindowsDefenderApplicationControlSupplementalPolicy _x = new WindowsDefenderApplicationControlSupplementalPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.content = content;
        _x.contentFileName = contentFileName;
        _x.version = version;
        _x.creationDateTime = creationDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<WindowsDefenderApplicationControlSupplementalPolicyAssignment> wdacPolicyAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("wdacPolicyAssignments", "Collection(microsoft.graph.windowsDefenderApplicationControlSupplementalPolicyAssignment)", wdacPolicyAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDefenderApplicationControlSupplementalPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("contentFileName=");
        b.append(this.contentFileName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
