package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;


/**
 * <i>“Windows Defender AdvancedThreatProtection Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "advancedThreatProtectionOnboardingBlob", 
    "advancedThreatProtectionOnboardingFilename", 
    "advancedThreatProtectionAutoPopulateOnboardingBlob", 
    "allowSampleSharing", 
    "enableExpeditedTelemetryReporting", 
    "advancedThreatProtectionOffboardingBlob", 
    "advancedThreatProtectionOffboardingFilename"})
@JsonInclude(Include.NON_NULL)
public class WindowsDefenderAdvancedThreatProtectionConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration";
    }

    @JsonProperty("advancedThreatProtectionOnboardingBlob")
    protected String advancedThreatProtectionOnboardingBlob;

    @JsonProperty("advancedThreatProtectionOnboardingFilename")
    protected String advancedThreatProtectionOnboardingFilename;

    @JsonProperty("advancedThreatProtectionAutoPopulateOnboardingBlob")
    protected Boolean advancedThreatProtectionAutoPopulateOnboardingBlob;

    @JsonProperty("allowSampleSharing")
    protected Boolean allowSampleSharing;

    @JsonProperty("enableExpeditedTelemetryReporting")
    protected Boolean enableExpeditedTelemetryReporting;

    @JsonProperty("advancedThreatProtectionOffboardingBlob")
    protected String advancedThreatProtectionOffboardingBlob;

    @JsonProperty("advancedThreatProtectionOffboardingFilename")
    protected String advancedThreatProtectionOffboardingFilename;

    protected WindowsDefenderAdvancedThreatProtectionConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDefenderAdvancedThreatProtectionConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String advancedThreatProtectionOnboardingBlob;
        private String advancedThreatProtectionOnboardingFilename;
        private Boolean advancedThreatProtectionAutoPopulateOnboardingBlob;
        private Boolean allowSampleSharing;
        private Boolean enableExpeditedTelemetryReporting;
        private String advancedThreatProtectionOffboardingBlob;
        private String advancedThreatProtectionOffboardingFilename;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Windows Defender AdvancedThreatProtection Onboarding Blob.”</i>
         * 
         * @param advancedThreatProtectionOnboardingBlob
         *            value of {@code advancedThreatProtectionOnboardingBlob} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionOnboardingBlob(String advancedThreatProtectionOnboardingBlob) {
            this.advancedThreatProtectionOnboardingBlob = advancedThreatProtectionOnboardingBlob;
            this.changedFields = changedFields.add("advancedThreatProtectionOnboardingBlob");
            return this;
        }

        /**
         * <i>“Name of the file from which AdvancedThreatProtectionOnboardingBlob was obtained.”</i>
         * 
         * @param advancedThreatProtectionOnboardingFilename
         *            value of {@code advancedThreatProtectionOnboardingFilename} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionOnboardingFilename(String advancedThreatProtectionOnboardingFilename) {
            this.advancedThreatProtectionOnboardingFilename = advancedThreatProtectionOnboardingFilename;
            this.changedFields = changedFields.add("advancedThreatProtectionOnboardingFilename");
            return this;
        }

        /**
         * <i>“Auto populate onboarding blob programmatically from Advanced Threat protection
         * service”</i>
         * 
         * @param advancedThreatProtectionAutoPopulateOnboardingBlob
         *            value of {@code advancedThreatProtectionAutoPopulateOnboardingBlob} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionAutoPopulateOnboardingBlob(Boolean advancedThreatProtectionAutoPopulateOnboardingBlob) {
            this.advancedThreatProtectionAutoPopulateOnboardingBlob = advancedThreatProtectionAutoPopulateOnboardingBlob;
            this.changedFields = changedFields.add("advancedThreatProtectionAutoPopulateOnboardingBlob");
            return this;
        }

        /**
         * <i>“Windows Defender AdvancedThreatProtection "Allow Sample Sharing" Rule”</i>
         * 
         * @param allowSampleSharing
         *            value of {@code allowSampleSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowSampleSharing(Boolean allowSampleSharing) {
            this.allowSampleSharing = allowSampleSharing;
            this.changedFields = changedFields.add("allowSampleSharing");
            return this;
        }

        /**
         * <i>“Expedite Windows Defender Advanced Threat Protection telemetry reporting
         * frequency.”</i>
         * 
         * @param enableExpeditedTelemetryReporting
         *            value of {@code enableExpeditedTelemetryReporting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableExpeditedTelemetryReporting(Boolean enableExpeditedTelemetryReporting) {
            this.enableExpeditedTelemetryReporting = enableExpeditedTelemetryReporting;
            this.changedFields = changedFields.add("enableExpeditedTelemetryReporting");
            return this;
        }

        /**
         * <i>“Windows Defender AdvancedThreatProtection Offboarding Blob.”</i>
         * 
         * @param advancedThreatProtectionOffboardingBlob
         *            value of {@code advancedThreatProtectionOffboardingBlob} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionOffboardingBlob(String advancedThreatProtectionOffboardingBlob) {
            this.advancedThreatProtectionOffboardingBlob = advancedThreatProtectionOffboardingBlob;
            this.changedFields = changedFields.add("advancedThreatProtectionOffboardingBlob");
            return this;
        }

        /**
         * <i>“Name of the file from which AdvancedThreatProtectionOffboardingBlob was obtained
         * .”</i>
         * 
         * @param advancedThreatProtectionOffboardingFilename
         *            value of {@code advancedThreatProtectionOffboardingFilename} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionOffboardingFilename(String advancedThreatProtectionOffboardingFilename) {
            this.advancedThreatProtectionOffboardingFilename = advancedThreatProtectionOffboardingFilename;
            this.changedFields = changedFields.add("advancedThreatProtectionOffboardingFilename");
            return this;
        }

        public WindowsDefenderAdvancedThreatProtectionConfiguration build() {
            WindowsDefenderAdvancedThreatProtectionConfiguration _x = new WindowsDefenderAdvancedThreatProtectionConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.advancedThreatProtectionOnboardingBlob = advancedThreatProtectionOnboardingBlob;
            _x.advancedThreatProtectionOnboardingFilename = advancedThreatProtectionOnboardingFilename;
            _x.advancedThreatProtectionAutoPopulateOnboardingBlob = advancedThreatProtectionAutoPopulateOnboardingBlob;
            _x.allowSampleSharing = allowSampleSharing;
            _x.enableExpeditedTelemetryReporting = enableExpeditedTelemetryReporting;
            _x.advancedThreatProtectionOffboardingBlob = advancedThreatProtectionOffboardingBlob;
            _x.advancedThreatProtectionOffboardingFilename = advancedThreatProtectionOffboardingFilename;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Windows Defender AdvancedThreatProtection Onboarding Blob.”</i>
     * 
     * @return property advancedThreatProtectionOnboardingBlob
     */
    @Property(name="advancedThreatProtectionOnboardingBlob")
    @JsonIgnore
    public Optional<String> getAdvancedThreatProtectionOnboardingBlob() {
        return Optional.ofNullable(advancedThreatProtectionOnboardingBlob);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionOnboardingBlob} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows Defender AdvancedThreatProtection Onboarding Blob.”</i>
     * 
     * @param advancedThreatProtectionOnboardingBlob
     *            new value of {@code advancedThreatProtectionOnboardingBlob} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionOnboardingBlob} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAdvancedThreatProtectionOnboardingBlob(String advancedThreatProtectionOnboardingBlob) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOnboardingBlob");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.advancedThreatProtectionOnboardingBlob = advancedThreatProtectionOnboardingBlob;
        return _x;
    }

    /**
     * <i>“Name of the file from which AdvancedThreatProtectionOnboardingBlob was obtained.”</i>
     * 
     * @return property advancedThreatProtectionOnboardingFilename
     */
    @Property(name="advancedThreatProtectionOnboardingFilename")
    @JsonIgnore
    public Optional<String> getAdvancedThreatProtectionOnboardingFilename() {
        return Optional.ofNullable(advancedThreatProtectionOnboardingFilename);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionOnboardingFilename} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Name of the file from which AdvancedThreatProtectionOnboardingBlob was obtained.”</i>
     * 
     * @param advancedThreatProtectionOnboardingFilename
     *            new value of {@code advancedThreatProtectionOnboardingFilename} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionOnboardingFilename} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAdvancedThreatProtectionOnboardingFilename(String advancedThreatProtectionOnboardingFilename) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOnboardingFilename");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.advancedThreatProtectionOnboardingFilename = advancedThreatProtectionOnboardingFilename;
        return _x;
    }

    /**
     * <i>“Auto populate onboarding blob programmatically from Advanced Threat protection
     * service”</i>
     * 
     * @return property advancedThreatProtectionAutoPopulateOnboardingBlob
     */
    @Property(name="advancedThreatProtectionAutoPopulateOnboardingBlob")
    @JsonIgnore
    public Optional<Boolean> getAdvancedThreatProtectionAutoPopulateOnboardingBlob() {
        return Optional.ofNullable(advancedThreatProtectionAutoPopulateOnboardingBlob);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionAutoPopulateOnboardingBlob} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Auto populate onboarding blob programmatically from Advanced Threat protection
     * service”</i>
     * 
     * @param advancedThreatProtectionAutoPopulateOnboardingBlob
     *            new value of {@code advancedThreatProtectionAutoPopulateOnboardingBlob} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionAutoPopulateOnboardingBlob} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAdvancedThreatProtectionAutoPopulateOnboardingBlob(Boolean advancedThreatProtectionAutoPopulateOnboardingBlob) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionAutoPopulateOnboardingBlob");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.advancedThreatProtectionAutoPopulateOnboardingBlob = advancedThreatProtectionAutoPopulateOnboardingBlob;
        return _x;
    }

    /**
     * <i>“Windows Defender AdvancedThreatProtection "Allow Sample Sharing" Rule”</i>
     * 
     * @return property allowSampleSharing
     */
    @Property(name="allowSampleSharing")
    @JsonIgnore
    public Optional<Boolean> getAllowSampleSharing() {
        return Optional.ofNullable(allowSampleSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowSampleSharing} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Windows Defender AdvancedThreatProtection "Allow Sample Sharing" Rule”</i>
     * 
     * @param allowSampleSharing
     *            new value of {@code allowSampleSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowSampleSharing} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAllowSampleSharing(Boolean allowSampleSharing) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowSampleSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.allowSampleSharing = allowSampleSharing;
        return _x;
    }

    /**
     * <i>“Expedite Windows Defender Advanced Threat Protection telemetry reporting
     * frequency.”</i>
     * 
     * @return property enableExpeditedTelemetryReporting
     */
    @Property(name="enableExpeditedTelemetryReporting")
    @JsonIgnore
    public Optional<Boolean> getEnableExpeditedTelemetryReporting() {
        return Optional.ofNullable(enableExpeditedTelemetryReporting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableExpeditedTelemetryReporting} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Expedite Windows Defender Advanced Threat Protection telemetry reporting
     * frequency.”</i>
     * 
     * @param enableExpeditedTelemetryReporting
     *            new value of {@code enableExpeditedTelemetryReporting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableExpeditedTelemetryReporting} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withEnableExpeditedTelemetryReporting(Boolean enableExpeditedTelemetryReporting) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableExpeditedTelemetryReporting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.enableExpeditedTelemetryReporting = enableExpeditedTelemetryReporting;
        return _x;
    }

    /**
     * <i>“Windows Defender AdvancedThreatProtection Offboarding Blob.”</i>
     * 
     * @return property advancedThreatProtectionOffboardingBlob
     */
    @Property(name="advancedThreatProtectionOffboardingBlob")
    @JsonIgnore
    public Optional<String> getAdvancedThreatProtectionOffboardingBlob() {
        return Optional.ofNullable(advancedThreatProtectionOffboardingBlob);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionOffboardingBlob} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows Defender AdvancedThreatProtection Offboarding Blob.”</i>
     * 
     * @param advancedThreatProtectionOffboardingBlob
     *            new value of {@code advancedThreatProtectionOffboardingBlob} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionOffboardingBlob} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAdvancedThreatProtectionOffboardingBlob(String advancedThreatProtectionOffboardingBlob) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOffboardingBlob");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.advancedThreatProtectionOffboardingBlob = advancedThreatProtectionOffboardingBlob;
        return _x;
    }

    /**
     * <i>“Name of the file from which AdvancedThreatProtectionOffboardingBlob was obtained
     * .”</i>
     * 
     * @return property advancedThreatProtectionOffboardingFilename
     */
    @Property(name="advancedThreatProtectionOffboardingFilename")
    @JsonIgnore
    public Optional<String> getAdvancedThreatProtectionOffboardingFilename() {
        return Optional.ofNullable(advancedThreatProtectionOffboardingFilename);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionOffboardingFilename} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Name of the file from which AdvancedThreatProtectionOffboardingBlob was obtained
     * .”</i>
     * 
     * @param advancedThreatProtectionOffboardingFilename
     *            new value of {@code advancedThreatProtectionOffboardingFilename} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionOffboardingFilename} field changed
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration withAdvancedThreatProtectionOffboardingFilename(String advancedThreatProtectionOffboardingFilename) {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionOffboardingFilename");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration");
        _x.advancedThreatProtectionOffboardingFilename = advancedThreatProtectionOffboardingFilename;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDefenderAdvancedThreatProtectionConfiguration _copy() {
        WindowsDefenderAdvancedThreatProtectionConfiguration _x = new WindowsDefenderAdvancedThreatProtectionConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.advancedThreatProtectionOnboardingBlob = advancedThreatProtectionOnboardingBlob;
        _x.advancedThreatProtectionOnboardingFilename = advancedThreatProtectionOnboardingFilename;
        _x.advancedThreatProtectionAutoPopulateOnboardingBlob = advancedThreatProtectionAutoPopulateOnboardingBlob;
        _x.allowSampleSharing = allowSampleSharing;
        _x.enableExpeditedTelemetryReporting = enableExpeditedTelemetryReporting;
        _x.advancedThreatProtectionOffboardingBlob = advancedThreatProtectionOffboardingBlob;
        _x.advancedThreatProtectionOffboardingFilename = advancedThreatProtectionOffboardingFilename;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDefenderAdvancedThreatProtectionConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("advancedThreatProtectionOnboardingBlob=");
        b.append(this.advancedThreatProtectionOnboardingBlob);
        b.append(", ");
        b.append("advancedThreatProtectionOnboardingFilename=");
        b.append(this.advancedThreatProtectionOnboardingFilename);
        b.append(", ");
        b.append("advancedThreatProtectionAutoPopulateOnboardingBlob=");
        b.append(this.advancedThreatProtectionAutoPopulateOnboardingBlob);
        b.append(", ");
        b.append("allowSampleSharing=");
        b.append(this.allowSampleSharing);
        b.append(", ");
        b.append("enableExpeditedTelemetryReporting=");
        b.append(this.enableExpeditedTelemetryReporting);
        b.append(", ");
        b.append("advancedThreatProtectionOffboardingBlob=");
        b.append(this.advancedThreatProtectionOffboardingBlob);
        b.append(", ");
        b.append("advancedThreatProtectionOffboardingFilename=");
        b.append(this.advancedThreatProtectionOffboardingFilename);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
