package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsAutopilotSyncStatus;


/**
 * <i>“The windowsAutopilotSettings resource represents a Windows Autopilot Account to
 * sync data with Windows device data sync service.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastSyncDateTime", 
    "lastManualSyncTriggerDateTime", 
    "syncStatus"})
@JsonInclude(Include.NON_NULL)
public class WindowsAutopilotSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsAutopilotSettings";
    }

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("lastManualSyncTriggerDateTime")
    protected OffsetDateTime lastManualSyncTriggerDateTime;

    @JsonProperty("syncStatus")
    protected WindowsAutopilotSyncStatus syncStatus;

    protected WindowsAutopilotSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsAutopilotSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastSyncDateTime;
        private OffsetDateTime lastManualSyncTriggerDateTime;
        private WindowsAutopilotSyncStatus syncStatus;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Last data sync date time with DDS service.”</i>
         * 
         * @param lastSyncDateTime
         *            value of {@code lastSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        /**
         * <i>“Last data sync date time with DDS service.”</i>
         * 
         * @param lastManualSyncTriggerDateTime
         *            value of {@code lastManualSyncTriggerDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastManualSyncTriggerDateTime(OffsetDateTime lastManualSyncTriggerDateTime) {
            this.lastManualSyncTriggerDateTime = lastManualSyncTriggerDateTime;
            this.changedFields = changedFields.add("lastManualSyncTriggerDateTime");
            return this;
        }

        /**
         * <i>“Indicates the status of sync with Device data sync (DDS) service.”</i>
         * 
         * @param syncStatus
         *            value of {@code syncStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncStatus(WindowsAutopilotSyncStatus syncStatus) {
            this.syncStatus = syncStatus;
            this.changedFields = changedFields.add("syncStatus");
            return this;
        }

        public WindowsAutopilotSettings build() {
            WindowsAutopilotSettings _x = new WindowsAutopilotSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsAutopilotSettings";
            _x.id = id;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.lastManualSyncTriggerDateTime = lastManualSyncTriggerDateTime;
            _x.syncStatus = syncStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Last data sync date time with DDS service.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last data sync date time with DDS service.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public WindowsAutopilotSettings withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        WindowsAutopilotSettings _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotSettings");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“Last data sync date time with DDS service.”</i>
     * 
     * @return property lastManualSyncTriggerDateTime
     */
    @Property(name="lastManualSyncTriggerDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastManualSyncTriggerDateTime() {
        return Optional.ofNullable(lastManualSyncTriggerDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastManualSyncTriggerDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last data sync date time with DDS service.”</i>
     * 
     * @param lastManualSyncTriggerDateTime
     *            new value of {@code lastManualSyncTriggerDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastManualSyncTriggerDateTime} field changed
     */
    public WindowsAutopilotSettings withLastManualSyncTriggerDateTime(OffsetDateTime lastManualSyncTriggerDateTime) {
        WindowsAutopilotSettings _x = _copy();
        _x.changedFields = changedFields.add("lastManualSyncTriggerDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotSettings");
        _x.lastManualSyncTriggerDateTime = lastManualSyncTriggerDateTime;
        return _x;
    }

    /**
     * <i>“Indicates the status of sync with Device data sync (DDS) service.”</i>
     * 
     * @return property syncStatus
     */
    @Property(name="syncStatus")
    @JsonIgnore
    public Optional<WindowsAutopilotSyncStatus> getSyncStatus() {
        return Optional.ofNullable(syncStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncStatus} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates the status of sync with Device data sync (DDS) service.”</i>
     * 
     * @param syncStatus
     *            new value of {@code syncStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncStatus} field changed
     */
    public WindowsAutopilotSettings withSyncStatus(WindowsAutopilotSyncStatus syncStatus) {
        WindowsAutopilotSettings _x = _copy();
        _x.changedFields = changedFields.add("syncStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotSettings");
        _x.syncStatus = syncStatus;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsAutopilotSettings _copy() {
        WindowsAutopilotSettings _x = new WindowsAutopilotSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.lastManualSyncTriggerDateTime = lastManualSyncTriggerDateTime;
        _x.syncStatus = syncStatus;
        return _x;
    }

    @Action(name = "sync")
    @JsonIgnore
    public ActionRequestNoReturn sync() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sync"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsAutopilotSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("lastManualSyncTriggerDateTime=");
        b.append(this.lastManualSyncTriggerDateTime);
        b.append(", ");
        b.append("syncStatus=");
        b.append(this.syncStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
