package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.complex.Windows81VpnProxyServer;
import odata.msgraph.client.beta.enums.WindowsVpnConnectionType;


/**
 * <i>“By providing the configurations in this profile you can instruct the Windows 8.1
 * (and later) devices to connect to desired VPN endpoint. By specifying the
 * authentication method and security types expected by VPN endpoint you can make
 * the VPN connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applyOnlyToWindows81", 
    "connectionType", 
    "loginGroupOrDomain", 
    "enableSplitTunneling", 
    "proxyServer"})
@JsonInclude(Include.NON_NULL)
public class Windows81VpnConfiguration extends WindowsVpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81VpnConfiguration";
    }

    @JsonProperty("applyOnlyToWindows81")
    protected Boolean applyOnlyToWindows81;

    @JsonProperty("connectionType")
    protected WindowsVpnConnectionType connectionType;

    @JsonProperty("loginGroupOrDomain")
    protected String loginGroupOrDomain;

    @JsonProperty("enableSplitTunneling")
    protected Boolean enableSplitTunneling;

    @JsonProperty("proxyServer")
    protected Windows81VpnProxyServer proxyServer;

    protected Windows81VpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows81VpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String connectionName;
        private List<VpnServer> servers;
        private String serversNextLink;
        private byte[] customXml;
        private Boolean applyOnlyToWindows81;
        private WindowsVpnConnectionType connectionType;
        private String loginGroupOrDomain;
        private Boolean enableSplitTunneling;
        private Windows81VpnProxyServer proxyServer;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder customXml(byte[] customXml) {
            this.customXml = customXml;
            this.changedFields = changedFields.add("customXml");
            return this;
        }

        /**
         * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param applyOnlyToWindows81
         *            value of {@code applyOnlyToWindows81} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applyOnlyToWindows81(Boolean applyOnlyToWindows81) {
            this.applyOnlyToWindows81 = applyOnlyToWindows81;
            this.changedFields = changedFields.add("applyOnlyToWindows81");
            return this;
        }

        /**
         * <i>“Connection type.”</i>
         * 
         * @param connectionType
         *            value of {@code connectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionType(WindowsVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        /**
         * <i>“Login group or domain when connection type is set to Dell SonicWALL Mobile
         * Connection.”</i>
         * 
         * @param loginGroupOrDomain
         *            value of {@code loginGroupOrDomain} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder loginGroupOrDomain(String loginGroupOrDomain) {
            this.loginGroupOrDomain = loginGroupOrDomain;
            this.changedFields = changedFields.add("loginGroupOrDomain");
            return this;
        }

        /**
         * <i>“Enable split tunneling for the VPN.”</i>
         * 
         * @param enableSplitTunneling
         *            value of {@code enableSplitTunneling} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSplitTunneling(Boolean enableSplitTunneling) {
            this.enableSplitTunneling = enableSplitTunneling;
            this.changedFields = changedFields.add("enableSplitTunneling");
            return this;
        }

        /**
         * <i>“Proxy Server.”</i>
         * 
         * @param proxyServer
         *            value of {@code proxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyServer(Windows81VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        public Windows81VpnConfiguration build() {
            Windows81VpnConfiguration _x = new Windows81VpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows81VpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.connectionName = connectionName;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.customXml = customXml;
            _x.applyOnlyToWindows81 = applyOnlyToWindows81;
            _x.connectionType = connectionType;
            _x.loginGroupOrDomain = loginGroupOrDomain;
            _x.enableSplitTunneling = enableSplitTunneling;
            _x.proxyServer = proxyServer;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property applyOnlyToWindows81
     */
    @Property(name="applyOnlyToWindows81")
    @JsonIgnore
    public Optional<Boolean> getApplyOnlyToWindows81() {
        return Optional.ofNullable(applyOnlyToWindows81);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applyOnlyToWindows81} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param applyOnlyToWindows81
     *            new value of {@code applyOnlyToWindows81} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applyOnlyToWindows81} field changed
     */
    public Windows81VpnConfiguration withApplyOnlyToWindows81(Boolean applyOnlyToWindows81) {
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applyOnlyToWindows81");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnConfiguration");
        _x.applyOnlyToWindows81 = applyOnlyToWindows81;
        return _x;
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<WindowsVpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public Windows81VpnConfiguration withConnectionType(WindowsVpnConnectionType connectionType) {
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Login group or domain when connection type is set to Dell SonicWALL Mobile
     * Connection.”</i>
     * 
     * @return property loginGroupOrDomain
     */
    @Property(name="loginGroupOrDomain")
    @JsonIgnore
    public Optional<String> getLoginGroupOrDomain() {
        return Optional.ofNullable(loginGroupOrDomain);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * loginGroupOrDomain} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Login group or domain when connection type is set to Dell SonicWALL Mobile
     * Connection.”</i>
     * 
     * @param loginGroupOrDomain
     *            new value of {@code loginGroupOrDomain} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code loginGroupOrDomain} field changed
     */
    public Windows81VpnConfiguration withLoginGroupOrDomain(String loginGroupOrDomain) {
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("loginGroupOrDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnConfiguration");
        _x.loginGroupOrDomain = loginGroupOrDomain;
        return _x;
    }

    /**
     * <i>“Enable split tunneling for the VPN.”</i>
     * 
     * @return property enableSplitTunneling
     */
    @Property(name="enableSplitTunneling")
    @JsonIgnore
    public Optional<Boolean> getEnableSplitTunneling() {
        return Optional.ofNullable(enableSplitTunneling);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSplitTunneling} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enable split tunneling for the VPN.”</i>
     * 
     * @param enableSplitTunneling
     *            new value of {@code enableSplitTunneling} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSplitTunneling} field changed
     */
    public Windows81VpnConfiguration withEnableSplitTunneling(Boolean enableSplitTunneling) {
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableSplitTunneling");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnConfiguration");
        _x.enableSplitTunneling = enableSplitTunneling;
        return _x;
    }

    /**
     * <i>“Proxy Server.”</i>
     * 
     * @return property proxyServer
     */
    @Property(name="proxyServer")
    @JsonIgnore
    public Optional<Windows81VpnProxyServer> getProxyServer() {
        return Optional.ofNullable(proxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy Server.”</i>
     * 
     * @param proxyServer
     *            new value of {@code proxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServer} field changed
     */
    public Windows81VpnConfiguration withProxyServer(Windows81VpnProxyServer proxyServer) {
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81VpnConfiguration");
        _x.proxyServer = proxyServer;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81VpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81VpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows81VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows81VpnConfiguration _copy() {
        Windows81VpnConfiguration _x = new Windows81VpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.servers = servers;
        _x.customXml = customXml;
        _x.applyOnlyToWindows81 = applyOnlyToWindows81;
        _x.connectionType = connectionType;
        _x.loginGroupOrDomain = loginGroupOrDomain;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.proxyServer = proxyServer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81VpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("customXml=");
        b.append(this.customXml);
        b.append(", ");
        b.append("applyOnlyToWindows81=");
        b.append(this.applyOnlyToWindows81);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("loginGroupOrDomain=");
        b.append(this.loginGroupOrDomain);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
