package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.InternetSiteSecurityLevel;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.enums.SiteSecurityLevel;
import odata.msgraph.client.beta.enums.UpdateClassification;
import odata.msgraph.client.beta.enums.WindowsUserAccountControlSettings;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the windows81GeneralConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountsBlockAddingNonMicrosoftAccountEmail", 
    "applyOnlyToWindows81", 
    "browserBlockAutofill", 
    "browserBlockAutomaticDetectionOfIntranetSites", 
    "browserBlockEnterpriseModeAccess", 
    "browserBlockJavaScript", 
    "browserBlockPlugins", 
    "browserBlockPopups", 
    "browserBlockSendingDoNotTrackHeader", 
    "browserBlockSingleWordEntryOnIntranetSites", 
    "browserRequireSmartScreen", 
    "browserEnterpriseModeSiteListLocation", 
    "browserInternetSecurityLevel", 
    "browserIntranetSecurityLevel", 
    "browserLoggingReportLocation", 
    "browserRequireHighSecurityForRestrictedSites", 
    "browserRequireFirewall", 
    "browserRequireFraudWarning", 
    "browserTrustedSitesSecurityLevel", 
    "cellularBlockDataRoaming", 
    "diagnosticsBlockDataSubmission", 
    "passwordBlockPicturePasswordAndPin", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordMinimumCharacterSetCount", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequiredType", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "storageRequireDeviceEncryption", 
    "minimumAutoInstallClassification", 
    "updatesMinimumAutoInstallClassification", 
    "updatesRequireAutomaticUpdates", 
    "userAccountControlSettings", 
    "workFoldersUrl"})
@JsonInclude(Include.NON_NULL)
public class Windows81GeneralConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81GeneralConfiguration";
    }

    @JsonProperty("accountsBlockAddingNonMicrosoftAccountEmail")
    protected Boolean accountsBlockAddingNonMicrosoftAccountEmail;

    @JsonProperty("applyOnlyToWindows81")
    protected Boolean applyOnlyToWindows81;

    @JsonProperty("browserBlockAutofill")
    protected Boolean browserBlockAutofill;

    @JsonProperty("browserBlockAutomaticDetectionOfIntranetSites")
    protected Boolean browserBlockAutomaticDetectionOfIntranetSites;

    @JsonProperty("browserBlockEnterpriseModeAccess")
    protected Boolean browserBlockEnterpriseModeAccess;

    @JsonProperty("browserBlockJavaScript")
    protected Boolean browserBlockJavaScript;

    @JsonProperty("browserBlockPlugins")
    protected Boolean browserBlockPlugins;

    @JsonProperty("browserBlockPopups")
    protected Boolean browserBlockPopups;

    @JsonProperty("browserBlockSendingDoNotTrackHeader")
    protected Boolean browserBlockSendingDoNotTrackHeader;

    @JsonProperty("browserBlockSingleWordEntryOnIntranetSites")
    protected Boolean browserBlockSingleWordEntryOnIntranetSites;

    @JsonProperty("browserRequireSmartScreen")
    protected Boolean browserRequireSmartScreen;

    @JsonProperty("browserEnterpriseModeSiteListLocation")
    protected String browserEnterpriseModeSiteListLocation;

    @JsonProperty("browserInternetSecurityLevel")
    protected InternetSiteSecurityLevel browserInternetSecurityLevel;

    @JsonProperty("browserIntranetSecurityLevel")
    protected SiteSecurityLevel browserIntranetSecurityLevel;

    @JsonProperty("browserLoggingReportLocation")
    protected String browserLoggingReportLocation;

    @JsonProperty("browserRequireHighSecurityForRestrictedSites")
    protected Boolean browserRequireHighSecurityForRestrictedSites;

    @JsonProperty("browserRequireFirewall")
    protected Boolean browserRequireFirewall;

    @JsonProperty("browserRequireFraudWarning")
    protected Boolean browserRequireFraudWarning;

    @JsonProperty("browserTrustedSitesSecurityLevel")
    protected SiteSecurityLevel browserTrustedSitesSecurityLevel;

    @JsonProperty("cellularBlockDataRoaming")
    protected Boolean cellularBlockDataRoaming;

    @JsonProperty("diagnosticsBlockDataSubmission")
    protected Boolean diagnosticsBlockDataSubmission;

    @JsonProperty("passwordBlockPicturePasswordAndPin")
    protected Boolean passwordBlockPicturePasswordAndPin;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("storageRequireDeviceEncryption")
    protected Boolean storageRequireDeviceEncryption;

    @JsonProperty("minimumAutoInstallClassification")
    protected UpdateClassification minimumAutoInstallClassification;

    @JsonProperty("updatesMinimumAutoInstallClassification")
    protected UpdateClassification updatesMinimumAutoInstallClassification;

    @JsonProperty("updatesRequireAutomaticUpdates")
    protected Boolean updatesRequireAutomaticUpdates;

    @JsonProperty("userAccountControlSettings")
    protected WindowsUserAccountControlSettings userAccountControlSettings;

    @JsonProperty("workFoldersUrl")
    protected String workFoldersUrl;

    protected Windows81GeneralConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows81GeneralConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Boolean accountsBlockAddingNonMicrosoftAccountEmail;
        private Boolean applyOnlyToWindows81;
        private Boolean browserBlockAutofill;
        private Boolean browserBlockAutomaticDetectionOfIntranetSites;
        private Boolean browserBlockEnterpriseModeAccess;
        private Boolean browserBlockJavaScript;
        private Boolean browserBlockPlugins;
        private Boolean browserBlockPopups;
        private Boolean browserBlockSendingDoNotTrackHeader;
        private Boolean browserBlockSingleWordEntryOnIntranetSites;
        private Boolean browserRequireSmartScreen;
        private String browserEnterpriseModeSiteListLocation;
        private InternetSiteSecurityLevel browserInternetSecurityLevel;
        private SiteSecurityLevel browserIntranetSecurityLevel;
        private String browserLoggingReportLocation;
        private Boolean browserRequireHighSecurityForRestrictedSites;
        private Boolean browserRequireFirewall;
        private Boolean browserRequireFraudWarning;
        private SiteSecurityLevel browserTrustedSitesSecurityLevel;
        private Boolean cellularBlockDataRoaming;
        private Boolean diagnosticsBlockDataSubmission;
        private Boolean passwordBlockPicturePasswordAndPin;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordMinimumCharacterSetCount;
        private Integer passwordPreviousPasswordBlockCount;
        private RequiredPasswordType passwordRequiredType;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private Boolean storageRequireDeviceEncryption;
        private UpdateClassification minimumAutoInstallClassification;
        private UpdateClassification updatesMinimumAutoInstallClassification;
        private Boolean updatesRequireAutomaticUpdates;
        private WindowsUserAccountControlSettings userAccountControlSettings;
        private String workFoldersUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from adding email accounts to the
         * device that are not associated with a Microsoft account.”</i>
         * 
         * @param accountsBlockAddingNonMicrosoftAccountEmail
         *            value of {@code accountsBlockAddingNonMicrosoftAccountEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountsBlockAddingNonMicrosoftAccountEmail(Boolean accountsBlockAddingNonMicrosoftAccountEmail) {
            this.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
            this.changedFields = changedFields.add("accountsBlockAddingNonMicrosoftAccountEmail");
            return this;
        }

        /**
         * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param applyOnlyToWindows81
         *            value of {@code applyOnlyToWindows81} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applyOnlyToWindows81(Boolean applyOnlyToWindows81) {
            this.applyOnlyToWindows81 = applyOnlyToWindows81;
            this.changedFields = changedFields.add("applyOnlyToWindows81");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block auto fill.”</i>
         * 
         * @param browserBlockAutofill
         *            value of {@code browserBlockAutofill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockAutofill(Boolean browserBlockAutofill) {
            this.browserBlockAutofill = browserBlockAutofill;
            this.changedFields = changedFields.add("browserBlockAutofill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block automatic detection of Intranet sites.”</i>
         * 
         * @param browserBlockAutomaticDetectionOfIntranetSites
         *            value of {@code browserBlockAutomaticDetectionOfIntranetSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockAutomaticDetectionOfIntranetSites(Boolean browserBlockAutomaticDetectionOfIntranetSites) {
            this.browserBlockAutomaticDetectionOfIntranetSites = browserBlockAutomaticDetectionOfIntranetSites;
            this.changedFields = changedFields.add("browserBlockAutomaticDetectionOfIntranetSites");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block enterprise mode access.”</i>
         * 
         * @param browserBlockEnterpriseModeAccess
         *            value of {@code browserBlockEnterpriseModeAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockEnterpriseModeAccess(Boolean browserBlockEnterpriseModeAccess) {
            this.browserBlockEnterpriseModeAccess = browserBlockEnterpriseModeAccess;
            this.changedFields = changedFields.add("browserBlockEnterpriseModeAccess");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
         * 
         * @param browserBlockJavaScript
         *            value of {@code browserBlockJavaScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockJavaScript(Boolean browserBlockJavaScript) {
            this.browserBlockJavaScript = browserBlockJavaScript;
            this.changedFields = changedFields.add("browserBlockJavaScript");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block plug-ins.”</i>
         * 
         * @param browserBlockPlugins
         *            value of {@code browserBlockPlugins} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockPlugins(Boolean browserBlockPlugins) {
            this.browserBlockPlugins = browserBlockPlugins;
            this.changedFields = changedFields.add("browserBlockPlugins");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block popups.”</i>
         * 
         * @param browserBlockPopups
         *            value of {@code browserBlockPopups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockPopups(Boolean browserBlockPopups) {
            this.browserBlockPopups = browserBlockPopups;
            this.changedFields = changedFields.add("browserBlockPopups");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
         * 
         * @param browserBlockSendingDoNotTrackHeader
         *            value of {@code browserBlockSendingDoNotTrackHeader} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockSendingDoNotTrackHeader(Boolean browserBlockSendingDoNotTrackHeader) {
            this.browserBlockSendingDoNotTrackHeader = browserBlockSendingDoNotTrackHeader;
            this.changedFields = changedFields.add("browserBlockSendingDoNotTrackHeader");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block a single word entry on Intranet sites.”</i>
         * 
         * @param browserBlockSingleWordEntryOnIntranetSites
         *            value of {@code browserBlockSingleWordEntryOnIntranetSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserBlockSingleWordEntryOnIntranetSites(Boolean browserBlockSingleWordEntryOnIntranetSites) {
            this.browserBlockSingleWordEntryOnIntranetSites = browserBlockSingleWordEntryOnIntranetSites;
            this.changedFields = changedFields.add("browserBlockSingleWordEntryOnIntranetSites");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require the user to use the smart screen filter.”</i>
         * 
         * @param browserRequireSmartScreen
         *            value of {@code browserRequireSmartScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserRequireSmartScreen(Boolean browserRequireSmartScreen) {
            this.browserRequireSmartScreen = browserRequireSmartScreen;
            this.changedFields = changedFields.add("browserRequireSmartScreen");
            return this;
        }

        /**
         * <i>“The enterprise mode site list location. Could be a local file, local network or
         * http location.”</i>
         * 
         * @param browserEnterpriseModeSiteListLocation
         *            value of {@code browserEnterpriseModeSiteListLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserEnterpriseModeSiteListLocation(String browserEnterpriseModeSiteListLocation) {
            this.browserEnterpriseModeSiteListLocation = browserEnterpriseModeSiteListLocation;
            this.changedFields = changedFields.add("browserEnterpriseModeSiteListLocation");
            return this;
        }

        /**
         * <i>“The internet security level.”</i>
         * 
         * @param browserInternetSecurityLevel
         *            value of {@code browserInternetSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserInternetSecurityLevel(InternetSiteSecurityLevel browserInternetSecurityLevel) {
            this.browserInternetSecurityLevel = browserInternetSecurityLevel;
            this.changedFields = changedFields.add("browserInternetSecurityLevel");
            return this;
        }

        /**
         * <i>“The Intranet security level.”</i>
         * 
         * @param browserIntranetSecurityLevel
         *            value of {@code browserIntranetSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserIntranetSecurityLevel(SiteSecurityLevel browserIntranetSecurityLevel) {
            this.browserIntranetSecurityLevel = browserIntranetSecurityLevel;
            this.changedFields = changedFields.add("browserIntranetSecurityLevel");
            return this;
        }

        /**
         * <i>“The logging report location.”</i>
         * 
         * @param browserLoggingReportLocation
         *            value of {@code browserLoggingReportLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserLoggingReportLocation(String browserLoggingReportLocation) {
            this.browserLoggingReportLocation = browserLoggingReportLocation;
            this.changedFields = changedFields.add("browserLoggingReportLocation");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require high security for restricted sites.”</i>
         * 
         * @param browserRequireHighSecurityForRestrictedSites
         *            value of {@code browserRequireHighSecurityForRestrictedSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserRequireHighSecurityForRestrictedSites(Boolean browserRequireHighSecurityForRestrictedSites) {
            this.browserRequireHighSecurityForRestrictedSites = browserRequireHighSecurityForRestrictedSites;
            this.changedFields = changedFields.add("browserRequireHighSecurityForRestrictedSites");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a firewall.”</i>
         * 
         * @param browserRequireFirewall
         *            value of {@code browserRequireFirewall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserRequireFirewall(Boolean browserRequireFirewall) {
            this.browserRequireFirewall = browserRequireFirewall;
            this.changedFields = changedFields.add("browserRequireFirewall");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require fraud warning.”</i>
         * 
         * @param browserRequireFraudWarning
         *            value of {@code browserRequireFraudWarning} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserRequireFraudWarning(Boolean browserRequireFraudWarning) {
            this.browserRequireFraudWarning = browserRequireFraudWarning;
            this.changedFields = changedFields.add("browserRequireFraudWarning");
            return this;
        }

        /**
         * <i>“The trusted sites security level.”</i>
         * 
         * @param browserTrustedSitesSecurityLevel
         *            value of {@code browserTrustedSitesSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder browserTrustedSitesSecurityLevel(SiteSecurityLevel browserTrustedSitesSecurityLevel) {
            this.browserTrustedSitesSecurityLevel = browserTrustedSitesSecurityLevel;
            this.changedFields = changedFields.add("browserTrustedSitesSecurityLevel");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block data roaming.”</i>
         * 
         * @param cellularBlockDataRoaming
         *            value of {@code cellularBlockDataRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
            this.cellularBlockDataRoaming = cellularBlockDataRoaming;
            this.changedFields = changedFields.add("cellularBlockDataRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block diagnostic data submission.”</i>
         * 
         * @param diagnosticsBlockDataSubmission
         *            value of {@code diagnosticsBlockDataSubmission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticsBlockDataSubmission(Boolean diagnosticsBlockDataSubmission) {
            this.diagnosticsBlockDataSubmission = diagnosticsBlockDataSubmission;
            this.changedFields = changedFields.add("diagnosticsBlockDataSubmission");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using a pictures password and
         * pin.”</i>
         * 
         * @param passwordBlockPicturePasswordAndPin
         *            value of {@code passwordBlockPicturePasswordAndPin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockPicturePasswordAndPin(Boolean passwordBlockPicturePasswordAndPin) {
            this.passwordBlockPicturePasswordAndPin = passwordBlockPicturePasswordAndPin;
            this.changedFields = changedFields.add("passwordBlockPicturePasswordAndPin");
            return this;
        }

        /**
         * <i>“Password expiration in days.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“The minimum password length.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“The minutes of inactivity before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“The required password type.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“The number of sign in failures before factory reset.”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require encryption on a mobile device.”</i>
         * 
         * @param storageRequireDeviceEncryption
         *            value of {@code storageRequireDeviceEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireDeviceEncryption(Boolean storageRequireDeviceEncryption) {
            this.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
            this.changedFields = changedFields.add("storageRequireDeviceEncryption");
            return this;
        }

        /**
         * <i>“The minimum update classification to install automatically.”</i>
         * 
         * @param minimumAutoInstallClassification
         *            value of {@code minimumAutoInstallClassification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumAutoInstallClassification(UpdateClassification minimumAutoInstallClassification) {
            this.minimumAutoInstallClassification = minimumAutoInstallClassification;
            this.changedFields = changedFields.add("minimumAutoInstallClassification");
            return this;
        }

        /**
         * <i>“The minimum update classification to install automatically.”</i>
         * 
         * @param updatesMinimumAutoInstallClassification
         *            value of {@code updatesMinimumAutoInstallClassification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updatesMinimumAutoInstallClassification(UpdateClassification updatesMinimumAutoInstallClassification) {
            this.updatesMinimumAutoInstallClassification = updatesMinimumAutoInstallClassification;
            this.changedFields = changedFields.add("updatesMinimumAutoInstallClassification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require automatic updates.”</i>
         * 
         * @param updatesRequireAutomaticUpdates
         *            value of {@code updatesRequireAutomaticUpdates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updatesRequireAutomaticUpdates(Boolean updatesRequireAutomaticUpdates) {
            this.updatesRequireAutomaticUpdates = updatesRequireAutomaticUpdates;
            this.changedFields = changedFields.add("updatesRequireAutomaticUpdates");
            return this;
        }

        /**
         * <i>“The user account control settings.”</i>
         * 
         * @param userAccountControlSettings
         *            value of {@code userAccountControlSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccountControlSettings(WindowsUserAccountControlSettings userAccountControlSettings) {
            this.userAccountControlSettings = userAccountControlSettings;
            this.changedFields = changedFields.add("userAccountControlSettings");
            return this;
        }

        /**
         * <i>“The work folders url.”</i>
         * 
         * @param workFoldersUrl
         *            value of {@code workFoldersUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder workFoldersUrl(String workFoldersUrl) {
            this.workFoldersUrl = workFoldersUrl;
            this.changedFields = changedFields.add("workFoldersUrl");
            return this;
        }

        public Windows81GeneralConfiguration build() {
            Windows81GeneralConfiguration _x = new Windows81GeneralConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows81GeneralConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
            _x.applyOnlyToWindows81 = applyOnlyToWindows81;
            _x.browserBlockAutofill = browserBlockAutofill;
            _x.browserBlockAutomaticDetectionOfIntranetSites = browserBlockAutomaticDetectionOfIntranetSites;
            _x.browserBlockEnterpriseModeAccess = browserBlockEnterpriseModeAccess;
            _x.browserBlockJavaScript = browserBlockJavaScript;
            _x.browserBlockPlugins = browserBlockPlugins;
            _x.browserBlockPopups = browserBlockPopups;
            _x.browserBlockSendingDoNotTrackHeader = browserBlockSendingDoNotTrackHeader;
            _x.browserBlockSingleWordEntryOnIntranetSites = browserBlockSingleWordEntryOnIntranetSites;
            _x.browserRequireSmartScreen = browserRequireSmartScreen;
            _x.browserEnterpriseModeSiteListLocation = browserEnterpriseModeSiteListLocation;
            _x.browserInternetSecurityLevel = browserInternetSecurityLevel;
            _x.browserIntranetSecurityLevel = browserIntranetSecurityLevel;
            _x.browserLoggingReportLocation = browserLoggingReportLocation;
            _x.browserRequireHighSecurityForRestrictedSites = browserRequireHighSecurityForRestrictedSites;
            _x.browserRequireFirewall = browserRequireFirewall;
            _x.browserRequireFraudWarning = browserRequireFraudWarning;
            _x.browserTrustedSitesSecurityLevel = browserTrustedSitesSecurityLevel;
            _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
            _x.diagnosticsBlockDataSubmission = diagnosticsBlockDataSubmission;
            _x.passwordBlockPicturePasswordAndPin = passwordBlockPicturePasswordAndPin;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
            _x.minimumAutoInstallClassification = minimumAutoInstallClassification;
            _x.updatesMinimumAutoInstallClassification = updatesMinimumAutoInstallClassification;
            _x.updatesRequireAutomaticUpdates = updatesRequireAutomaticUpdates;
            _x.userAccountControlSettings = userAccountControlSettings;
            _x.workFoldersUrl = workFoldersUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates whether or not to Block the user from adding email accounts to the
     * device that are not associated with a Microsoft account.”</i>
     * 
     * @return property accountsBlockAddingNonMicrosoftAccountEmail
     */
    @Property(name="accountsBlockAddingNonMicrosoftAccountEmail")
    @JsonIgnore
    public Optional<Boolean> getAccountsBlockAddingNonMicrosoftAccountEmail() {
        return Optional.ofNullable(accountsBlockAddingNonMicrosoftAccountEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountsBlockAddingNonMicrosoftAccountEmail} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from adding email accounts to the
     * device that are not associated with a Microsoft account.”</i>
     * 
     * @param accountsBlockAddingNonMicrosoftAccountEmail
     *            new value of {@code accountsBlockAddingNonMicrosoftAccountEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountsBlockAddingNonMicrosoftAccountEmail} field changed
     */
    public Windows81GeneralConfiguration withAccountsBlockAddingNonMicrosoftAccountEmail(Boolean accountsBlockAddingNonMicrosoftAccountEmail) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountsBlockAddingNonMicrosoftAccountEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
        return _x;
    }

    /**
     * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property applyOnlyToWindows81
     */
    @Property(name="applyOnlyToWindows81")
    @JsonIgnore
    public Optional<Boolean> getApplyOnlyToWindows81() {
        return Optional.ofNullable(applyOnlyToWindows81);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applyOnlyToWindows81} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Value indicating whether this policy only applies to Windows 8.1. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param applyOnlyToWindows81
     *            new value of {@code applyOnlyToWindows81} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applyOnlyToWindows81} field changed
     */
    public Windows81GeneralConfiguration withApplyOnlyToWindows81(Boolean applyOnlyToWindows81) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applyOnlyToWindows81");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.applyOnlyToWindows81 = applyOnlyToWindows81;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block auto fill.”</i>
     * 
     * @return property browserBlockAutofill
     */
    @Property(name="browserBlockAutofill")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockAutofill() {
        return Optional.ofNullable(browserBlockAutofill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockAutofill} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block auto fill.”</i>
     * 
     * @param browserBlockAutofill
     *            new value of {@code browserBlockAutofill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockAutofill} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockAutofill(Boolean browserBlockAutofill) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockAutofill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockAutofill = browserBlockAutofill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block automatic detection of Intranet sites.”</i>
     * 
     * @return property browserBlockAutomaticDetectionOfIntranetSites
     */
    @Property(name="browserBlockAutomaticDetectionOfIntranetSites")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockAutomaticDetectionOfIntranetSites() {
        return Optional.ofNullable(browserBlockAutomaticDetectionOfIntranetSites);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockAutomaticDetectionOfIntranetSites} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block automatic detection of Intranet sites.”</i>
     * 
     * @param browserBlockAutomaticDetectionOfIntranetSites
     *            new value of {@code browserBlockAutomaticDetectionOfIntranetSites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockAutomaticDetectionOfIntranetSites} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockAutomaticDetectionOfIntranetSites(Boolean browserBlockAutomaticDetectionOfIntranetSites) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockAutomaticDetectionOfIntranetSites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockAutomaticDetectionOfIntranetSites = browserBlockAutomaticDetectionOfIntranetSites;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block enterprise mode access.”</i>
     * 
     * @return property browserBlockEnterpriseModeAccess
     */
    @Property(name="browserBlockEnterpriseModeAccess")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockEnterpriseModeAccess() {
        return Optional.ofNullable(browserBlockEnterpriseModeAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockEnterpriseModeAccess} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block enterprise mode access.”</i>
     * 
     * @param browserBlockEnterpriseModeAccess
     *            new value of {@code browserBlockEnterpriseModeAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockEnterpriseModeAccess} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockEnterpriseModeAccess(Boolean browserBlockEnterpriseModeAccess) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockEnterpriseModeAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockEnterpriseModeAccess = browserBlockEnterpriseModeAccess;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
     * 
     * @return property browserBlockJavaScript
     */
    @Property(name="browserBlockJavaScript")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockJavaScript() {
        return Optional.ofNullable(browserBlockJavaScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockJavaScript} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
     * 
     * @param browserBlockJavaScript
     *            new value of {@code browserBlockJavaScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockJavaScript} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockJavaScript(Boolean browserBlockJavaScript) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockJavaScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockJavaScript = browserBlockJavaScript;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block plug-ins.”</i>
     * 
     * @return property browserBlockPlugins
     */
    @Property(name="browserBlockPlugins")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockPlugins() {
        return Optional.ofNullable(browserBlockPlugins);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockPlugins} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block plug-ins.”</i>
     * 
     * @param browserBlockPlugins
     *            new value of {@code browserBlockPlugins} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockPlugins} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockPlugins(Boolean browserBlockPlugins) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockPlugins");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockPlugins = browserBlockPlugins;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block popups.”</i>
     * 
     * @return property browserBlockPopups
     */
    @Property(name="browserBlockPopups")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockPopups() {
        return Optional.ofNullable(browserBlockPopups);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockPopups} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block popups.”</i>
     * 
     * @param browserBlockPopups
     *            new value of {@code browserBlockPopups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockPopups} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockPopups(Boolean browserBlockPopups) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockPopups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockPopups = browserBlockPopups;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
     * 
     * @return property browserBlockSendingDoNotTrackHeader
     */
    @Property(name="browserBlockSendingDoNotTrackHeader")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockSendingDoNotTrackHeader() {
        return Optional.ofNullable(browserBlockSendingDoNotTrackHeader);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockSendingDoNotTrackHeader} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
     * 
     * @param browserBlockSendingDoNotTrackHeader
     *            new value of {@code browserBlockSendingDoNotTrackHeader} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockSendingDoNotTrackHeader} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockSendingDoNotTrackHeader(Boolean browserBlockSendingDoNotTrackHeader) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockSendingDoNotTrackHeader");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockSendingDoNotTrackHeader = browserBlockSendingDoNotTrackHeader;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block a single word entry on Intranet sites.”</i>
     * 
     * @return property browserBlockSingleWordEntryOnIntranetSites
     */
    @Property(name="browserBlockSingleWordEntryOnIntranetSites")
    @JsonIgnore
    public Optional<Boolean> getBrowserBlockSingleWordEntryOnIntranetSites() {
        return Optional.ofNullable(browserBlockSingleWordEntryOnIntranetSites);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserBlockSingleWordEntryOnIntranetSites} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block a single word entry on Intranet sites.”</i>
     * 
     * @param browserBlockSingleWordEntryOnIntranetSites
     *            new value of {@code browserBlockSingleWordEntryOnIntranetSites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserBlockSingleWordEntryOnIntranetSites} field changed
     */
    public Windows81GeneralConfiguration withBrowserBlockSingleWordEntryOnIntranetSites(Boolean browserBlockSingleWordEntryOnIntranetSites) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserBlockSingleWordEntryOnIntranetSites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserBlockSingleWordEntryOnIntranetSites = browserBlockSingleWordEntryOnIntranetSites;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require the user to use the smart screen filter.”</i>
     * 
     * @return property browserRequireSmartScreen
     */
    @Property(name="browserRequireSmartScreen")
    @JsonIgnore
    public Optional<Boolean> getBrowserRequireSmartScreen() {
        return Optional.ofNullable(browserRequireSmartScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserRequireSmartScreen} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require the user to use the smart screen filter.”</i>
     * 
     * @param browserRequireSmartScreen
     *            new value of {@code browserRequireSmartScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserRequireSmartScreen} field changed
     */
    public Windows81GeneralConfiguration withBrowserRequireSmartScreen(Boolean browserRequireSmartScreen) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserRequireSmartScreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserRequireSmartScreen = browserRequireSmartScreen;
        return _x;
    }

    /**
     * <i>“The enterprise mode site list location. Could be a local file, local network or
     * http location.”</i>
     * 
     * @return property browserEnterpriseModeSiteListLocation
     */
    @Property(name="browserEnterpriseModeSiteListLocation")
    @JsonIgnore
    public Optional<String> getBrowserEnterpriseModeSiteListLocation() {
        return Optional.ofNullable(browserEnterpriseModeSiteListLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserEnterpriseModeSiteListLocation} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The enterprise mode site list location. Could be a local file, local network or
     * http location.”</i>
     * 
     * @param browserEnterpriseModeSiteListLocation
     *            new value of {@code browserEnterpriseModeSiteListLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserEnterpriseModeSiteListLocation} field changed
     */
    public Windows81GeneralConfiguration withBrowserEnterpriseModeSiteListLocation(String browserEnterpriseModeSiteListLocation) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserEnterpriseModeSiteListLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserEnterpriseModeSiteListLocation = browserEnterpriseModeSiteListLocation;
        return _x;
    }

    /**
     * <i>“The internet security level.”</i>
     * 
     * @return property browserInternetSecurityLevel
     */
    @Property(name="browserInternetSecurityLevel")
    @JsonIgnore
    public Optional<InternetSiteSecurityLevel> getBrowserInternetSecurityLevel() {
        return Optional.ofNullable(browserInternetSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserInternetSecurityLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The internet security level.”</i>
     * 
     * @param browserInternetSecurityLevel
     *            new value of {@code browserInternetSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserInternetSecurityLevel} field changed
     */
    public Windows81GeneralConfiguration withBrowserInternetSecurityLevel(InternetSiteSecurityLevel browserInternetSecurityLevel) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserInternetSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserInternetSecurityLevel = browserInternetSecurityLevel;
        return _x;
    }

    /**
     * <i>“The Intranet security level.”</i>
     * 
     * @return property browserIntranetSecurityLevel
     */
    @Property(name="browserIntranetSecurityLevel")
    @JsonIgnore
    public Optional<SiteSecurityLevel> getBrowserIntranetSecurityLevel() {
        return Optional.ofNullable(browserIntranetSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserIntranetSecurityLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Intranet security level.”</i>
     * 
     * @param browserIntranetSecurityLevel
     *            new value of {@code browserIntranetSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserIntranetSecurityLevel} field changed
     */
    public Windows81GeneralConfiguration withBrowserIntranetSecurityLevel(SiteSecurityLevel browserIntranetSecurityLevel) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserIntranetSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserIntranetSecurityLevel = browserIntranetSecurityLevel;
        return _x;
    }

    /**
     * <i>“The logging report location.”</i>
     * 
     * @return property browserLoggingReportLocation
     */
    @Property(name="browserLoggingReportLocation")
    @JsonIgnore
    public Optional<String> getBrowserLoggingReportLocation() {
        return Optional.ofNullable(browserLoggingReportLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserLoggingReportLocation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The logging report location.”</i>
     * 
     * @param browserLoggingReportLocation
     *            new value of {@code browserLoggingReportLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserLoggingReportLocation} field changed
     */
    public Windows81GeneralConfiguration withBrowserLoggingReportLocation(String browserLoggingReportLocation) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserLoggingReportLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserLoggingReportLocation = browserLoggingReportLocation;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require high security for restricted sites.”</i>
     * 
     * @return property browserRequireHighSecurityForRestrictedSites
     */
    @Property(name="browserRequireHighSecurityForRestrictedSites")
    @JsonIgnore
    public Optional<Boolean> getBrowserRequireHighSecurityForRestrictedSites() {
        return Optional.ofNullable(browserRequireHighSecurityForRestrictedSites);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserRequireHighSecurityForRestrictedSites} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require high security for restricted sites.”</i>
     * 
     * @param browserRequireHighSecurityForRestrictedSites
     *            new value of {@code browserRequireHighSecurityForRestrictedSites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserRequireHighSecurityForRestrictedSites} field changed
     */
    public Windows81GeneralConfiguration withBrowserRequireHighSecurityForRestrictedSites(Boolean browserRequireHighSecurityForRestrictedSites) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserRequireHighSecurityForRestrictedSites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserRequireHighSecurityForRestrictedSites = browserRequireHighSecurityForRestrictedSites;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a firewall.”</i>
     * 
     * @return property browserRequireFirewall
     */
    @Property(name="browserRequireFirewall")
    @JsonIgnore
    public Optional<Boolean> getBrowserRequireFirewall() {
        return Optional.ofNullable(browserRequireFirewall);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserRequireFirewall} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require a firewall.”</i>
     * 
     * @param browserRequireFirewall
     *            new value of {@code browserRequireFirewall} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserRequireFirewall} field changed
     */
    public Windows81GeneralConfiguration withBrowserRequireFirewall(Boolean browserRequireFirewall) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserRequireFirewall");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserRequireFirewall = browserRequireFirewall;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require fraud warning.”</i>
     * 
     * @return property browserRequireFraudWarning
     */
    @Property(name="browserRequireFraudWarning")
    @JsonIgnore
    public Optional<Boolean> getBrowserRequireFraudWarning() {
        return Optional.ofNullable(browserRequireFraudWarning);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserRequireFraudWarning} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require fraud warning.”</i>
     * 
     * @param browserRequireFraudWarning
     *            new value of {@code browserRequireFraudWarning} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserRequireFraudWarning} field changed
     */
    public Windows81GeneralConfiguration withBrowserRequireFraudWarning(Boolean browserRequireFraudWarning) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserRequireFraudWarning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserRequireFraudWarning = browserRequireFraudWarning;
        return _x;
    }

    /**
     * <i>“The trusted sites security level.”</i>
     * 
     * @return property browserTrustedSitesSecurityLevel
     */
    @Property(name="browserTrustedSitesSecurityLevel")
    @JsonIgnore
    public Optional<SiteSecurityLevel> getBrowserTrustedSitesSecurityLevel() {
        return Optional.ofNullable(browserTrustedSitesSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * browserTrustedSitesSecurityLevel} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The trusted sites security level.”</i>
     * 
     * @param browserTrustedSitesSecurityLevel
     *            new value of {@code browserTrustedSitesSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code browserTrustedSitesSecurityLevel} field changed
     */
    public Windows81GeneralConfiguration withBrowserTrustedSitesSecurityLevel(SiteSecurityLevel browserTrustedSitesSecurityLevel) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("browserTrustedSitesSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.browserTrustedSitesSecurityLevel = browserTrustedSitesSecurityLevel;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @return property cellularBlockDataRoaming
     */
    @Property(name="cellularBlockDataRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockDataRoaming() {
        return Optional.ofNullable(cellularBlockDataRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockDataRoaming} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @param cellularBlockDataRoaming
     *            new value of {@code cellularBlockDataRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockDataRoaming} field changed
     */
    public Windows81GeneralConfiguration withCellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockDataRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @return property diagnosticsBlockDataSubmission
     */
    @Property(name="diagnosticsBlockDataSubmission")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticsBlockDataSubmission() {
        return Optional.ofNullable(diagnosticsBlockDataSubmission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticsBlockDataSubmission} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @param diagnosticsBlockDataSubmission
     *            new value of {@code diagnosticsBlockDataSubmission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticsBlockDataSubmission} field changed
     */
    public Windows81GeneralConfiguration withDiagnosticsBlockDataSubmission(Boolean diagnosticsBlockDataSubmission) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticsBlockDataSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.diagnosticsBlockDataSubmission = diagnosticsBlockDataSubmission;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using a pictures password and
     * pin.”</i>
     * 
     * @return property passwordBlockPicturePasswordAndPin
     */
    @Property(name="passwordBlockPicturePasswordAndPin")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockPicturePasswordAndPin() {
        return Optional.ofNullable(passwordBlockPicturePasswordAndPin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockPicturePasswordAndPin} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using a pictures password and
     * pin.”</i>
     * 
     * @param passwordBlockPicturePasswordAndPin
     *            new value of {@code passwordBlockPicturePasswordAndPin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockPicturePasswordAndPin} field changed
     */
    public Windows81GeneralConfiguration withPasswordBlockPicturePasswordAndPin(Boolean passwordBlockPicturePasswordAndPin) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockPicturePasswordAndPin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordBlockPicturePasswordAndPin = passwordBlockPicturePasswordAndPin;
        return _x;
    }

    /**
     * <i>“Password expiration in days.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Password expiration in days.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public Windows81GeneralConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“The minimum password length.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The minimum password length.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public Windows81GeneralConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“The minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The minutes of inactivity before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public Windows81GeneralConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public Windows81GeneralConfiguration withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public Windows81GeneralConfiguration withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“The required password type.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required password type.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public Windows81GeneralConfiguration withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“The number of sign in failures before factory reset.”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of sign in failures before factory reset.”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public Windows81GeneralConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require encryption on a mobile device.”</i>
     * 
     * @return property storageRequireDeviceEncryption
     */
    @Property(name="storageRequireDeviceEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireDeviceEncryption() {
        return Optional.ofNullable(storageRequireDeviceEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireDeviceEncryption} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require encryption on a mobile device.”</i>
     * 
     * @param storageRequireDeviceEncryption
     *            new value of {@code storageRequireDeviceEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireDeviceEncryption} field changed
     */
    public Windows81GeneralConfiguration withStorageRequireDeviceEncryption(Boolean storageRequireDeviceEncryption) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRequireDeviceEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
        return _x;
    }

    /**
     * <i>“The minimum update classification to install automatically.”</i>
     * 
     * @return property minimumAutoInstallClassification
     */
    @Property(name="minimumAutoInstallClassification")
    @JsonIgnore
    public Optional<UpdateClassification> getMinimumAutoInstallClassification() {
        return Optional.ofNullable(minimumAutoInstallClassification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumAutoInstallClassification} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The minimum update classification to install automatically.”</i>
     * 
     * @param minimumAutoInstallClassification
     *            new value of {@code minimumAutoInstallClassification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumAutoInstallClassification} field changed
     */
    public Windows81GeneralConfiguration withMinimumAutoInstallClassification(UpdateClassification minimumAutoInstallClassification) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumAutoInstallClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.minimumAutoInstallClassification = minimumAutoInstallClassification;
        return _x;
    }

    /**
     * <i>“The minimum update classification to install automatically.”</i>
     * 
     * @return property updatesMinimumAutoInstallClassification
     */
    @Property(name="updatesMinimumAutoInstallClassification")
    @JsonIgnore
    public Optional<UpdateClassification> getUpdatesMinimumAutoInstallClassification() {
        return Optional.ofNullable(updatesMinimumAutoInstallClassification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * updatesMinimumAutoInstallClassification} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The minimum update classification to install automatically.”</i>
     * 
     * @param updatesMinimumAutoInstallClassification
     *            new value of {@code updatesMinimumAutoInstallClassification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updatesMinimumAutoInstallClassification} field changed
     */
    public Windows81GeneralConfiguration withUpdatesMinimumAutoInstallClassification(UpdateClassification updatesMinimumAutoInstallClassification) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("updatesMinimumAutoInstallClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.updatesMinimumAutoInstallClassification = updatesMinimumAutoInstallClassification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require automatic updates.”</i>
     * 
     * @return property updatesRequireAutomaticUpdates
     */
    @Property(name="updatesRequireAutomaticUpdates")
    @JsonIgnore
    public Optional<Boolean> getUpdatesRequireAutomaticUpdates() {
        return Optional.ofNullable(updatesRequireAutomaticUpdates);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * updatesRequireAutomaticUpdates} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require automatic updates.”</i>
     * 
     * @param updatesRequireAutomaticUpdates
     *            new value of {@code updatesRequireAutomaticUpdates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updatesRequireAutomaticUpdates} field changed
     */
    public Windows81GeneralConfiguration withUpdatesRequireAutomaticUpdates(Boolean updatesRequireAutomaticUpdates) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("updatesRequireAutomaticUpdates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.updatesRequireAutomaticUpdates = updatesRequireAutomaticUpdates;
        return _x;
    }

    /**
     * <i>“The user account control settings.”</i>
     * 
     * @return property userAccountControlSettings
     */
    @Property(name="userAccountControlSettings")
    @JsonIgnore
    public Optional<WindowsUserAccountControlSettings> getUserAccountControlSettings() {
        return Optional.ofNullable(userAccountControlSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userAccountControlSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user account control settings.”</i>
     * 
     * @param userAccountControlSettings
     *            new value of {@code userAccountControlSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userAccountControlSettings} field changed
     */
    public Windows81GeneralConfiguration withUserAccountControlSettings(WindowsUserAccountControlSettings userAccountControlSettings) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userAccountControlSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.userAccountControlSettings = userAccountControlSettings;
        return _x;
    }

    /**
     * <i>“The work folders url.”</i>
     * 
     * @return property workFoldersUrl
     */
    @Property(name="workFoldersUrl")
    @JsonIgnore
    public Optional<String> getWorkFoldersUrl() {
        return Optional.ofNullable(workFoldersUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code workFoldersUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The work folders url.”</i>
     * 
     * @param workFoldersUrl
     *            new value of {@code workFoldersUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code workFoldersUrl} field changed
     */
    public Windows81GeneralConfiguration withWorkFoldersUrl(String workFoldersUrl) {
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("workFoldersUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81GeneralConfiguration");
        _x.workFoldersUrl = workFoldersUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81GeneralConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81GeneralConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows81GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows81GeneralConfiguration _copy() {
        Windows81GeneralConfiguration _x = new Windows81GeneralConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
        _x.applyOnlyToWindows81 = applyOnlyToWindows81;
        _x.browserBlockAutofill = browserBlockAutofill;
        _x.browserBlockAutomaticDetectionOfIntranetSites = browserBlockAutomaticDetectionOfIntranetSites;
        _x.browserBlockEnterpriseModeAccess = browserBlockEnterpriseModeAccess;
        _x.browserBlockJavaScript = browserBlockJavaScript;
        _x.browserBlockPlugins = browserBlockPlugins;
        _x.browserBlockPopups = browserBlockPopups;
        _x.browserBlockSendingDoNotTrackHeader = browserBlockSendingDoNotTrackHeader;
        _x.browserBlockSingleWordEntryOnIntranetSites = browserBlockSingleWordEntryOnIntranetSites;
        _x.browserRequireSmartScreen = browserRequireSmartScreen;
        _x.browserEnterpriseModeSiteListLocation = browserEnterpriseModeSiteListLocation;
        _x.browserInternetSecurityLevel = browserInternetSecurityLevel;
        _x.browserIntranetSecurityLevel = browserIntranetSecurityLevel;
        _x.browserLoggingReportLocation = browserLoggingReportLocation;
        _x.browserRequireHighSecurityForRestrictedSites = browserRequireHighSecurityForRestrictedSites;
        _x.browserRequireFirewall = browserRequireFirewall;
        _x.browserRequireFraudWarning = browserRequireFraudWarning;
        _x.browserTrustedSitesSecurityLevel = browserTrustedSitesSecurityLevel;
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        _x.diagnosticsBlockDataSubmission = diagnosticsBlockDataSubmission;
        _x.passwordBlockPicturePasswordAndPin = passwordBlockPicturePasswordAndPin;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
        _x.minimumAutoInstallClassification = minimumAutoInstallClassification;
        _x.updatesMinimumAutoInstallClassification = updatesMinimumAutoInstallClassification;
        _x.updatesRequireAutomaticUpdates = updatesRequireAutomaticUpdates;
        _x.userAccountControlSettings = userAccountControlSettings;
        _x.workFoldersUrl = workFoldersUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81GeneralConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("accountsBlockAddingNonMicrosoftAccountEmail=");
        b.append(this.accountsBlockAddingNonMicrosoftAccountEmail);
        b.append(", ");
        b.append("applyOnlyToWindows81=");
        b.append(this.applyOnlyToWindows81);
        b.append(", ");
        b.append("browserBlockAutofill=");
        b.append(this.browserBlockAutofill);
        b.append(", ");
        b.append("browserBlockAutomaticDetectionOfIntranetSites=");
        b.append(this.browserBlockAutomaticDetectionOfIntranetSites);
        b.append(", ");
        b.append("browserBlockEnterpriseModeAccess=");
        b.append(this.browserBlockEnterpriseModeAccess);
        b.append(", ");
        b.append("browserBlockJavaScript=");
        b.append(this.browserBlockJavaScript);
        b.append(", ");
        b.append("browserBlockPlugins=");
        b.append(this.browserBlockPlugins);
        b.append(", ");
        b.append("browserBlockPopups=");
        b.append(this.browserBlockPopups);
        b.append(", ");
        b.append("browserBlockSendingDoNotTrackHeader=");
        b.append(this.browserBlockSendingDoNotTrackHeader);
        b.append(", ");
        b.append("browserBlockSingleWordEntryOnIntranetSites=");
        b.append(this.browserBlockSingleWordEntryOnIntranetSites);
        b.append(", ");
        b.append("browserRequireSmartScreen=");
        b.append(this.browserRequireSmartScreen);
        b.append(", ");
        b.append("browserEnterpriseModeSiteListLocation=");
        b.append(this.browserEnterpriseModeSiteListLocation);
        b.append(", ");
        b.append("browserInternetSecurityLevel=");
        b.append(this.browserInternetSecurityLevel);
        b.append(", ");
        b.append("browserIntranetSecurityLevel=");
        b.append(this.browserIntranetSecurityLevel);
        b.append(", ");
        b.append("browserLoggingReportLocation=");
        b.append(this.browserLoggingReportLocation);
        b.append(", ");
        b.append("browserRequireHighSecurityForRestrictedSites=");
        b.append(this.browserRequireHighSecurityForRestrictedSites);
        b.append(", ");
        b.append("browserRequireFirewall=");
        b.append(this.browserRequireFirewall);
        b.append(", ");
        b.append("browserRequireFraudWarning=");
        b.append(this.browserRequireFraudWarning);
        b.append(", ");
        b.append("browserTrustedSitesSecurityLevel=");
        b.append(this.browserTrustedSitesSecurityLevel);
        b.append(", ");
        b.append("cellularBlockDataRoaming=");
        b.append(this.cellularBlockDataRoaming);
        b.append(", ");
        b.append("diagnosticsBlockDataSubmission=");
        b.append(this.diagnosticsBlockDataSubmission);
        b.append(", ");
        b.append("passwordBlockPicturePasswordAndPin=");
        b.append(this.passwordBlockPicturePasswordAndPin);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("storageRequireDeviceEncryption=");
        b.append(this.storageRequireDeviceEncryption);
        b.append(", ");
        b.append("minimumAutoInstallClassification=");
        b.append(this.minimumAutoInstallClassification);
        b.append(", ");
        b.append("updatesMinimumAutoInstallClassification=");
        b.append(this.updatesMinimumAutoInstallClassification);
        b.append(", ");
        b.append("updatesRequireAutomaticUpdates=");
        b.append(this.updatesRequireAutomaticUpdates);
        b.append(", ");
        b.append("userAccountControlSettings=");
        b.append(this.userAccountControlSettings);
        b.append(", ");
        b.append("workFoldersUrl=");
        b.append(this.workFoldersUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
