package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RequiredPasswordType;


/**
 * <i>“This class contains compliance settings for Windows 8.1.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passwordRequired", 
    "passwordBlockSimple", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordMinimumCharacterSetCount", 
    "passwordRequiredType", 
    "passwordPreviousPasswordBlockCount", 
    "osMinimumVersion", 
    "osMaximumVersion", 
    "storageRequireEncryption"})
@JsonInclude(Include.NON_NULL)
public class Windows81CompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81CompliancePolicy";
    }

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    protected Windows81CompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows81CompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private OffsetDateTime lastModifiedDateTime;
        private String displayName;
        private Integer version;
        private Boolean passwordRequired;
        private Boolean passwordBlockSimple;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Integer passwordMinimumCharacterSetCount;
        private RequiredPasswordType passwordRequiredType;
        private Integer passwordPreviousPasswordBlockCount;
        private String osMinimumVersion;
        private String osMaximumVersion;
        private Boolean storageRequireEncryption;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Require a password to unlock Windows device.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block simple password.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“Password expiration in days.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“The minimum password length.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a password is required.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The required password type.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Minimum Windows 8.1 version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Maximum Windows 8.1 version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require encryption on a windows 8.1 device.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        public Windows81CompliancePolicy build() {
            Windows81CompliancePolicy _x = new Windows81CompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows81CompliancePolicy";
            _x.id = id;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.displayName = displayName;
            _x.version = version;
            _x.passwordRequired = passwordRequired;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.osMinimumVersion = osMinimumVersion;
            _x.osMaximumVersion = osMaximumVersion;
            _x.storageRequireEncryption = storageRequireEncryption;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Require a password to unlock Windows device.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require a password to unlock Windows device.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public Windows81CompliancePolicy withPasswordRequired(Boolean passwordRequired) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block simple password.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block simple password.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public Windows81CompliancePolicy withPasswordBlockSimple(Boolean passwordBlockSimple) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“Password expiration in days.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Password expiration in days.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public Windows81CompliancePolicy withPasswordExpirationDays(Integer passwordExpirationDays) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“The minimum password length.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The minimum password length.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public Windows81CompliancePolicy withPasswordMinimumLength(Integer passwordMinimumLength) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public Windows81CompliancePolicy withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public Windows81CompliancePolicy withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The required password type.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required password type.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public Windows81CompliancePolicy withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of previous passwords to prevent re-use of. Valid values 0 to 24”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public Windows81CompliancePolicy withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Minimum Windows 8.1 version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum Windows 8.1 version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public Windows81CompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Maximum Windows 8.1 version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum Windows 8.1 version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public Windows81CompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require encryption on a windows 8.1 device.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require encryption on a windows 8.1 device.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public Windows81CompliancePolicy withStorageRequireEncryption(Boolean storageRequireEncryption) {
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CompliancePolicy");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows81CompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows81CompliancePolicy _copy() {
        Windows81CompliancePolicy _x = new Windows81CompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.version = version;
        _x.passwordRequired = passwordRequired;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.osMinimumVersion = osMinimumVersion;
        _x.osMaximumVersion = osMaximumVersion;
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81CompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
