package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomSubjectAlternativeName;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Device Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "extendedKeyUsages", 
    "customSubjectAlternativeNames"})
@JsonInclude(Include.NON_NULL)
public class Windows81CertificateProfileBase extends WindowsCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81CertificateProfileBase";
    }

    @JsonProperty("extendedKeyUsages")
    protected List<ExtendedKeyUsage> extendedKeyUsages;

    @JsonProperty("extendedKeyUsages@nextLink")
    protected String extendedKeyUsagesNextLink;

    @JsonProperty("customSubjectAlternativeNames")
    protected List<CustomSubjectAlternativeName> customSubjectAlternativeNames;

    @JsonProperty("customSubjectAlternativeNames@nextLink")
    protected String customSubjectAlternativeNamesNextLink;

    protected Windows81CertificateProfileBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages() {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages(HttpRequestOptions options) {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames() {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames(HttpRequestOptions options) {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CertificateProfileBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CertificateProfileBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows81CertificateProfileBase _copy() {
        Windows81CertificateProfileBase _x = new Windows81CertificateProfileBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.keyStorageProvider = keyStorageProvider;
        _x.subjectNameFormat = subjectNameFormat;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81CertificateProfileBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("keyStorageProvider=");
        b.append(this.keyStorageProvider);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("customSubjectAlternativeNames=");
        b.append(this.customSubjectAlternativeNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
