package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CryptographySuite;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.complex.VpnDnsRule;
import odata.msgraph.client.beta.complex.VpnRoute;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.complex.VpnTrafficRule;
import odata.msgraph.client.beta.complex.Windows10AssociatedApps;
import odata.msgraph.client.beta.complex.Windows10VpnProxyServer;
import odata.msgraph.client.beta.entity.request.WindowsCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.Windows10VpnAuthenticationMethod;
import odata.msgraph.client.beta.enums.Windows10VpnConnectionType;
import odata.msgraph.client.beta.enums.Windows10VpnProfileTarget;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“By providing the configurations in this profile you can instruct the Windows 10
 * device (desktop or mobile) to connect to desired VPN endpoint. By specifying the
 * authentication method and security types expected by VPN endpoint you can make
 * the VPN connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "profileTarget", 
    "connectionType", 
    "enableSplitTunneling", 
    "enableAlwaysOn", 
    "enableDeviceTunnel", 
    "enableDnsRegistration", 
    "dnsSuffixes", 
    "authenticationMethod", 
    "rememberUserCredentials", 
    "enableConditionalAccess", 
    "enableSingleSignOnWithAlternateCertificate", 
    "singleSignOnEku", 
    "singleSignOnIssuerHash", 
    "eapXml", 
    "proxyServer", 
    "associatedApps", 
    "onlyAssociatedAppsCanUseConnection", 
    "windowsInformationProtectionDomain", 
    "trafficRules", 
    "routes", 
    "dnsRules", 
    "trustedNetworkDomains", 
    "cryptographySuite"})
@JsonInclude(Include.NON_NULL)
public class Windows10VpnConfiguration extends WindowsVpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10VpnConfiguration";
    }

    @JsonProperty("profileTarget")
    protected Windows10VpnProfileTarget profileTarget;

    @JsonProperty("connectionType")
    protected Windows10VpnConnectionType connectionType;

    @JsonProperty("enableSplitTunneling")
    protected Boolean enableSplitTunneling;

    @JsonProperty("enableAlwaysOn")
    protected Boolean enableAlwaysOn;

    @JsonProperty("enableDeviceTunnel")
    protected Boolean enableDeviceTunnel;

    @JsonProperty("enableDnsRegistration")
    protected Boolean enableDnsRegistration;

    @JsonProperty("dnsSuffixes")
    protected List<String> dnsSuffixes;

    @JsonProperty("dnsSuffixes@nextLink")
    protected String dnsSuffixesNextLink;

    @JsonProperty("authenticationMethod")
    protected Windows10VpnAuthenticationMethod authenticationMethod;

    @JsonProperty("rememberUserCredentials")
    protected Boolean rememberUserCredentials;

    @JsonProperty("enableConditionalAccess")
    protected Boolean enableConditionalAccess;

    @JsonProperty("enableSingleSignOnWithAlternateCertificate")
    protected Boolean enableSingleSignOnWithAlternateCertificate;

    @JsonProperty("singleSignOnEku")
    protected ExtendedKeyUsage singleSignOnEku;

    @JsonProperty("singleSignOnIssuerHash")
    protected String singleSignOnIssuerHash;

    @JsonProperty("eapXml")
    protected byte[] eapXml;

    @JsonProperty("proxyServer")
    protected Windows10VpnProxyServer proxyServer;

    @JsonProperty("associatedApps")
    protected List<Windows10AssociatedApps> associatedApps;

    @JsonProperty("associatedApps@nextLink")
    protected String associatedAppsNextLink;

    @JsonProperty("onlyAssociatedAppsCanUseConnection")
    protected Boolean onlyAssociatedAppsCanUseConnection;

    @JsonProperty("windowsInformationProtectionDomain")
    protected String windowsInformationProtectionDomain;

    @JsonProperty("trafficRules")
    protected List<VpnTrafficRule> trafficRules;

    @JsonProperty("trafficRules@nextLink")
    protected String trafficRulesNextLink;

    @JsonProperty("routes")
    protected List<VpnRoute> routes;

    @JsonProperty("routes@nextLink")
    protected String routesNextLink;

    @JsonProperty("dnsRules")
    protected List<VpnDnsRule> dnsRules;

    @JsonProperty("dnsRules@nextLink")
    protected String dnsRulesNextLink;

    @JsonProperty("trustedNetworkDomains")
    protected List<String> trustedNetworkDomains;

    @JsonProperty("trustedNetworkDomains@nextLink")
    protected String trustedNetworkDomainsNextLink;

    @JsonProperty("cryptographySuite")
    protected CryptographySuite cryptographySuite;

    protected Windows10VpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10VpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String connectionName;
        private List<VpnServer> servers;
        private String serversNextLink;
        private byte[] customXml;
        private Windows10VpnProfileTarget profileTarget;
        private Windows10VpnConnectionType connectionType;
        private Boolean enableSplitTunneling;
        private Boolean enableAlwaysOn;
        private Boolean enableDeviceTunnel;
        private Boolean enableDnsRegistration;
        private List<String> dnsSuffixes;
        private String dnsSuffixesNextLink;
        private Windows10VpnAuthenticationMethod authenticationMethod;
        private Boolean rememberUserCredentials;
        private Boolean enableConditionalAccess;
        private Boolean enableSingleSignOnWithAlternateCertificate;
        private ExtendedKeyUsage singleSignOnEku;
        private String singleSignOnIssuerHash;
        private byte[] eapXml;
        private Windows10VpnProxyServer proxyServer;
        private List<Windows10AssociatedApps> associatedApps;
        private String associatedAppsNextLink;
        private Boolean onlyAssociatedAppsCanUseConnection;
        private String windowsInformationProtectionDomain;
        private List<VpnTrafficRule> trafficRules;
        private String trafficRulesNextLink;
        private List<VpnRoute> routes;
        private String routesNextLink;
        private List<VpnDnsRule> dnsRules;
        private String dnsRulesNextLink;
        private List<String> trustedNetworkDomains;
        private String trustedNetworkDomainsNextLink;
        private CryptographySuite cryptographySuite;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder customXml(byte[] customXml) {
            this.customXml = customXml;
            this.changedFields = changedFields.add("customXml");
            return this;
        }

        /**
         * <i>“Profile target type.”</i>
         * 
         * @param profileTarget
         *            value of {@code profileTarget} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileTarget(Windows10VpnProfileTarget profileTarget) {
            this.profileTarget = profileTarget;
            this.changedFields = changedFields.add("profileTarget");
            return this;
        }

        /**
         * <i>“Connection type.”</i>
         * 
         * @param connectionType
         *            value of {@code connectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionType(Windows10VpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        /**
         * <i>“Enable split tunneling.”</i>
         * 
         * @param enableSplitTunneling
         *            value of {@code enableSplitTunneling} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSplitTunneling(Boolean enableSplitTunneling) {
            this.enableSplitTunneling = enableSplitTunneling;
            this.changedFields = changedFields.add("enableSplitTunneling");
            return this;
        }

        /**
         * <i>“Enable Always On mode.”</i>
         * 
         * @param enableAlwaysOn
         *            value of {@code enableAlwaysOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableAlwaysOn(Boolean enableAlwaysOn) {
            this.enableAlwaysOn = enableAlwaysOn;
            this.changedFields = changedFields.add("enableAlwaysOn");
            return this;
        }

        /**
         * <i>“Enable device tunnel.”</i>
         * 
         * @param enableDeviceTunnel
         *            value of {@code enableDeviceTunnel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableDeviceTunnel(Boolean enableDeviceTunnel) {
            this.enableDeviceTunnel = enableDeviceTunnel;
            this.changedFields = changedFields.add("enableDeviceTunnel");
            return this;
        }

        /**
         * <i>“Enable IP address registration with internal DNS.”</i>
         * 
         * @param enableDnsRegistration
         *            value of {@code enableDnsRegistration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableDnsRegistration(Boolean enableDnsRegistration) {
            this.enableDnsRegistration = enableDnsRegistration;
            this.changedFields = changedFields.add("enableDnsRegistration");
            return this;
        }

        /**
         * <i>“Specify DNS suffixes to add to the DNS search list to properly route short names
         * .”</i>
         * 
         * @param dnsSuffixes
         *            value of {@code dnsSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixes(List<String> dnsSuffixes) {
            this.dnsSuffixes = dnsSuffixes;
            this.changedFields = changedFields.add("dnsSuffixes");
            return this;
        }

        /**
         * <i>“Specify DNS suffixes to add to the DNS search list to properly route short names
         * .”</i>
         * 
         * @param dnsSuffixes
         *            value of {@code dnsSuffixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixes(String... dnsSuffixes) {
            return dnsSuffixes(Arrays.asList(dnsSuffixes));
        }

        /**
         * <i>“Specify DNS suffixes to add to the DNS search list to properly route short names
         * .”</i>
         * 
         * @param dnsSuffixesNextLink
         *            value of {@code dnsSuffixes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixesNextLink(String dnsSuffixesNextLink) {
            this.dnsSuffixesNextLink = dnsSuffixesNextLink;
            this.changedFields = changedFields.add("dnsSuffixes");
            return this;
        }

        /**
         * <i>“Authentication method.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(Windows10VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Remember user credentials.”</i>
         * 
         * @param rememberUserCredentials
         *            value of {@code rememberUserCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rememberUserCredentials(Boolean rememberUserCredentials) {
            this.rememberUserCredentials = rememberUserCredentials;
            this.changedFields = changedFields.add("rememberUserCredentials");
            return this;
        }

        /**
         * <i>“Enable conditional access.”</i>
         * 
         * @param enableConditionalAccess
         *            value of {@code enableConditionalAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableConditionalAccess(Boolean enableConditionalAccess) {
            this.enableConditionalAccess = enableConditionalAccess;
            this.changedFields = changedFields.add("enableConditionalAccess");
            return this;
        }

        /**
         * <i>“Enable single sign-on (SSO) with alternate certificate.”</i>
         * 
         * @param enableSingleSignOnWithAlternateCertificate
         *            value of {@code enableSingleSignOnWithAlternateCertificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableSingleSignOnWithAlternateCertificate(Boolean enableSingleSignOnWithAlternateCertificate) {
            this.enableSingleSignOnWithAlternateCertificate = enableSingleSignOnWithAlternateCertificate;
            this.changedFields = changedFields.add("enableSingleSignOnWithAlternateCertificate");
            return this;
        }

        /**
         * <i>“Single sign-on Extended Key Usage (EKU).”</i>
         * 
         * @param singleSignOnEku
         *            value of {@code singleSignOnEku} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleSignOnEku(ExtendedKeyUsage singleSignOnEku) {
            this.singleSignOnEku = singleSignOnEku;
            this.changedFields = changedFields.add("singleSignOnEku");
            return this;
        }

        /**
         * <i>“Single sign-on issuer hash.”</i>
         * 
         * @param singleSignOnIssuerHash
         *            value of {@code singleSignOnIssuerHash} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder singleSignOnIssuerHash(String singleSignOnIssuerHash) {
            this.singleSignOnIssuerHash = singleSignOnIssuerHash;
            this.changedFields = changedFields.add("singleSignOnIssuerHash");
            return this;
        }

        /**
         * <i>“Extensible Authentication Protocol (EAP) XML. (UTF8 encoded byte array)”</i>
         * 
         * @param eapXml
         *            value of {@code eapXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapXml(byte[] eapXml) {
            this.eapXml = eapXml;
            this.changedFields = changedFields.add("eapXml");
            return this;
        }

        /**
         * <i>“Proxy Server.”</i>
         * 
         * @param proxyServer
         *            value of {@code proxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyServer(Windows10VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        /**
         * <i>“Associated Apps. This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param associatedApps
         *            value of {@code associatedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedApps(List<Windows10AssociatedApps> associatedApps) {
            this.associatedApps = associatedApps;
            this.changedFields = changedFields.add("associatedApps");
            return this;
        }

        /**
         * <i>“Associated Apps. This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param associatedApps
         *            value of {@code associatedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedApps(Windows10AssociatedApps... associatedApps) {
            return associatedApps(Arrays.asList(associatedApps));
        }

        /**
         * <i>“Associated Apps. This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param associatedAppsNextLink
         *            value of {@code associatedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder associatedAppsNextLink(String associatedAppsNextLink) {
            this.associatedAppsNextLink = associatedAppsNextLink;
            this.changedFields = changedFields.add("associatedApps");
            return this;
        }

        /**
         * <i>“Only associated Apps can use connection (per-app VPN).”</i>
         * 
         * @param onlyAssociatedAppsCanUseConnection
         *            value of {@code onlyAssociatedAppsCanUseConnection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onlyAssociatedAppsCanUseConnection(Boolean onlyAssociatedAppsCanUseConnection) {
            this.onlyAssociatedAppsCanUseConnection = onlyAssociatedAppsCanUseConnection;
            this.changedFields = changedFields.add("onlyAssociatedAppsCanUseConnection");
            return this;
        }

        /**
         * <i>“Windows Information Protection (WIP) domain to associate with this connection.”</i>
         * 
         * @param windowsInformationProtectionDomain
         *            value of {@code windowsInformationProtectionDomain} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionDomain(String windowsInformationProtectionDomain) {
            this.windowsInformationProtectionDomain = windowsInformationProtectionDomain;
            this.changedFields = changedFields.add("windowsInformationProtectionDomain");
            return this;
        }

        /**
         * <i>“Traffic rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param trafficRules
         *            value of {@code trafficRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trafficRules(List<VpnTrafficRule> trafficRules) {
            this.trafficRules = trafficRules;
            this.changedFields = changedFields.add("trafficRules");
            return this;
        }

        /**
         * <i>“Traffic rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param trafficRules
         *            value of {@code trafficRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trafficRules(VpnTrafficRule... trafficRules) {
            return trafficRules(Arrays.asList(trafficRules));
        }

        /**
         * <i>“Traffic rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param trafficRulesNextLink
         *            value of {@code trafficRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trafficRulesNextLink(String trafficRulesNextLink) {
            this.trafficRulesNextLink = trafficRulesNextLink;
            this.changedFields = changedFields.add("trafficRules");
            return this;
        }

        /**
         * <i>“Routes (optional for third-party providers). This collection can contain a
         * maximum of 1000 elements.”</i>
         * 
         * @param routes
         *            value of {@code routes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routes(List<VpnRoute> routes) {
            this.routes = routes;
            this.changedFields = changedFields.add("routes");
            return this;
        }

        /**
         * <i>“Routes (optional for third-party providers). This collection can contain a
         * maximum of 1000 elements.”</i>
         * 
         * @param routes
         *            value of {@code routes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routes(VpnRoute... routes) {
            return routes(Arrays.asList(routes));
        }

        /**
         * <i>“Routes (optional for third-party providers). This collection can contain a
         * maximum of 1000 elements.”</i>
         * 
         * @param routesNextLink
         *            value of {@code routes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesNextLink(String routesNextLink) {
            this.routesNextLink = routesNextLink;
            this.changedFields = changedFields.add("routes");
            return this;
        }

        /**
         * <i>“DNS rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param dnsRules
         *            value of {@code dnsRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsRules(List<VpnDnsRule> dnsRules) {
            this.dnsRules = dnsRules;
            this.changedFields = changedFields.add("dnsRules");
            return this;
        }

        /**
         * <i>“DNS rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param dnsRules
         *            value of {@code dnsRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsRules(VpnDnsRule... dnsRules) {
            return dnsRules(Arrays.asList(dnsRules));
        }

        /**
         * <i>“DNS rules. This collection can contain a maximum of 1000 elements.”</i>
         * 
         * @param dnsRulesNextLink
         *            value of {@code dnsRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsRulesNextLink(String dnsRulesNextLink) {
            this.dnsRulesNextLink = dnsRulesNextLink;
            this.changedFields = changedFields.add("dnsRules");
            return this;
        }

        /**
         * <i>“Trusted Network Domains”</i>
         * 
         * @param trustedNetworkDomains
         *            value of {@code trustedNetworkDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedNetworkDomains(List<String> trustedNetworkDomains) {
            this.trustedNetworkDomains = trustedNetworkDomains;
            this.changedFields = changedFields.add("trustedNetworkDomains");
            return this;
        }

        /**
         * <i>“Trusted Network Domains”</i>
         * 
         * @param trustedNetworkDomains
         *            value of {@code trustedNetworkDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedNetworkDomains(String... trustedNetworkDomains) {
            return trustedNetworkDomains(Arrays.asList(trustedNetworkDomains));
        }

        /**
         * <i>“Trusted Network Domains”</i>
         * 
         * @param trustedNetworkDomainsNextLink
         *            value of {@code trustedNetworkDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedNetworkDomainsNextLink(String trustedNetworkDomainsNextLink) {
            this.trustedNetworkDomainsNextLink = trustedNetworkDomainsNextLink;
            this.changedFields = changedFields.add("trustedNetworkDomains");
            return this;
        }

        /**
         * <i>“Cryptography Suite security settings for IKEv2 VPN in Windows10 and above”</i>
         * 
         * @param cryptographySuite
         *            value of {@code cryptographySuite} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cryptographySuite(CryptographySuite cryptographySuite) {
            this.cryptographySuite = cryptographySuite;
            this.changedFields = changedFields.add("cryptographySuite");
            return this;
        }

        public Windows10VpnConfiguration build() {
            Windows10VpnConfiguration _x = new Windows10VpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10VpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.connectionName = connectionName;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.customXml = customXml;
            _x.profileTarget = profileTarget;
            _x.connectionType = connectionType;
            _x.enableSplitTunneling = enableSplitTunneling;
            _x.enableAlwaysOn = enableAlwaysOn;
            _x.enableDeviceTunnel = enableDeviceTunnel;
            _x.enableDnsRegistration = enableDnsRegistration;
            _x.dnsSuffixes = dnsSuffixes;
            _x.dnsSuffixesNextLink = dnsSuffixesNextLink;
            _x.authenticationMethod = authenticationMethod;
            _x.rememberUserCredentials = rememberUserCredentials;
            _x.enableConditionalAccess = enableConditionalAccess;
            _x.enableSingleSignOnWithAlternateCertificate = enableSingleSignOnWithAlternateCertificate;
            _x.singleSignOnEku = singleSignOnEku;
            _x.singleSignOnIssuerHash = singleSignOnIssuerHash;
            _x.eapXml = eapXml;
            _x.proxyServer = proxyServer;
            _x.associatedApps = associatedApps;
            _x.associatedAppsNextLink = associatedAppsNextLink;
            _x.onlyAssociatedAppsCanUseConnection = onlyAssociatedAppsCanUseConnection;
            _x.windowsInformationProtectionDomain = windowsInformationProtectionDomain;
            _x.trafficRules = trafficRules;
            _x.trafficRulesNextLink = trafficRulesNextLink;
            _x.routes = routes;
            _x.routesNextLink = routesNextLink;
            _x.dnsRules = dnsRules;
            _x.dnsRulesNextLink = dnsRulesNextLink;
            _x.trustedNetworkDomains = trustedNetworkDomains;
            _x.trustedNetworkDomainsNextLink = trustedNetworkDomainsNextLink;
            _x.cryptographySuite = cryptographySuite;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Profile target type.”</i>
     * 
     * @return property profileTarget
     */
    @Property(name="profileTarget")
    @JsonIgnore
    public Optional<Windows10VpnProfileTarget> getProfileTarget() {
        return Optional.ofNullable(profileTarget);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileTarget}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Profile target type.”</i>
     * 
     * @param profileTarget
     *            new value of {@code profileTarget} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileTarget} field changed
     */
    public Windows10VpnConfiguration withProfileTarget(Windows10VpnProfileTarget profileTarget) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("profileTarget");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.profileTarget = profileTarget;
        return _x;
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<Windows10VpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public Windows10VpnConfiguration withConnectionType(Windows10VpnConnectionType connectionType) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Enable split tunneling.”</i>
     * 
     * @return property enableSplitTunneling
     */
    @Property(name="enableSplitTunneling")
    @JsonIgnore
    public Optional<Boolean> getEnableSplitTunneling() {
        return Optional.ofNullable(enableSplitTunneling);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSplitTunneling} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enable split tunneling.”</i>
     * 
     * @param enableSplitTunneling
     *            new value of {@code enableSplitTunneling} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSplitTunneling} field changed
     */
    public Windows10VpnConfiguration withEnableSplitTunneling(Boolean enableSplitTunneling) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableSplitTunneling");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableSplitTunneling = enableSplitTunneling;
        return _x;
    }

    /**
     * <i>“Enable Always On mode.”</i>
     * 
     * @return property enableAlwaysOn
     */
    @Property(name="enableAlwaysOn")
    @JsonIgnore
    public Optional<Boolean> getEnableAlwaysOn() {
        return Optional.ofNullable(enableAlwaysOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enableAlwaysOn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enable Always On mode.”</i>
     * 
     * @param enableAlwaysOn
     *            new value of {@code enableAlwaysOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableAlwaysOn} field changed
     */
    public Windows10VpnConfiguration withEnableAlwaysOn(Boolean enableAlwaysOn) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableAlwaysOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableAlwaysOn = enableAlwaysOn;
        return _x;
    }

    /**
     * <i>“Enable device tunnel.”</i>
     * 
     * @return property enableDeviceTunnel
     */
    @Property(name="enableDeviceTunnel")
    @JsonIgnore
    public Optional<Boolean> getEnableDeviceTunnel() {
        return Optional.ofNullable(enableDeviceTunnel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableDeviceTunnel} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enable device tunnel.”</i>
     * 
     * @param enableDeviceTunnel
     *            new value of {@code enableDeviceTunnel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableDeviceTunnel} field changed
     */
    public Windows10VpnConfiguration withEnableDeviceTunnel(Boolean enableDeviceTunnel) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableDeviceTunnel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableDeviceTunnel = enableDeviceTunnel;
        return _x;
    }

    /**
     * <i>“Enable IP address registration with internal DNS.”</i>
     * 
     * @return property enableDnsRegistration
     */
    @Property(name="enableDnsRegistration")
    @JsonIgnore
    public Optional<Boolean> getEnableDnsRegistration() {
        return Optional.ofNullable(enableDnsRegistration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableDnsRegistration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enable IP address registration with internal DNS.”</i>
     * 
     * @param enableDnsRegistration
     *            new value of {@code enableDnsRegistration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableDnsRegistration} field changed
     */
    public Windows10VpnConfiguration withEnableDnsRegistration(Boolean enableDnsRegistration) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableDnsRegistration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableDnsRegistration = enableDnsRegistration;
        return _x;
    }

    /**
     * <i>“Specify DNS suffixes to add to the DNS search list to properly route short names
     * .”</i>
     * 
     * @return property dnsSuffixes
     */
    @Property(name="dnsSuffixes")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixes() {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixes, Optional.ofNullable(dnsSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Specify DNS suffixes to add to the DNS search list to properly route short names
     * .”</i>
     * 
     * @return property dnsSuffixes
     */
    @Property(name="dnsSuffixes")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, dnsSuffixes, Optional.ofNullable(dnsSuffixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<Windows10VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public Windows10VpnConfiguration withAuthenticationMethod(Windows10VpnAuthenticationMethod authenticationMethod) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Remember user credentials.”</i>
     * 
     * @return property rememberUserCredentials
     */
    @Property(name="rememberUserCredentials")
    @JsonIgnore
    public Optional<Boolean> getRememberUserCredentials() {
        return Optional.ofNullable(rememberUserCredentials);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * rememberUserCredentials} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Remember user credentials.”</i>
     * 
     * @param rememberUserCredentials
     *            new value of {@code rememberUserCredentials} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rememberUserCredentials} field changed
     */
    public Windows10VpnConfiguration withRememberUserCredentials(Boolean rememberUserCredentials) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("rememberUserCredentials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.rememberUserCredentials = rememberUserCredentials;
        return _x;
    }

    /**
     * <i>“Enable conditional access.”</i>
     * 
     * @return property enableConditionalAccess
     */
    @Property(name="enableConditionalAccess")
    @JsonIgnore
    public Optional<Boolean> getEnableConditionalAccess() {
        return Optional.ofNullable(enableConditionalAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableConditionalAccess} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable conditional access.”</i>
     * 
     * @param enableConditionalAccess
     *            new value of {@code enableConditionalAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableConditionalAccess} field changed
     */
    public Windows10VpnConfiguration withEnableConditionalAccess(Boolean enableConditionalAccess) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableConditionalAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableConditionalAccess = enableConditionalAccess;
        return _x;
    }

    /**
     * <i>“Enable single sign-on (SSO) with alternate certificate.”</i>
     * 
     * @return property enableSingleSignOnWithAlternateCertificate
     */
    @Property(name="enableSingleSignOnWithAlternateCertificate")
    @JsonIgnore
    public Optional<Boolean> getEnableSingleSignOnWithAlternateCertificate() {
        return Optional.ofNullable(enableSingleSignOnWithAlternateCertificate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSingleSignOnWithAlternateCertificate} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enable single sign-on (SSO) with alternate certificate.”</i>
     * 
     * @param enableSingleSignOnWithAlternateCertificate
     *            new value of {@code enableSingleSignOnWithAlternateCertificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSingleSignOnWithAlternateCertificate} field changed
     */
    public Windows10VpnConfiguration withEnableSingleSignOnWithAlternateCertificate(Boolean enableSingleSignOnWithAlternateCertificate) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableSingleSignOnWithAlternateCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.enableSingleSignOnWithAlternateCertificate = enableSingleSignOnWithAlternateCertificate;
        return _x;
    }

    /**
     * <i>“Single sign-on Extended Key Usage (EKU).”</i>
     * 
     * @return property singleSignOnEku
     */
    @Property(name="singleSignOnEku")
    @JsonIgnore
    public Optional<ExtendedKeyUsage> getSingleSignOnEku() {
        return Optional.ofNullable(singleSignOnEku);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code singleSignOnEku}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Single sign-on Extended Key Usage (EKU).”</i>
     * 
     * @param singleSignOnEku
     *            new value of {@code singleSignOnEku} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleSignOnEku} field changed
     */
    public Windows10VpnConfiguration withSingleSignOnEku(ExtendedKeyUsage singleSignOnEku) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("singleSignOnEku");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.singleSignOnEku = singleSignOnEku;
        return _x;
    }

    /**
     * <i>“Single sign-on issuer hash.”</i>
     * 
     * @return property singleSignOnIssuerHash
     */
    @Property(name="singleSignOnIssuerHash")
    @JsonIgnore
    public Optional<String> getSingleSignOnIssuerHash() {
        return Optional.ofNullable(singleSignOnIssuerHash);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * singleSignOnIssuerHash} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Single sign-on issuer hash.”</i>
     * 
     * @param singleSignOnIssuerHash
     *            new value of {@code singleSignOnIssuerHash} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code singleSignOnIssuerHash} field changed
     */
    public Windows10VpnConfiguration withSingleSignOnIssuerHash(String singleSignOnIssuerHash) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("singleSignOnIssuerHash");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.singleSignOnIssuerHash = singleSignOnIssuerHash;
        return _x;
    }

    /**
     * <i>“Extensible Authentication Protocol (EAP) XML. (UTF8 encoded byte array)”</i>
     * 
     * @return property eapXml
     */
    @Property(name="eapXml")
    @JsonIgnore
    public Optional<byte[]> getEapXml() {
        return Optional.ofNullable(eapXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapXml} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Extensible Authentication Protocol (EAP) XML. (UTF8 encoded byte array)”</i>
     * 
     * @param eapXml
     *            new value of {@code eapXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapXml} field changed
     */
    public Windows10VpnConfiguration withEapXml(byte[] eapXml) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.eapXml = eapXml;
        return _x;
    }

    /**
     * <i>“Proxy Server.”</i>
     * 
     * @return property proxyServer
     */
    @Property(name="proxyServer")
    @JsonIgnore
    public Optional<Windows10VpnProxyServer> getProxyServer() {
        return Optional.ofNullable(proxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy Server.”</i>
     * 
     * @param proxyServer
     *            new value of {@code proxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServer} field changed
     */
    public Windows10VpnConfiguration withProxyServer(Windows10VpnProxyServer proxyServer) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.proxyServer = proxyServer;
        return _x;
    }

    /**
     * <i>“Associated Apps. This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property associatedApps
     */
    @Property(name="associatedApps")
    @JsonIgnore
    public CollectionPage<Windows10AssociatedApps> getAssociatedApps() {
        return new CollectionPage<Windows10AssociatedApps>(contextPath, Windows10AssociatedApps.class, associatedApps, Optional.ofNullable(associatedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Associated Apps. This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property associatedApps
     */
    @Property(name="associatedApps")
    @JsonIgnore
    public CollectionPage<Windows10AssociatedApps> getAssociatedApps(HttpRequestOptions options) {
        return new CollectionPage<Windows10AssociatedApps>(contextPath, Windows10AssociatedApps.class, associatedApps, Optional.ofNullable(associatedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Only associated Apps can use connection (per-app VPN).”</i>
     * 
     * @return property onlyAssociatedAppsCanUseConnection
     */
    @Property(name="onlyAssociatedAppsCanUseConnection")
    @JsonIgnore
    public Optional<Boolean> getOnlyAssociatedAppsCanUseConnection() {
        return Optional.ofNullable(onlyAssociatedAppsCanUseConnection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * onlyAssociatedAppsCanUseConnection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Only associated Apps can use connection (per-app VPN).”</i>
     * 
     * @param onlyAssociatedAppsCanUseConnection
     *            new value of {@code onlyAssociatedAppsCanUseConnection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onlyAssociatedAppsCanUseConnection} field changed
     */
    public Windows10VpnConfiguration withOnlyAssociatedAppsCanUseConnection(Boolean onlyAssociatedAppsCanUseConnection) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("onlyAssociatedAppsCanUseConnection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.onlyAssociatedAppsCanUseConnection = onlyAssociatedAppsCanUseConnection;
        return _x;
    }

    /**
     * <i>“Windows Information Protection (WIP) domain to associate with this connection.”</i>
     * 
     * @return property windowsInformationProtectionDomain
     */
    @Property(name="windowsInformationProtectionDomain")
    @JsonIgnore
    public Optional<String> getWindowsInformationProtectionDomain() {
        return Optional.ofNullable(windowsInformationProtectionDomain);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionDomain} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Windows Information Protection (WIP) domain to associate with this connection.”</i>
     * 
     * @param windowsInformationProtectionDomain
     *            new value of {@code windowsInformationProtectionDomain} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionDomain} field changed
     */
    public Windows10VpnConfiguration withWindowsInformationProtectionDomain(String windowsInformationProtectionDomain) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.windowsInformationProtectionDomain = windowsInformationProtectionDomain;
        return _x;
    }

    /**
     * <i>“Traffic rules. This collection can contain a maximum of 1000 elements.”</i>
     * 
     * @return property trafficRules
     */
    @Property(name="trafficRules")
    @JsonIgnore
    public CollectionPage<VpnTrafficRule> getTrafficRules() {
        return new CollectionPage<VpnTrafficRule>(contextPath, VpnTrafficRule.class, trafficRules, Optional.ofNullable(trafficRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Traffic rules. This collection can contain a maximum of 1000 elements.”</i>
     * 
     * @return property trafficRules
     */
    @Property(name="trafficRules")
    @JsonIgnore
    public CollectionPage<VpnTrafficRule> getTrafficRules(HttpRequestOptions options) {
        return new CollectionPage<VpnTrafficRule>(contextPath, VpnTrafficRule.class, trafficRules, Optional.ofNullable(trafficRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Routes (optional for third-party providers). This collection can contain a
     * maximum of 1000 elements.”</i>
     * 
     * @return property routes
     */
    @Property(name="routes")
    @JsonIgnore
    public CollectionPage<VpnRoute> getRoutes() {
        return new CollectionPage<VpnRoute>(contextPath, VpnRoute.class, routes, Optional.ofNullable(routesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Routes (optional for third-party providers). This collection can contain a
     * maximum of 1000 elements.”</i>
     * 
     * @return property routes
     */
    @Property(name="routes")
    @JsonIgnore
    public CollectionPage<VpnRoute> getRoutes(HttpRequestOptions options) {
        return new CollectionPage<VpnRoute>(contextPath, VpnRoute.class, routes, Optional.ofNullable(routesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“DNS rules. This collection can contain a maximum of 1000 elements.”</i>
     * 
     * @return property dnsRules
     */
    @Property(name="dnsRules")
    @JsonIgnore
    public CollectionPage<VpnDnsRule> getDnsRules() {
        return new CollectionPage<VpnDnsRule>(contextPath, VpnDnsRule.class, dnsRules, Optional.ofNullable(dnsRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“DNS rules. This collection can contain a maximum of 1000 elements.”</i>
     * 
     * @return property dnsRules
     */
    @Property(name="dnsRules")
    @JsonIgnore
    public CollectionPage<VpnDnsRule> getDnsRules(HttpRequestOptions options) {
        return new CollectionPage<VpnDnsRule>(contextPath, VpnDnsRule.class, dnsRules, Optional.ofNullable(dnsRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Trusted Network Domains”</i>
     * 
     * @return property trustedNetworkDomains
     */
    @Property(name="trustedNetworkDomains")
    @JsonIgnore
    public CollectionPage<String> getTrustedNetworkDomains() {
        return new CollectionPage<String>(contextPath, String.class, trustedNetworkDomains, Optional.ofNullable(trustedNetworkDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Trusted Network Domains”</i>
     * 
     * @return property trustedNetworkDomains
     */
    @Property(name="trustedNetworkDomains")
    @JsonIgnore
    public CollectionPage<String> getTrustedNetworkDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, trustedNetworkDomains, Optional.ofNullable(trustedNetworkDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Cryptography Suite security settings for IKEv2 VPN in Windows10 and above”</i>
     * 
     * @return property cryptographySuite
     */
    @Property(name="cryptographySuite")
    @JsonIgnore
    public Optional<CryptographySuite> getCryptographySuite() {
        return Optional.ofNullable(cryptographySuite);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cryptographySuite
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Cryptography Suite security settings for IKEv2 VPN in Windows10 and above”</i>
     * 
     * @param cryptographySuite
     *            new value of {@code cryptographySuite} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cryptographySuite} field changed
     */
    public Windows10VpnConfiguration withCryptographySuite(CryptographySuite cryptographySuite) {
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cryptographySuite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10VpnConfiguration");
        _x.cryptographySuite = cryptographySuite;
        return _x;
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public WindowsCertificateProfileBaseRequest getIdentityCertificate() {
        return new WindowsCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10VpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10VpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10VpnConfiguration _copy() {
        Windows10VpnConfiguration _x = new Windows10VpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.servers = servers;
        _x.customXml = customXml;
        _x.profileTarget = profileTarget;
        _x.connectionType = connectionType;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.enableAlwaysOn = enableAlwaysOn;
        _x.enableDeviceTunnel = enableDeviceTunnel;
        _x.enableDnsRegistration = enableDnsRegistration;
        _x.dnsSuffixes = dnsSuffixes;
        _x.authenticationMethod = authenticationMethod;
        _x.rememberUserCredentials = rememberUserCredentials;
        _x.enableConditionalAccess = enableConditionalAccess;
        _x.enableSingleSignOnWithAlternateCertificate = enableSingleSignOnWithAlternateCertificate;
        _x.singleSignOnEku = singleSignOnEku;
        _x.singleSignOnIssuerHash = singleSignOnIssuerHash;
        _x.eapXml = eapXml;
        _x.proxyServer = proxyServer;
        _x.associatedApps = associatedApps;
        _x.onlyAssociatedAppsCanUseConnection = onlyAssociatedAppsCanUseConnection;
        _x.windowsInformationProtectionDomain = windowsInformationProtectionDomain;
        _x.trafficRules = trafficRules;
        _x.routes = routes;
        _x.dnsRules = dnsRules;
        _x.trustedNetworkDomains = trustedNetworkDomains;
        _x.cryptographySuite = cryptographySuite;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10VpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("customXml=");
        b.append(this.customXml);
        b.append(", ");
        b.append("profileTarget=");
        b.append(this.profileTarget);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("enableAlwaysOn=");
        b.append(this.enableAlwaysOn);
        b.append(", ");
        b.append("enableDeviceTunnel=");
        b.append(this.enableDeviceTunnel);
        b.append(", ");
        b.append("enableDnsRegistration=");
        b.append(this.enableDnsRegistration);
        b.append(", ");
        b.append("dnsSuffixes=");
        b.append(this.dnsSuffixes);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("rememberUserCredentials=");
        b.append(this.rememberUserCredentials);
        b.append(", ");
        b.append("enableConditionalAccess=");
        b.append(this.enableConditionalAccess);
        b.append(", ");
        b.append("enableSingleSignOnWithAlternateCertificate=");
        b.append(this.enableSingleSignOnWithAlternateCertificate);
        b.append(", ");
        b.append("singleSignOnEku=");
        b.append(this.singleSignOnEku);
        b.append(", ");
        b.append("singleSignOnIssuerHash=");
        b.append(this.singleSignOnIssuerHash);
        b.append(", ");
        b.append("eapXml=");
        b.append(this.eapXml);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("associatedApps=");
        b.append(this.associatedApps);
        b.append(", ");
        b.append("onlyAssociatedAppsCanUseConnection=");
        b.append(this.onlyAssociatedAppsCanUseConnection);
        b.append(", ");
        b.append("windowsInformationProtectionDomain=");
        b.append(this.windowsInformationProtectionDomain);
        b.append(", ");
        b.append("trafficRules=");
        b.append(this.trafficRules);
        b.append(", ");
        b.append("routes=");
        b.append(this.routes);
        b.append(", ");
        b.append("dnsRules=");
        b.append(this.dnsRules);
        b.append(", ");
        b.append("trustedNetworkDomains=");
        b.append(this.trustedNetworkDomains);
        b.append(", ");
        b.append("cryptographySuite=");
        b.append(this.cryptographySuite);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
