package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.SecureAssessmentAccountType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the secureAssessment resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "launchUri", 
    "configurationAccount", 
    "configurationAccountType", 
    "allowPrinting", 
    "allowScreenCapture", 
    "allowTextSuggestion", 
    "localGuestAccountName", 
    "assessmentAppUserModelId"})
@JsonInclude(Include.NON_NULL)
public class Windows10SecureAssessmentConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10SecureAssessmentConfiguration";
    }

    @JsonProperty("launchUri")
    protected String launchUri;

    @JsonProperty("configurationAccount")
    protected String configurationAccount;

    @JsonProperty("configurationAccountType")
    protected SecureAssessmentAccountType configurationAccountType;

    @JsonProperty("allowPrinting")
    protected Boolean allowPrinting;

    @JsonProperty("allowScreenCapture")
    protected Boolean allowScreenCapture;

    @JsonProperty("allowTextSuggestion")
    protected Boolean allowTextSuggestion;

    @JsonProperty("localGuestAccountName")
    protected String localGuestAccountName;

    @JsonProperty("assessmentAppUserModelId")
    protected String assessmentAppUserModelId;

    protected Windows10SecureAssessmentConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10SecureAssessmentConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String launchUri;
        private String configurationAccount;
        private SecureAssessmentAccountType configurationAccountType;
        private Boolean allowPrinting;
        private Boolean allowScreenCapture;
        private Boolean allowTextSuggestion;
        private String localGuestAccountName;
        private String assessmentAppUserModelId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Url link to an assessment that's automatically loaded when the secure assessment
         * browser is launched. It has to be a valid Url (http[s]://msdn.microsoft.com/).”</i>
         * 
         * @param launchUri
         *            value of {@code launchUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder launchUri(String launchUri) {
            this.launchUri = launchUri;
            this.changedFields = changedFields.add("launchUri");
            return this;
        }

        /**
         * <i>“The account used to configure the Windows device for taking the test. The user
         * can be a domain account (domain{@literal \}user), an AAD account (username&amp;#064;tenant.com) or a
         * local account (username).”</i>
         * 
         * @param configurationAccount
         *            value of {@code configurationAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationAccount(String configurationAccount) {
            this.configurationAccount = configurationAccount;
            this.changedFields = changedFields.add("configurationAccount");
            return this;
        }

        /**
         * <i>“The account type used to by ConfigurationAccount.”</i>
         * 
         * @param configurationAccountType
         *            value of {@code configurationAccountType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationAccountType(SecureAssessmentAccountType configurationAccountType) {
            this.configurationAccountType = configurationAccountType;
            this.changedFields = changedFields.add("configurationAccountType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the app from printing during the test.”</i>
         * 
         * @param allowPrinting
         *            value of {@code allowPrinting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowPrinting(Boolean allowPrinting) {
            this.allowPrinting = allowPrinting;
            this.changedFields = changedFields.add("allowPrinting");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow screen capture capability during a test.”</i>
         * 
         * @param allowScreenCapture
         *            value of {@code allowScreenCapture} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowScreenCapture(Boolean allowScreenCapture) {
            this.allowScreenCapture = allowScreenCapture;
            this.changedFields = changedFields.add("allowScreenCapture");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow text suggestions during the test.”</i>
         * 
         * @param allowTextSuggestion
         *            value of {@code allowTextSuggestion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowTextSuggestion(Boolean allowTextSuggestion) {
            this.allowTextSuggestion = allowTextSuggestion;
            this.changedFields = changedFields.add("allowTextSuggestion");
            return this;
        }

        /**
         * <i>“Specifies the display text for the local guest account shown on the sign-in
         * screen. Typically is the name of an assessment. When the user clicks the local
         * guest account on the sign-in screen, an assessment app is launched with a
         * specified assessment URL. Secure assessments can only be configured with local
         * guest account sign-in on devices running Windows 10, version 1903 or later.
         * Important notice: this property must be set with assessmentAppUserModelID in
         * order to make the local guest account sign-in experience work properly for
         * secure assessments.”</i>
         * 
         * @param localGuestAccountName
         *            value of {@code localGuestAccountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localGuestAccountName(String localGuestAccountName) {
            this.localGuestAccountName = localGuestAccountName;
            this.changedFields = changedFields.add("localGuestAccountName");
            return this;
        }

        /**
         * <i>“Specifies the application user model ID of the assessment app launched when a
         * user signs in to a secure assessment with a local guest account. Important
         * notice: this property must be set with localGuestAccountName in order to make
         * the local guest account sign-in experience work properly for secure assessments.”</i>
         * 
         * @param assessmentAppUserModelId
         *            value of {@code assessmentAppUserModelId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assessmentAppUserModelId(String assessmentAppUserModelId) {
            this.assessmentAppUserModelId = assessmentAppUserModelId;
            this.changedFields = changedFields.add("assessmentAppUserModelId");
            return this;
        }

        public Windows10SecureAssessmentConfiguration build() {
            Windows10SecureAssessmentConfiguration _x = new Windows10SecureAssessmentConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10SecureAssessmentConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.launchUri = launchUri;
            _x.configurationAccount = configurationAccount;
            _x.configurationAccountType = configurationAccountType;
            _x.allowPrinting = allowPrinting;
            _x.allowScreenCapture = allowScreenCapture;
            _x.allowTextSuggestion = allowTextSuggestion;
            _x.localGuestAccountName = localGuestAccountName;
            _x.assessmentAppUserModelId = assessmentAppUserModelId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Url link to an assessment that's automatically loaded when the secure assessment
     * browser is launched. It has to be a valid Url (http[s]://msdn.microsoft.com/).”</i>
     * 
     * @return property launchUri
     */
    @Property(name="launchUri")
    @JsonIgnore
    public Optional<String> getLaunchUri() {
        return Optional.ofNullable(launchUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code launchUri} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Url link to an assessment that's automatically loaded when the secure assessment
     * browser is launched. It has to be a valid Url (http[s]://msdn.microsoft.com/).”</i>
     * 
     * @param launchUri
     *            new value of {@code launchUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code launchUri} field changed
     */
    public Windows10SecureAssessmentConfiguration withLaunchUri(String launchUri) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("launchUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.launchUri = launchUri;
        return _x;
    }

    /**
     * <i>“The account used to configure the Windows device for taking the test. The user
     * can be a domain account (domain{@literal \}user), an AAD account (username&amp;#064;tenant.com) or a
     * local account (username).”</i>
     * 
     * @return property configurationAccount
     */
    @Property(name="configurationAccount")
    @JsonIgnore
    public Optional<String> getConfigurationAccount() {
        return Optional.ofNullable(configurationAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationAccount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The account used to configure the Windows device for taking the test. The user
     * can be a domain account (domain{@literal \}user), an AAD account (username&amp;#064;tenant.com) or a
     * local account (username).”</i>
     * 
     * @param configurationAccount
     *            new value of {@code configurationAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationAccount} field changed
     */
    public Windows10SecureAssessmentConfiguration withConfigurationAccount(String configurationAccount) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configurationAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.configurationAccount = configurationAccount;
        return _x;
    }

    /**
     * <i>“The account type used to by ConfigurationAccount.”</i>
     * 
     * @return property configurationAccountType
     */
    @Property(name="configurationAccountType")
    @JsonIgnore
    public Optional<SecureAssessmentAccountType> getConfigurationAccountType() {
        return Optional.ofNullable(configurationAccountType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationAccountType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The account type used to by ConfigurationAccount.”</i>
     * 
     * @param configurationAccountType
     *            new value of {@code configurationAccountType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationAccountType} field changed
     */
    public Windows10SecureAssessmentConfiguration withConfigurationAccountType(SecureAssessmentAccountType configurationAccountType) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configurationAccountType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.configurationAccountType = configurationAccountType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the app from printing during the test.”</i>
     * 
     * @return property allowPrinting
     */
    @Property(name="allowPrinting")
    @JsonIgnore
    public Optional<Boolean> getAllowPrinting() {
        return Optional.ofNullable(allowPrinting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code allowPrinting}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the app from printing during the test.”</i>
     * 
     * @param allowPrinting
     *            new value of {@code allowPrinting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowPrinting} field changed
     */
    public Windows10SecureAssessmentConfiguration withAllowPrinting(Boolean allowPrinting) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowPrinting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.allowPrinting = allowPrinting;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow screen capture capability during a test.”</i>
     * 
     * @return property allowScreenCapture
     */
    @Property(name="allowScreenCapture")
    @JsonIgnore
    public Optional<Boolean> getAllowScreenCapture() {
        return Optional.ofNullable(allowScreenCapture);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowScreenCapture} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow screen capture capability during a test.”</i>
     * 
     * @param allowScreenCapture
     *            new value of {@code allowScreenCapture} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowScreenCapture} field changed
     */
    public Windows10SecureAssessmentConfiguration withAllowScreenCapture(Boolean allowScreenCapture) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowScreenCapture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.allowScreenCapture = allowScreenCapture;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow text suggestions during the test.”</i>
     * 
     * @return property allowTextSuggestion
     */
    @Property(name="allowTextSuggestion")
    @JsonIgnore
    public Optional<Boolean> getAllowTextSuggestion() {
        return Optional.ofNullable(allowTextSuggestion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowTextSuggestion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow text suggestions during the test.”</i>
     * 
     * @param allowTextSuggestion
     *            new value of {@code allowTextSuggestion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowTextSuggestion} field changed
     */
    public Windows10SecureAssessmentConfiguration withAllowTextSuggestion(Boolean allowTextSuggestion) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowTextSuggestion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.allowTextSuggestion = allowTextSuggestion;
        return _x;
    }

    /**
     * <i>“Specifies the display text for the local guest account shown on the sign-in
     * screen. Typically is the name of an assessment. When the user clicks the local
     * guest account on the sign-in screen, an assessment app is launched with a
     * specified assessment URL. Secure assessments can only be configured with local
     * guest account sign-in on devices running Windows 10, version 1903 or later.
     * Important notice: this property must be set with assessmentAppUserModelID in
     * order to make the local guest account sign-in experience work properly for
     * secure assessments.”</i>
     * 
     * @return property localGuestAccountName
     */
    @Property(name="localGuestAccountName")
    @JsonIgnore
    public Optional<String> getLocalGuestAccountName() {
        return Optional.ofNullable(localGuestAccountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localGuestAccountName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the display text for the local guest account shown on the sign-in
     * screen. Typically is the name of an assessment. When the user clicks the local
     * guest account on the sign-in screen, an assessment app is launched with a
     * specified assessment URL. Secure assessments can only be configured with local
     * guest account sign-in on devices running Windows 10, version 1903 or later.
     * Important notice: this property must be set with assessmentAppUserModelID in
     * order to make the local guest account sign-in experience work properly for
     * secure assessments.”</i>
     * 
     * @param localGuestAccountName
     *            new value of {@code localGuestAccountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localGuestAccountName} field changed
     */
    public Windows10SecureAssessmentConfiguration withLocalGuestAccountName(String localGuestAccountName) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localGuestAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.localGuestAccountName = localGuestAccountName;
        return _x;
    }

    /**
     * <i>“Specifies the application user model ID of the assessment app launched when a
     * user signs in to a secure assessment with a local guest account. Important
     * notice: this property must be set with localGuestAccountName in order to make
     * the local guest account sign-in experience work properly for secure assessments.”</i>
     * 
     * @return property assessmentAppUserModelId
     */
    @Property(name="assessmentAppUserModelId")
    @JsonIgnore
    public Optional<String> getAssessmentAppUserModelId() {
        return Optional.ofNullable(assessmentAppUserModelId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * assessmentAppUserModelId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the application user model ID of the assessment app launched when a
     * user signs in to a secure assessment with a local guest account. Important
     * notice: this property must be set with localGuestAccountName in order to make
     * the local guest account sign-in experience work properly for secure assessments.”</i>
     * 
     * @param assessmentAppUserModelId
     *            new value of {@code assessmentAppUserModelId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assessmentAppUserModelId} field changed
     */
    public Windows10SecureAssessmentConfiguration withAssessmentAppUserModelId(String assessmentAppUserModelId) {
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = changedFields.add("assessmentAppUserModelId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10SecureAssessmentConfiguration");
        _x.assessmentAppUserModelId = assessmentAppUserModelId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10SecureAssessmentConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10SecureAssessmentConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10SecureAssessmentConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10SecureAssessmentConfiguration _copy() {
        Windows10SecureAssessmentConfiguration _x = new Windows10SecureAssessmentConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.launchUri = launchUri;
        _x.configurationAccount = configurationAccount;
        _x.configurationAccountType = configurationAccountType;
        _x.allowPrinting = allowPrinting;
        _x.allowScreenCapture = allowScreenCapture;
        _x.allowTextSuggestion = allowTextSuggestion;
        _x.localGuestAccountName = localGuestAccountName;
        _x.assessmentAppUserModelId = assessmentAppUserModelId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10SecureAssessmentConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("launchUri=");
        b.append(this.launchUri);
        b.append(", ");
        b.append("configurationAccount=");
        b.append(this.configurationAccount);
        b.append(", ");
        b.append("configurationAccountType=");
        b.append(this.configurationAccountType);
        b.append(", ");
        b.append("allowPrinting=");
        b.append(this.allowPrinting);
        b.append(", ");
        b.append("allowScreenCapture=");
        b.append(this.allowScreenCapture);
        b.append(", ");
        b.append("allowTextSuggestion=");
        b.append(this.allowTextSuggestion);
        b.append(", ");
        b.append("localGuestAccountName=");
        b.append(this.localGuestAccountName);
        b.append(", ");
        b.append("assessmentAppUserModelId=");
        b.append(this.assessmentAppUserModelId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
