package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.OperatingSystemVersionRange;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This class contains compliance settings for Windows 10 Mobile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passwordRequired", 
    "passwordBlockSimple", 
    "passwordMinimumLength", 
    "passwordMinimumCharacterSetCount", 
    "passwordRequiredType", 
    "passwordPreviousPasswordBlockCount", 
    "passwordExpirationDays", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordRequireToUnlockFromIdle", 
    "osMinimumVersion", 
    "osMaximumVersion", 
    "earlyLaunchAntiMalwareDriverEnabled", 
    "bitLockerEnabled", 
    "secureBootEnabled", 
    "codeIntegrityEnabled", 
    "storageRequireEncryption", 
    "activeFirewallRequired", 
    "validOperatingSystemBuildRanges"})
@JsonInclude(Include.NON_NULL)
public class Windows10MobileCompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10MobileCompliancePolicy";
    }

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordRequireToUnlockFromIdle")
    protected Boolean passwordRequireToUnlockFromIdle;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("earlyLaunchAntiMalwareDriverEnabled")
    protected Boolean earlyLaunchAntiMalwareDriverEnabled;

    @JsonProperty("bitLockerEnabled")
    protected Boolean bitLockerEnabled;

    @JsonProperty("secureBootEnabled")
    protected Boolean secureBootEnabled;

    @JsonProperty("codeIntegrityEnabled")
    protected Boolean codeIntegrityEnabled;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    @JsonProperty("activeFirewallRequired")
    protected Boolean activeFirewallRequired;

    @JsonProperty("validOperatingSystemBuildRanges")
    protected List<OperatingSystemVersionRange> validOperatingSystemBuildRanges;

    @JsonProperty("validOperatingSystemBuildRanges@nextLink")
    protected String validOperatingSystemBuildRangesNextLink;

    protected Windows10MobileCompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10MobileCompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private OffsetDateTime lastModifiedDateTime;
        private String displayName;
        private Integer version;
        private Boolean passwordRequired;
        private Boolean passwordBlockSimple;
        private Integer passwordMinimumLength;
        private Integer passwordMinimumCharacterSetCount;
        private RequiredPasswordType passwordRequiredType;
        private Integer passwordPreviousPasswordBlockCount;
        private Integer passwordExpirationDays;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Boolean passwordRequireToUnlockFromIdle;
        private String osMinimumVersion;
        private String osMaximumVersion;
        private Boolean earlyLaunchAntiMalwareDriverEnabled;
        private Boolean bitLockerEnabled;
        private Boolean secureBootEnabled;
        private Boolean codeIntegrityEnabled;
        private Boolean storageRequireEncryption;
        private Boolean activeFirewallRequired;
        private List<OperatingSystemVersionRange> validOperatingSystemBuildRanges;
        private String validOperatingSystemBuildRangesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Require a password to unlock Windows Phone device.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Whether or not to block syncing the calendar.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“Minimum password length. Valid values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The required password type.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“The number of previous passwords to prevent re-use of.”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Number of days before password expiration. Valid values 1 to 255”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a password is required.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Require a password to unlock an idle device.”</i>
         * 
         * @param passwordRequireToUnlockFromIdle
         *            value of {@code passwordRequireToUnlockFromIdle} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequireToUnlockFromIdle(Boolean passwordRequireToUnlockFromIdle) {
            this.passwordRequireToUnlockFromIdle = passwordRequireToUnlockFromIdle;
            this.changedFields = changedFields.add("passwordRequireToUnlockFromIdle");
            return this;
        }

        /**
         * <i>“Minimum Windows Phone version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Maximum Windows Phone version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
         * early launch antimalware driver is enabled.”</i>
         * 
         * @param earlyLaunchAntiMalwareDriverEnabled
         *            value of {@code earlyLaunchAntiMalwareDriverEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder earlyLaunchAntiMalwareDriverEnabled(Boolean earlyLaunchAntiMalwareDriverEnabled) {
            this.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
            this.changedFields = changedFields.add("earlyLaunchAntiMalwareDriverEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
         * bit locker is enabled”</i>
         * 
         * @param bitLockerEnabled
         *            value of {@code bitLockerEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerEnabled(Boolean bitLockerEnabled) {
            this.bitLockerEnabled = bitLockerEnabled;
            this.changedFields = changedFields.add("bitLockerEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
         * secure boot is enabled.”</i>
         * 
         * @param secureBootEnabled
         *            value of {@code secureBootEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBootEnabled(Boolean secureBootEnabled) {
            this.secureBootEnabled = secureBootEnabled;
            this.changedFields = changedFields.add("secureBootEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
         * 
         * @param codeIntegrityEnabled
         *            value of {@code codeIntegrityEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeIntegrityEnabled(Boolean codeIntegrityEnabled) {
            this.codeIntegrityEnabled = codeIntegrityEnabled;
            this.changedFields = changedFields.add("codeIntegrityEnabled");
            return this;
        }

        /**
         * <i>“Require encryption on windows devices.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        /**
         * <i>“Require active firewall on Windows devices.”</i>
         * 
         * @param activeFirewallRequired
         *            value of {@code activeFirewallRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeFirewallRequired(Boolean activeFirewallRequired) {
            this.activeFirewallRequired = activeFirewallRequired;
            this.changedFields = changedFields.add("activeFirewallRequired");
            return this;
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRanges
         *            value of {@code validOperatingSystemBuildRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRanges(List<OperatingSystemVersionRange> validOperatingSystemBuildRanges) {
            this.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
            this.changedFields = changedFields.add("validOperatingSystemBuildRanges");
            return this;
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRanges
         *            value of {@code validOperatingSystemBuildRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRanges(OperatingSystemVersionRange... validOperatingSystemBuildRanges) {
            return validOperatingSystemBuildRanges(Arrays.asList(validOperatingSystemBuildRanges));
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRangesNextLink
         *            value of {@code validOperatingSystemBuildRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRangesNextLink(String validOperatingSystemBuildRangesNextLink) {
            this.validOperatingSystemBuildRangesNextLink = validOperatingSystemBuildRangesNextLink;
            this.changedFields = changedFields.add("validOperatingSystemBuildRanges");
            return this;
        }

        public Windows10MobileCompliancePolicy build() {
            Windows10MobileCompliancePolicy _x = new Windows10MobileCompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10MobileCompliancePolicy";
            _x.id = id;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.displayName = displayName;
            _x.version = version;
            _x.passwordRequired = passwordRequired;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordRequireToUnlockFromIdle = passwordRequireToUnlockFromIdle;
            _x.osMinimumVersion = osMinimumVersion;
            _x.osMaximumVersion = osMaximumVersion;
            _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
            _x.bitLockerEnabled = bitLockerEnabled;
            _x.secureBootEnabled = secureBootEnabled;
            _x.codeIntegrityEnabled = codeIntegrityEnabled;
            _x.storageRequireEncryption = storageRequireEncryption;
            _x.activeFirewallRequired = activeFirewallRequired;
            _x.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
            _x.validOperatingSystemBuildRangesNextLink = validOperatingSystemBuildRangesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Require a password to unlock Windows Phone device.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require a password to unlock Windows Phone device.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordRequired(Boolean passwordRequired) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Whether or not to block syncing the calendar.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block syncing the calendar.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordBlockSimple(Boolean passwordBlockSimple) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordMinimumLength(Integer passwordMinimumLength) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The required password type.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required password type.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“The number of previous passwords to prevent re-use of.”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of previous passwords to prevent re-use of.”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Number of days before password expiration. Valid values 1 to 255”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before password expiration. Valid values 1 to 255”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordExpirationDays(Integer passwordExpirationDays) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Require a password to unlock an idle device.”</i>
     * 
     * @return property passwordRequireToUnlockFromIdle
     */
    @Property(name="passwordRequireToUnlockFromIdle")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequireToUnlockFromIdle() {
        return Optional.ofNullable(passwordRequireToUnlockFromIdle);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequireToUnlockFromIdle} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Require a password to unlock an idle device.”</i>
     * 
     * @param passwordRequireToUnlockFromIdle
     *            new value of {@code passwordRequireToUnlockFromIdle} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequireToUnlockFromIdle} field changed
     */
    public Windows10MobileCompliancePolicy withPasswordRequireToUnlockFromIdle(Boolean passwordRequireToUnlockFromIdle) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequireToUnlockFromIdle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.passwordRequireToUnlockFromIdle = passwordRequireToUnlockFromIdle;
        return _x;
    }

    /**
     * <i>“Minimum Windows Phone version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum Windows Phone version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public Windows10MobileCompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Maximum Windows Phone version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum Windows Phone version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public Windows10MobileCompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * early launch antimalware driver is enabled.”</i>
     * 
     * @return property earlyLaunchAntiMalwareDriverEnabled
     */
    @Property(name="earlyLaunchAntiMalwareDriverEnabled")
    @JsonIgnore
    public Optional<Boolean> getEarlyLaunchAntiMalwareDriverEnabled() {
        return Optional.ofNullable(earlyLaunchAntiMalwareDriverEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * earlyLaunchAntiMalwareDriverEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * early launch antimalware driver is enabled.”</i>
     * 
     * @param earlyLaunchAntiMalwareDriverEnabled
     *            new value of {@code earlyLaunchAntiMalwareDriverEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code earlyLaunchAntiMalwareDriverEnabled} field changed
     */
    public Windows10MobileCompliancePolicy withEarlyLaunchAntiMalwareDriverEnabled(Boolean earlyLaunchAntiMalwareDriverEnabled) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("earlyLaunchAntiMalwareDriverEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
     * bit locker is enabled”</i>
     * 
     * @return property bitLockerEnabled
     */
    @Property(name="bitLockerEnabled")
    @JsonIgnore
    public Optional<Boolean> getBitLockerEnabled() {
        return Optional.ofNullable(bitLockerEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bitLockerEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
     * bit locker is enabled”</i>
     * 
     * @param bitLockerEnabled
     *            new value of {@code bitLockerEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerEnabled} field changed
     */
    public Windows10MobileCompliancePolicy withBitLockerEnabled(Boolean bitLockerEnabled) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("bitLockerEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.bitLockerEnabled = bitLockerEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * secure boot is enabled.”</i>
     * 
     * @return property secureBootEnabled
     */
    @Property(name="secureBootEnabled")
    @JsonIgnore
    public Optional<Boolean> getSecureBootEnabled() {
        return Optional.ofNullable(secureBootEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secureBootEnabled
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * secure boot is enabled.”</i>
     * 
     * @param secureBootEnabled
     *            new value of {@code secureBootEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBootEnabled} field changed
     */
    public Windows10MobileCompliancePolicy withSecureBootEnabled(Boolean secureBootEnabled) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("secureBootEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.secureBootEnabled = secureBootEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @return property codeIntegrityEnabled
     */
    @Property(name="codeIntegrityEnabled")
    @JsonIgnore
    public Optional<Boolean> getCodeIntegrityEnabled() {
        return Optional.ofNullable(codeIntegrityEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * codeIntegrityEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @param codeIntegrityEnabled
     *            new value of {@code codeIntegrityEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeIntegrityEnabled} field changed
     */
    public Windows10MobileCompliancePolicy withCodeIntegrityEnabled(Boolean codeIntegrityEnabled) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("codeIntegrityEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.codeIntegrityEnabled = codeIntegrityEnabled;
        return _x;
    }

    /**
     * <i>“Require encryption on windows devices.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require encryption on windows devices.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public Windows10MobileCompliancePolicy withStorageRequireEncryption(Boolean storageRequireEncryption) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    /**
     * <i>“Require active firewall on Windows devices.”</i>
     * 
     * @return property activeFirewallRequired
     */
    @Property(name="activeFirewallRequired")
    @JsonIgnore
    public Optional<Boolean> getActiveFirewallRequired() {
        return Optional.ofNullable(activeFirewallRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeFirewallRequired} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require active firewall on Windows devices.”</i>
     * 
     * @param activeFirewallRequired
     *            new value of {@code activeFirewallRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeFirewallRequired} field changed
     */
    public Windows10MobileCompliancePolicy withActiveFirewallRequired(Boolean activeFirewallRequired) {
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("activeFirewallRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10MobileCompliancePolicy");
        _x.activeFirewallRequired = activeFirewallRequired;
        return _x;
    }

    /**
     * <i>“The valid operating system build ranges on Windows devices. This collection can
     * contain a maximum of 10000 elements.”</i>
     * 
     * @return property validOperatingSystemBuildRanges
     */
    @Property(name="validOperatingSystemBuildRanges")
    @JsonIgnore
    public CollectionPage<OperatingSystemVersionRange> getValidOperatingSystemBuildRanges() {
        return new CollectionPage<OperatingSystemVersionRange>(contextPath, OperatingSystemVersionRange.class, validOperatingSystemBuildRanges, Optional.ofNullable(validOperatingSystemBuildRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The valid operating system build ranges on Windows devices. This collection can
     * contain a maximum of 10000 elements.”</i>
     * 
     * @return property validOperatingSystemBuildRanges
     */
    @Property(name="validOperatingSystemBuildRanges")
    @JsonIgnore
    public CollectionPage<OperatingSystemVersionRange> getValidOperatingSystemBuildRanges(HttpRequestOptions options) {
        return new CollectionPage<OperatingSystemVersionRange>(contextPath, OperatingSystemVersionRange.class, validOperatingSystemBuildRanges, Optional.ofNullable(validOperatingSystemBuildRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10MobileCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10MobileCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10MobileCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10MobileCompliancePolicy _copy() {
        Windows10MobileCompliancePolicy _x = new Windows10MobileCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.version = version;
        _x.passwordRequired = passwordRequired;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordRequireToUnlockFromIdle = passwordRequireToUnlockFromIdle;
        _x.osMinimumVersion = osMinimumVersion;
        _x.osMaximumVersion = osMaximumVersion;
        _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
        _x.bitLockerEnabled = bitLockerEnabled;
        _x.secureBootEnabled = secureBootEnabled;
        _x.codeIntegrityEnabled = codeIntegrityEnabled;
        _x.storageRequireEncryption = storageRequireEncryption;
        _x.activeFirewallRequired = activeFirewallRequired;
        _x.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10MobileCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordRequireToUnlockFromIdle=");
        b.append(this.passwordRequireToUnlockFromIdle);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("earlyLaunchAntiMalwareDriverEnabled=");
        b.append(this.earlyLaunchAntiMalwareDriverEnabled);
        b.append(", ");
        b.append("bitLockerEnabled=");
        b.append(this.bitLockerEnabled);
        b.append(", ");
        b.append("secureBootEnabled=");
        b.append(this.secureBootEnabled);
        b.append(", ");
        b.append("codeIntegrityEnabled=");
        b.append(this.codeIntegrityEnabled);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append(", ");
        b.append("activeFirewallRequired=");
        b.append(this.activeFirewallRequired);
        b.append(", ");
        b.append("validOperatingSystemBuildRanges=");
        b.append(this.validOperatingSystemBuildRanges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
