package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Windows 10 Enrollment Status Page Configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "showInstallationProgress", 
    "blockDeviceSetupRetryByUser", 
    "allowDeviceResetOnInstallFailure", 
    "allowLogCollectionOnInstallFailure", 
    "customErrorMessage", 
    "installProgressTimeoutInMinutes", 
    "allowDeviceUseOnInstallFailure", 
    "selectedMobileAppIds", 
    "trackInstallProgressForAutopilotOnly", 
    "disableUserStatusTrackingAfterFirstUser"})
@JsonInclude(Include.NON_NULL)
public class Windows10EnrollmentCompletionPageConfiguration extends DeviceEnrollmentConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10EnrollmentCompletionPageConfiguration";
    }

    @JsonProperty("showInstallationProgress")
    protected Boolean showInstallationProgress;

    @JsonProperty("blockDeviceSetupRetryByUser")
    protected Boolean blockDeviceSetupRetryByUser;

    @JsonProperty("allowDeviceResetOnInstallFailure")
    protected Boolean allowDeviceResetOnInstallFailure;

    @JsonProperty("allowLogCollectionOnInstallFailure")
    protected Boolean allowLogCollectionOnInstallFailure;

    @JsonProperty("customErrorMessage")
    protected String customErrorMessage;

    @JsonProperty("installProgressTimeoutInMinutes")
    protected Integer installProgressTimeoutInMinutes;

    @JsonProperty("allowDeviceUseOnInstallFailure")
    protected Boolean allowDeviceUseOnInstallFailure;

    @JsonProperty("selectedMobileAppIds")
    protected List<String> selectedMobileAppIds;

    @JsonProperty("selectedMobileAppIds@nextLink")
    protected String selectedMobileAppIdsNextLink;

    @JsonProperty("trackInstallProgressForAutopilotOnly")
    protected Boolean trackInstallProgressForAutopilotOnly;

    @JsonProperty("disableUserStatusTrackingAfterFirstUser")
    protected Boolean disableUserStatusTrackingAfterFirstUser;

    protected Windows10EnrollmentCompletionPageConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10EnrollmentCompletionPageConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private Integer priority;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Integer version;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean showInstallationProgress;
        private Boolean blockDeviceSetupRetryByUser;
        private Boolean allowDeviceResetOnInstallFailure;
        private Boolean allowLogCollectionOnInstallFailure;
        private String customErrorMessage;
        private Integer installProgressTimeoutInMinutes;
        private Boolean allowDeviceUseOnInstallFailure;
        private List<String> selectedMobileAppIds;
        private String selectedMobileAppIdsNextLink;
        private Boolean trackInstallProgressForAutopilotOnly;
        private Boolean disableUserStatusTrackingAfterFirstUser;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Show or hide installation progress to user”</i>
         * 
         * @param showInstallationProgress
         *            value of {@code showInstallationProgress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showInstallationProgress(Boolean showInstallationProgress) {
            this.showInstallationProgress = showInstallationProgress;
            this.changedFields = changedFields.add("showInstallationProgress");
            return this;
        }

        /**
         * <i>“Allow the user to retry the setup on installation failure”</i>
         * 
         * @param blockDeviceSetupRetryByUser
         *            value of {@code blockDeviceSetupRetryByUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockDeviceSetupRetryByUser(Boolean blockDeviceSetupRetryByUser) {
            this.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
            this.changedFields = changedFields.add("blockDeviceSetupRetryByUser");
            return this;
        }

        /**
         * <i>“Allow or block device reset on installation failure”</i>
         * 
         * @param allowDeviceResetOnInstallFailure
         *            value of {@code allowDeviceResetOnInstallFailure} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDeviceResetOnInstallFailure(Boolean allowDeviceResetOnInstallFailure) {
            this.allowDeviceResetOnInstallFailure = allowDeviceResetOnInstallFailure;
            this.changedFields = changedFields.add("allowDeviceResetOnInstallFailure");
            return this;
        }

        /**
         * <i>“Allow or block log collection on installation failure”</i>
         * 
         * @param allowLogCollectionOnInstallFailure
         *            value of {@code allowLogCollectionOnInstallFailure} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowLogCollectionOnInstallFailure(Boolean allowLogCollectionOnInstallFailure) {
            this.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
            this.changedFields = changedFields.add("allowLogCollectionOnInstallFailure");
            return this;
        }

        /**
         * <i>“Set custom error message to show upon installation failure”</i>
         * 
         * @param customErrorMessage
         *            value of {@code customErrorMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customErrorMessage(String customErrorMessage) {
            this.customErrorMessage = customErrorMessage;
            this.changedFields = changedFields.add("customErrorMessage");
            return this;
        }

        /**
         * <i>“Set installation progress timeout in minutes”</i>
         * 
         * @param installProgressTimeoutInMinutes
         *            value of {@code installProgressTimeoutInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installProgressTimeoutInMinutes(Integer installProgressTimeoutInMinutes) {
            this.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
            this.changedFields = changedFields.add("installProgressTimeoutInMinutes");
            return this;
        }

        /**
         * <i>“Allow the user to continue using the device on installation failure”</i>
         * 
         * @param allowDeviceUseOnInstallFailure
         *            value of {@code allowDeviceUseOnInstallFailure} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDeviceUseOnInstallFailure(Boolean allowDeviceUseOnInstallFailure) {
            this.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
            this.changedFields = changedFields.add("allowDeviceUseOnInstallFailure");
            return this;
        }

        /**
         * <i>“Selected applications to track the installation status”</i>
         * 
         * @param selectedMobileAppIds
         *            value of {@code selectedMobileAppIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectedMobileAppIds(List<String> selectedMobileAppIds) {
            this.selectedMobileAppIds = selectedMobileAppIds;
            this.changedFields = changedFields.add("selectedMobileAppIds");
            return this;
        }

        /**
         * <i>“Selected applications to track the installation status”</i>
         * 
         * @param selectedMobileAppIds
         *            value of {@code selectedMobileAppIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectedMobileAppIds(String... selectedMobileAppIds) {
            return selectedMobileAppIds(Arrays.asList(selectedMobileAppIds));
        }

        /**
         * <i>“Selected applications to track the installation status”</i>
         * 
         * @param selectedMobileAppIdsNextLink
         *            value of {@code selectedMobileAppIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectedMobileAppIdsNextLink(String selectedMobileAppIdsNextLink) {
            this.selectedMobileAppIdsNextLink = selectedMobileAppIdsNextLink;
            this.changedFields = changedFields.add("selectedMobileAppIds");
            return this;
        }

        /**
         * <i>“Only show installation progress for Autopilot enrollment scenarios”</i>
         * 
         * @param trackInstallProgressForAutopilotOnly
         *            value of {@code trackInstallProgressForAutopilotOnly} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trackInstallProgressForAutopilotOnly(Boolean trackInstallProgressForAutopilotOnly) {
            this.trackInstallProgressForAutopilotOnly = trackInstallProgressForAutopilotOnly;
            this.changedFields = changedFields.add("trackInstallProgressForAutopilotOnly");
            return this;
        }

        /**
         * <i>“Only show installation progress for first user post enrollment”</i>
         * 
         * @param disableUserStatusTrackingAfterFirstUser
         *            value of {@code disableUserStatusTrackingAfterFirstUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableUserStatusTrackingAfterFirstUser(Boolean disableUserStatusTrackingAfterFirstUser) {
            this.disableUserStatusTrackingAfterFirstUser = disableUserStatusTrackingAfterFirstUser;
            this.changedFields = changedFields.add("disableUserStatusTrackingAfterFirstUser");
            return this;
        }

        public Windows10EnrollmentCompletionPageConfiguration build() {
            Windows10EnrollmentCompletionPageConfiguration _x = new Windows10EnrollmentCompletionPageConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10EnrollmentCompletionPageConfiguration";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.priority = priority;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.version = version;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.showInstallationProgress = showInstallationProgress;
            _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
            _x.allowDeviceResetOnInstallFailure = allowDeviceResetOnInstallFailure;
            _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
            _x.customErrorMessage = customErrorMessage;
            _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
            _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
            _x.selectedMobileAppIds = selectedMobileAppIds;
            _x.selectedMobileAppIdsNextLink = selectedMobileAppIdsNextLink;
            _x.trackInstallProgressForAutopilotOnly = trackInstallProgressForAutopilotOnly;
            _x.disableUserStatusTrackingAfterFirstUser = disableUserStatusTrackingAfterFirstUser;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Show or hide installation progress to user”</i>
     * 
     * @return property showInstallationProgress
     */
    @Property(name="showInstallationProgress")
    @JsonIgnore
    public Optional<Boolean> getShowInstallationProgress() {
        return Optional.ofNullable(showInstallationProgress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * showInstallationProgress} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Show or hide installation progress to user”</i>
     * 
     * @param showInstallationProgress
     *            new value of {@code showInstallationProgress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showInstallationProgress} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withShowInstallationProgress(Boolean showInstallationProgress) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("showInstallationProgress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.showInstallationProgress = showInstallationProgress;
        return _x;
    }

    /**
     * <i>“Allow the user to retry the setup on installation failure”</i>
     * 
     * @return property blockDeviceSetupRetryByUser
     */
    @Property(name="blockDeviceSetupRetryByUser")
    @JsonIgnore
    public Optional<Boolean> getBlockDeviceSetupRetryByUser() {
        return Optional.ofNullable(blockDeviceSetupRetryByUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockDeviceSetupRetryByUser} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow the user to retry the setup on installation failure”</i>
     * 
     * @param blockDeviceSetupRetryByUser
     *            new value of {@code blockDeviceSetupRetryByUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockDeviceSetupRetryByUser} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withBlockDeviceSetupRetryByUser(Boolean blockDeviceSetupRetryByUser) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("blockDeviceSetupRetryByUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
        return _x;
    }

    /**
     * <i>“Allow or block device reset on installation failure”</i>
     * 
     * @return property allowDeviceResetOnInstallFailure
     */
    @Property(name="allowDeviceResetOnInstallFailure")
    @JsonIgnore
    public Optional<Boolean> getAllowDeviceResetOnInstallFailure() {
        return Optional.ofNullable(allowDeviceResetOnInstallFailure);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDeviceResetOnInstallFailure} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow or block device reset on installation failure”</i>
     * 
     * @param allowDeviceResetOnInstallFailure
     *            new value of {@code allowDeviceResetOnInstallFailure} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDeviceResetOnInstallFailure} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withAllowDeviceResetOnInstallFailure(Boolean allowDeviceResetOnInstallFailure) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowDeviceResetOnInstallFailure");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.allowDeviceResetOnInstallFailure = allowDeviceResetOnInstallFailure;
        return _x;
    }

    /**
     * <i>“Allow or block log collection on installation failure”</i>
     * 
     * @return property allowLogCollectionOnInstallFailure
     */
    @Property(name="allowLogCollectionOnInstallFailure")
    @JsonIgnore
    public Optional<Boolean> getAllowLogCollectionOnInstallFailure() {
        return Optional.ofNullable(allowLogCollectionOnInstallFailure);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowLogCollectionOnInstallFailure} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow or block log collection on installation failure”</i>
     * 
     * @param allowLogCollectionOnInstallFailure
     *            new value of {@code allowLogCollectionOnInstallFailure} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowLogCollectionOnInstallFailure} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withAllowLogCollectionOnInstallFailure(Boolean allowLogCollectionOnInstallFailure) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowLogCollectionOnInstallFailure");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
        return _x;
    }

    /**
     * <i>“Set custom error message to show upon installation failure”</i>
     * 
     * @return property customErrorMessage
     */
    @Property(name="customErrorMessage")
    @JsonIgnore
    public Optional<String> getCustomErrorMessage() {
        return Optional.ofNullable(customErrorMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customErrorMessage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Set custom error message to show upon installation failure”</i>
     * 
     * @param customErrorMessage
     *            new value of {@code customErrorMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customErrorMessage} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withCustomErrorMessage(String customErrorMessage) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customErrorMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.customErrorMessage = customErrorMessage;
        return _x;
    }

    /**
     * <i>“Set installation progress timeout in minutes”</i>
     * 
     * @return property installProgressTimeoutInMinutes
     */
    @Property(name="installProgressTimeoutInMinutes")
    @JsonIgnore
    public Optional<Integer> getInstallProgressTimeoutInMinutes() {
        return Optional.ofNullable(installProgressTimeoutInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installProgressTimeoutInMinutes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Set installation progress timeout in minutes”</i>
     * 
     * @param installProgressTimeoutInMinutes
     *            new value of {@code installProgressTimeoutInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installProgressTimeoutInMinutes} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withInstallProgressTimeoutInMinutes(Integer installProgressTimeoutInMinutes) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("installProgressTimeoutInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
        return _x;
    }

    /**
     * <i>“Allow the user to continue using the device on installation failure”</i>
     * 
     * @return property allowDeviceUseOnInstallFailure
     */
    @Property(name="allowDeviceUseOnInstallFailure")
    @JsonIgnore
    public Optional<Boolean> getAllowDeviceUseOnInstallFailure() {
        return Optional.ofNullable(allowDeviceUseOnInstallFailure);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDeviceUseOnInstallFailure} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow the user to continue using the device on installation failure”</i>
     * 
     * @param allowDeviceUseOnInstallFailure
     *            new value of {@code allowDeviceUseOnInstallFailure} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDeviceUseOnInstallFailure} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withAllowDeviceUseOnInstallFailure(Boolean allowDeviceUseOnInstallFailure) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowDeviceUseOnInstallFailure");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
        return _x;
    }

    /**
     * <i>“Selected applications to track the installation status”</i>
     * 
     * @return property selectedMobileAppIds
     */
    @Property(name="selectedMobileAppIds")
    @JsonIgnore
    public CollectionPage<String> getSelectedMobileAppIds() {
        return new CollectionPage<String>(contextPath, String.class, selectedMobileAppIds, Optional.ofNullable(selectedMobileAppIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Selected applications to track the installation status”</i>
     * 
     * @return property selectedMobileAppIds
     */
    @Property(name="selectedMobileAppIds")
    @JsonIgnore
    public CollectionPage<String> getSelectedMobileAppIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, selectedMobileAppIds, Optional.ofNullable(selectedMobileAppIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Only show installation progress for Autopilot enrollment scenarios”</i>
     * 
     * @return property trackInstallProgressForAutopilotOnly
     */
    @Property(name="trackInstallProgressForAutopilotOnly")
    @JsonIgnore
    public Optional<Boolean> getTrackInstallProgressForAutopilotOnly() {
        return Optional.ofNullable(trackInstallProgressForAutopilotOnly);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trackInstallProgressForAutopilotOnly} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Only show installation progress for Autopilot enrollment scenarios”</i>
     * 
     * @param trackInstallProgressForAutopilotOnly
     *            new value of {@code trackInstallProgressForAutopilotOnly} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trackInstallProgressForAutopilotOnly} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withTrackInstallProgressForAutopilotOnly(Boolean trackInstallProgressForAutopilotOnly) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("trackInstallProgressForAutopilotOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.trackInstallProgressForAutopilotOnly = trackInstallProgressForAutopilotOnly;
        return _x;
    }

    /**
     * <i>“Only show installation progress for first user post enrollment”</i>
     * 
     * @return property disableUserStatusTrackingAfterFirstUser
     */
    @Property(name="disableUserStatusTrackingAfterFirstUser")
    @JsonIgnore
    public Optional<Boolean> getDisableUserStatusTrackingAfterFirstUser() {
        return Optional.ofNullable(disableUserStatusTrackingAfterFirstUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableUserStatusTrackingAfterFirstUser} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Only show installation progress for first user post enrollment”</i>
     * 
     * @param disableUserStatusTrackingAfterFirstUser
     *            new value of {@code disableUserStatusTrackingAfterFirstUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableUserStatusTrackingAfterFirstUser} field changed
     */
    public Windows10EnrollmentCompletionPageConfiguration withDisableUserStatusTrackingAfterFirstUser(Boolean disableUserStatusTrackingAfterFirstUser) {
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableUserStatusTrackingAfterFirstUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EnrollmentCompletionPageConfiguration");
        _x.disableUserStatusTrackingAfterFirstUser = disableUserStatusTrackingAfterFirstUser;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EnrollmentCompletionPageConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EnrollmentCompletionPageConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10EnrollmentCompletionPageConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10EnrollmentCompletionPageConfiguration _copy() {
        Windows10EnrollmentCompletionPageConfiguration _x = new Windows10EnrollmentCompletionPageConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.priority = priority;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.version = version;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.showInstallationProgress = showInstallationProgress;
        _x.blockDeviceSetupRetryByUser = blockDeviceSetupRetryByUser;
        _x.allowDeviceResetOnInstallFailure = allowDeviceResetOnInstallFailure;
        _x.allowLogCollectionOnInstallFailure = allowLogCollectionOnInstallFailure;
        _x.customErrorMessage = customErrorMessage;
        _x.installProgressTimeoutInMinutes = installProgressTimeoutInMinutes;
        _x.allowDeviceUseOnInstallFailure = allowDeviceUseOnInstallFailure;
        _x.selectedMobileAppIds = selectedMobileAppIds;
        _x.trackInstallProgressForAutopilotOnly = trackInstallProgressForAutopilotOnly;
        _x.disableUserStatusTrackingAfterFirstUser = disableUserStatusTrackingAfterFirstUser;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10EnrollmentCompletionPageConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("showInstallationProgress=");
        b.append(this.showInstallationProgress);
        b.append(", ");
        b.append("blockDeviceSetupRetryByUser=");
        b.append(this.blockDeviceSetupRetryByUser);
        b.append(", ");
        b.append("allowDeviceResetOnInstallFailure=");
        b.append(this.allowDeviceResetOnInstallFailure);
        b.append(", ");
        b.append("allowLogCollectionOnInstallFailure=");
        b.append(this.allowLogCollectionOnInstallFailure);
        b.append(", ");
        b.append("customErrorMessage=");
        b.append(this.customErrorMessage);
        b.append(", ");
        b.append("installProgressTimeoutInMinutes=");
        b.append(this.installProgressTimeoutInMinutes);
        b.append(", ");
        b.append("allowDeviceUseOnInstallFailure=");
        b.append(this.allowDeviceUseOnInstallFailure);
        b.append(", ");
        b.append("selectedMobileAppIds=");
        b.append(this.selectedMobileAppIds);
        b.append(", ");
        b.append("trackInstallProgressForAutopilotOnly=");
        b.append(this.trackInstallProgressForAutopilotOnly);
        b.append(", ");
        b.append("disableUserStatusTrackingAfterFirstUser=");
        b.append(this.disableUserStatusTrackingAfterFirstUser);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
