package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.ChangeUefiSettingsPermission;
import odata.msgraph.client.beta.enums.Enablement;


/**
 * <i>“Graph properties for Device Firmware Configuration Interface”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "changeUefiSettingsPermission", 
    "virtualizationOfCpuAndIO", 
    "cameras", 
    "microphonesAndSpeakers", 
    "radios", 
    "bootFromExternalMedia", 
    "bootFromBuiltInNetworkAdapters"})
@JsonInclude(Include.NON_NULL)
public class Windows10DeviceFirmwareConfigurationInterface extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10DeviceFirmwareConfigurationInterface";
    }

    @JsonProperty("changeUefiSettingsPermission")
    protected ChangeUefiSettingsPermission changeUefiSettingsPermission;

    @JsonProperty("virtualizationOfCpuAndIO")
    protected Enablement virtualizationOfCpuAndIO;

    @JsonProperty("cameras")
    protected Enablement cameras;

    @JsonProperty("microphonesAndSpeakers")
    protected Enablement microphonesAndSpeakers;

    @JsonProperty("radios")
    protected Enablement radios;

    @JsonProperty("bootFromExternalMedia")
    protected Enablement bootFromExternalMedia;

    @JsonProperty("bootFromBuiltInNetworkAdapters")
    protected Enablement bootFromBuiltInNetworkAdapters;

    protected Windows10DeviceFirmwareConfigurationInterface() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10DeviceFirmwareConfigurationInterface() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private ChangeUefiSettingsPermission changeUefiSettingsPermission;
        private Enablement virtualizationOfCpuAndIO;
        private Enablement cameras;
        private Enablement microphonesAndSpeakers;
        private Enablement radios;
        private Enablement bootFromExternalMedia;
        private Enablement bootFromBuiltInNetworkAdapters;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
         * 
         * @param changeUefiSettingsPermission
         *            value of {@code changeUefiSettingsPermission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder changeUefiSettingsPermission(ChangeUefiSettingsPermission changeUefiSettingsPermission) {
            this.changeUefiSettingsPermission = changeUefiSettingsPermission;
            this.changedFields = changedFields.add("changeUefiSettingsPermission");
            return this;
        }

        /**
         * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
         * 
         * @param virtualizationOfCpuAndIO
         *            value of {@code virtualizationOfCpuAndIO} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder virtualizationOfCpuAndIO(Enablement virtualizationOfCpuAndIO) {
            this.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
            this.changedFields = changedFields.add("virtualizationOfCpuAndIO");
            return this;
        }

        /**
         * <i>“Defines whether built-in cameras are enabled.”</i>
         * 
         * @param cameras
         *            value of {@code cameras} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameras(Enablement cameras) {
            this.cameras = cameras;
            this.changedFields = changedFields.add("cameras");
            return this;
        }

        /**
         * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
         * 
         * @param microphonesAndSpeakers
         *            value of {@code microphonesAndSpeakers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microphonesAndSpeakers(Enablement microphonesAndSpeakers) {
            this.microphonesAndSpeakers = microphonesAndSpeakers;
            this.changedFields = changedFields.add("microphonesAndSpeakers");
            return this;
        }

        /**
         * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
         * 
         * @param radios
         *            value of {@code radios} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder radios(Enablement radios) {
            this.radios = radios;
            this.changedFields = changedFields.add("radios");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to boot from external media.”</i>
         * 
         * @param bootFromExternalMedia
         *            value of {@code bootFromExternalMedia} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootFromExternalMedia(Enablement bootFromExternalMedia) {
            this.bootFromExternalMedia = bootFromExternalMedia;
            this.changedFields = changedFields.add("bootFromExternalMedia");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
         * 
         * @param bootFromBuiltInNetworkAdapters
         *            value of {@code bootFromBuiltInNetworkAdapters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootFromBuiltInNetworkAdapters(Enablement bootFromBuiltInNetworkAdapters) {
            this.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
            this.changedFields = changedFields.add("bootFromBuiltInNetworkAdapters");
            return this;
        }

        public Windows10DeviceFirmwareConfigurationInterface build() {
            Windows10DeviceFirmwareConfigurationInterface _x = new Windows10DeviceFirmwareConfigurationInterface();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10DeviceFirmwareConfigurationInterface";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
            _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
            _x.cameras = cameras;
            _x.microphonesAndSpeakers = microphonesAndSpeakers;
            _x.radios = radios;
            _x.bootFromExternalMedia = bootFromExternalMedia;
            _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
     * 
     * @return property changeUefiSettingsPermission
     */
    @Property(name="changeUefiSettingsPermission")
    @JsonIgnore
    public Optional<ChangeUefiSettingsPermission> getChangeUefiSettingsPermission() {
        return Optional.ofNullable(changeUefiSettingsPermission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * changeUefiSettingsPermission} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
     * 
     * @param changeUefiSettingsPermission
     *            new value of {@code changeUefiSettingsPermission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code changeUefiSettingsPermission} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withChangeUefiSettingsPermission(ChangeUefiSettingsPermission changeUefiSettingsPermission) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("changeUefiSettingsPermission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
        return _x;
    }

    /**
     * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
     * 
     * @return property virtualizationOfCpuAndIO
     */
    @Property(name="virtualizationOfCpuAndIO")
    @JsonIgnore
    public Optional<Enablement> getVirtualizationOfCpuAndIO() {
        return Optional.ofNullable(virtualizationOfCpuAndIO);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * virtualizationOfCpuAndIO} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
     * 
     * @param virtualizationOfCpuAndIO
     *            new value of {@code virtualizationOfCpuAndIO} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code virtualizationOfCpuAndIO} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withVirtualizationOfCpuAndIO(Enablement virtualizationOfCpuAndIO) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("virtualizationOfCpuAndIO");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
        return _x;
    }

    /**
     * <i>“Defines whether built-in cameras are enabled.”</i>
     * 
     * @return property cameras
     */
    @Property(name="cameras")
    @JsonIgnore
    public Optional<Enablement> getCameras() {
        return Optional.ofNullable(cameras);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameras} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Defines whether built-in cameras are enabled.”</i>
     * 
     * @param cameras
     *            new value of {@code cameras} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameras} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withCameras(Enablement cameras) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("cameras");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.cameras = cameras;
        return _x;
    }

    /**
     * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
     * 
     * @return property microphonesAndSpeakers
     */
    @Property(name="microphonesAndSpeakers")
    @JsonIgnore
    public Optional<Enablement> getMicrophonesAndSpeakers() {
        return Optional.ofNullable(microphonesAndSpeakers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microphonesAndSpeakers} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
     * 
     * @param microphonesAndSpeakers
     *            new value of {@code microphonesAndSpeakers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microphonesAndSpeakers} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withMicrophonesAndSpeakers(Enablement microphonesAndSpeakers) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("microphonesAndSpeakers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.microphonesAndSpeakers = microphonesAndSpeakers;
        return _x;
    }

    /**
     * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
     * 
     * @return property radios
     */
    @Property(name="radios")
    @JsonIgnore
    public Optional<Enablement> getRadios() {
        return Optional.ofNullable(radios);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code radios} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
     * 
     * @param radios
     *            new value of {@code radios} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code radios} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withRadios(Enablement radios) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("radios");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.radios = radios;
        return _x;
    }

    /**
     * <i>“Defines whether a user is allowed to boot from external media.”</i>
     * 
     * @return property bootFromExternalMedia
     */
    @Property(name="bootFromExternalMedia")
    @JsonIgnore
    public Optional<Enablement> getBootFromExternalMedia() {
        return Optional.ofNullable(bootFromExternalMedia);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootFromExternalMedia} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to boot from external media.”</i>
     * 
     * @param bootFromExternalMedia
     *            new value of {@code bootFromExternalMedia} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootFromExternalMedia} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withBootFromExternalMedia(Enablement bootFromExternalMedia) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("bootFromExternalMedia");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.bootFromExternalMedia = bootFromExternalMedia;
        return _x;
    }

    /**
     * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
     * 
     * @return property bootFromBuiltInNetworkAdapters
     */
    @Property(name="bootFromBuiltInNetworkAdapters")
    @JsonIgnore
    public Optional<Enablement> getBootFromBuiltInNetworkAdapters() {
        return Optional.ofNullable(bootFromBuiltInNetworkAdapters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootFromBuiltInNetworkAdapters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
     * 
     * @param bootFromBuiltInNetworkAdapters
     *            new value of {@code bootFromBuiltInNetworkAdapters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootFromBuiltInNetworkAdapters} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withBootFromBuiltInNetworkAdapters(Enablement bootFromBuiltInNetworkAdapters) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("bootFromBuiltInNetworkAdapters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10DeviceFirmwareConfigurationInterface patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10DeviceFirmwareConfigurationInterface put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10DeviceFirmwareConfigurationInterface _copy() {
        Windows10DeviceFirmwareConfigurationInterface _x = new Windows10DeviceFirmwareConfigurationInterface();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
        _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
        _x.cameras = cameras;
        _x.microphonesAndSpeakers = microphonesAndSpeakers;
        _x.radios = radios;
        _x.bootFromExternalMedia = bootFromExternalMedia;
        _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10DeviceFirmwareConfigurationInterface[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("changeUefiSettingsPermission=");
        b.append(this.changeUefiSettingsPermission);
        b.append(", ");
        b.append("virtualizationOfCpuAndIO=");
        b.append(this.virtualizationOfCpuAndIO);
        b.append(", ");
        b.append("cameras=");
        b.append(this.cameras);
        b.append(", ");
        b.append("microphonesAndSpeakers=");
        b.append(this.microphonesAndSpeakers);
        b.append(", ");
        b.append("radios=");
        b.append(this.radios);
        b.append(", ");
        b.append("bootFromExternalMedia=");
        b.append(this.bootFromExternalMedia);
        b.append(", ");
        b.append("bootFromBuiltInNetworkAdapters=");
        b.append(this.bootFromBuiltInNetworkAdapters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
