package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceCompliancePolicyScript;
import odata.msgraph.client.beta.complex.OperatingSystemVersionRange;
import odata.msgraph.client.beta.enums.DeviceThreatProtectionLevel;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This class contains compliance settings for Windows 10.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passwordRequired", 
    "passwordBlockSimple", 
    "passwordRequiredToUnlockFromIdle", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinimumCharacterSetCount", 
    "passwordRequiredType", 
    "passwordPreviousPasswordBlockCount", 
    "requireHealthyDeviceReport", 
    "osMinimumVersion", 
    "osMaximumVersion", 
    "mobileOsMinimumVersion", 
    "mobileOsMaximumVersion", 
    "earlyLaunchAntiMalwareDriverEnabled", 
    "bitLockerEnabled", 
    "secureBootEnabled", 
    "codeIntegrityEnabled", 
    "storageRequireEncryption", 
    "activeFirewallRequired", 
    "defenderEnabled", 
    "defenderVersion", 
    "signatureOutOfDate", 
    "rtpEnabled", 
    "antivirusRequired", 
    "antiSpywareRequired", 
    "validOperatingSystemBuildRanges", 
    "deviceThreatProtectionEnabled", 
    "deviceThreatProtectionRequiredSecurityLevel", 
    "configurationManagerComplianceRequired", 
    "tpmRequired", 
    "deviceCompliancePolicyScript"})
@JsonInclude(Include.NON_NULL)
public class Windows10CompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10CompliancePolicy";
    }

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordRequiredToUnlockFromIdle")
    protected Boolean passwordRequiredToUnlockFromIdle;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("requireHealthyDeviceReport")
    protected Boolean requireHealthyDeviceReport;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("mobileOsMinimumVersion")
    protected String mobileOsMinimumVersion;

    @JsonProperty("mobileOsMaximumVersion")
    protected String mobileOsMaximumVersion;

    @JsonProperty("earlyLaunchAntiMalwareDriverEnabled")
    protected Boolean earlyLaunchAntiMalwareDriverEnabled;

    @JsonProperty("bitLockerEnabled")
    protected Boolean bitLockerEnabled;

    @JsonProperty("secureBootEnabled")
    protected Boolean secureBootEnabled;

    @JsonProperty("codeIntegrityEnabled")
    protected Boolean codeIntegrityEnabled;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    @JsonProperty("activeFirewallRequired")
    protected Boolean activeFirewallRequired;

    @JsonProperty("defenderEnabled")
    protected Boolean defenderEnabled;

    @JsonProperty("defenderVersion")
    protected String defenderVersion;

    @JsonProperty("signatureOutOfDate")
    protected Boolean signatureOutOfDate;

    @JsonProperty("rtpEnabled")
    protected Boolean rtpEnabled;

    @JsonProperty("antivirusRequired")
    protected Boolean antivirusRequired;

    @JsonProperty("antiSpywareRequired")
    protected Boolean antiSpywareRequired;

    @JsonProperty("validOperatingSystemBuildRanges")
    protected List<OperatingSystemVersionRange> validOperatingSystemBuildRanges;

    @JsonProperty("validOperatingSystemBuildRanges@nextLink")
    protected String validOperatingSystemBuildRangesNextLink;

    @JsonProperty("deviceThreatProtectionEnabled")
    protected Boolean deviceThreatProtectionEnabled;

    @JsonProperty("deviceThreatProtectionRequiredSecurityLevel")
    protected DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;

    @JsonProperty("configurationManagerComplianceRequired")
    protected Boolean configurationManagerComplianceRequired;

    @JsonProperty("tpmRequired")
    protected Boolean tpmRequired;

    @JsonProperty("deviceCompliancePolicyScript")
    protected DeviceCompliancePolicyScript deviceCompliancePolicyScript;

    protected Windows10CompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10CompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private OffsetDateTime lastModifiedDateTime;
        private String displayName;
        private Integer version;
        private Boolean passwordRequired;
        private Boolean passwordBlockSimple;
        private Boolean passwordRequiredToUnlockFromIdle;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinimumCharacterSetCount;
        private RequiredPasswordType passwordRequiredType;
        private Integer passwordPreviousPasswordBlockCount;
        private Boolean requireHealthyDeviceReport;
        private String osMinimumVersion;
        private String osMaximumVersion;
        private String mobileOsMinimumVersion;
        private String mobileOsMaximumVersion;
        private Boolean earlyLaunchAntiMalwareDriverEnabled;
        private Boolean bitLockerEnabled;
        private Boolean secureBootEnabled;
        private Boolean codeIntegrityEnabled;
        private Boolean storageRequireEncryption;
        private Boolean activeFirewallRequired;
        private Boolean defenderEnabled;
        private String defenderVersion;
        private Boolean signatureOutOfDate;
        private Boolean rtpEnabled;
        private Boolean antivirusRequired;
        private Boolean antiSpywareRequired;
        private List<OperatingSystemVersionRange> validOperatingSystemBuildRanges;
        private String validOperatingSystemBuildRangesNextLink;
        private Boolean deviceThreatProtectionEnabled;
        private DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;
        private Boolean configurationManagerComplianceRequired;
        private Boolean tpmRequired;
        private DeviceCompliancePolicyScript deviceCompliancePolicyScript;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Require a password to unlock Windows device.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block simple password.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“Require a password to unlock an idle device.”</i>
         * 
         * @param passwordRequiredToUnlockFromIdle
         *            value of {@code passwordRequiredToUnlockFromIdle} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredToUnlockFromIdle(Boolean passwordRequiredToUnlockFromIdle) {
            this.passwordRequiredToUnlockFromIdle = passwordRequiredToUnlockFromIdle;
            this.changedFields = changedFields.add("passwordRequiredToUnlockFromIdle");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a password is required.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“The password expiration in days.”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“The minimum password length.”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The required password type.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“The number of previous passwords to prevent re-use of.”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
         * 
         * @param requireHealthyDeviceReport
         *            value of {@code requireHealthyDeviceReport} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireHealthyDeviceReport(Boolean requireHealthyDeviceReport) {
            this.requireHealthyDeviceReport = requireHealthyDeviceReport;
            this.changedFields = changedFields.add("requireHealthyDeviceReport");
            return this;
        }

        /**
         * <i>“Minimum Windows 10 version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Maximum Windows 10 version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Minimum Windows Phone version.”</i>
         * 
         * @param mobileOsMinimumVersion
         *            value of {@code mobileOsMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileOsMinimumVersion(String mobileOsMinimumVersion) {
            this.mobileOsMinimumVersion = mobileOsMinimumVersion;
            this.changedFields = changedFields.add("mobileOsMinimumVersion");
            return this;
        }

        /**
         * <i>“Maximum Windows Phone version.”</i>
         * 
         * @param mobileOsMaximumVersion
         *            value of {@code mobileOsMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileOsMaximumVersion(String mobileOsMaximumVersion) {
            this.mobileOsMaximumVersion = mobileOsMaximumVersion;
            this.changedFields = changedFields.add("mobileOsMaximumVersion");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
         * early launch antimalware driver is enabled.”</i>
         * 
         * @param earlyLaunchAntiMalwareDriverEnabled
         *            value of {@code earlyLaunchAntiMalwareDriverEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder earlyLaunchAntiMalwareDriverEnabled(Boolean earlyLaunchAntiMalwareDriverEnabled) {
            this.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
            this.changedFields = changedFields.add("earlyLaunchAntiMalwareDriverEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
         * bit locker is enabled”</i>
         * 
         * @param bitLockerEnabled
         *            value of {@code bitLockerEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerEnabled(Boolean bitLockerEnabled) {
            this.bitLockerEnabled = bitLockerEnabled;
            this.changedFields = changedFields.add("bitLockerEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
         * secure boot is enabled.”</i>
         * 
         * @param secureBootEnabled
         *            value of {@code secureBootEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBootEnabled(Boolean secureBootEnabled) {
            this.secureBootEnabled = secureBootEnabled;
            this.changedFields = changedFields.add("secureBootEnabled");
            return this;
        }

        /**
         * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
         * 
         * @param codeIntegrityEnabled
         *            value of {@code codeIntegrityEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeIntegrityEnabled(Boolean codeIntegrityEnabled) {
            this.codeIntegrityEnabled = codeIntegrityEnabled;
            this.changedFields = changedFields.add("codeIntegrityEnabled");
            return this;
        }

        /**
         * <i>“Require encryption on windows devices.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        /**
         * <i>“Require active firewall on Windows devices.”</i>
         * 
         * @param activeFirewallRequired
         *            value of {@code activeFirewallRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activeFirewallRequired(Boolean activeFirewallRequired) {
            this.activeFirewallRequired = activeFirewallRequired;
            this.changedFields = changedFields.add("activeFirewallRequired");
            return this;
        }

        /**
         * <i>“Require Windows Defender Antimalware on Windows devices.”</i>
         * 
         * @param defenderEnabled
         *            value of {@code defenderEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEnabled(Boolean defenderEnabled) {
            this.defenderEnabled = defenderEnabled;
            this.changedFields = changedFields.add("defenderEnabled");
            return this;
        }

        /**
         * <i>“Require Windows Defender Antimalware minimum version on Windows devices.”</i>
         * 
         * @param defenderVersion
         *            value of {@code defenderVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderVersion(String defenderVersion) {
            this.defenderVersion = defenderVersion;
            this.changedFields = changedFields.add("defenderVersion");
            return this;
        }

        /**
         * <i>“Require Windows Defender Antimalware Signature to be up to date on Windows
         * devices.”</i>
         * 
         * @param signatureOutOfDate
         *            value of {@code signatureOutOfDate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder signatureOutOfDate(Boolean signatureOutOfDate) {
            this.signatureOutOfDate = signatureOutOfDate;
            this.changedFields = changedFields.add("signatureOutOfDate");
            return this;
        }

        /**
         * <i>“Require Windows Defender Antimalware Real-Time Protection on Windows devices.”</i>
         * 
         * @param rtpEnabled
         *            value of {@code rtpEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rtpEnabled(Boolean rtpEnabled) {
            this.rtpEnabled = rtpEnabled;
            this.changedFields = changedFields.add("rtpEnabled");
            return this;
        }

        /**
         * <i>“Require any Antivirus solution registered with Windows Decurity Center to be on
         * and monitoring (e.g. Symantec, Windows Defender).”</i>
         * 
         * @param antivirusRequired
         *            value of {@code antivirusRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder antivirusRequired(Boolean antivirusRequired) {
            this.antivirusRequired = antivirusRequired;
            this.changedFields = changedFields.add("antivirusRequired");
            return this;
        }

        /**
         * <i>“Require any AntiSpyware solution registered with Windows Decurity Center to be
         * on and monitoring (e.g. Symantec, Windows Defender).”</i>
         * 
         * @param antiSpywareRequired
         *            value of {@code antiSpywareRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder antiSpywareRequired(Boolean antiSpywareRequired) {
            this.antiSpywareRequired = antiSpywareRequired;
            this.changedFields = changedFields.add("antiSpywareRequired");
            return this;
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRanges
         *            value of {@code validOperatingSystemBuildRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRanges(List<OperatingSystemVersionRange> validOperatingSystemBuildRanges) {
            this.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
            this.changedFields = changedFields.add("validOperatingSystemBuildRanges");
            return this;
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRanges
         *            value of {@code validOperatingSystemBuildRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRanges(OperatingSystemVersionRange... validOperatingSystemBuildRanges) {
            return validOperatingSystemBuildRanges(Arrays.asList(validOperatingSystemBuildRanges));
        }

        /**
         * <i>“The valid operating system build ranges on Windows devices. This collection can
         * contain a maximum of 10000 elements.”</i>
         * 
         * @param validOperatingSystemBuildRangesNextLink
         *            value of {@code validOperatingSystemBuildRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validOperatingSystemBuildRangesNextLink(String validOperatingSystemBuildRangesNextLink) {
            this.validOperatingSystemBuildRangesNextLink = validOperatingSystemBuildRangesNextLink;
            this.changedFields = changedFields.add("validOperatingSystemBuildRanges");
            return this;
        }

        /**
         * <i>“Require that devices have enabled device threat protection.”</i>
         * 
         * @param deviceThreatProtectionEnabled
         *            value of {@code deviceThreatProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
            this.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            this.changedFields = changedFields.add("deviceThreatProtectionEnabled");
            return this;
        }

        /**
         * <i>“Require Device Threat Protection minimum risk level to report noncompliance.”</i>
         * 
         * @param deviceThreatProtectionRequiredSecurityLevel
         *            value of {@code deviceThreatProtectionRequiredSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
            this.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            this.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
            return this;
        }

        /**
         * <i>“Require to consider SCCM Compliance state into consideration for Intune
         * Compliance State.”</i>
         * 
         * @param configurationManagerComplianceRequired
         *            value of {@code configurationManagerComplianceRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerComplianceRequired(Boolean configurationManagerComplianceRequired) {
            this.configurationManagerComplianceRequired = configurationManagerComplianceRequired;
            this.changedFields = changedFields.add("configurationManagerComplianceRequired");
            return this;
        }

        /**
         * <i>“Require Trusted Platform Module(TPM) to be present.”</i>
         * 
         * @param tpmRequired
         *            value of {@code tpmRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmRequired(Boolean tpmRequired) {
            this.tpmRequired = tpmRequired;
            this.changedFields = changedFields.add("tpmRequired");
            return this;
        }

        public Builder deviceCompliancePolicyScript(DeviceCompliancePolicyScript deviceCompliancePolicyScript) {
            this.deviceCompliancePolicyScript = deviceCompliancePolicyScript;
            this.changedFields = changedFields.add("deviceCompliancePolicyScript");
            return this;
        }

        public Windows10CompliancePolicy build() {
            Windows10CompliancePolicy _x = new Windows10CompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10CompliancePolicy";
            _x.id = id;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.displayName = displayName;
            _x.version = version;
            _x.passwordRequired = passwordRequired;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordRequiredToUnlockFromIdle = passwordRequiredToUnlockFromIdle;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.requireHealthyDeviceReport = requireHealthyDeviceReport;
            _x.osMinimumVersion = osMinimumVersion;
            _x.osMaximumVersion = osMaximumVersion;
            _x.mobileOsMinimumVersion = mobileOsMinimumVersion;
            _x.mobileOsMaximumVersion = mobileOsMaximumVersion;
            _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
            _x.bitLockerEnabled = bitLockerEnabled;
            _x.secureBootEnabled = secureBootEnabled;
            _x.codeIntegrityEnabled = codeIntegrityEnabled;
            _x.storageRequireEncryption = storageRequireEncryption;
            _x.activeFirewallRequired = activeFirewallRequired;
            _x.defenderEnabled = defenderEnabled;
            _x.defenderVersion = defenderVersion;
            _x.signatureOutOfDate = signatureOutOfDate;
            _x.rtpEnabled = rtpEnabled;
            _x.antivirusRequired = antivirusRequired;
            _x.antiSpywareRequired = antiSpywareRequired;
            _x.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
            _x.validOperatingSystemBuildRangesNextLink = validOperatingSystemBuildRangesNextLink;
            _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            _x.configurationManagerComplianceRequired = configurationManagerComplianceRequired;
            _x.tpmRequired = tpmRequired;
            _x.deviceCompliancePolicyScript = deviceCompliancePolicyScript;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Require a password to unlock Windows device.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require a password to unlock Windows device.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public Windows10CompliancePolicy withPasswordRequired(Boolean passwordRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block simple password.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block simple password.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public Windows10CompliancePolicy withPasswordBlockSimple(Boolean passwordBlockSimple) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“Require a password to unlock an idle device.”</i>
     * 
     * @return property passwordRequiredToUnlockFromIdle
     */
    @Property(name="passwordRequiredToUnlockFromIdle")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequiredToUnlockFromIdle() {
        return Optional.ofNullable(passwordRequiredToUnlockFromIdle);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredToUnlockFromIdle} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Require a password to unlock an idle device.”</i>
     * 
     * @param passwordRequiredToUnlockFromIdle
     *            new value of {@code passwordRequiredToUnlockFromIdle} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredToUnlockFromIdle} field changed
     */
    public Windows10CompliancePolicy withPasswordRequiredToUnlockFromIdle(Boolean passwordRequiredToUnlockFromIdle) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredToUnlockFromIdle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordRequiredToUnlockFromIdle = passwordRequiredToUnlockFromIdle;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public Windows10CompliancePolicy withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“The password expiration in days.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The password expiration in days.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public Windows10CompliancePolicy withPasswordExpirationDays(Integer passwordExpirationDays) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“The minimum password length.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The minimum password length.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public Windows10CompliancePolicy withPasswordMinimumLength(Integer passwordMinimumLength) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public Windows10CompliancePolicy withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The required password type.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required password type.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public Windows10CompliancePolicy withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“The number of previous passwords to prevent re-use of.”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of previous passwords to prevent re-use of.”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public Windows10CompliancePolicy withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @return property requireHealthyDeviceReport
     */
    @Property(name="requireHealthyDeviceReport")
    @JsonIgnore
    public Optional<Boolean> getRequireHealthyDeviceReport() {
        return Optional.ofNullable(requireHealthyDeviceReport);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireHealthyDeviceReport} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @param requireHealthyDeviceReport
     *            new value of {@code requireHealthyDeviceReport} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireHealthyDeviceReport} field changed
     */
    public Windows10CompliancePolicy withRequireHealthyDeviceReport(Boolean requireHealthyDeviceReport) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("requireHealthyDeviceReport");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.requireHealthyDeviceReport = requireHealthyDeviceReport;
        return _x;
    }

    /**
     * <i>“Minimum Windows 10 version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum Windows 10 version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public Windows10CompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Maximum Windows 10 version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum Windows 10 version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public Windows10CompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Minimum Windows Phone version.”</i>
     * 
     * @return property mobileOsMinimumVersion
     */
    @Property(name="mobileOsMinimumVersion")
    @JsonIgnore
    public Optional<String> getMobileOsMinimumVersion() {
        return Optional.ofNullable(mobileOsMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileOsMinimumVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Minimum Windows Phone version.”</i>
     * 
     * @param mobileOsMinimumVersion
     *            new value of {@code mobileOsMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileOsMinimumVersion} field changed
     */
    public Windows10CompliancePolicy withMobileOsMinimumVersion(String mobileOsMinimumVersion) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("mobileOsMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.mobileOsMinimumVersion = mobileOsMinimumVersion;
        return _x;
    }

    /**
     * <i>“Maximum Windows Phone version.”</i>
     * 
     * @return property mobileOsMaximumVersion
     */
    @Property(name="mobileOsMaximumVersion")
    @JsonIgnore
    public Optional<String> getMobileOsMaximumVersion() {
        return Optional.ofNullable(mobileOsMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileOsMaximumVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Maximum Windows Phone version.”</i>
     * 
     * @param mobileOsMaximumVersion
     *            new value of {@code mobileOsMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileOsMaximumVersion} field changed
     */
    public Windows10CompliancePolicy withMobileOsMaximumVersion(String mobileOsMaximumVersion) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("mobileOsMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.mobileOsMaximumVersion = mobileOsMaximumVersion;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * early launch antimalware driver is enabled.”</i>
     * 
     * @return property earlyLaunchAntiMalwareDriverEnabled
     */
    @Property(name="earlyLaunchAntiMalwareDriverEnabled")
    @JsonIgnore
    public Optional<Boolean> getEarlyLaunchAntiMalwareDriverEnabled() {
        return Optional.ofNullable(earlyLaunchAntiMalwareDriverEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * earlyLaunchAntiMalwareDriverEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * early launch antimalware driver is enabled.”</i>
     * 
     * @param earlyLaunchAntiMalwareDriverEnabled
     *            new value of {@code earlyLaunchAntiMalwareDriverEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code earlyLaunchAntiMalwareDriverEnabled} field changed
     */
    public Windows10CompliancePolicy withEarlyLaunchAntiMalwareDriverEnabled(Boolean earlyLaunchAntiMalwareDriverEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("earlyLaunchAntiMalwareDriverEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
     * bit locker is enabled”</i>
     * 
     * @return property bitLockerEnabled
     */
    @Property(name="bitLockerEnabled")
    @JsonIgnore
    public Optional<Boolean> getBitLockerEnabled() {
        return Optional.ofNullable(bitLockerEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bitLockerEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require devices to be reported healthy by Windows Device Health Attestation -
     * bit locker is enabled”</i>
     * 
     * @param bitLockerEnabled
     *            new value of {@code bitLockerEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerEnabled} field changed
     */
    public Windows10CompliancePolicy withBitLockerEnabled(Boolean bitLockerEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("bitLockerEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.bitLockerEnabled = bitLockerEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * secure boot is enabled.”</i>
     * 
     * @return property secureBootEnabled
     */
    @Property(name="secureBootEnabled")
    @JsonIgnore
    public Optional<Boolean> getSecureBootEnabled() {
        return Optional.ofNullable(secureBootEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secureBootEnabled
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation -
     * secure boot is enabled.”</i>
     * 
     * @param secureBootEnabled
     *            new value of {@code secureBootEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBootEnabled} field changed
     */
    public Windows10CompliancePolicy withSecureBootEnabled(Boolean secureBootEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("secureBootEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.secureBootEnabled = secureBootEnabled;
        return _x;
    }

    /**
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @return property codeIntegrityEnabled
     */
    @Property(name="codeIntegrityEnabled")
    @JsonIgnore
    public Optional<Boolean> getCodeIntegrityEnabled() {
        return Optional.ofNullable(codeIntegrityEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * codeIntegrityEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Require devices to be reported as healthy by Windows Device Health Attestation.”</i>
     * 
     * @param codeIntegrityEnabled
     *            new value of {@code codeIntegrityEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeIntegrityEnabled} field changed
     */
    public Windows10CompliancePolicy withCodeIntegrityEnabled(Boolean codeIntegrityEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("codeIntegrityEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.codeIntegrityEnabled = codeIntegrityEnabled;
        return _x;
    }

    /**
     * <i>“Require encryption on windows devices.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require encryption on windows devices.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public Windows10CompliancePolicy withStorageRequireEncryption(Boolean storageRequireEncryption) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    /**
     * <i>“Require active firewall on Windows devices.”</i>
     * 
     * @return property activeFirewallRequired
     */
    @Property(name="activeFirewallRequired")
    @JsonIgnore
    public Optional<Boolean> getActiveFirewallRequired() {
        return Optional.ofNullable(activeFirewallRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeFirewallRequired} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require active firewall on Windows devices.”</i>
     * 
     * @param activeFirewallRequired
     *            new value of {@code activeFirewallRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeFirewallRequired} field changed
     */
    public Windows10CompliancePolicy withActiveFirewallRequired(Boolean activeFirewallRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("activeFirewallRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.activeFirewallRequired = activeFirewallRequired;
        return _x;
    }

    /**
     * <i>“Require Windows Defender Antimalware on Windows devices.”</i>
     * 
     * @return property defenderEnabled
     */
    @Property(name="defenderEnabled")
    @JsonIgnore
    public Optional<Boolean> getDefenderEnabled() {
        return Optional.ofNullable(defenderEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defenderEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require Windows Defender Antimalware on Windows devices.”</i>
     * 
     * @param defenderEnabled
     *            new value of {@code defenderEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEnabled} field changed
     */
    public Windows10CompliancePolicy withDefenderEnabled(Boolean defenderEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("defenderEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.defenderEnabled = defenderEnabled;
        return _x;
    }

    /**
     * <i>“Require Windows Defender Antimalware minimum version on Windows devices.”</i>
     * 
     * @return property defenderVersion
     */
    @Property(name="defenderVersion")
    @JsonIgnore
    public Optional<String> getDefenderVersion() {
        return Optional.ofNullable(defenderVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defenderVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require Windows Defender Antimalware minimum version on Windows devices.”</i>
     * 
     * @param defenderVersion
     *            new value of {@code defenderVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderVersion} field changed
     */
    public Windows10CompliancePolicy withDefenderVersion(String defenderVersion) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("defenderVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.defenderVersion = defenderVersion;
        return _x;
    }

    /**
     * <i>“Require Windows Defender Antimalware Signature to be up to date on Windows
     * devices.”</i>
     * 
     * @return property signatureOutOfDate
     */
    @Property(name="signatureOutOfDate")
    @JsonIgnore
    public Optional<Boolean> getSignatureOutOfDate() {
        return Optional.ofNullable(signatureOutOfDate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * signatureOutOfDate} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Require Windows Defender Antimalware Signature to be up to date on Windows
     * devices.”</i>
     * 
     * @param signatureOutOfDate
     *            new value of {@code signatureOutOfDate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code signatureOutOfDate} field changed
     */
    public Windows10CompliancePolicy withSignatureOutOfDate(Boolean signatureOutOfDate) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("signatureOutOfDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.signatureOutOfDate = signatureOutOfDate;
        return _x;
    }

    /**
     * <i>“Require Windows Defender Antimalware Real-Time Protection on Windows devices.”</i>
     * 
     * @return property rtpEnabled
     */
    @Property(name="rtpEnabled")
    @JsonIgnore
    public Optional<Boolean> getRtpEnabled() {
        return Optional.ofNullable(rtpEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rtpEnabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Require Windows Defender Antimalware Real-Time Protection on Windows devices.”</i>
     * 
     * @param rtpEnabled
     *            new value of {@code rtpEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rtpEnabled} field changed
     */
    public Windows10CompliancePolicy withRtpEnabled(Boolean rtpEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("rtpEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.rtpEnabled = rtpEnabled;
        return _x;
    }

    /**
     * <i>“Require any Antivirus solution registered with Windows Decurity Center to be on
     * and monitoring (e.g. Symantec, Windows Defender).”</i>
     * 
     * @return property antivirusRequired
     */
    @Property(name="antivirusRequired")
    @JsonIgnore
    public Optional<Boolean> getAntivirusRequired() {
        return Optional.ofNullable(antivirusRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code antivirusRequired
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require any Antivirus solution registered with Windows Decurity Center to be on
     * and monitoring (e.g. Symantec, Windows Defender).”</i>
     * 
     * @param antivirusRequired
     *            new value of {@code antivirusRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code antivirusRequired} field changed
     */
    public Windows10CompliancePolicy withAntivirusRequired(Boolean antivirusRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("antivirusRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.antivirusRequired = antivirusRequired;
        return _x;
    }

    /**
     * <i>“Require any AntiSpyware solution registered with Windows Decurity Center to be
     * on and monitoring (e.g. Symantec, Windows Defender).”</i>
     * 
     * @return property antiSpywareRequired
     */
    @Property(name="antiSpywareRequired")
    @JsonIgnore
    public Optional<Boolean> getAntiSpywareRequired() {
        return Optional.ofNullable(antiSpywareRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * antiSpywareRequired} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Require any AntiSpyware solution registered with Windows Decurity Center to be
     * on and monitoring (e.g. Symantec, Windows Defender).”</i>
     * 
     * @param antiSpywareRequired
     *            new value of {@code antiSpywareRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code antiSpywareRequired} field changed
     */
    public Windows10CompliancePolicy withAntiSpywareRequired(Boolean antiSpywareRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("antiSpywareRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.antiSpywareRequired = antiSpywareRequired;
        return _x;
    }

    /**
     * <i>“The valid operating system build ranges on Windows devices. This collection can
     * contain a maximum of 10000 elements.”</i>
     * 
     * @return property validOperatingSystemBuildRanges
     */
    @Property(name="validOperatingSystemBuildRanges")
    @JsonIgnore
    public CollectionPage<OperatingSystemVersionRange> getValidOperatingSystemBuildRanges() {
        return new CollectionPage<OperatingSystemVersionRange>(contextPath, OperatingSystemVersionRange.class, validOperatingSystemBuildRanges, Optional.ofNullable(validOperatingSystemBuildRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The valid operating system build ranges on Windows devices. This collection can
     * contain a maximum of 10000 elements.”</i>
     * 
     * @return property validOperatingSystemBuildRanges
     */
    @Property(name="validOperatingSystemBuildRanges")
    @JsonIgnore
    public CollectionPage<OperatingSystemVersionRange> getValidOperatingSystemBuildRanges(HttpRequestOptions options) {
        return new CollectionPage<OperatingSystemVersionRange>(contextPath, OperatingSystemVersionRange.class, validOperatingSystemBuildRanges, Optional.ofNullable(validOperatingSystemBuildRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Require that devices have enabled device threat protection.”</i>
     * 
     * @return property deviceThreatProtectionEnabled
     */
    @Property(name="deviceThreatProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceThreatProtectionEnabled() {
        return Optional.ofNullable(deviceThreatProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require that devices have enabled device threat protection.”</i>
     * 
     * @param deviceThreatProtectionEnabled
     *            new value of {@code deviceThreatProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionEnabled} field changed
     */
    public Windows10CompliancePolicy withDeviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        return _x;
    }

    /**
     * <i>“Require Device Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @return property deviceThreatProtectionRequiredSecurityLevel
     */
    @Property(name="deviceThreatProtectionRequiredSecurityLevel")
    @JsonIgnore
    public Optional<DeviceThreatProtectionLevel> getDeviceThreatProtectionRequiredSecurityLevel() {
        return Optional.ofNullable(deviceThreatProtectionRequiredSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionRequiredSecurityLevel} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Require Device Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @param deviceThreatProtectionRequiredSecurityLevel
     *            new value of {@code deviceThreatProtectionRequiredSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionRequiredSecurityLevel} field changed
     */
    public Windows10CompliancePolicy withDeviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        return _x;
    }

    /**
     * <i>“Require to consider SCCM Compliance state into consideration for Intune
     * Compliance State.”</i>
     * 
     * @return property configurationManagerComplianceRequired
     */
    @Property(name="configurationManagerComplianceRequired")
    @JsonIgnore
    public Optional<Boolean> getConfigurationManagerComplianceRequired() {
        return Optional.ofNullable(configurationManagerComplianceRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerComplianceRequired} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Require to consider SCCM Compliance state into consideration for Intune
     * Compliance State.”</i>
     * 
     * @param configurationManagerComplianceRequired
     *            new value of {@code configurationManagerComplianceRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerComplianceRequired} field changed
     */
    public Windows10CompliancePolicy withConfigurationManagerComplianceRequired(Boolean configurationManagerComplianceRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("configurationManagerComplianceRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.configurationManagerComplianceRequired = configurationManagerComplianceRequired;
        return _x;
    }

    /**
     * <i>“Require Trusted Platform Module(TPM) to be present.”</i>
     * 
     * @return property tpmRequired
     */
    @Property(name="tpmRequired")
    @JsonIgnore
    public Optional<Boolean> getTpmRequired() {
        return Optional.ofNullable(tpmRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tpmRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require Trusted Platform Module(TPM) to be present.”</i>
     * 
     * @param tpmRequired
     *            new value of {@code tpmRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmRequired} field changed
     */
    public Windows10CompliancePolicy withTpmRequired(Boolean tpmRequired) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("tpmRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.tpmRequired = tpmRequired;
        return _x;
    }

    @Property(name="deviceCompliancePolicyScript")
    @JsonIgnore
    public Optional<DeviceCompliancePolicyScript> getDeviceCompliancePolicyScript() {
        return Optional.ofNullable(deviceCompliancePolicyScript);
    }

    public Windows10CompliancePolicy withDeviceCompliancePolicyScript(DeviceCompliancePolicyScript deviceCompliancePolicyScript) {
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceCompliancePolicyScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10CompliancePolicy");
        _x.deviceCompliancePolicyScript = deviceCompliancePolicyScript;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10CompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10CompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10CompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10CompliancePolicy _copy() {
        Windows10CompliancePolicy _x = new Windows10CompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.displayName = displayName;
        _x.version = version;
        _x.passwordRequired = passwordRequired;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordRequiredToUnlockFromIdle = passwordRequiredToUnlockFromIdle;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.requireHealthyDeviceReport = requireHealthyDeviceReport;
        _x.osMinimumVersion = osMinimumVersion;
        _x.osMaximumVersion = osMaximumVersion;
        _x.mobileOsMinimumVersion = mobileOsMinimumVersion;
        _x.mobileOsMaximumVersion = mobileOsMaximumVersion;
        _x.earlyLaunchAntiMalwareDriverEnabled = earlyLaunchAntiMalwareDriverEnabled;
        _x.bitLockerEnabled = bitLockerEnabled;
        _x.secureBootEnabled = secureBootEnabled;
        _x.codeIntegrityEnabled = codeIntegrityEnabled;
        _x.storageRequireEncryption = storageRequireEncryption;
        _x.activeFirewallRequired = activeFirewallRequired;
        _x.defenderEnabled = defenderEnabled;
        _x.defenderVersion = defenderVersion;
        _x.signatureOutOfDate = signatureOutOfDate;
        _x.rtpEnabled = rtpEnabled;
        _x.antivirusRequired = antivirusRequired;
        _x.antiSpywareRequired = antiSpywareRequired;
        _x.validOperatingSystemBuildRanges = validOperatingSystemBuildRanges;
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        _x.configurationManagerComplianceRequired = configurationManagerComplianceRequired;
        _x.tpmRequired = tpmRequired;
        _x.deviceCompliancePolicyScript = deviceCompliancePolicyScript;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10CompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordRequiredToUnlockFromIdle=");
        b.append(this.passwordRequiredToUnlockFromIdle);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("requireHealthyDeviceReport=");
        b.append(this.requireHealthyDeviceReport);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("mobileOsMinimumVersion=");
        b.append(this.mobileOsMinimumVersion);
        b.append(", ");
        b.append("mobileOsMaximumVersion=");
        b.append(this.mobileOsMaximumVersion);
        b.append(", ");
        b.append("earlyLaunchAntiMalwareDriverEnabled=");
        b.append(this.earlyLaunchAntiMalwareDriverEnabled);
        b.append(", ");
        b.append("bitLockerEnabled=");
        b.append(this.bitLockerEnabled);
        b.append(", ");
        b.append("secureBootEnabled=");
        b.append(this.secureBootEnabled);
        b.append(", ");
        b.append("codeIntegrityEnabled=");
        b.append(this.codeIntegrityEnabled);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append(", ");
        b.append("activeFirewallRequired=");
        b.append(this.activeFirewallRequired);
        b.append(", ");
        b.append("defenderEnabled=");
        b.append(this.defenderEnabled);
        b.append(", ");
        b.append("defenderVersion=");
        b.append(this.defenderVersion);
        b.append(", ");
        b.append("signatureOutOfDate=");
        b.append(this.signatureOutOfDate);
        b.append(", ");
        b.append("rtpEnabled=");
        b.append(this.rtpEnabled);
        b.append(", ");
        b.append("antivirusRequired=");
        b.append(this.antivirusRequired);
        b.append(", ");
        b.append("antiSpywareRequired=");
        b.append(this.antiSpywareRequired);
        b.append(", ");
        b.append("validOperatingSystemBuildRanges=");
        b.append(this.validOperatingSystemBuildRanges);
        b.append(", ");
        b.append("deviceThreatProtectionEnabled=");
        b.append(this.deviceThreatProtectionEnabled);
        b.append(", ");
        b.append("deviceThreatProtectionRequiredSecurityLevel=");
        b.append(this.deviceThreatProtectionRequiredSecurityLevel);
        b.append(", ");
        b.append("configurationManagerComplianceRequired=");
        b.append(this.configurationManagerComplianceRequired);
        b.append(", ");
        b.append("tpmRequired=");
        b.append(this.tpmRequired);
        b.append(", ");
        b.append("deviceCompliancePolicyScript=");
        b.append(this.deviceCompliancePolicyScript);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
