package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Base VPN Configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethod", 
    "connectionName", 
    "role", 
    "realm", 
    "servers"})
@JsonInclude(Include.NON_NULL)
public class VpnConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnConfiguration";
    }

    @JsonProperty("authenticationMethod")
    protected VpnAuthenticationMethod authenticationMethod;

    @JsonProperty("connectionName")
    protected String connectionName;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("servers")
    protected List<VpnServer> servers;

    @JsonProperty("servers@nextLink")
    protected String serversNextLink;

    protected VpnConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public VpnConfiguration withAuthenticationMethod(VpnAuthenticationMethod authenticationMethod) {
        VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @return property connectionName
     */
    @Property(name="connectionName")
    @JsonIgnore
    public Optional<String> getConnectionName() {
        return Optional.ofNullable(connectionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @param connectionName
     *            new value of {@code connectionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionName} field changed
     */
    public VpnConfiguration withConnectionName(String connectionName) {
        VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnConfiguration");
        _x.connectionName = connectionName;
        return _x;
    }

    /**
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @return property role
     */
    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code role} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @param role
     *            new value of {@code role} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code role} field changed
     */
    public VpnConfiguration withRole(String role) {
        VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnConfiguration");
        _x.role = role;
        return _x;
    }

    /**
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public VpnConfiguration withRealm(String realm) {
        VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("realm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnConfiguration");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers() {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers(HttpRequestOptions options) {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private VpnConfiguration _copy() {
        VpnConfiguration _x = new VpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.authenticationMethod = authenticationMethod;
        _x.connectionName = connectionName;
        _x.role = role;
        _x.realm = realm;
        _x.servers = servers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
