package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserPfxIntendedPurpose;
import odata.msgraph.client.beta.enums.UserPfxPaddingScheme;


/**
 * <i>“Entity that encapsulates all information required for a user's PFX certificates.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "thumbprint", 
    "intendedPurpose", 
    "userPrincipalName", 
    "startDateTime", 
    "expirationDateTime", 
    "providerName", 
    "keyName", 
    "paddingScheme", 
    "encryptedPfxBlob", 
    "encryptedPfxPassword", 
    "createdDateTime", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserPFXCertificate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userPFXCertificate";
    }

    @JsonProperty("thumbprint")
    protected String thumbprint;

    @JsonProperty("intendedPurpose")
    protected UserPfxIntendedPurpose intendedPurpose;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("providerName")
    protected String providerName;

    @JsonProperty("keyName")
    protected String keyName;

    @JsonProperty("paddingScheme")
    protected UserPfxPaddingScheme paddingScheme;

    @JsonProperty("encryptedPfxBlob")
    protected byte[] encryptedPfxBlob;

    @JsonProperty("encryptedPfxPassword")
    protected String encryptedPfxPassword;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected UserPFXCertificate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserPFXCertificate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String thumbprint;
        private UserPfxIntendedPurpose intendedPurpose;
        private String userPrincipalName;
        private OffsetDateTime startDateTime;
        private OffsetDateTime expirationDateTime;
        private String providerName;
        private String keyName;
        private UserPfxPaddingScheme paddingScheme;
        private byte[] encryptedPfxBlob;
        private String encryptedPfxPassword;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“SHA-1 thumbprint of the PFX certificate.”</i>
         * 
         * @param thumbprint
         *            value of {@code thumbprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            this.changedFields = changedFields.add("thumbprint");
            return this;
        }

        /**
         * <i>“Certificate's intended purpose from the point-of-view of deployment.”</i>
         * 
         * @param intendedPurpose
         *            value of {@code intendedPurpose} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intendedPurpose(UserPfxIntendedPurpose intendedPurpose) {
            this.intendedPurpose = intendedPurpose;
            this.changedFields = changedFields.add("intendedPurpose");
            return this;
        }

        /**
         * <i>“User Principal Name of the PFX certificate.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Certificate's validity start date/time.”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Certificate's validity expiration date/time.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“Crypto provider used to encrypt this blob.”</i>
         * 
         * @param providerName
         *            value of {@code providerName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder providerName(String providerName) {
            this.providerName = providerName;
            this.changedFields = changedFields.add("providerName");
            return this;
        }

        /**
         * <i>“Name of the key (within the provider) used to encrypt the blob.”</i>
         * 
         * @param keyName
         *            value of {@code keyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyName(String keyName) {
            this.keyName = keyName;
            this.changedFields = changedFields.add("keyName");
            return this;
        }

        /**
         * <i>“Padding scheme used by the provider during encryption/decryption.”</i>
         * 
         * @param paddingScheme
         *            value of {@code paddingScheme} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder paddingScheme(UserPfxPaddingScheme paddingScheme) {
            this.paddingScheme = paddingScheme;
            this.changedFields = changedFields.add("paddingScheme");
            return this;
        }

        /**
         * <i>“Encrypted PFX blob.”</i>
         * 
         * @param encryptedPfxBlob
         *            value of {@code encryptedPfxBlob} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptedPfxBlob(byte[] encryptedPfxBlob) {
            this.encryptedPfxBlob = encryptedPfxBlob;
            this.changedFields = changedFields.add("encryptedPfxBlob");
            return this;
        }

        /**
         * <i>“Encrypted PFX password.”</i>
         * 
         * @param encryptedPfxPassword
         *            value of {@code encryptedPfxPassword} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptedPfxPassword(String encryptedPfxPassword) {
            this.encryptedPfxPassword = encryptedPfxPassword;
            this.changedFields = changedFields.add("encryptedPfxPassword");
            return this;
        }

        /**
         * <i>“Date/time when this PFX certificate was imported.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Date/time when this PFX certificate was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public UserPFXCertificate build() {
            UserPFXCertificate _x = new UserPFXCertificate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userPFXCertificate";
            _x.id = id;
            _x.thumbprint = thumbprint;
            _x.intendedPurpose = intendedPurpose;
            _x.userPrincipalName = userPrincipalName;
            _x.startDateTime = startDateTime;
            _x.expirationDateTime = expirationDateTime;
            _x.providerName = providerName;
            _x.keyName = keyName;
            _x.paddingScheme = paddingScheme;
            _x.encryptedPfxBlob = encryptedPfxBlob;
            _x.encryptedPfxPassword = encryptedPfxPassword;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“SHA-1 thumbprint of the PFX certificate.”</i>
     * 
     * @return property thumbprint
     */
    @Property(name="thumbprint")
    @JsonIgnore
    public Optional<String> getThumbprint() {
        return Optional.ofNullable(thumbprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code thumbprint} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SHA-1 thumbprint of the PFX certificate.”</i>
     * 
     * @param thumbprint
     *            new value of {@code thumbprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code thumbprint} field changed
     */
    public UserPFXCertificate withThumbprint(String thumbprint) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("thumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.thumbprint = thumbprint;
        return _x;
    }

    /**
     * <i>“Certificate's intended purpose from the point-of-view of deployment.”</i>
     * 
     * @return property intendedPurpose
     */
    @Property(name="intendedPurpose")
    @JsonIgnore
    public Optional<UserPfxIntendedPurpose> getIntendedPurpose() {
        return Optional.ofNullable(intendedPurpose);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intendedPurpose}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate's intended purpose from the point-of-view of deployment.”</i>
     * 
     * @param intendedPurpose
     *            new value of {@code intendedPurpose} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intendedPurpose} field changed
     */
    public UserPFXCertificate withIntendedPurpose(UserPfxIntendedPurpose intendedPurpose) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("intendedPurpose");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.intendedPurpose = intendedPurpose;
        return _x;
    }

    /**
     * <i>“User Principal Name of the PFX certificate.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name of the PFX certificate.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public UserPFXCertificate withUserPrincipalName(String userPrincipalName) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Certificate's validity start date/time.”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate's validity start date/time.”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public UserPFXCertificate withStartDateTime(OffsetDateTime startDateTime) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Certificate's validity expiration date/time.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Certificate's validity expiration date/time.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public UserPFXCertificate withExpirationDateTime(OffsetDateTime expirationDateTime) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“Crypto provider used to encrypt this blob.”</i>
     * 
     * @return property providerName
     */
    @Property(name="providerName")
    @JsonIgnore
    public Optional<String> getProviderName() {
        return Optional.ofNullable(providerName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code providerName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Crypto provider used to encrypt this blob.”</i>
     * 
     * @param providerName
     *            new value of {@code providerName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code providerName} field changed
     */
    public UserPFXCertificate withProviderName(String providerName) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("providerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.providerName = providerName;
        return _x;
    }

    /**
     * <i>“Name of the key (within the provider) used to encrypt the blob.”</i>
     * 
     * @return property keyName
     */
    @Property(name="keyName")
    @JsonIgnore
    public Optional<String> getKeyName() {
        return Optional.ofNullable(keyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keyName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the key (within the provider) used to encrypt the blob.”</i>
     * 
     * @param keyName
     *            new value of {@code keyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyName} field changed
     */
    public UserPFXCertificate withKeyName(String keyName) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("keyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.keyName = keyName;
        return _x;
    }

    /**
     * <i>“Padding scheme used by the provider during encryption/decryption.”</i>
     * 
     * @return property paddingScheme
     */
    @Property(name="paddingScheme")
    @JsonIgnore
    public Optional<UserPfxPaddingScheme> getPaddingScheme() {
        return Optional.ofNullable(paddingScheme);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code paddingScheme}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Padding scheme used by the provider during encryption/decryption.”</i>
     * 
     * @param paddingScheme
     *            new value of {@code paddingScheme} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code paddingScheme} field changed
     */
    public UserPFXCertificate withPaddingScheme(UserPfxPaddingScheme paddingScheme) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("paddingScheme");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.paddingScheme = paddingScheme;
        return _x;
    }

    /**
     * <i>“Encrypted PFX blob.”</i>
     * 
     * @return property encryptedPfxBlob
     */
    @Property(name="encryptedPfxBlob")
    @JsonIgnore
    public Optional<byte[]> getEncryptedPfxBlob() {
        return Optional.ofNullable(encryptedPfxBlob);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptedPfxBlob}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Encrypted PFX blob.”</i>
     * 
     * @param encryptedPfxBlob
     *            new value of {@code encryptedPfxBlob} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptedPfxBlob} field changed
     */
    public UserPFXCertificate withEncryptedPfxBlob(byte[] encryptedPfxBlob) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("encryptedPfxBlob");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.encryptedPfxBlob = encryptedPfxBlob;
        return _x;
    }

    /**
     * <i>“Encrypted PFX password.”</i>
     * 
     * @return property encryptedPfxPassword
     */
    @Property(name="encryptedPfxPassword")
    @JsonIgnore
    public Optional<String> getEncryptedPfxPassword() {
        return Optional.ofNullable(encryptedPfxPassword);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * encryptedPfxPassword} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Encrypted PFX password.”</i>
     * 
     * @param encryptedPfxPassword
     *            new value of {@code encryptedPfxPassword} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptedPfxPassword} field changed
     */
    public UserPFXCertificate withEncryptedPfxPassword(String encryptedPfxPassword) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("encryptedPfxPassword");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.encryptedPfxPassword = encryptedPfxPassword;
        return _x;
    }

    /**
     * <i>“Date/time when this PFX certificate was imported.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Date/time when this PFX certificate was imported.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public UserPFXCertificate withCreatedDateTime(OffsetDateTime createdDateTime) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Date/time when this PFX certificate was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Date/time when this PFX certificate was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public UserPFXCertificate withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        UserPFXCertificate _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userPFXCertificate");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserPFXCertificate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserPFXCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserPFXCertificate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserPFXCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserPFXCertificate _copy() {
        UserPFXCertificate _x = new UserPFXCertificate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.thumbprint = thumbprint;
        _x.intendedPurpose = intendedPurpose;
        _x.userPrincipalName = userPrincipalName;
        _x.startDateTime = startDateTime;
        _x.expirationDateTime = expirationDateTime;
        _x.providerName = providerName;
        _x.keyName = keyName;
        _x.paddingScheme = paddingScheme;
        _x.encryptedPfxBlob = encryptedPfxBlob;
        _x.encryptedPfxPassword = encryptedPfxPassword;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserPFXCertificate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("thumbprint=");
        b.append(this.thumbprint);
        b.append(", ");
        b.append("intendedPurpose=");
        b.append(this.intendedPurpose);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("providerName=");
        b.append(this.providerName);
        b.append(", ");
        b.append("keyName=");
        b.append(this.keyName);
        b.append(", ");
        b.append("paddingScheme=");
        b.append(this.paddingScheme);
        b.append(", ");
        b.append("encryptedPfxBlob=");
        b.append(this.encryptedPfxBlob);
        b.append(", ");
        b.append("encryptedPfxPassword=");
        b.append(this.encryptedPfxPassword);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
