package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analytics device startup score history.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "startupDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsScoreHistory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsScoreHistory";
    }

    @JsonProperty("startupDateTime")
    protected OffsetDateTime startupDateTime;

    protected UserExperienceAnalyticsScoreHistory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsScoreHistory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime startupDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience analytics device startup date time.”</i>
         * 
         * @param startupDateTime
         *            value of {@code startupDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startupDateTime(OffsetDateTime startupDateTime) {
            this.startupDateTime = startupDateTime;
            this.changedFields = changedFields.add("startupDateTime");
            return this;
        }

        public UserExperienceAnalyticsScoreHistory build() {
            UserExperienceAnalyticsScoreHistory _x = new UserExperienceAnalyticsScoreHistory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsScoreHistory";
            _x.id = id;
            _x.startupDateTime = startupDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The user experience analytics device startup date time.”</i>
     * 
     * @return property startupDateTime
     */
    @Property(name="startupDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartupDateTime() {
        return Optional.ofNullable(startupDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startupDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device startup date time.”</i>
     * 
     * @param startupDateTime
     *            new value of {@code startupDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startupDateTime} field changed
     */
    public UserExperienceAnalyticsScoreHistory withStartupDateTime(OffsetDateTime startupDateTime) {
        UserExperienceAnalyticsScoreHistory _x = _copy();
        _x.changedFields = changedFields.add("startupDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsScoreHistory");
        _x.startupDateTime = startupDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsScoreHistory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsScoreHistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsScoreHistory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsScoreHistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsScoreHistory _copy() {
        UserExperienceAnalyticsScoreHistory _x = new UserExperienceAnalyticsScoreHistory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.startupDateTime = startupDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsScoreHistory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("startupDateTime=");
        b.append(this.startupDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
