package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;

import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricCollectionRequest;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsSummarizedBy;


/**
 * <i>“The user experience analytics Regression Summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsRegressionSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsRegressionSummary";
    }

    protected UserExperienceAnalyticsRegressionSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsRegressionSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public UserExperienceAnalyticsRegressionSummary build() {
            UserExperienceAnalyticsRegressionSummary _x = new UserExperienceAnalyticsRegressionSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsRegressionSummary";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The metric values for the user experience analytics model regression.”</i>
     * 
     * @return navigational property modelRegression
     */
    @NavigationProperty(name="modelRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getModelRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("modelRegression"));
    }

    /**
     * <i>“The metric values for the user experience analytics Manufacturer regression.”</i>
     * 
     * @return navigational property manufacturerRegression
     */
    @NavigationProperty(name="manufacturerRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getManufacturerRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("manufacturerRegression"));
    }

    /**
     * <i>“The metric values for the user experience analytics operating system regression.”</i>
     * 
     * @return navigational property operatingSystemRegression
     */
    @NavigationProperty(name="operatingSystemRegression")
    @JsonIgnore
    public UserExperienceAnalyticsMetricCollectionRequest getOperatingSystemRegression() {
        return new UserExperienceAnalyticsMetricCollectionRequest(
                        contextPath.addSegment("operatingSystemRegression"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsRegressionSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsRegressionSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsRegressionSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsRegressionSummary _copy() {
        UserExperienceAnalyticsRegressionSummary _x = new UserExperienceAnalyticsRegressionSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Function(name = "summarizeDeviceRegressionPerformance")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary> summarizeDeviceRegressionPerformance(UserExperienceAnalyticsSummarizedBy summarizeBy) {
        Preconditions.checkNotNull(summarizeBy, "summarizeBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("summarizeBy", "microsoft.graph.userExperienceAnalyticsSummarizedBy", summarizeBy)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsRegressionSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.summarizeDeviceRegressionPerformance"), UserExperienceAnalyticsRegressionSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsRegressionSummary[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
