package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DiskType;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsHealthState;


/**
 * <i>“The user experience analytics device performance entity contains device boot
 * performance details.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceName", 
    "model", 
    "manufacturer", 
    "diskType", 
    "operatingSystemVersion", 
    "bootScore", 
    "coreBootTimeInMs", 
    "groupPolicyBootTimeInMs", 
    "healthStatus", 
    "loginScore", 
    "coreLoginTimeInMs", 
    "groupPolicyLoginTimeInMs", 
    "deviceCount", 
    "responsiveDesktopTimeInMs"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsDevicePerformance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsDevicePerformance";
    }

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("diskType")
    protected DiskType diskType;

    @JsonProperty("operatingSystemVersion")
    protected String operatingSystemVersion;

    @JsonProperty("bootScore")
    protected Integer bootScore;

    @JsonProperty("coreBootTimeInMs")
    protected Integer coreBootTimeInMs;

    @JsonProperty("groupPolicyBootTimeInMs")
    protected Integer groupPolicyBootTimeInMs;

    @JsonProperty("healthStatus")
    protected UserExperienceAnalyticsHealthState healthStatus;

    @JsonProperty("loginScore")
    protected Integer loginScore;

    @JsonProperty("coreLoginTimeInMs")
    protected Integer coreLoginTimeInMs;

    @JsonProperty("groupPolicyLoginTimeInMs")
    protected Integer groupPolicyLoginTimeInMs;

    @JsonProperty("deviceCount")
    protected Long deviceCount;

    @JsonProperty("responsiveDesktopTimeInMs")
    protected Integer responsiveDesktopTimeInMs;

    protected UserExperienceAnalyticsDevicePerformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsDevicePerformance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceName;
        private String model;
        private String manufacturer;
        private DiskType diskType;
        private String operatingSystemVersion;
        private Integer bootScore;
        private Integer coreBootTimeInMs;
        private Integer groupPolicyBootTimeInMs;
        private UserExperienceAnalyticsHealthState healthStatus;
        private Integer loginScore;
        private Integer coreLoginTimeInMs;
        private Integer groupPolicyLoginTimeInMs;
        private Long deviceCount;
        private Integer responsiveDesktopTimeInMs;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user experience analytics device name.”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“The user experience analytics device model.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“The user experience analytics device manufacturer.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“The user experience analytics device disk type.”</i>
         * 
         * @param diskType
         *            value of {@code diskType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diskType(DiskType diskType) {
            this.diskType = diskType;
            this.changedFields = changedFields.add("diskType");
            return this;
        }

        /**
         * <i>“The user experience analytics device Operating System version.”</i>
         * 
         * @param operatingSystemVersion
         *            value of {@code operatingSystemVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.changedFields = changedFields.add("operatingSystemVersion");
            return this;
        }

        /**
         * <i>“The user experience analytics device boot score.”</i>
         * 
         * @param bootScore
         *            value of {@code bootScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootScore(Integer bootScore) {
            this.bootScore = bootScore;
            this.changedFields = changedFields.add("bootScore");
            return this;
        }

        /**
         * <i>“The user experience analytics device core boot time in milliseconds.”</i>
         * 
         * @param coreBootTimeInMs
         *            value of {@code coreBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coreBootTimeInMs(Integer coreBootTimeInMs) {
            this.coreBootTimeInMs = coreBootTimeInMs;
            this.changedFields = changedFields.add("coreBootTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device group policy boot time in milliseconds.”</i>
         * 
         * @param groupPolicyBootTimeInMs
         *            value of {@code groupPolicyBootTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyBootTimeInMs(Integer groupPolicyBootTimeInMs) {
            this.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
            this.changedFields = changedFields.add("groupPolicyBootTimeInMs");
            return this;
        }

        /**
         * <i>“The health state of the user experience analytics device.”</i>
         * 
         * @param healthStatus
         *            value of {@code healthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStatus(UserExperienceAnalyticsHealthState healthStatus) {
            this.healthStatus = healthStatus;
            this.changedFields = changedFields.add("healthStatus");
            return this;
        }

        /**
         * <i>“The user experience analytics device login score.”</i>
         * 
         * @param loginScore
         *            value of {@code loginScore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder loginScore(Integer loginScore) {
            this.loginScore = loginScore;
            this.changedFields = changedFields.add("loginScore");
            return this;
        }

        /**
         * <i>“The user experience analytics device core login time in milliseconds.”</i>
         * 
         * @param coreLoginTimeInMs
         *            value of {@code coreLoginTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coreLoginTimeInMs(Integer coreLoginTimeInMs) {
            this.coreLoginTimeInMs = coreLoginTimeInMs;
            this.changedFields = changedFields.add("coreLoginTimeInMs");
            return this;
        }

        /**
         * <i>“The user experience analytics device group policy login time in milliseconds.”</i>
         * 
         * @param groupPolicyLoginTimeInMs
         *            value of {@code groupPolicyLoginTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupPolicyLoginTimeInMs(Integer groupPolicyLoginTimeInMs) {
            this.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
            this.changedFields = changedFields.add("groupPolicyLoginTimeInMs");
            return this;
        }

        /**
         * <i>“User experience analytics summarized device count.”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Long deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
         * 
         * @param responsiveDesktopTimeInMs
         *            value of {@code responsiveDesktopTimeInMs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder responsiveDesktopTimeInMs(Integer responsiveDesktopTimeInMs) {
            this.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
            this.changedFields = changedFields.add("responsiveDesktopTimeInMs");
            return this;
        }

        public UserExperienceAnalyticsDevicePerformance build() {
            UserExperienceAnalyticsDevicePerformance _x = new UserExperienceAnalyticsDevicePerformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsDevicePerformance";
            _x.id = id;
            _x.deviceName = deviceName;
            _x.model = model;
            _x.manufacturer = manufacturer;
            _x.diskType = diskType;
            _x.operatingSystemVersion = operatingSystemVersion;
            _x.bootScore = bootScore;
            _x.coreBootTimeInMs = coreBootTimeInMs;
            _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
            _x.healthStatus = healthStatus;
            _x.loginScore = loginScore;
            _x.coreLoginTimeInMs = coreLoginTimeInMs;
            _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
            _x.deviceCount = deviceCount;
            _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The user experience analytics device name.”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device name.”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withDeviceName(String deviceName) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“The user experience analytics device model.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device model.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withModel(String model) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“The user experience analytics device manufacturer.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device manufacturer.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withManufacturer(String manufacturer) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“The user experience analytics device disk type.”</i>
     * 
     * @return property diskType
     */
    @Property(name="diskType")
    @JsonIgnore
    public Optional<DiskType> getDiskType() {
        return Optional.ofNullable(diskType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code diskType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device disk type.”</i>
     * 
     * @param diskType
     *            new value of {@code diskType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diskType} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withDiskType(DiskType diskType) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("diskType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.diskType = diskType;
        return _x;
    }

    /**
     * <i>“The user experience analytics device Operating System version.”</i>
     * 
     * @return property operatingSystemVersion
     */
    @Property(name="operatingSystemVersion")
    @JsonIgnore
    public Optional<String> getOperatingSystemVersion() {
        return Optional.ofNullable(operatingSystemVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device Operating System version.”</i>
     * 
     * @param operatingSystemVersion
     *            new value of {@code operatingSystemVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemVersion} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withOperatingSystemVersion(String operatingSystemVersion) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("operatingSystemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.operatingSystemVersion = operatingSystemVersion;
        return _x;
    }

    /**
     * <i>“The user experience analytics device boot score.”</i>
     * 
     * @return property bootScore
     */
    @Property(name="bootScore")
    @JsonIgnore
    public Optional<Integer> getBootScore() {
        return Optional.ofNullable(bootScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bootScore} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device boot score.”</i>
     * 
     * @param bootScore
     *            new value of {@code bootScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootScore} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withBootScore(Integer bootScore) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("bootScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.bootScore = bootScore;
        return _x;
    }

    /**
     * <i>“The user experience analytics device core boot time in milliseconds.”</i>
     * 
     * @return property coreBootTimeInMs
     */
    @Property(name="coreBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getCoreBootTimeInMs() {
        return Optional.ofNullable(coreBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code coreBootTimeInMs}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device core boot time in milliseconds.”</i>
     * 
     * @param coreBootTimeInMs
     *            new value of {@code coreBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coreBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withCoreBootTimeInMs(Integer coreBootTimeInMs) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("coreBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.coreBootTimeInMs = coreBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device group policy boot time in milliseconds.”</i>
     * 
     * @return property groupPolicyBootTimeInMs
     */
    @Property(name="groupPolicyBootTimeInMs")
    @JsonIgnore
    public Optional<Integer> getGroupPolicyBootTimeInMs() {
        return Optional.ofNullable(groupPolicyBootTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyBootTimeInMs} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device group policy boot time in milliseconds.”</i>
     * 
     * @param groupPolicyBootTimeInMs
     *            new value of {@code groupPolicyBootTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyBootTimeInMs} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withGroupPolicyBootTimeInMs(Integer groupPolicyBootTimeInMs) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyBootTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
        return _x;
    }

    /**
     * <i>“The health state of the user experience analytics device.”</i>
     * 
     * @return property healthStatus
     */
    @Property(name="healthStatus")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsHealthState> getHealthStatus() {
        return Optional.ofNullable(healthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The health state of the user experience analytics device.”</i>
     * 
     * @param healthStatus
     *            new value of {@code healthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStatus} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withHealthStatus(UserExperienceAnalyticsHealthState healthStatus) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("healthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.healthStatus = healthStatus;
        return _x;
    }

    /**
     * <i>“The user experience analytics device login score.”</i>
     * 
     * @return property loginScore
     */
    @Property(name="loginScore")
    @JsonIgnore
    public Optional<Integer> getLoginScore() {
        return Optional.ofNullable(loginScore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code loginScore} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user experience analytics device login score.”</i>
     * 
     * @param loginScore
     *            new value of {@code loginScore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code loginScore} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withLoginScore(Integer loginScore) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("loginScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.loginScore = loginScore;
        return _x;
    }

    /**
     * <i>“The user experience analytics device core login time in milliseconds.”</i>
     * 
     * @return property coreLoginTimeInMs
     */
    @Property(name="coreLoginTimeInMs")
    @JsonIgnore
    public Optional<Integer> getCoreLoginTimeInMs() {
        return Optional.ofNullable(coreLoginTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code coreLoginTimeInMs
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user experience analytics device core login time in milliseconds.”</i>
     * 
     * @param coreLoginTimeInMs
     *            new value of {@code coreLoginTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coreLoginTimeInMs} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withCoreLoginTimeInMs(Integer coreLoginTimeInMs) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("coreLoginTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.coreLoginTimeInMs = coreLoginTimeInMs;
        return _x;
    }

    /**
     * <i>“The user experience analytics device group policy login time in milliseconds.”</i>
     * 
     * @return property groupPolicyLoginTimeInMs
     */
    @Property(name="groupPolicyLoginTimeInMs")
    @JsonIgnore
    public Optional<Integer> getGroupPolicyLoginTimeInMs() {
        return Optional.ofNullable(groupPolicyLoginTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * groupPolicyLoginTimeInMs} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics device group policy login time in milliseconds.”</i>
     * 
     * @param groupPolicyLoginTimeInMs
     *            new value of {@code groupPolicyLoginTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupPolicyLoginTimeInMs} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withGroupPolicyLoginTimeInMs(Integer groupPolicyLoginTimeInMs) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("groupPolicyLoginTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
        return _x;
    }

    /**
     * <i>“User experience analytics summarized device count.”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Long> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User experience analytics summarized device count.”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withDeviceCount(Long deviceCount) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
     * 
     * @return property responsiveDesktopTimeInMs
     */
    @Property(name="responsiveDesktopTimeInMs")
    @JsonIgnore
    public Optional<Integer> getResponsiveDesktopTimeInMs() {
        return Optional.ofNullable(responsiveDesktopTimeInMs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * responsiveDesktopTimeInMs} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics responsive desktop time in milliseconds.”</i>
     * 
     * @param responsiveDesktopTimeInMs
     *            new value of {@code responsiveDesktopTimeInMs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code responsiveDesktopTimeInMs} field changed
     */
    public UserExperienceAnalyticsDevicePerformance withResponsiveDesktopTimeInMs(Integer responsiveDesktopTimeInMs) {
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = changedFields.add("responsiveDesktopTimeInMs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsDevicePerformance");
        _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDevicePerformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsDevicePerformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsDevicePerformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsDevicePerformance _copy() {
        UserExperienceAnalyticsDevicePerformance _x = new UserExperienceAnalyticsDevicePerformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceName = deviceName;
        _x.model = model;
        _x.manufacturer = manufacturer;
        _x.diskType = diskType;
        _x.operatingSystemVersion = operatingSystemVersion;
        _x.bootScore = bootScore;
        _x.coreBootTimeInMs = coreBootTimeInMs;
        _x.groupPolicyBootTimeInMs = groupPolicyBootTimeInMs;
        _x.healthStatus = healthStatus;
        _x.loginScore = loginScore;
        _x.coreLoginTimeInMs = coreLoginTimeInMs;
        _x.groupPolicyLoginTimeInMs = groupPolicyLoginTimeInMs;
        _x.deviceCount = deviceCount;
        _x.responsiveDesktopTimeInMs = responsiveDesktopTimeInMs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsDevicePerformance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("diskType=");
        b.append(this.diskType);
        b.append(", ");
        b.append("operatingSystemVersion=");
        b.append(this.operatingSystemVersion);
        b.append(", ");
        b.append("bootScore=");
        b.append(this.bootScore);
        b.append(", ");
        b.append("coreBootTimeInMs=");
        b.append(this.coreBootTimeInMs);
        b.append(", ");
        b.append("groupPolicyBootTimeInMs=");
        b.append(this.groupPolicyBootTimeInMs);
        b.append(", ");
        b.append("healthStatus=");
        b.append(this.healthStatus);
        b.append(", ");
        b.append("loginScore=");
        b.append(this.loginScore);
        b.append(", ");
        b.append("coreLoginTimeInMs=");
        b.append(this.coreLoginTimeInMs);
        b.append(", ");
        b.append("groupPolicyLoginTimeInMs=");
        b.append(this.groupPolicyLoginTimeInMs);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("responsiveDesktopTimeInMs=");
        b.append(this.responsiveDesktopTimeInMs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
