package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FeatureType;
import odata.msgraph.client.beta.enums.UsageAuthMethod;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "feature", 
    "userPrincipalName", 
    "userDisplayName", 
    "isSuccess", 
    "authMethod", 
    "failureReason", 
    "eventDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserCredentialUsageDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userCredentialUsageDetails";
    }

    @JsonProperty("feature")
    protected FeatureType feature;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("isSuccess")
    protected Boolean isSuccess;

    @JsonProperty("authMethod")
    protected UsageAuthMethod authMethod;

    @JsonProperty("failureReason")
    protected String failureReason;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    protected UserCredentialUsageDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserCredentialUsageDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private FeatureType feature;
        private String userPrincipalName;
        private String userDisplayName;
        private Boolean isSuccess;
        private UsageAuthMethod authMethod;
        private String failureReason;
        private OffsetDateTime eventDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder feature(FeatureType feature) {
            this.feature = feature;
            this.changedFields = changedFields.add("feature");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.changedFields = changedFields.add("isSuccess");
            return this;
        }

        public Builder authMethod(UsageAuthMethod authMethod) {
            this.authMethod = authMethod;
            this.changedFields = changedFields.add("authMethod");
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            this.changedFields = changedFields.add("failureReason");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public UserCredentialUsageDetails build() {
            UserCredentialUsageDetails _x = new UserCredentialUsageDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userCredentialUsageDetails";
            _x.id = id;
            _x.feature = feature;
            _x.userPrincipalName = userPrincipalName;
            _x.userDisplayName = userDisplayName;
            _x.isSuccess = isSuccess;
            _x.authMethod = authMethod;
            _x.failureReason = failureReason;
            _x.eventDateTime = eventDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="feature")
    @JsonIgnore
    public Optional<FeatureType> getFeature() {
        return Optional.ofNullable(feature);
    }

    public UserCredentialUsageDetails withFeature(FeatureType feature) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("feature");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.feature = feature;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public UserCredentialUsageDetails withUserPrincipalName(String userPrincipalName) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public UserCredentialUsageDetails withUserDisplayName(String userDisplayName) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="isSuccess")
    @JsonIgnore
    public Optional<Boolean> getIsSuccess() {
        return Optional.ofNullable(isSuccess);
    }

    public UserCredentialUsageDetails withIsSuccess(Boolean isSuccess) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("isSuccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.isSuccess = isSuccess;
        return _x;
    }

    @Property(name="authMethod")
    @JsonIgnore
    public Optional<UsageAuthMethod> getAuthMethod() {
        return Optional.ofNullable(authMethod);
    }

    public UserCredentialUsageDetails withAuthMethod(UsageAuthMethod authMethod) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("authMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.authMethod = authMethod;
        return _x;
    }

    @Property(name="failureReason")
    @JsonIgnore
    public Optional<String> getFailureReason() {
        return Optional.ofNullable(failureReason);
    }

    public UserCredentialUsageDetails withFailureReason(String failureReason) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("failureReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.failureReason = failureReason;
        return _x;
    }

    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    public UserCredentialUsageDetails withEventDateTime(OffsetDateTime eventDateTime) {
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = changedFields.add("eventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userCredentialUsageDetails");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserCredentialUsageDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserCredentialUsageDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserCredentialUsageDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserCredentialUsageDetails _copy() {
        UserCredentialUsageDetails _x = new UserCredentialUsageDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.feature = feature;
        _x.userPrincipalName = userPrincipalName;
        _x.userDisplayName = userDisplayName;
        _x.isSuccess = isSuccess;
        _x.authMethod = authMethod;
        _x.failureReason = failureReason;
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserCredentialUsageDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("feature=");
        b.append(this.feature);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("isSuccess=");
        b.append(this.isSuccess);
        b.append(", ");
        b.append("authMethod=");
        b.append(this.authMethod);
        b.append(", ");
        b.append("failureReason=");
        b.append(this.failureReason);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
