package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserIdentity;

@JsonPropertyOrder({
    "@odata.type", 
    "reason", 
    "createdBy", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class UserConsentRequest extends Request implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userConsentRequest";
    }

    @JsonProperty("reason")
    protected String reason;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected UserConsentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserConsentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String reason;
        private UserIdentity createdBy;
        private OffsetDateTime createdDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public UserConsentRequest build() {
            UserConsentRequest _x = new UserConsentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userConsentRequest";
            _x.id = id;
            _x.reason = reason;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public UserConsentRequest withReason(String reason) {
        UserConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("reason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userConsentRequest");
        _x.reason = reason;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public UserConsentRequest withCreatedBy(UserIdentity createdBy) {
        UserConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userConsentRequest");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public UserConsentRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        UserConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userConsentRequest");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserConsentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserConsentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserConsentRequest _copy() {
        UserConsentRequest _x = new UserConsentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reason = reason;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserConsentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
