package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MobileAppInstallStatusCollectionRequest;
import odata.msgraph.client.beta.entity.request.MobileAppRequest;


/**
 * <i>“Contains properties for the installation status for a user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userName", 
    "userPrincipalName", 
    "installedDeviceCount", 
    "failedDeviceCount", 
    "notInstalledDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class UserAppInstallStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userAppInstallStatus";
    }

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("installedDeviceCount")
    protected Integer installedDeviceCount;

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    @JsonProperty("notInstalledDeviceCount")
    protected Integer notInstalledDeviceCount;

    protected UserAppInstallStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserAppInstallStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userName;
        private String userPrincipalName;
        private Integer installedDeviceCount;
        private Integer failedDeviceCount;
        private Integer notInstalledDeviceCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“User name.”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“User Principal Name.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        /**
         * <i>“Installed Device Count.”</i>
         * 
         * @param installedDeviceCount
         *            value of {@code installedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedDeviceCount(Integer installedDeviceCount) {
            this.installedDeviceCount = installedDeviceCount;
            this.changedFields = changedFields.add("installedDeviceCount");
            return this;
        }

        /**
         * <i>“Failed Device Count.”</i>
         * 
         * @param failedDeviceCount
         *            value of {@code failedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        /**
         * <i>“Not installed device count.”</i>
         * 
         * @param notInstalledDeviceCount
         *            value of {@code notInstalledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notInstalledDeviceCount(Integer notInstalledDeviceCount) {
            this.notInstalledDeviceCount = notInstalledDeviceCount;
            this.changedFields = changedFields.add("notInstalledDeviceCount");
            return this;
        }

        public UserAppInstallStatus build() {
            UserAppInstallStatus _x = new UserAppInstallStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userAppInstallStatus";
            _x.id = id;
            _x.userName = userName;
            _x.userPrincipalName = userPrincipalName;
            _x.installedDeviceCount = installedDeviceCount;
            _x.failedDeviceCount = failedDeviceCount;
            _x.notInstalledDeviceCount = notInstalledDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“User name.”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“User name.”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public UserAppInstallStatus withUserName(String userName) {
        UserAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAppInstallStatus");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“User Principal Name.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public UserAppInstallStatus withUserPrincipalName(String userPrincipalName) {
        UserAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAppInstallStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Installed Device Count.”</i>
     * 
     * @return property installedDeviceCount
     */
    @Property(name="installedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getInstalledDeviceCount() {
        return Optional.ofNullable(installedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Installed Device Count.”</i>
     * 
     * @param installedDeviceCount
     *            new value of {@code installedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedDeviceCount} field changed
     */
    public UserAppInstallStatus withInstalledDeviceCount(Integer installedDeviceCount) {
        UserAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("installedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAppInstallStatus");
        _x.installedDeviceCount = installedDeviceCount;
        return _x;
    }

    /**
     * <i>“Failed Device Count.”</i>
     * 
     * @return property failedDeviceCount
     */
    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Failed Device Count.”</i>
     * 
     * @param failedDeviceCount
     *            new value of {@code failedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedDeviceCount} field changed
     */
    public UserAppInstallStatus withFailedDeviceCount(Integer failedDeviceCount) {
        UserAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("failedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAppInstallStatus");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    /**
     * <i>“Not installed device count.”</i>
     * 
     * @return property notInstalledDeviceCount
     */
    @Property(name="notInstalledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotInstalledDeviceCount() {
        return Optional.ofNullable(notInstalledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notInstalledDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Not installed device count.”</i>
     * 
     * @param notInstalledDeviceCount
     *            new value of {@code notInstalledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notInstalledDeviceCount} field changed
     */
    public UserAppInstallStatus withNotInstalledDeviceCount(Integer notInstalledDeviceCount) {
        UserAppInstallStatus _x = _copy();
        _x.changedFields = changedFields.add("notInstalledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAppInstallStatus");
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        return _x;
    }

    /**
     * <i>“The navigation link to the mobile app.”</i>
     * 
     * @return navigational property app
     */
    @NavigationProperty(name="app")
    @JsonIgnore
    public MobileAppRequest getApp() {
        return new MobileAppRequest(contextPath.addSegment("app"));
    }

    /**
     * <i>“The install state of the app on devices.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public MobileAppInstallStatusCollectionRequest getDeviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAppInstallStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserAppInstallStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAppInstallStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserAppInstallStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserAppInstallStatus _copy() {
        UserAppInstallStatus _x = new UserAppInstallStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userName = userName;
        _x.userPrincipalName = userPrincipalName;
        _x.installedDeviceCount = installedDeviceCount;
        _x.failedDeviceCount = failedDeviceCount;
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAppInstallStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("installedDeviceCount=");
        b.append(this.installedDeviceCount);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append(", ");
        b.append("notInstalledDeviceCount=");
        b.append(this.notInstalledDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
