package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.complex.VisualInfo;
import odata.msgraph.client.beta.entity.collection.request.ActivityHistoryItemCollectionRequest;
import odata.msgraph.client.beta.enums.Status;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "visualElements", 
    "activitySourceHost", 
    "activationUrl", 
    "appActivityId", 
    "appDisplayName", 
    "contentUrl", 
    "createdDateTime", 
    "expirationDateTime", 
    "fallbackUrl", 
    "lastModifiedDateTime", 
    "userTimezone", 
    "contentInfo", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class UserActivity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userActivity";
    }

    @JsonProperty("visualElements")
    protected VisualInfo visualElements;

    @JsonProperty("activitySourceHost")
    protected String activitySourceHost;

    @JsonProperty("activationUrl")
    protected String activationUrl;

    @JsonProperty("appActivityId")
    protected String appActivityId;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("contentUrl")
    protected String contentUrl;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("fallbackUrl")
    protected String fallbackUrl;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("userTimezone")
    protected String userTimezone;

    @JsonProperty("contentInfo")
    protected Json contentInfo;

    @JsonProperty("status")
    protected Status status;

    protected UserActivity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserActivity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private VisualInfo visualElements;
        private String activitySourceHost;
        private String activationUrl;
        private String appActivityId;
        private String appDisplayName;
        private String contentUrl;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime expirationDateTime;
        private String fallbackUrl;
        private OffsetDateTime lastModifiedDateTime;
        private String userTimezone;
        private Json contentInfo;
        private Status status;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder visualElements(VisualInfo visualElements) {
            this.visualElements = visualElements;
            this.changedFields = changedFields.add("visualElements");
            return this;
        }

        public Builder activitySourceHost(String activitySourceHost) {
            this.activitySourceHost = activitySourceHost;
            this.changedFields = changedFields.add("activitySourceHost");
            return this;
        }

        public Builder activationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
            this.changedFields = changedFields.add("activationUrl");
            return this;
        }

        public Builder appActivityId(String appActivityId) {
            this.appActivityId = appActivityId;
            this.changedFields = changedFields.add("appActivityId");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.changedFields = changedFields.add("contentUrl");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder fallbackUrl(String fallbackUrl) {
            this.fallbackUrl = fallbackUrl;
            this.changedFields = changedFields.add("fallbackUrl");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder userTimezone(String userTimezone) {
            this.userTimezone = userTimezone;
            this.changedFields = changedFields.add("userTimezone");
            return this;
        }

        public Builder contentInfo(Json contentInfo) {
            this.contentInfo = contentInfo;
            this.changedFields = changedFields.add("contentInfo");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public UserActivity build() {
            UserActivity _x = new UserActivity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userActivity";
            _x.id = id;
            _x.visualElements = visualElements;
            _x.activitySourceHost = activitySourceHost;
            _x.activationUrl = activationUrl;
            _x.appActivityId = appActivityId;
            _x.appDisplayName = appDisplayName;
            _x.contentUrl = contentUrl;
            _x.createdDateTime = createdDateTime;
            _x.expirationDateTime = expirationDateTime;
            _x.fallbackUrl = fallbackUrl;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.userTimezone = userTimezone;
            _x.contentInfo = contentInfo;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="visualElements")
    @JsonIgnore
    public Optional<VisualInfo> getVisualElements() {
        return Optional.ofNullable(visualElements);
    }

    public UserActivity withVisualElements(VisualInfo visualElements) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("visualElements");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.visualElements = visualElements;
        return _x;
    }

    @Property(name="activitySourceHost")
    @JsonIgnore
    public Optional<String> getActivitySourceHost() {
        return Optional.ofNullable(activitySourceHost);
    }

    public UserActivity withActivitySourceHost(String activitySourceHost) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("activitySourceHost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.activitySourceHost = activitySourceHost;
        return _x;
    }

    @Property(name="activationUrl")
    @JsonIgnore
    public Optional<String> getActivationUrl() {
        return Optional.ofNullable(activationUrl);
    }

    public UserActivity withActivationUrl(String activationUrl) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("activationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.activationUrl = activationUrl;
        return _x;
    }

    @Property(name="appActivityId")
    @JsonIgnore
    public Optional<String> getAppActivityId() {
        return Optional.ofNullable(appActivityId);
    }

    public UserActivity withAppActivityId(String appActivityId) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("appActivityId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.appActivityId = appActivityId;
        return _x;
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public UserActivity withAppDisplayName(String appDisplayName) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="contentUrl")
    @JsonIgnore
    public Optional<String> getContentUrl() {
        return Optional.ofNullable(contentUrl);
    }

    public UserActivity withContentUrl(String contentUrl) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("contentUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.contentUrl = contentUrl;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public UserActivity withCreatedDateTime(OffsetDateTime createdDateTime) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public UserActivity withExpirationDateTime(OffsetDateTime expirationDateTime) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="fallbackUrl")
    @JsonIgnore
    public Optional<String> getFallbackUrl() {
        return Optional.ofNullable(fallbackUrl);
    }

    public UserActivity withFallbackUrl(String fallbackUrl) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("fallbackUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.fallbackUrl = fallbackUrl;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public UserActivity withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="userTimezone")
    @JsonIgnore
    public Optional<String> getUserTimezone() {
        return Optional.ofNullable(userTimezone);
    }

    public UserActivity withUserTimezone(String userTimezone) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("userTimezone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.userTimezone = userTimezone;
        return _x;
    }

    @Property(name="contentInfo")
    @JsonIgnore
    public Optional<Json> getContentInfo() {
        return Optional.ofNullable(contentInfo);
    }

    public UserActivity withContentInfo(Json contentInfo) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("contentInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.contentInfo = contentInfo;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Status> getStatus() {
        return Optional.ofNullable(status);
    }

    public UserActivity withStatus(Status status) {
        UserActivity _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivity");
        _x.status = status;
        return _x;
    }

    @NavigationProperty(name="historyItems")
    @JsonIgnore
    public ActivityHistoryItemCollectionRequest getHistoryItems() {
        return new ActivityHistoryItemCollectionRequest(
                        contextPath.addSegment("historyItems"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserActivity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserActivity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserActivity _copy() {
        UserActivity _x = new UserActivity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.visualElements = visualElements;
        _x.activitySourceHost = activitySourceHost;
        _x.activationUrl = activationUrl;
        _x.appActivityId = appActivityId;
        _x.appDisplayName = appDisplayName;
        _x.contentUrl = contentUrl;
        _x.createdDateTime = createdDateTime;
        _x.expirationDateTime = expirationDateTime;
        _x.fallbackUrl = fallbackUrl;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.userTimezone = userTimezone;
        _x.contentInfo = contentInfo;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserActivity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("visualElements=");
        b.append(this.visualElements);
        b.append(", ");
        b.append("activitySourceHost=");
        b.append(this.activitySourceHost);
        b.append(", ");
        b.append("activationUrl=");
        b.append(this.activationUrl);
        b.append(", ");
        b.append("appActivityId=");
        b.append(this.appActivityId);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("contentUrl=");
        b.append(this.contentUrl);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("fallbackUrl=");
        b.append(this.fallbackUrl);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("userTimezone=");
        b.append(this.userTimezone);
        b.append(", ");
        b.append("contentInfo=");
        b.append(this.contentInfo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
