package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.LocaleInfo;
import odata.msgraph.client.beta.complex.PersonDataSource;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "ageGroup", 
    "countryCode", 
    "preferredLanguageTag", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class UserAccountInformation extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userAccountInformation";
    }

    @JsonProperty("ageGroup")
    protected String ageGroup;

    @JsonProperty("countryCode")
    protected String countryCode;

    @JsonProperty("preferredLanguageTag")
    protected LocaleInfo preferredLanguageTag;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected UserAccountInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserAccountInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private InferenceData inference;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private PersonDataSource source;
        private String ageGroup;
        private String countryCode;
        private LocaleInfo preferredLanguageTag;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder source(PersonDataSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder ageGroup(String ageGroup) {
            this.ageGroup = ageGroup;
            this.changedFields = changedFields.add("ageGroup");
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.changedFields = changedFields.add("countryCode");
            return this;
        }

        public Builder preferredLanguageTag(LocaleInfo preferredLanguageTag) {
            this.preferredLanguageTag = preferredLanguageTag;
            this.changedFields = changedFields.add("preferredLanguageTag");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public UserAccountInformation build() {
            UserAccountInformation _x = new UserAccountInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userAccountInformation";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.inference = inference;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.source = source;
            _x.ageGroup = ageGroup;
            _x.countryCode = countryCode;
            _x.preferredLanguageTag = preferredLanguageTag;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="ageGroup")
    @JsonIgnore
    public Optional<String> getAgeGroup() {
        return Optional.ofNullable(ageGroup);
    }

    public UserAccountInformation withAgeGroup(String ageGroup) {
        UserAccountInformation _x = _copy();
        _x.changedFields = changedFields.add("ageGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccountInformation");
        _x.ageGroup = ageGroup;
        return _x;
    }

    @Property(name="countryCode")
    @JsonIgnore
    public Optional<String> getCountryCode() {
        return Optional.ofNullable(countryCode);
    }

    public UserAccountInformation withCountryCode(String countryCode) {
        UserAccountInformation _x = _copy();
        _x.changedFields = changedFields.add("countryCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccountInformation");
        _x.countryCode = countryCode;
        return _x;
    }

    @Property(name="preferredLanguageTag")
    @JsonIgnore
    public Optional<LocaleInfo> getPreferredLanguageTag() {
        return Optional.ofNullable(preferredLanguageTag);
    }

    public UserAccountInformation withPreferredLanguageTag(LocaleInfo preferredLanguageTag) {
        UserAccountInformation _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguageTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccountInformation");
        _x.preferredLanguageTag = preferredLanguageTag;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public UserAccountInformation withUserPrincipalName(String userPrincipalName) {
        UserAccountInformation _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userAccountInformation");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAccountInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserAccountInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserAccountInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserAccountInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserAccountInformation _copy() {
        UserAccountInformation _x = new UserAccountInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.inference = inference;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.source = source;
        _x.ageGroup = ageGroup;
        _x.countryCode = countryCode;
        _x.preferredLanguageTag = preferredLanguageTag;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserAccountInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("ageGroup=");
        b.append(this.ageGroup);
        b.append(", ");
        b.append("countryCode=");
        b.append(this.countryCode);
        b.append(", ");
        b.append("preferredLanguageTag=");
        b.append(this.preferredLanguageTag);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
