package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.AssignedPlan;
import odata.msgraph.client.beta.complex.AttendeeBase;
import odata.msgraph.client.beta.complex.ConvertIdResult;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementData;
import odata.msgraph.client.beta.complex.DeviceKey;
import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.complex.LicenseAssignmentState;
import odata.msgraph.client.beta.complex.LocationConstraint;
import odata.msgraph.client.beta.complex.MailTips;
import odata.msgraph.client.beta.complex.MailboxSettings;
import odata.msgraph.client.beta.complex.ManagedAppDiagnosticStatus;
import odata.msgraph.client.beta.complex.ManagedDeviceSummarizedAppState;
import odata.msgraph.client.beta.complex.MeetingTimeSuggestionsResult;
import odata.msgraph.client.beta.complex.ObjectIdentity;
import odata.msgraph.client.beta.complex.OnPremisesExtensionAttributes;
import odata.msgraph.client.beta.complex.OnPremisesProvisioningError;
import odata.msgraph.client.beta.complex.PasswordProfile;
import odata.msgraph.client.beta.complex.ProvisionedPlan;
import odata.msgraph.client.beta.complex.Reminder;
import odata.msgraph.client.beta.complex.SignInActivity;
import odata.msgraph.client.beta.complex.TimeConstraint;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppConsentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CalendarGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppIntentAndStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.request.AuthenticationRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.InferenceClassificationRequest;
import odata.msgraph.client.beta.entity.request.InformationProtectionRequest;
import odata.msgraph.client.beta.entity.request.OfficeGraphInsightsRequest;
import odata.msgraph.client.beta.entity.request.OnenoteRequest;
import odata.msgraph.client.beta.entity.request.OutlookUserRequest;
import odata.msgraph.client.beta.entity.request.PlannerUserRequest;
import odata.msgraph.client.beta.entity.request.PresenceRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ProfileRequest;
import odata.msgraph.client.beta.entity.request.UserAnalyticsRequest;
import odata.msgraph.client.beta.entity.request.UserSettingsRequest;
import odata.msgraph.client.beta.entity.request.UserTeamworkRequest;
import odata.msgraph.client.beta.enums.ExchangeIdFormat;
import odata.msgraph.client.beta.enums.MailTipsType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Represents an Azure Active Directory user object.”</i>
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "signInActivity", 
    "accountEnabled", 
    "ageGroup", 
    "assignedLicenses", 
    "assignedPlans", 
    "businessPhones", 
    "city", 
    "companyName", 
    "consentProvidedForMinor", 
    "country", 
    "createdDateTime", 
    "creationType", 
    "department", 
    "deviceKeys", 
    "displayName", 
    "employeeId", 
    "faxNumber", 
    "givenName", 
    "identities", 
    "imAddresses", 
    "infoCatalogs", 
    "isResourceAccount", 
    "jobTitle", 
    "lastPasswordChangeDateTime", 
    "legalAgeGroupClassification", 
    "licenseAssignmentStates", 
    "mail", 
    "mailNickname", 
    "mobilePhone", 
    "onPremisesDistinguishedName", 
    "onPremisesExtensionAttributes", 
    "onPremisesImmutableId", 
    "onPremisesLastSyncDateTime", 
    "onPremisesProvisioningErrors", 
    "onPremisesSecurityIdentifier", 
    "onPremisesSyncEnabled", 
    "onPremisesDomainName", 
    "onPremisesSamAccountName", 
    "onPremisesUserPrincipalName", 
    "otherMails", 
    "passwordPolicies", 
    "passwordProfile", 
    "officeLocation", 
    "postalCode", 
    "preferredDataLocation", 
    "preferredLanguage", 
    "provisionedPlans", 
    "proxyAddresses", 
    "refreshTokensValidFromDateTime", 
    "showInAddressList", 
    "signInSessionsValidFromDateTime", 
    "state", 
    "streetAddress", 
    "surname", 
    "usageLocation", 
    "userPrincipalName", 
    "externalUserState", 
    "externalUserStateChangeDateTime", 
    "userType", 
    "mailboxSettings", 
    "deviceEnrollmentLimit", 
    "aboutMe", 
    "birthday", 
    "hireDate", 
    "interests", 
    "mySite", 
    "pastProjects", 
    "preferredName", 
    "responsibilities", 
    "schools", 
    "skills"})
@JsonInclude(Include.NON_NULL)
public class User extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.user";
    }

    @JsonProperty("signInActivity")
    protected SignInActivity signInActivity;

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("ageGroup")
    protected String ageGroup;

    @JsonProperty("assignedLicenses")
    protected List<AssignedLicense> assignedLicenses;

    @JsonProperty("assignedLicenses@nextLink")
    protected String assignedLicensesNextLink;

    @JsonProperty("assignedPlans")
    protected List<AssignedPlan> assignedPlans;

    @JsonProperty("assignedPlans@nextLink")
    protected String assignedPlansNextLink;

    @JsonProperty("businessPhones")
    protected List<String> businessPhones;

    @JsonProperty("businessPhones@nextLink")
    protected String businessPhonesNextLink;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("companyName")
    protected String companyName;

    @JsonProperty("consentProvidedForMinor")
    protected String consentProvidedForMinor;

    @JsonProperty("country")
    protected String country;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creationType")
    protected String creationType;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("deviceKeys")
    protected List<DeviceKey> deviceKeys;

    @JsonProperty("deviceKeys@nextLink")
    protected String deviceKeysNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("employeeId")
    protected String employeeId;

    @JsonProperty("faxNumber")
    protected String faxNumber;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("identities")
    protected List<ObjectIdentity> identities;

    @JsonProperty("identities@nextLink")
    protected String identitiesNextLink;

    @JsonProperty("imAddresses")
    protected List<String> imAddresses;

    @JsonProperty("imAddresses@nextLink")
    protected String imAddressesNextLink;

    @JsonProperty("infoCatalogs")
    protected List<String> infoCatalogs;

    @JsonProperty("infoCatalogs@nextLink")
    protected String infoCatalogsNextLink;

    @JsonProperty("isResourceAccount")
    protected Boolean isResourceAccount;

    @JsonProperty("jobTitle")
    protected String jobTitle;

    @JsonProperty("lastPasswordChangeDateTime")
    protected OffsetDateTime lastPasswordChangeDateTime;

    @JsonProperty("legalAgeGroupClassification")
    protected String legalAgeGroupClassification;

    @JsonProperty("licenseAssignmentStates")
    protected List<LicenseAssignmentState> licenseAssignmentStates;

    @JsonProperty("licenseAssignmentStates@nextLink")
    protected String licenseAssignmentStatesNextLink;

    @JsonProperty("mail")
    protected String mail;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("mobilePhone")
    protected String mobilePhone;

    @JsonProperty("onPremisesDistinguishedName")
    protected String onPremisesDistinguishedName;

    @JsonProperty("onPremisesExtensionAttributes")
    protected OnPremisesExtensionAttributes onPremisesExtensionAttributes;

    @JsonProperty("onPremisesImmutableId")
    protected String onPremisesImmutableId;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesProvisioningErrors")
    protected List<OnPremisesProvisioningError> onPremisesProvisioningErrors;

    @JsonProperty("onPremisesProvisioningErrors@nextLink")
    protected String onPremisesProvisioningErrorsNextLink;

    @JsonProperty("onPremisesSecurityIdentifier")
    protected String onPremisesSecurityIdentifier;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("onPremisesDomainName")
    protected String onPremisesDomainName;

    @JsonProperty("onPremisesSamAccountName")
    protected String onPremisesSamAccountName;

    @JsonProperty("onPremisesUserPrincipalName")
    protected String onPremisesUserPrincipalName;

    @JsonProperty("otherMails")
    protected List<String> otherMails;

    @JsonProperty("otherMails@nextLink")
    protected String otherMailsNextLink;

    @JsonProperty("passwordPolicies")
    protected String passwordPolicies;

    @JsonProperty("passwordProfile")
    protected PasswordProfile passwordProfile;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("preferredDataLocation")
    protected String preferredDataLocation;

    @JsonProperty("preferredLanguage")
    protected String preferredLanguage;

    @JsonProperty("provisionedPlans")
    protected List<ProvisionedPlan> provisionedPlans;

    @JsonProperty("provisionedPlans@nextLink")
    protected String provisionedPlansNextLink;

    @JsonProperty("proxyAddresses")
    protected List<String> proxyAddresses;

    @JsonProperty("proxyAddresses@nextLink")
    protected String proxyAddressesNextLink;

    @JsonProperty("refreshTokensValidFromDateTime")
    protected OffsetDateTime refreshTokensValidFromDateTime;

    @JsonProperty("showInAddressList")
    protected Boolean showInAddressList;

    @JsonProperty("signInSessionsValidFromDateTime")
    protected OffsetDateTime signInSessionsValidFromDateTime;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("streetAddress")
    protected String streetAddress;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("usageLocation")
    protected String usageLocation;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("externalUserState")
    protected String externalUserState;

    @JsonProperty("externalUserStateChangeDateTime")
    protected String externalUserStateChangeDateTime;

    @JsonProperty("userType")
    protected String userType;

    @JsonProperty("mailboxSettings")
    protected MailboxSettings mailboxSettings;

    @JsonProperty("deviceEnrollmentLimit")
    protected Integer deviceEnrollmentLimit;

    @JsonProperty("aboutMe")
    protected String aboutMe;

    @JsonProperty("birthday")
    protected OffsetDateTime birthday;

    @JsonProperty("hireDate")
    protected OffsetDateTime hireDate;

    @JsonProperty("interests")
    protected List<String> interests;

    @JsonProperty("interests@nextLink")
    protected String interestsNextLink;

    @JsonProperty("mySite")
    protected String mySite;

    @JsonProperty("pastProjects")
    protected List<String> pastProjects;

    @JsonProperty("pastProjects@nextLink")
    protected String pastProjectsNextLink;

    @JsonProperty("preferredName")
    protected String preferredName;

    @JsonProperty("responsibilities")
    protected List<String> responsibilities;

    @JsonProperty("responsibilities@nextLink")
    protected String responsibilitiesNextLink;

    @JsonProperty("schools")
    protected List<String> schools;

    @JsonProperty("schools@nextLink")
    protected String schoolsNextLink;

    @JsonProperty("skills")
    protected List<String> skills;

    @JsonProperty("skills@nextLink")
    protected String skillsNextLink;

    protected User() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private SignInActivity signInActivity;
        private Boolean accountEnabled;
        private String ageGroup;
        private List<AssignedLicense> assignedLicenses;
        private String assignedLicensesNextLink;
        private List<AssignedPlan> assignedPlans;
        private String assignedPlansNextLink;
        private List<String> businessPhones;
        private String businessPhonesNextLink;
        private String city;
        private String companyName;
        private String consentProvidedForMinor;
        private String country;
        private OffsetDateTime createdDateTime;
        private String creationType;
        private String department;
        private List<DeviceKey> deviceKeys;
        private String deviceKeysNextLink;
        private String displayName;
        private String employeeId;
        private String faxNumber;
        private String givenName;
        private List<ObjectIdentity> identities;
        private String identitiesNextLink;
        private List<String> imAddresses;
        private String imAddressesNextLink;
        private List<String> infoCatalogs;
        private String infoCatalogsNextLink;
        private Boolean isResourceAccount;
        private String jobTitle;
        private OffsetDateTime lastPasswordChangeDateTime;
        private String legalAgeGroupClassification;
        private List<LicenseAssignmentState> licenseAssignmentStates;
        private String licenseAssignmentStatesNextLink;
        private String mail;
        private String mailNickname;
        private String mobilePhone;
        private String onPremisesDistinguishedName;
        private OnPremisesExtensionAttributes onPremisesExtensionAttributes;
        private String onPremisesImmutableId;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private List<OnPremisesProvisioningError> onPremisesProvisioningErrors;
        private String onPremisesProvisioningErrorsNextLink;
        private String onPremisesSecurityIdentifier;
        private Boolean onPremisesSyncEnabled;
        private String onPremisesDomainName;
        private String onPremisesSamAccountName;
        private String onPremisesUserPrincipalName;
        private List<String> otherMails;
        private String otherMailsNextLink;
        private String passwordPolicies;
        private PasswordProfile passwordProfile;
        private String officeLocation;
        private String postalCode;
        private String preferredDataLocation;
        private String preferredLanguage;
        private List<ProvisionedPlan> provisionedPlans;
        private String provisionedPlansNextLink;
        private List<String> proxyAddresses;
        private String proxyAddressesNextLink;
        private OffsetDateTime refreshTokensValidFromDateTime;
        private Boolean showInAddressList;
        private OffsetDateTime signInSessionsValidFromDateTime;
        private String state;
        private String streetAddress;
        private String surname;
        private String usageLocation;
        private String userPrincipalName;
        private String externalUserState;
        private String externalUserStateChangeDateTime;
        private String userType;
        private MailboxSettings mailboxSettings;
        private Integer deviceEnrollmentLimit;
        private String aboutMe;
        private OffsetDateTime birthday;
        private OffsetDateTime hireDate;
        private List<String> interests;
        private String interestsNextLink;
        private String mySite;
        private List<String> pastProjects;
        private String pastProjectsNextLink;
        private String preferredName;
        private List<String> responsibilities;
        private String responsibilitiesNextLink;
        private List<String> schools;
        private String schoolsNextLink;
        private List<String> skills;
        private String skillsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder signInActivity(SignInActivity signInActivity) {
            this.signInActivity = signInActivity;
            this.changedFields = changedFields.add("signInActivity");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder ageGroup(String ageGroup) {
            this.ageGroup = ageGroup;
            this.changedFields = changedFields.add("ageGroup");
            return this;
        }

        public Builder assignedLicenses(List<AssignedLicense> assignedLicenses) {
            this.assignedLicenses = assignedLicenses;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedLicenses(AssignedLicense... assignedLicenses) {
            return assignedLicenses(Arrays.asList(assignedLicenses));
        }

        public Builder assignedLicensesNextLink(String assignedLicensesNextLink) {
            this.assignedLicensesNextLink = assignedLicensesNextLink;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedPlans(List<AssignedPlan> assignedPlans) {
            this.assignedPlans = assignedPlans;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder assignedPlans(AssignedPlan... assignedPlans) {
            return assignedPlans(Arrays.asList(assignedPlans));
        }

        public Builder assignedPlansNextLink(String assignedPlansNextLink) {
            this.assignedPlansNextLink = assignedPlansNextLink;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder businessPhones(List<String> businessPhones) {
            this.businessPhones = businessPhones;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder businessPhones(String... businessPhones) {
            return businessPhones(Arrays.asList(businessPhones));
        }

        public Builder businessPhonesNextLink(String businessPhonesNextLink) {
            this.businessPhonesNextLink = businessPhonesNextLink;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.changedFields = changedFields.add("companyName");
            return this;
        }

        public Builder consentProvidedForMinor(String consentProvidedForMinor) {
            this.consentProvidedForMinor = consentProvidedForMinor;
            this.changedFields = changedFields.add("consentProvidedForMinor");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.changedFields = changedFields.add("country");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder creationType(String creationType) {
            this.creationType = creationType;
            this.changedFields = changedFields.add("creationType");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder deviceKeys(List<DeviceKey> deviceKeys) {
            this.deviceKeys = deviceKeys;
            this.changedFields = changedFields.add("deviceKeys");
            return this;
        }

        public Builder deviceKeys(DeviceKey... deviceKeys) {
            return deviceKeys(Arrays.asList(deviceKeys));
        }

        public Builder deviceKeysNextLink(String deviceKeysNextLink) {
            this.deviceKeysNextLink = deviceKeysNextLink;
            this.changedFields = changedFields.add("deviceKeys");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            this.changedFields = changedFields.add("employeeId");
            return this;
        }

        public Builder faxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
            this.changedFields = changedFields.add("faxNumber");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder identities(List<ObjectIdentity> identities) {
            this.identities = identities;
            this.changedFields = changedFields.add("identities");
            return this;
        }

        public Builder identities(ObjectIdentity... identities) {
            return identities(Arrays.asList(identities));
        }

        public Builder identitiesNextLink(String identitiesNextLink) {
            this.identitiesNextLink = identitiesNextLink;
            this.changedFields = changedFields.add("identities");
            return this;
        }

        public Builder imAddresses(List<String> imAddresses) {
            this.imAddresses = imAddresses;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder imAddresses(String... imAddresses) {
            return imAddresses(Arrays.asList(imAddresses));
        }

        public Builder imAddressesNextLink(String imAddressesNextLink) {
            this.imAddressesNextLink = imAddressesNextLink;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder infoCatalogs(List<String> infoCatalogs) {
            this.infoCatalogs = infoCatalogs;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder infoCatalogs(String... infoCatalogs) {
            return infoCatalogs(Arrays.asList(infoCatalogs));
        }

        public Builder infoCatalogsNextLink(String infoCatalogsNextLink) {
            this.infoCatalogsNextLink = infoCatalogsNextLink;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder isResourceAccount(Boolean isResourceAccount) {
            this.isResourceAccount = isResourceAccount;
            this.changedFields = changedFields.add("isResourceAccount");
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.changedFields = changedFields.add("jobTitle");
            return this;
        }

        public Builder lastPasswordChangeDateTime(OffsetDateTime lastPasswordChangeDateTime) {
            this.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
            this.changedFields = changedFields.add("lastPasswordChangeDateTime");
            return this;
        }

        public Builder legalAgeGroupClassification(String legalAgeGroupClassification) {
            this.legalAgeGroupClassification = legalAgeGroupClassification;
            this.changedFields = changedFields.add("legalAgeGroupClassification");
            return this;
        }

        public Builder licenseAssignmentStates(List<LicenseAssignmentState> licenseAssignmentStates) {
            this.licenseAssignmentStates = licenseAssignmentStates;
            this.changedFields = changedFields.add("licenseAssignmentStates");
            return this;
        }

        public Builder licenseAssignmentStates(LicenseAssignmentState... licenseAssignmentStates) {
            return licenseAssignmentStates(Arrays.asList(licenseAssignmentStates));
        }

        public Builder licenseAssignmentStatesNextLink(String licenseAssignmentStatesNextLink) {
            this.licenseAssignmentStatesNextLink = licenseAssignmentStatesNextLink;
            this.changedFields = changedFields.add("licenseAssignmentStates");
            return this;
        }

        public Builder mail(String mail) {
            this.mail = mail;
            this.changedFields = changedFields.add("mail");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
            this.changedFields = changedFields.add("mobilePhone");
            return this;
        }

        public Builder onPremisesDistinguishedName(String onPremisesDistinguishedName) {
            this.onPremisesDistinguishedName = onPremisesDistinguishedName;
            this.changedFields = changedFields.add("onPremisesDistinguishedName");
            return this;
        }

        public Builder onPremisesExtensionAttributes(OnPremisesExtensionAttributes onPremisesExtensionAttributes) {
            this.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
            this.changedFields = changedFields.add("onPremisesExtensionAttributes");
            return this;
        }

        public Builder onPremisesImmutableId(String onPremisesImmutableId) {
            this.onPremisesImmutableId = onPremisesImmutableId;
            this.changedFields = changedFields.add("onPremisesImmutableId");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesProvisioningErrors(List<OnPremisesProvisioningError> onPremisesProvisioningErrors) {
            this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesProvisioningErrors(OnPremisesProvisioningError... onPremisesProvisioningErrors) {
            return onPremisesProvisioningErrors(Arrays.asList(onPremisesProvisioningErrors));
        }

        public Builder onPremisesProvisioningErrorsNextLink(String onPremisesProvisioningErrorsNextLink) {
            this.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
            this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            this.changedFields = changedFields.add("onPremisesSecurityIdentifier");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder onPremisesDomainName(String onPremisesDomainName) {
            this.onPremisesDomainName = onPremisesDomainName;
            this.changedFields = changedFields.add("onPremisesDomainName");
            return this;
        }

        public Builder onPremisesSamAccountName(String onPremisesSamAccountName) {
            this.onPremisesSamAccountName = onPremisesSamAccountName;
            this.changedFields = changedFields.add("onPremisesSamAccountName");
            return this;
        }

        public Builder onPremisesUserPrincipalName(String onPremisesUserPrincipalName) {
            this.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
            this.changedFields = changedFields.add("onPremisesUserPrincipalName");
            return this;
        }

        public Builder otherMails(List<String> otherMails) {
            this.otherMails = otherMails;
            this.changedFields = changedFields.add("otherMails");
            return this;
        }

        public Builder otherMails(String... otherMails) {
            return otherMails(Arrays.asList(otherMails));
        }

        public Builder otherMailsNextLink(String otherMailsNextLink) {
            this.otherMailsNextLink = otherMailsNextLink;
            this.changedFields = changedFields.add("otherMails");
            return this;
        }

        public Builder passwordPolicies(String passwordPolicies) {
            this.passwordPolicies = passwordPolicies;
            this.changedFields = changedFields.add("passwordPolicies");
            return this;
        }

        public Builder passwordProfile(PasswordProfile passwordProfile) {
            this.passwordProfile = passwordProfile;
            this.changedFields = changedFields.add("passwordProfile");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder preferredDataLocation(String preferredDataLocation) {
            this.preferredDataLocation = preferredDataLocation;
            this.changedFields = changedFields.add("preferredDataLocation");
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            this.changedFields = changedFields.add("preferredLanguage");
            return this;
        }

        public Builder provisionedPlans(List<ProvisionedPlan> provisionedPlans) {
            this.provisionedPlans = provisionedPlans;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder provisionedPlans(ProvisionedPlan... provisionedPlans) {
            return provisionedPlans(Arrays.asList(provisionedPlans));
        }

        public Builder provisionedPlansNextLink(String provisionedPlansNextLink) {
            this.provisionedPlansNextLink = provisionedPlansNextLink;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder proxyAddresses(List<String> proxyAddresses) {
            this.proxyAddresses = proxyAddresses;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder proxyAddresses(String... proxyAddresses) {
            return proxyAddresses(Arrays.asList(proxyAddresses));
        }

        public Builder proxyAddressesNextLink(String proxyAddressesNextLink) {
            this.proxyAddressesNextLink = proxyAddressesNextLink;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder refreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
            this.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            this.changedFields = changedFields.add("refreshTokensValidFromDateTime");
            return this;
        }

        public Builder showInAddressList(Boolean showInAddressList) {
            this.showInAddressList = showInAddressList;
            this.changedFields = changedFields.add("showInAddressList");
            return this;
        }

        public Builder signInSessionsValidFromDateTime(OffsetDateTime signInSessionsValidFromDateTime) {
            this.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
            this.changedFields = changedFields.add("signInSessionsValidFromDateTime");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            this.changedFields = changedFields.add("streetAddress");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder usageLocation(String usageLocation) {
            this.usageLocation = usageLocation;
            this.changedFields = changedFields.add("usageLocation");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder externalUserState(String externalUserState) {
            this.externalUserState = externalUserState;
            this.changedFields = changedFields.add("externalUserState");
            return this;
        }

        public Builder externalUserStateChangeDateTime(String externalUserStateChangeDateTime) {
            this.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
            this.changedFields = changedFields.add("externalUserStateChangeDateTime");
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("userType");
            return this;
        }

        public Builder mailboxSettings(MailboxSettings mailboxSettings) {
            this.mailboxSettings = mailboxSettings;
            this.changedFields = changedFields.add("mailboxSettings");
            return this;
        }

        /**
         * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
         * Allowed values are 5 or 1000.”</i>
         * 
         * @param deviceEnrollmentLimit
         *            value of {@code deviceEnrollmentLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceEnrollmentLimit(Integer deviceEnrollmentLimit) {
            this.deviceEnrollmentLimit = deviceEnrollmentLimit;
            this.changedFields = changedFields.add("deviceEnrollmentLimit");
            return this;
        }

        public Builder aboutMe(String aboutMe) {
            this.aboutMe = aboutMe;
            this.changedFields = changedFields.add("aboutMe");
            return this;
        }

        public Builder birthday(OffsetDateTime birthday) {
            this.birthday = birthday;
            this.changedFields = changedFields.add("birthday");
            return this;
        }

        public Builder hireDate(OffsetDateTime hireDate) {
            this.hireDate = hireDate;
            this.changedFields = changedFields.add("hireDate");
            return this;
        }

        public Builder interests(List<String> interests) {
            this.interests = interests;
            this.changedFields = changedFields.add("interests");
            return this;
        }

        public Builder interests(String... interests) {
            return interests(Arrays.asList(interests));
        }

        public Builder interestsNextLink(String interestsNextLink) {
            this.interestsNextLink = interestsNextLink;
            this.changedFields = changedFields.add("interests");
            return this;
        }

        public Builder mySite(String mySite) {
            this.mySite = mySite;
            this.changedFields = changedFields.add("mySite");
            return this;
        }

        public Builder pastProjects(List<String> pastProjects) {
            this.pastProjects = pastProjects;
            this.changedFields = changedFields.add("pastProjects");
            return this;
        }

        public Builder pastProjects(String... pastProjects) {
            return pastProjects(Arrays.asList(pastProjects));
        }

        public Builder pastProjectsNextLink(String pastProjectsNextLink) {
            this.pastProjectsNextLink = pastProjectsNextLink;
            this.changedFields = changedFields.add("pastProjects");
            return this;
        }

        public Builder preferredName(String preferredName) {
            this.preferredName = preferredName;
            this.changedFields = changedFields.add("preferredName");
            return this;
        }

        public Builder responsibilities(List<String> responsibilities) {
            this.responsibilities = responsibilities;
            this.changedFields = changedFields.add("responsibilities");
            return this;
        }

        public Builder responsibilities(String... responsibilities) {
            return responsibilities(Arrays.asList(responsibilities));
        }

        public Builder responsibilitiesNextLink(String responsibilitiesNextLink) {
            this.responsibilitiesNextLink = responsibilitiesNextLink;
            this.changedFields = changedFields.add("responsibilities");
            return this;
        }

        public Builder schools(List<String> schools) {
            this.schools = schools;
            this.changedFields = changedFields.add("schools");
            return this;
        }

        public Builder schools(String... schools) {
            return schools(Arrays.asList(schools));
        }

        public Builder schoolsNextLink(String schoolsNextLink) {
            this.schoolsNextLink = schoolsNextLink;
            this.changedFields = changedFields.add("schools");
            return this;
        }

        public Builder skills(List<String> skills) {
            this.skills = skills;
            this.changedFields = changedFields.add("skills");
            return this;
        }

        public Builder skills(String... skills) {
            return skills(Arrays.asList(skills));
        }

        public Builder skillsNextLink(String skillsNextLink) {
            this.skillsNextLink = skillsNextLink;
            this.changedFields = changedFields.add("skills");
            return this;
        }

        public User build() {
            User _x = new User();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.user";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.signInActivity = signInActivity;
            _x.accountEnabled = accountEnabled;
            _x.ageGroup = ageGroup;
            _x.assignedLicenses = assignedLicenses;
            _x.assignedLicensesNextLink = assignedLicensesNextLink;
            _x.assignedPlans = assignedPlans;
            _x.assignedPlansNextLink = assignedPlansNextLink;
            _x.businessPhones = businessPhones;
            _x.businessPhonesNextLink = businessPhonesNextLink;
            _x.city = city;
            _x.companyName = companyName;
            _x.consentProvidedForMinor = consentProvidedForMinor;
            _x.country = country;
            _x.createdDateTime = createdDateTime;
            _x.creationType = creationType;
            _x.department = department;
            _x.deviceKeys = deviceKeys;
            _x.deviceKeysNextLink = deviceKeysNextLink;
            _x.displayName = displayName;
            _x.employeeId = employeeId;
            _x.faxNumber = faxNumber;
            _x.givenName = givenName;
            _x.identities = identities;
            _x.identitiesNextLink = identitiesNextLink;
            _x.imAddresses = imAddresses;
            _x.imAddressesNextLink = imAddressesNextLink;
            _x.infoCatalogs = infoCatalogs;
            _x.infoCatalogsNextLink = infoCatalogsNextLink;
            _x.isResourceAccount = isResourceAccount;
            _x.jobTitle = jobTitle;
            _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
            _x.legalAgeGroupClassification = legalAgeGroupClassification;
            _x.licenseAssignmentStates = licenseAssignmentStates;
            _x.licenseAssignmentStatesNextLink = licenseAssignmentStatesNextLink;
            _x.mail = mail;
            _x.mailNickname = mailNickname;
            _x.mobilePhone = mobilePhone;
            _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
            _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
            _x.onPremisesImmutableId = onPremisesImmutableId;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            _x.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.onPremisesDomainName = onPremisesDomainName;
            _x.onPremisesSamAccountName = onPremisesSamAccountName;
            _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
            _x.otherMails = otherMails;
            _x.otherMailsNextLink = otherMailsNextLink;
            _x.passwordPolicies = passwordPolicies;
            _x.passwordProfile = passwordProfile;
            _x.officeLocation = officeLocation;
            _x.postalCode = postalCode;
            _x.preferredDataLocation = preferredDataLocation;
            _x.preferredLanguage = preferredLanguage;
            _x.provisionedPlans = provisionedPlans;
            _x.provisionedPlansNextLink = provisionedPlansNextLink;
            _x.proxyAddresses = proxyAddresses;
            _x.proxyAddressesNextLink = proxyAddressesNextLink;
            _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            _x.showInAddressList = showInAddressList;
            _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
            _x.state = state;
            _x.streetAddress = streetAddress;
            _x.surname = surname;
            _x.usageLocation = usageLocation;
            _x.userPrincipalName = userPrincipalName;
            _x.externalUserState = externalUserState;
            _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
            _x.userType = userType;
            _x.mailboxSettings = mailboxSettings;
            _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
            _x.aboutMe = aboutMe;
            _x.birthday = birthday;
            _x.hireDate = hireDate;
            _x.interests = interests;
            _x.interestsNextLink = interestsNextLink;
            _x.mySite = mySite;
            _x.pastProjects = pastProjects;
            _x.pastProjectsNextLink = pastProjectsNextLink;
            _x.preferredName = preferredName;
            _x.responsibilities = responsibilities;
            _x.responsibilitiesNextLink = responsibilitiesNextLink;
            _x.schools = schools;
            _x.schoolsNextLink = schoolsNextLink;
            _x.skills = skills;
            _x.skillsNextLink = skillsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="signInActivity")
    @JsonIgnore
    public Optional<SignInActivity> getSignInActivity() {
        return Optional.ofNullable(signInActivity);
    }

    public User withSignInActivity(SignInActivity signInActivity) {
        User _x = _copy();
        _x.changedFields = changedFields.add("signInActivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.signInActivity = signInActivity;
        return _x;
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public User withAccountEnabled(Boolean accountEnabled) {
        User _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="ageGroup")
    @JsonIgnore
    public Optional<String> getAgeGroup() {
        return Optional.ofNullable(ageGroup);
    }

    public User withAgeGroup(String ageGroup) {
        User _x = _copy();
        _x.changedFields = changedFields.add("ageGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.ageGroup = ageGroup;
        return _x;
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses() {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses(HttpRequestOptions options) {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans() {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans(HttpRequestOptions options) {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones() {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public User withCity(String city) {
        User _x = _copy();
        _x.changedFields = changedFields.add("city");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.city = city;
        return _x;
    }

    @Property(name="companyName")
    @JsonIgnore
    public Optional<String> getCompanyName() {
        return Optional.ofNullable(companyName);
    }

    public User withCompanyName(String companyName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("companyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.companyName = companyName;
        return _x;
    }

    @Property(name="consentProvidedForMinor")
    @JsonIgnore
    public Optional<String> getConsentProvidedForMinor() {
        return Optional.ofNullable(consentProvidedForMinor);
    }

    public User withConsentProvidedForMinor(String consentProvidedForMinor) {
        User _x = _copy();
        _x.changedFields = changedFields.add("consentProvidedForMinor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.consentProvidedForMinor = consentProvidedForMinor;
        return _x;
    }

    @Property(name="country")
    @JsonIgnore
    public Optional<String> getCountry() {
        return Optional.ofNullable(country);
    }

    public User withCountry(String country) {
        User _x = _copy();
        _x.changedFields = changedFields.add("country");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.country = country;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public User withCreatedDateTime(OffsetDateTime createdDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="creationType")
    @JsonIgnore
    public Optional<String> getCreationType() {
        return Optional.ofNullable(creationType);
    }

    public User withCreationType(String creationType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("creationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.creationType = creationType;
        return _x;
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public User withDepartment(String department) {
        User _x = _copy();
        _x.changedFields = changedFields.add("department");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.department = department;
        return _x;
    }

    @Property(name="deviceKeys")
    @JsonIgnore
    public CollectionPage<DeviceKey> getDeviceKeys() {
        return new CollectionPage<DeviceKey>(contextPath, DeviceKey.class, deviceKeys, Optional.ofNullable(deviceKeysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="deviceKeys")
    @JsonIgnore
    public CollectionPage<DeviceKey> getDeviceKeys(HttpRequestOptions options) {
        return new CollectionPage<DeviceKey>(contextPath, DeviceKey.class, deviceKeys, Optional.ofNullable(deviceKeysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public User withDisplayName(String displayName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="employeeId")
    @JsonIgnore
    public Optional<String> getEmployeeId() {
        return Optional.ofNullable(employeeId);
    }

    public User withEmployeeId(String employeeId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("employeeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.employeeId = employeeId;
        return _x;
    }

    @Property(name="faxNumber")
    @JsonIgnore
    public Optional<String> getFaxNumber() {
        return Optional.ofNullable(faxNumber);
    }

    public User withFaxNumber(String faxNumber) {
        User _x = _copy();
        _x.changedFields = changedFields.add("faxNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.faxNumber = faxNumber;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public User withGivenName(String givenName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="identities")
    @JsonIgnore
    public CollectionPage<ObjectIdentity> getIdentities() {
        return new CollectionPage<ObjectIdentity>(contextPath, ObjectIdentity.class, identities, Optional.ofNullable(identitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="identities")
    @JsonIgnore
    public CollectionPage<ObjectIdentity> getIdentities(HttpRequestOptions options) {
        return new CollectionPage<ObjectIdentity>(contextPath, ObjectIdentity.class, identities, Optional.ofNullable(identitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses() {
        return new CollectionPage<String>(contextPath, String.class, imAddresses, Optional.ofNullable(imAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, imAddresses, Optional.ofNullable(imAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs() {
        return new CollectionPage<String>(contextPath, String.class, infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="isResourceAccount")
    @JsonIgnore
    public Optional<Boolean> getIsResourceAccount() {
        return Optional.ofNullable(isResourceAccount);
    }

    public User withIsResourceAccount(Boolean isResourceAccount) {
        User _x = _copy();
        _x.changedFields = changedFields.add("isResourceAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.isResourceAccount = isResourceAccount;
        return _x;
    }

    @Property(name="jobTitle")
    @JsonIgnore
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    public User withJobTitle(String jobTitle) {
        User _x = _copy();
        _x.changedFields = changedFields.add("jobTitle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.jobTitle = jobTitle;
        return _x;
    }

    @Property(name="lastPasswordChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastPasswordChangeDateTime() {
        return Optional.ofNullable(lastPasswordChangeDateTime);
    }

    public User withLastPasswordChangeDateTime(OffsetDateTime lastPasswordChangeDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("lastPasswordChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
        return _x;
    }

    @Property(name="legalAgeGroupClassification")
    @JsonIgnore
    public Optional<String> getLegalAgeGroupClassification() {
        return Optional.ofNullable(legalAgeGroupClassification);
    }

    public User withLegalAgeGroupClassification(String legalAgeGroupClassification) {
        User _x = _copy();
        _x.changedFields = changedFields.add("legalAgeGroupClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.legalAgeGroupClassification = legalAgeGroupClassification;
        return _x;
    }

    @Property(name="licenseAssignmentStates")
    @JsonIgnore
    public CollectionPage<LicenseAssignmentState> getLicenseAssignmentStates() {
        return new CollectionPage<LicenseAssignmentState>(contextPath, LicenseAssignmentState.class, licenseAssignmentStates, Optional.ofNullable(licenseAssignmentStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="licenseAssignmentStates")
    @JsonIgnore
    public CollectionPage<LicenseAssignmentState> getLicenseAssignmentStates(HttpRequestOptions options) {
        return new CollectionPage<LicenseAssignmentState>(contextPath, LicenseAssignmentState.class, licenseAssignmentStates, Optional.ofNullable(licenseAssignmentStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="mail")
    @JsonIgnore
    public Optional<String> getMail() {
        return Optional.ofNullable(mail);
    }

    public User withMail(String mail) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mail = mail;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public User withMailNickname(String mailNickname) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="mobilePhone")
    @JsonIgnore
    public Optional<String> getMobilePhone() {
        return Optional.ofNullable(mobilePhone);
    }

    public User withMobilePhone(String mobilePhone) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mobilePhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mobilePhone = mobilePhone;
        return _x;
    }

    @Property(name="onPremisesDistinguishedName")
    @JsonIgnore
    public Optional<String> getOnPremisesDistinguishedName() {
        return Optional.ofNullable(onPremisesDistinguishedName);
    }

    public User withOnPremisesDistinguishedName(String onPremisesDistinguishedName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesDistinguishedName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
        return _x;
    }

    @Property(name="onPremisesExtensionAttributes")
    @JsonIgnore
    public Optional<OnPremisesExtensionAttributes> getOnPremisesExtensionAttributes() {
        return Optional.ofNullable(onPremisesExtensionAttributes);
    }

    public User withOnPremisesExtensionAttributes(OnPremisesExtensionAttributes onPremisesExtensionAttributes) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesExtensionAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
        return _x;
    }

    @Property(name="onPremisesImmutableId")
    @JsonIgnore
    public Optional<String> getOnPremisesImmutableId() {
        return Optional.ofNullable(onPremisesImmutableId);
    }

    public User withOnPremisesImmutableId(String onPremisesImmutableId) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesImmutableId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesImmutableId = onPremisesImmutableId;
        return _x;
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public User withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors() {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors(HttpRequestOptions options) {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="onPremisesSecurityIdentifier")
    @JsonIgnore
    public Optional<String> getOnPremisesSecurityIdentifier() {
        return Optional.ofNullable(onPremisesSecurityIdentifier);
    }

    public User withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSecurityIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public User withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="onPremisesDomainName")
    @JsonIgnore
    public Optional<String> getOnPremisesDomainName() {
        return Optional.ofNullable(onPremisesDomainName);
    }

    public User withOnPremisesDomainName(String onPremisesDomainName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesDomainName = onPremisesDomainName;
        return _x;
    }

    @Property(name="onPremisesSamAccountName")
    @JsonIgnore
    public Optional<String> getOnPremisesSamAccountName() {
        return Optional.ofNullable(onPremisesSamAccountName);
    }

    public User withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSamAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        return _x;
    }

    @Property(name="onPremisesUserPrincipalName")
    @JsonIgnore
    public Optional<String> getOnPremisesUserPrincipalName() {
        return Optional.ofNullable(onPremisesUserPrincipalName);
    }

    public User withOnPremisesUserPrincipalName(String onPremisesUserPrincipalName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("onPremisesUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
        return _x;
    }

    @Property(name="otherMails")
    @JsonIgnore
    public CollectionPage<String> getOtherMails() {
        return new CollectionPage<String>(contextPath, String.class, otherMails, Optional.ofNullable(otherMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="otherMails")
    @JsonIgnore
    public CollectionPage<String> getOtherMails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, otherMails, Optional.ofNullable(otherMailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="passwordPolicies")
    @JsonIgnore
    public Optional<String> getPasswordPolicies() {
        return Optional.ofNullable(passwordPolicies);
    }

    public User withPasswordPolicies(String passwordPolicies) {
        User _x = _copy();
        _x.changedFields = changedFields.add("passwordPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.passwordPolicies = passwordPolicies;
        return _x;
    }

    @Property(name="passwordProfile")
    @JsonIgnore
    public Optional<PasswordProfile> getPasswordProfile() {
        return Optional.ofNullable(passwordProfile);
    }

    public User withPasswordProfile(PasswordProfile passwordProfile) {
        User _x = _copy();
        _x.changedFields = changedFields.add("passwordProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.passwordProfile = passwordProfile;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public User withOfficeLocation(String officeLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("officeLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public User withPostalCode(String postalCode) {
        User _x = _copy();
        _x.changedFields = changedFields.add("postalCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="preferredDataLocation")
    @JsonIgnore
    public Optional<String> getPreferredDataLocation() {
        return Optional.ofNullable(preferredDataLocation);
    }

    public User withPreferredDataLocation(String preferredDataLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredDataLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredDataLocation = preferredDataLocation;
        return _x;
    }

    @Property(name="preferredLanguage")
    @JsonIgnore
    public Optional<String> getPreferredLanguage() {
        return Optional.ofNullable(preferredLanguage);
    }

    public User withPreferredLanguage(String preferredLanguage) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredLanguage = preferredLanguage;
        return _x;
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans() {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans(HttpRequestOptions options) {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses() {
        return new CollectionPage<String>(contextPath, String.class, proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="refreshTokensValidFromDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRefreshTokensValidFromDateTime() {
        return Optional.ofNullable(refreshTokensValidFromDateTime);
    }

    public User withRefreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("refreshTokensValidFromDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        return _x;
    }

    @Property(name="showInAddressList")
    @JsonIgnore
    public Optional<Boolean> getShowInAddressList() {
        return Optional.ofNullable(showInAddressList);
    }

    public User withShowInAddressList(Boolean showInAddressList) {
        User _x = _copy();
        _x.changedFields = changedFields.add("showInAddressList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.showInAddressList = showInAddressList;
        return _x;
    }

    @Property(name="signInSessionsValidFromDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSignInSessionsValidFromDateTime() {
        return Optional.ofNullable(signInSessionsValidFromDateTime);
    }

    public User withSignInSessionsValidFromDateTime(OffsetDateTime signInSessionsValidFromDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("signInSessionsValidFromDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public User withState(String state) {
        User _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.state = state;
        return _x;
    }

    @Property(name="streetAddress")
    @JsonIgnore
    public Optional<String> getStreetAddress() {
        return Optional.ofNullable(streetAddress);
    }

    public User withStreetAddress(String streetAddress) {
        User _x = _copy();
        _x.changedFields = changedFields.add("streetAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.streetAddress = streetAddress;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public User withSurname(String surname) {
        User _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.surname = surname;
        return _x;
    }

    @Property(name="usageLocation")
    @JsonIgnore
    public Optional<String> getUsageLocation() {
        return Optional.ofNullable(usageLocation);
    }

    public User withUsageLocation(String usageLocation) {
        User _x = _copy();
        _x.changedFields = changedFields.add("usageLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.usageLocation = usageLocation;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public User withUserPrincipalName(String userPrincipalName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="externalUserState")
    @JsonIgnore
    public Optional<String> getExternalUserState() {
        return Optional.ofNullable(externalUserState);
    }

    public User withExternalUserState(String externalUserState) {
        User _x = _copy();
        _x.changedFields = changedFields.add("externalUserState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.externalUserState = externalUserState;
        return _x;
    }

    @Property(name="externalUserStateChangeDateTime")
    @JsonIgnore
    public Optional<String> getExternalUserStateChangeDateTime() {
        return Optional.ofNullable(externalUserStateChangeDateTime);
    }

    public User withExternalUserStateChangeDateTime(String externalUserStateChangeDateTime) {
        User _x = _copy();
        _x.changedFields = changedFields.add("externalUserStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
        return _x;
    }

    @Property(name="userType")
    @JsonIgnore
    public Optional<String> getUserType() {
        return Optional.ofNullable(userType);
    }

    public User withUserType(String userType) {
        User _x = _copy();
        _x.changedFields = changedFields.add("userType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.userType = userType;
        return _x;
    }

    @Property(name="mailboxSettings")
    @JsonIgnore
    public Optional<MailboxSettings> getMailboxSettings() {
        return Optional.ofNullable(mailboxSettings);
    }

    public User withMailboxSettings(MailboxSettings mailboxSettings) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mailboxSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mailboxSettings = mailboxSettings;
        return _x;
    }

    /**
     * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
     * Allowed values are 5 or 1000.”</i>
     * 
     * @return property deviceEnrollmentLimit
     */
    @Property(name="deviceEnrollmentLimit")
    @JsonIgnore
    public Optional<Integer> getDeviceEnrollmentLimit() {
        return Optional.ofNullable(deviceEnrollmentLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceEnrollmentLimit} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The limit on the maximum number of devices that the user is permitted to enroll.
     * Allowed values are 5 or 1000.”</i>
     * 
     * @param deviceEnrollmentLimit
     *            new value of {@code deviceEnrollmentLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceEnrollmentLimit} field changed
     */
    public User withDeviceEnrollmentLimit(Integer deviceEnrollmentLimit) {
        User _x = _copy();
        _x.changedFields = changedFields.add("deviceEnrollmentLimit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
        return _x;
    }

    @Property(name="aboutMe")
    @JsonIgnore
    public Optional<String> getAboutMe() {
        return Optional.ofNullable(aboutMe);
    }

    public User withAboutMe(String aboutMe) {
        User _x = _copy();
        _x.changedFields = changedFields.add("aboutMe");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.aboutMe = aboutMe;
        return _x;
    }

    @Property(name="birthday")
    @JsonIgnore
    public Optional<OffsetDateTime> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    public User withBirthday(OffsetDateTime birthday) {
        User _x = _copy();
        _x.changedFields = changedFields.add("birthday");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.birthday = birthday;
        return _x;
    }

    @Property(name="hireDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getHireDate() {
        return Optional.ofNullable(hireDate);
    }

    public User withHireDate(OffsetDateTime hireDate) {
        User _x = _copy();
        _x.changedFields = changedFields.add("hireDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.hireDate = hireDate;
        return _x;
    }

    @Property(name="interests")
    @JsonIgnore
    public CollectionPage<String> getInterests() {
        return new CollectionPage<String>(contextPath, String.class, interests, Optional.ofNullable(interestsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="interests")
    @JsonIgnore
    public CollectionPage<String> getInterests(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, interests, Optional.ofNullable(interestsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="mySite")
    @JsonIgnore
    public Optional<String> getMySite() {
        return Optional.ofNullable(mySite);
    }

    public User withMySite(String mySite) {
        User _x = _copy();
        _x.changedFields = changedFields.add("mySite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.mySite = mySite;
        return _x;
    }

    @Property(name="pastProjects")
    @JsonIgnore
    public CollectionPage<String> getPastProjects() {
        return new CollectionPage<String>(contextPath, String.class, pastProjects, Optional.ofNullable(pastProjectsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pastProjects")
    @JsonIgnore
    public CollectionPage<String> getPastProjects(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, pastProjects, Optional.ofNullable(pastProjectsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="preferredName")
    @JsonIgnore
    public Optional<String> getPreferredName() {
        return Optional.ofNullable(preferredName);
    }

    public User withPreferredName(String preferredName) {
        User _x = _copy();
        _x.changedFields = changedFields.add("preferredName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.user");
        _x.preferredName = preferredName;
        return _x;
    }

    @Property(name="responsibilities")
    @JsonIgnore
    public CollectionPage<String> getResponsibilities() {
        return new CollectionPage<String>(contextPath, String.class, responsibilities, Optional.ofNullable(responsibilitiesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="responsibilities")
    @JsonIgnore
    public CollectionPage<String> getResponsibilities(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, responsibilities, Optional.ofNullable(responsibilitiesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="schools")
    @JsonIgnore
    public CollectionPage<String> getSchools() {
        return new CollectionPage<String>(contextPath, String.class, schools, Optional.ofNullable(schoolsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="schools")
    @JsonIgnore
    public CollectionPage<String> getSchools(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, schools, Optional.ofNullable(schoolsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="skills")
    @JsonIgnore
    public CollectionPage<String> getSkills() {
        return new CollectionPage<String>(contextPath, String.class, skills, Optional.ofNullable(skillsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="skills")
    @JsonIgnore
    public CollectionPage<String> getSkills(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, skills, Optional.ofNullable(skillsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="analytics")
    @JsonIgnore
    public UserAnalyticsRequest getAnalytics() {
        return new UserAnalyticsRequest(contextPath.addSegment("analytics"));
    }

    @NavigationProperty(name="informationProtection")
    @JsonIgnore
    public InformationProtectionRequest getInformationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"));
    }

    @NavigationProperty(name="appRoleAssignments")
    @JsonIgnore
    public AppRoleAssignmentCollectionRequest getAppRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"));
    }

    @NavigationProperty(name="createdObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getCreatedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"));
    }

    @NavigationProperty(name="directReports")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDirectReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directReports"));
    }

    @NavigationProperty(name="licenseDetails")
    @JsonIgnore
    public LicenseDetailsCollectionRequest getLicenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"));
    }

    @NavigationProperty(name="manager")
    @JsonIgnore
    public DirectoryObjectRequest getManager() {
        return new DirectoryObjectRequest(contextPath.addSegment("manager"));
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    @NavigationProperty(name="ownedDevices")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwnedDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedDevices"));
    }

    @NavigationProperty(name="ownedObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwnedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"));
    }

    @NavigationProperty(name="registeredDevices")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredDevices() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredDevices"));
    }

    @NavigationProperty(name="scopedRoleMemberOf")
    @JsonIgnore
    public ScopedRoleMembershipCollectionRequest getScopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedRoleMemberOf"));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property outlook
     */
    @NavigationProperty(name="outlook")
    @JsonIgnore
    public OutlookUserRequest getOutlook() {
        return new OutlookUserRequest(contextPath.addSegment("outlook"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public MessageCollectionRequest getMessages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property joinedGroups
     */
    @NavigationProperty(name="joinedGroups")
    @JsonIgnore
    public GroupCollectionRequest getJoinedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("joinedGroups"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property mailFolders
     */
    @NavigationProperty(name="mailFolders")
    @JsonIgnore
    public MailFolderCollectionRequest getMailFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("mailFolders"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendar
     */
    @NavigationProperty(name="calendar")
    @JsonIgnore
    public CalendarRequest getCalendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendars
     */
    @NavigationProperty(name="calendars")
    @JsonIgnore
    public CalendarCollectionRequest getCalendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendarGroups
     */
    @NavigationProperty(name="calendarGroups")
    @JsonIgnore
    public CalendarGroupCollectionRequest getCalendarGroups() {
        return new CalendarGroupCollectionRequest(
                        contextPath.addSegment("calendarGroups"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendarView
     */
    @NavigationProperty(name="calendarView")
    @JsonIgnore
    public EventCollectionRequest getCalendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property events
     */
    @NavigationProperty(name="events")
    @JsonIgnore
    public EventCollectionRequest getEvents() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property people
     */
    @NavigationProperty(name="people")
    @JsonIgnore
    public PersonCollectionRequest getPeople() {
        return new PersonCollectionRequest(
                        contextPath.addSegment("people"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property contacts
     */
    @NavigationProperty(name="contacts")
    @JsonIgnore
    public ContactCollectionRequest getContacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property contactFolders
     */
    @NavigationProperty(name="contactFolders")
    @JsonIgnore
    public ContactFolderCollectionRequest getContactFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("contactFolders"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property inferenceClassification
     */
    @NavigationProperty(name="inferenceClassification")
    @JsonIgnore
    public InferenceClassificationRequest getInferenceClassification() {
        return new InferenceClassificationRequest(contextPath.addSegment("inferenceClassification"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property photo
     */
    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property photos
     */
    @NavigationProperty(name="photos")
    @JsonIgnore
    public ProfilePhotoCollectionRequest getPhotos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"));
    }

    @NavigationProperty(name="drive")
    @JsonIgnore
    public DriveRequest getDrive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    @NavigationProperty(name="drives")
    @JsonIgnore
    public DriveCollectionRequest getDrives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"));
    }

    @NavigationProperty(name="followedSites")
    @JsonIgnore
    public SiteCollectionRequest getFollowedSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("followedSites"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    @NavigationProperty(name="approvals")
    @JsonIgnore
    public ApprovalCollectionRequest getApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("approvals"));
    }

    @NavigationProperty(name="appConsentRequestsForApproval")
    @JsonIgnore
    public AppConsentRequestCollectionRequest getAppConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(
                        contextPath.addSegment("appConsentRequestsForApproval"));
    }

    @NavigationProperty(name="pendingAccessReviewInstances")
    @JsonIgnore
    public AccessReviewInstanceCollectionRequest getPendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("pendingAccessReviewInstances"));
    }

    @NavigationProperty(name="agreementAcceptances")
    @JsonIgnore
    public AgreementAcceptanceCollectionRequest getAgreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("agreementAcceptances"));
    }

    /**
     * <i>“Get enrollment configurations targeted to the user”</i>
     * 
     * @return navigational property deviceEnrollmentConfigurations
     */
    @NavigationProperty(name="deviceEnrollmentConfigurations")
    @JsonIgnore
    public DeviceEnrollmentConfigurationCollectionRequest getDeviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"));
    }

    /**
     * <i>“The managed devices associated with the user.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getManagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    /**
     * <i>“Zero or more managed app registrations that belong to the user.”</i>
     * 
     * @return navigational property managedAppRegistrations
     */
    @NavigationProperty(name="managedAppRegistrations")
    @JsonIgnore
    public ManagedAppRegistrationCollectionRequest getManagedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"));
    }

    /**
     * <i>“Zero or more WIP device registrations that belong to the user.”</i>
     * 
     * @return navigational property windowsInformationProtectionDeviceRegistrations
     */
    @NavigationProperty(name="windowsInformationProtectionDeviceRegistrations")
    @JsonIgnore
    public WindowsInformationProtectionDeviceRegistrationCollectionRequest getWindowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"));
    }

    /**
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @return navigational property deviceManagementTroubleshootingEvents
     */
    @NavigationProperty(name="deviceManagementTroubleshootingEvents")
    @JsonIgnore
    public DeviceManagementTroubleshootingEventCollectionRequest getDeviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("deviceManagementTroubleshootingEvents"));
    }

    /**
     * <i>“The list of troubleshooting events for this user.”</i>
     * 
     * @return navigational property mobileAppIntentAndStates
     */
    @NavigationProperty(name="mobileAppIntentAndStates")
    @JsonIgnore
    public MobileAppIntentAndStateCollectionRequest getMobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(
                        contextPath.addSegment("mobileAppIntentAndStates"));
    }

    /**
     * <i>“The list of mobile app troubleshooting events for this user.”</i>
     * 
     * @return navigational property mobileAppTroubleshootingEvents
     */
    @NavigationProperty(name="mobileAppTroubleshootingEvents")
    @JsonIgnore
    public MobileAppTroubleshootingEventCollectionRequest getMobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"));
    }

    @NavigationProperty(name="notifications")
    @JsonIgnore
    public NotificationCollectionRequest getNotifications() {
        return new NotificationCollectionRequest(
                        contextPath.addSegment("notifications"));
    }

    @NavigationProperty(name="planner")
    @JsonIgnore
    public PlannerUserRequest getPlanner() {
        return new PlannerUserRequest(contextPath.addSegment("planner"));
    }

    @NavigationProperty(name="insights")
    @JsonIgnore
    public OfficeGraphInsightsRequest getInsights() {
        return new OfficeGraphInsightsRequest(contextPath.addSegment("insights"));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public UserSettingsRequest getSettings() {
        return new UserSettingsRequest(contextPath.addSegment("settings"));
    }

    @NavigationProperty(name="onenote")
    @JsonIgnore
    public OnenoteRequest getOnenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"));
    }

    @NavigationProperty(name="profile")
    @JsonIgnore
    public ProfileRequest getProfile() {
        return new ProfileRequest(contextPath.addSegment("profile"));
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public UserActivityCollectionRequest getActivities() {
        return new UserActivityCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    @NavigationProperty(name="devices")
    @JsonIgnore
    public DeviceCollectionRequest getDevices() {
        return new DeviceCollectionRequest(
                        contextPath.addSegment("devices"));
    }

    @NavigationProperty(name="onlineMeetings")
    @JsonIgnore
    public OnlineMeetingCollectionRequest getOnlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"));
    }

    @NavigationProperty(name="presence")
    @JsonIgnore
    public PresenceRequest getPresence() {
        return new PresenceRequest(contextPath.addSegment("presence"));
    }

    @NavigationProperty(name="authentication")
    @JsonIgnore
    public AuthenticationRequest getAuthentication() {
        return new AuthenticationRequest(contextPath.addSegment("authentication"));
    }

    @NavigationProperty(name="chats")
    @JsonIgnore
    public ChatCollectionRequest getChats() {
        return new ChatCollectionRequest(
                        contextPath.addSegment("chats"));
    }

    @NavigationProperty(name="joinedTeams")
    @JsonIgnore
    public TeamCollectionRequest getJoinedTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("joinedTeams"));
    }

    @NavigationProperty(name="teamwork")
    @JsonIgnore
    public UserTeamworkRequest getTeamwork() {
        return new UserTeamworkRequest(contextPath.addSegment("teamwork"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public User put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        User _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private User _copy() {
        User _x = new User();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.signInActivity = signInActivity;
        _x.accountEnabled = accountEnabled;
        _x.ageGroup = ageGroup;
        _x.assignedLicenses = assignedLicenses;
        _x.assignedPlans = assignedPlans;
        _x.businessPhones = businessPhones;
        _x.city = city;
        _x.companyName = companyName;
        _x.consentProvidedForMinor = consentProvidedForMinor;
        _x.country = country;
        _x.createdDateTime = createdDateTime;
        _x.creationType = creationType;
        _x.department = department;
        _x.deviceKeys = deviceKeys;
        _x.displayName = displayName;
        _x.employeeId = employeeId;
        _x.faxNumber = faxNumber;
        _x.givenName = givenName;
        _x.identities = identities;
        _x.imAddresses = imAddresses;
        _x.infoCatalogs = infoCatalogs;
        _x.isResourceAccount = isResourceAccount;
        _x.jobTitle = jobTitle;
        _x.lastPasswordChangeDateTime = lastPasswordChangeDateTime;
        _x.legalAgeGroupClassification = legalAgeGroupClassification;
        _x.licenseAssignmentStates = licenseAssignmentStates;
        _x.mail = mail;
        _x.mailNickname = mailNickname;
        _x.mobilePhone = mobilePhone;
        _x.onPremisesDistinguishedName = onPremisesDistinguishedName;
        _x.onPremisesExtensionAttributes = onPremisesExtensionAttributes;
        _x.onPremisesImmutableId = onPremisesImmutableId;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.onPremisesDomainName = onPremisesDomainName;
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        _x.onPremisesUserPrincipalName = onPremisesUserPrincipalName;
        _x.otherMails = otherMails;
        _x.passwordPolicies = passwordPolicies;
        _x.passwordProfile = passwordProfile;
        _x.officeLocation = officeLocation;
        _x.postalCode = postalCode;
        _x.preferredDataLocation = preferredDataLocation;
        _x.preferredLanguage = preferredLanguage;
        _x.provisionedPlans = provisionedPlans;
        _x.proxyAddresses = proxyAddresses;
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        _x.showInAddressList = showInAddressList;
        _x.signInSessionsValidFromDateTime = signInSessionsValidFromDateTime;
        _x.state = state;
        _x.streetAddress = streetAddress;
        _x.surname = surname;
        _x.usageLocation = usageLocation;
        _x.userPrincipalName = userPrincipalName;
        _x.externalUserState = externalUserState;
        _x.externalUserStateChangeDateTime = externalUserStateChangeDateTime;
        _x.userType = userType;
        _x.mailboxSettings = mailboxSettings;
        _x.deviceEnrollmentLimit = deviceEnrollmentLimit;
        _x.aboutMe = aboutMe;
        _x.birthday = birthday;
        _x.hireDate = hireDate;
        _x.interests = interests;
        _x.mySite = mySite;
        _x.pastProjects = pastProjects;
        _x.preferredName = preferredName;
        _x.responsibilities = responsibilities;
        _x.schools = schools;
        _x.skills = skills;
        return _x;
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> assignLicense(List<AssignedLicense> addLicenses, List<String> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), User.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "changePassword")
    @JsonIgnore
    public ActionRequestNoReturn changePassword(String currentPassword, String newPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("currentPassword", "Edm.String", Checks.checkIsAscii(currentPassword))
            .put("newPassword", "Edm.String", Checks.checkIsAscii(newPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changePassword"), _parameters);
    }

    @Action(name = "invalidateAllRefreshTokens")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> invalidateAllRefreshTokens() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invalidateAllRefreshTokens"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "revokeSignInSessions")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> revokeSignInSessions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeSignInSessions"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "reprocessLicenseAssignment")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<User> reprocessLicenseAssignment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<User>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprocessLicenseAssignment"), User.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "findMeetingTimes")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult> findMeetingTimes(List<AttendeeBase> attendees, LocationConstraint locationConstraint, TimeConstraint timeConstraint, Duration meetingDuration, Integer maxCandidates, Boolean isOrganizerOptional, Boolean returnSuggestionReasons, Double minimumAttendeePercentage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("attendees", "Collection(microsoft.graph.attendeeBase)", attendees)
            .put("locationConstraint", "microsoft.graph.locationConstraint", locationConstraint)
            .put("timeConstraint", "microsoft.graph.timeConstraint", timeConstraint)
            .put("meetingDuration", "Edm.Duration", meetingDuration)
            .put("maxCandidates", "Edm.Int32", maxCandidates)
            .put("isOrganizerOptional", "Edm.Boolean", isOrganizerOptional)
            .put("returnSuggestionReasons", "Edm.Boolean", returnSuggestionReasons)
            .put("minimumAttendeePercentage", "Edm.Double", minimumAttendeePercentage)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MeetingTimeSuggestionsResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findMeetingTimes"), MeetingTimeSuggestionsResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "sendMail")
    @JsonIgnore
    public ActionRequestNoReturn sendMail(Message message, Boolean saveToSentItems) {
        Preconditions.checkNotNull(message, "message cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Message", "microsoft.graph.message", message)
            .put("SaveToSentItems", "Edm.Boolean", saveToSentItems)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendMail"), _parameters);
    }

    @Action(name = "getMailTips")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailTips> getMailTips(List<String> emailAddresses, MailTipsType mailTipsOptions) {
        Preconditions.checkNotNull(emailAddresses, "emailAddresses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EmailAddresses", "Collection(Edm.String)", Checks.checkIsAscii(emailAddresses))
            .put("MailTipsOptions", "microsoft.graph.mailTipsType", mailTipsOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailTips"), MailTips.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "translateExchangeIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ConvertIdResult> translateExchangeIds(List<String> inputIds, ExchangeIdFormat targetIdType, ExchangeIdFormat sourceIdType) {
        Preconditions.checkNotNull(inputIds, "inputIds cannot be null");
        Preconditions.checkNotNull(targetIdType, "targetIdType cannot be null");
        Preconditions.checkNotNull(sourceIdType, "sourceIdType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("InputIds", "Collection(Edm.String)", Checks.checkIsAscii(inputIds))
            .put("TargetIdType", "microsoft.graph.exchangeIdFormat", targetIdType)
            .put("SourceIdType", "microsoft.graph.exchangeIdFormat", sourceIdType)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.translateExchangeIds"), ConvertIdResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "removeAllDevicesFromManagement")
    @JsonIgnore
    public ActionRequestNoReturn removeAllDevicesFromManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeAllDevicesFromManagement"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationByDeviceTag"), _parameters);
    }

    @Action(name = "wipeManagedAppRegistrationsByDeviceTag")
    @JsonIgnore
    public ActionRequestNoReturn wipeManagedAppRegistrationsByDeviceTag(String deviceTag) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceTag", "Edm.String", Checks.checkIsAscii(deviceTag))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeManagedAppRegistrationsByDeviceTag"), _parameters);
    }

    @Action(name = "wipeAndBlockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn wipeAndBlockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipeAndBlockManagedApps"), _parameters);
    }

    @Action(name = "unblockManagedApps")
    @JsonIgnore
    public ActionRequestNoReturn unblockManagedApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unblockManagedApps"), _parameters);
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Function(name = "reminderView")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Reminder> reminderView(String startDateTime, String endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("StartDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("EndDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reminderView"), Reminder.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRoomLists")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRoomLists() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRoomLists"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "findRooms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAddress> findRooms_Function(String roomList) {
        Preconditions.checkNotNull(roomList, "roomList cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("RoomList", "Edm.String", Checks.checkIsAscii(roomList))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.findRooms"), EmailAddress.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "exportDeviceAndAppManagementData")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData> exportDeviceAndAppManagementData_Function(Integer skip, Integer top) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementData>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportDeviceAndAppManagementData"), DeviceAndAppManagementData.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectiveDeviceEnrollmentConfigurations")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceEnrollmentConfiguration> getEffectiveDeviceEnrollmentConfigurations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectiveDeviceEnrollmentConfigurations"), DeviceEnrollmentConfiguration.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getLoggedOnManagedDevices")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDevice> getLoggedOnManagedDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getLoggedOnManagedDevices"), ManagedDevice.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedAppDiagnosticStatuses")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppDiagnosticStatus> getManagedAppDiagnosticStatuses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppDiagnosticStatuses"), ManagedAppDiagnosticStatus.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedAppPolicies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedAppPolicy> getManagedAppPolicies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppPolicies"), ManagedAppPolicy.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "isManagedAppUserBlocked")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isManagedAppUserBlocked() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isManagedAppUserBlocked"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedDevicesWithAppFailures")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedDevicesWithAppFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithAppFailures"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedDevicesWithFailedOrPendingApps")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ManagedDeviceSummarizedAppState> getManagedDevicesWithFailedOrPendingApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedDevicesWithFailedOrPendingApps"), ManagedDeviceSummarizedAppState.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("User[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("signInActivity=");
        b.append(this.signInActivity);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("ageGroup=");
        b.append(this.ageGroup);
        b.append(", ");
        b.append("assignedLicenses=");
        b.append(this.assignedLicenses);
        b.append(", ");
        b.append("assignedPlans=");
        b.append(this.assignedPlans);
        b.append(", ");
        b.append("businessPhones=");
        b.append(this.businessPhones);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("companyName=");
        b.append(this.companyName);
        b.append(", ");
        b.append("consentProvidedForMinor=");
        b.append(this.consentProvidedForMinor);
        b.append(", ");
        b.append("country=");
        b.append(this.country);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creationType=");
        b.append(this.creationType);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("deviceKeys=");
        b.append(this.deviceKeys);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("employeeId=");
        b.append(this.employeeId);
        b.append(", ");
        b.append("faxNumber=");
        b.append(this.faxNumber);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("identities=");
        b.append(this.identities);
        b.append(", ");
        b.append("imAddresses=");
        b.append(this.imAddresses);
        b.append(", ");
        b.append("infoCatalogs=");
        b.append(this.infoCatalogs);
        b.append(", ");
        b.append("isResourceAccount=");
        b.append(this.isResourceAccount);
        b.append(", ");
        b.append("jobTitle=");
        b.append(this.jobTitle);
        b.append(", ");
        b.append("lastPasswordChangeDateTime=");
        b.append(this.lastPasswordChangeDateTime);
        b.append(", ");
        b.append("legalAgeGroupClassification=");
        b.append(this.legalAgeGroupClassification);
        b.append(", ");
        b.append("licenseAssignmentStates=");
        b.append(this.licenseAssignmentStates);
        b.append(", ");
        b.append("mail=");
        b.append(this.mail);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("mobilePhone=");
        b.append(this.mobilePhone);
        b.append(", ");
        b.append("onPremisesDistinguishedName=");
        b.append(this.onPremisesDistinguishedName);
        b.append(", ");
        b.append("onPremisesExtensionAttributes=");
        b.append(this.onPremisesExtensionAttributes);
        b.append(", ");
        b.append("onPremisesImmutableId=");
        b.append(this.onPremisesImmutableId);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesProvisioningErrors=");
        b.append(this.onPremisesProvisioningErrors);
        b.append(", ");
        b.append("onPremisesSecurityIdentifier=");
        b.append(this.onPremisesSecurityIdentifier);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("onPremisesDomainName=");
        b.append(this.onPremisesDomainName);
        b.append(", ");
        b.append("onPremisesSamAccountName=");
        b.append(this.onPremisesSamAccountName);
        b.append(", ");
        b.append("onPremisesUserPrincipalName=");
        b.append(this.onPremisesUserPrincipalName);
        b.append(", ");
        b.append("otherMails=");
        b.append(this.otherMails);
        b.append(", ");
        b.append("passwordPolicies=");
        b.append(this.passwordPolicies);
        b.append(", ");
        b.append("passwordProfile=");
        b.append(this.passwordProfile);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("preferredDataLocation=");
        b.append(this.preferredDataLocation);
        b.append(", ");
        b.append("preferredLanguage=");
        b.append(this.preferredLanguage);
        b.append(", ");
        b.append("provisionedPlans=");
        b.append(this.provisionedPlans);
        b.append(", ");
        b.append("proxyAddresses=");
        b.append(this.proxyAddresses);
        b.append(", ");
        b.append("refreshTokensValidFromDateTime=");
        b.append(this.refreshTokensValidFromDateTime);
        b.append(", ");
        b.append("showInAddressList=");
        b.append(this.showInAddressList);
        b.append(", ");
        b.append("signInSessionsValidFromDateTime=");
        b.append(this.signInSessionsValidFromDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("streetAddress=");
        b.append(this.streetAddress);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("usageLocation=");
        b.append(this.usageLocation);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("externalUserState=");
        b.append(this.externalUserState);
        b.append(", ");
        b.append("externalUserStateChangeDateTime=");
        b.append(this.externalUserStateChangeDateTime);
        b.append(", ");
        b.append("userType=");
        b.append(this.userType);
        b.append(", ");
        b.append("mailboxSettings=");
        b.append(this.mailboxSettings);
        b.append(", ");
        b.append("deviceEnrollmentLimit=");
        b.append(this.deviceEnrollmentLimit);
        b.append(", ");
        b.append("aboutMe=");
        b.append(this.aboutMe);
        b.append(", ");
        b.append("birthday=");
        b.append(this.birthday);
        b.append(", ");
        b.append("hireDate=");
        b.append(this.hireDate);
        b.append(", ");
        b.append("interests=");
        b.append(this.interests);
        b.append(", ");
        b.append("mySite=");
        b.append(this.mySite);
        b.append(", ");
        b.append("pastProjects=");
        b.append(this.pastProjects);
        b.append(", ");
        b.append("preferredName=");
        b.append(this.preferredName);
        b.append(", ");
        b.append("responsibilities=");
        b.append(this.responsibilities);
        b.append(", ");
        b.append("schools=");
        b.append(this.schools);
        b.append(", ");
        b.append("skills=");
        b.append(this.skills);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
