package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.ResourceReference;
import odata.msgraph.client.beta.complex.ResourceVisualization;
import odata.msgraph.client.beta.complex.UsageDetails;
import odata.msgraph.client.beta.entity.request.EntityRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "lastUsed", 
    "resourceVisualization", 
    "resourceReference"})
@JsonInclude(Include.NON_NULL)
public class UsedInsight extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.usedInsight";
    }

    @JsonProperty("lastUsed")
    protected UsageDetails lastUsed;

    @JsonProperty("resourceVisualization")
    protected ResourceVisualization resourceVisualization;

    @JsonProperty("resourceReference")
    protected ResourceReference resourceReference;

    protected UsedInsight() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUsedInsight() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UsageDetails lastUsed;
        private ResourceVisualization resourceVisualization;
        private ResourceReference resourceReference;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastUsed(UsageDetails lastUsed) {
            this.lastUsed = lastUsed;
            this.changedFields = changedFields.add("lastUsed");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourceVisualization
         *            value of {@code resourceVisualization} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceVisualization(ResourceVisualization resourceVisualization) {
            this.resourceVisualization = resourceVisualization;
            this.changedFields = changedFields.add("resourceVisualization");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourceReference
         *            value of {@code resourceReference} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceReference(ResourceReference resourceReference) {
            this.resourceReference = resourceReference;
            this.changedFields = changedFields.add("resourceReference");
            return this;
        }

        public UsedInsight build() {
            UsedInsight _x = new UsedInsight();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.usedInsight";
            _x.id = id;
            _x.lastUsed = lastUsed;
            _x.resourceVisualization = resourceVisualization;
            _x.resourceReference = resourceReference;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="lastUsed")
    @JsonIgnore
    public Optional<UsageDetails> getLastUsed() {
        return Optional.ofNullable(lastUsed);
    }

    public UsedInsight withLastUsed(UsageDetails lastUsed) {
        UsedInsight _x = _copy();
        _x.changedFields = changedFields.add("lastUsed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usedInsight");
        _x.lastUsed = lastUsed;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourceVisualization
     */
    @Property(name="resourceVisualization")
    @JsonIgnore
    public Optional<ResourceVisualization> getResourceVisualization() {
        return Optional.ofNullable(resourceVisualization);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourceVisualization} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourceVisualization
     *            new value of {@code resourceVisualization} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceVisualization} field changed
     */
    public UsedInsight withResourceVisualization(ResourceVisualization resourceVisualization) {
        UsedInsight _x = _copy();
        _x.changedFields = changedFields.add("resourceVisualization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usedInsight");
        _x.resourceVisualization = resourceVisualization;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourceReference
     */
    @Property(name="resourceReference")
    @JsonIgnore
    public Optional<ResourceReference> getResourceReference() {
        return Optional.ofNullable(resourceReference);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceReference
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourceReference
     *            new value of {@code resourceReference} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceReference} field changed
     */
    public UsedInsight withResourceReference(ResourceReference resourceReference) {
        UsedInsight _x = _copy();
        _x.changedFields = changedFields.add("resourceReference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usedInsight");
        _x.resourceReference = resourceReference;
        return _x;
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public EntityRequest getResource() {
        return new EntityRequest(contextPath.addSegment("resource"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UsedInsight patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UsedInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UsedInsight put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UsedInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UsedInsight _copy() {
        UsedInsight _x = new UsedInsight();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastUsed = lastUsed;
        _x.resourceVisualization = resourceVisualization;
        _x.resourceReference = resourceReference;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UsedInsight[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastUsed=");
        b.append(this.lastUsed);
        b.append(", ");
        b.append("resourceVisualization=");
        b.append(this.resourceVisualization);
        b.append(", ");
        b.append("resourceReference=");
        b.append(this.resourceReference);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
