package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.enums.ThreatAssessmentContentType;
import odata.msgraph.client.beta.enums.ThreatAssessmentRequestSource;
import odata.msgraph.client.beta.enums.ThreatAssessmentStatus;
import odata.msgraph.client.beta.enums.ThreatCategory;
import odata.msgraph.client.beta.enums.ThreatExpectedAssessment;

@JsonPropertyOrder({
    "@odata.type", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class UrlAssessmentRequest extends ThreatAssessmentRequest implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.urlAssessmentRequest";
    }

    @JsonProperty("url")
    protected String url;

    protected UrlAssessmentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUrlAssessmentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private ThreatAssessmentContentType contentType;
        private ThreatExpectedAssessment expectedAssessment;
        private ThreatCategory category;
        private ThreatAssessmentStatus status;
        private ThreatAssessmentRequestSource requestSource;
        private IdentitySet createdBy;
        private String url;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder contentType(ThreatAssessmentContentType contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder expectedAssessment(ThreatExpectedAssessment expectedAssessment) {
            this.expectedAssessment = expectedAssessment;
            this.changedFields = changedFields.add("expectedAssessment");
            return this;
        }

        public Builder category(ThreatCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder status(ThreatAssessmentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder requestSource(ThreatAssessmentRequestSource requestSource) {
            this.requestSource = requestSource;
            this.changedFields = changedFields.add("requestSource");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public UrlAssessmentRequest build() {
            UrlAssessmentRequest _x = new UrlAssessmentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.urlAssessmentRequest";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.contentType = contentType;
            _x.expectedAssessment = expectedAssessment;
            _x.category = category;
            _x.status = status;
            _x.requestSource = requestSource;
            _x.createdBy = createdBy;
            _x.url = url;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public UrlAssessmentRequest withUrl(String url) {
        UrlAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.urlAssessmentRequest");
        _x.url = url;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UrlAssessmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UrlAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UrlAssessmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UrlAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UrlAssessmentRequest _copy() {
        UrlAssessmentRequest _x = new UrlAssessmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.contentType = contentType;
        _x.expectedAssessment = expectedAssessment;
        _x.category = category;
        _x.status = status;
        _x.requestSource = requestSource;
        _x.createdBy = createdBy;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UrlAssessmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("expectedAssessment=");
        b.append(this.expectedAssessment);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("requestSource=");
        b.append(this.requestSource);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
