package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.GroupPolicySettingScope;


/**
 * <i>“Unsupported Group Policy Extension.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingScope", 
    "namespaceUrl", 
    "extensionType", 
    "nodeName"})
@JsonInclude(Include.NON_NULL)
public class UnsupportedGroupPolicyExtension extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unsupportedGroupPolicyExtension";
    }

    @JsonProperty("settingScope")
    protected GroupPolicySettingScope settingScope;

    @JsonProperty("namespaceUrl")
    protected String namespaceUrl;

    @JsonProperty("extensionType")
    protected String extensionType;

    @JsonProperty("nodeName")
    protected String nodeName;

    protected UnsupportedGroupPolicyExtension() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnsupportedGroupPolicyExtension() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private GroupPolicySettingScope settingScope;
        private String namespaceUrl;
        private String extensionType;
        private String nodeName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Setting Scope of the unsupported extension.”</i>
         * 
         * @param settingScope
         *            value of {@code settingScope} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingScope(GroupPolicySettingScope settingScope) {
            this.settingScope = settingScope;
            this.changedFields = changedFields.add("settingScope");
            return this;
        }

        /**
         * <i>“Namespace Url of the unsupported extension.”</i>
         * 
         * @param namespaceUrl
         *            value of {@code namespaceUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder namespaceUrl(String namespaceUrl) {
            this.namespaceUrl = namespaceUrl;
            this.changedFields = changedFields.add("namespaceUrl");
            return this;
        }

        /**
         * <i>“ExtensionType of the unsupported extension.”</i>
         * 
         * @param extensionType
         *            value of {@code extensionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensionType(String extensionType) {
            this.extensionType = extensionType;
            this.changedFields = changedFields.add("extensionType");
            return this;
        }

        /**
         * <i>“Node name of the unsupported extension.”</i>
         * 
         * @param nodeName
         *            value of {@code nodeName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            this.changedFields = changedFields.add("nodeName");
            return this;
        }

        public UnsupportedGroupPolicyExtension build() {
            UnsupportedGroupPolicyExtension _x = new UnsupportedGroupPolicyExtension();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unsupportedGroupPolicyExtension";
            _x.id = id;
            _x.settingScope = settingScope;
            _x.namespaceUrl = namespaceUrl;
            _x.extensionType = extensionType;
            _x.nodeName = nodeName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Setting Scope of the unsupported extension.”</i>
     * 
     * @return property settingScope
     */
    @Property(name="settingScope")
    @JsonIgnore
    public Optional<GroupPolicySettingScope> getSettingScope() {
        return Optional.ofNullable(settingScope);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingScope}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting Scope of the unsupported extension.”</i>
     * 
     * @param settingScope
     *            new value of {@code settingScope} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingScope} field changed
     */
    public UnsupportedGroupPolicyExtension withSettingScope(GroupPolicySettingScope settingScope) {
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = changedFields.add("settingScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedGroupPolicyExtension");
        _x.settingScope = settingScope;
        return _x;
    }

    /**
     * <i>“Namespace Url of the unsupported extension.”</i>
     * 
     * @return property namespaceUrl
     */
    @Property(name="namespaceUrl")
    @JsonIgnore
    public Optional<String> getNamespaceUrl() {
        return Optional.ofNullable(namespaceUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code namespaceUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Namespace Url of the unsupported extension.”</i>
     * 
     * @param namespaceUrl
     *            new value of {@code namespaceUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code namespaceUrl} field changed
     */
    public UnsupportedGroupPolicyExtension withNamespaceUrl(String namespaceUrl) {
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = changedFields.add("namespaceUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedGroupPolicyExtension");
        _x.namespaceUrl = namespaceUrl;
        return _x;
    }

    /**
     * <i>“ExtensionType of the unsupported extension.”</i>
     * 
     * @return property extensionType
     */
    @Property(name="extensionType")
    @JsonIgnore
    public Optional<String> getExtensionType() {
        return Optional.ofNullable(extensionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extensionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“ExtensionType of the unsupported extension.”</i>
     * 
     * @param extensionType
     *            new value of {@code extensionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extensionType} field changed
     */
    public UnsupportedGroupPolicyExtension withExtensionType(String extensionType) {
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = changedFields.add("extensionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedGroupPolicyExtension");
        _x.extensionType = extensionType;
        return _x;
    }

    /**
     * <i>“Node name of the unsupported extension.”</i>
     * 
     * @return property nodeName
     */
    @Property(name="nodeName")
    @JsonIgnore
    public Optional<String> getNodeName() {
        return Optional.ofNullable(nodeName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code nodeName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Node name of the unsupported extension.”</i>
     * 
     * @param nodeName
     *            new value of {@code nodeName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nodeName} field changed
     */
    public UnsupportedGroupPolicyExtension withNodeName(String nodeName) {
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = changedFields.add("nodeName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedGroupPolicyExtension");
        _x.nodeName = nodeName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnsupportedGroupPolicyExtension patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnsupportedGroupPolicyExtension put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnsupportedGroupPolicyExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnsupportedGroupPolicyExtension _copy() {
        UnsupportedGroupPolicyExtension _x = new UnsupportedGroupPolicyExtension();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.settingScope = settingScope;
        _x.namespaceUrl = namespaceUrl;
        _x.extensionType = extensionType;
        _x.nodeName = nodeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnsupportedGroupPolicyExtension[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settingScope=");
        b.append(this.settingScope);
        b.append(", ");
        b.append("namespaceUrl=");
        b.append(this.namespaceUrl);
        b.append(", ");
        b.append("extensionType=");
        b.append(this.extensionType);
        b.append(", ");
        b.append("nodeName=");
        b.append(this.nodeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
