package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AppScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "roleDefinitionId", 
    "condition", 
    "displayName", 
    "description", 
    "principalIds", 
    "directoryScopeIds", 
    "appScopeIds"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignmentMultiple extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignmentMultiple";
    }

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("condition")
    protected String condition;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("principalIds")
    protected List<String> principalIds;

    @JsonProperty("principalIds@nextLink")
    protected String principalIdsNextLink;

    @JsonProperty("directoryScopeIds")
    protected List<String> directoryScopeIds;

    @JsonProperty("directoryScopeIds@nextLink")
    protected String directoryScopeIdsNextLink;

    @JsonProperty("appScopeIds")
    protected List<String> appScopeIds;

    @JsonProperty("appScopeIds@nextLink")
    protected String appScopeIdsNextLink;

    protected UnifiedRoleAssignmentMultiple() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignmentMultiple() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String roleDefinitionId;
        private String condition;
        private String displayName;
        private String description;
        private List<String> principalIds;
        private String principalIdsNextLink;
        private List<String> directoryScopeIds;
        private String directoryScopeIdsNextLink;
        private List<String> appScopeIds;
        private String appScopeIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("condition");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder principalIds(List<String> principalIds) {
            this.principalIds = principalIds;
            this.changedFields = changedFields.add("principalIds");
            return this;
        }

        public Builder principalIds(String... principalIds) {
            return principalIds(Arrays.asList(principalIds));
        }

        public Builder principalIdsNextLink(String principalIdsNextLink) {
            this.principalIdsNextLink = principalIdsNextLink;
            this.changedFields = changedFields.add("principalIds");
            return this;
        }

        public Builder directoryScopeIds(List<String> directoryScopeIds) {
            this.directoryScopeIds = directoryScopeIds;
            this.changedFields = changedFields.add("directoryScopeIds");
            return this;
        }

        public Builder directoryScopeIds(String... directoryScopeIds) {
            return directoryScopeIds(Arrays.asList(directoryScopeIds));
        }

        public Builder directoryScopeIdsNextLink(String directoryScopeIdsNextLink) {
            this.directoryScopeIdsNextLink = directoryScopeIdsNextLink;
            this.changedFields = changedFields.add("directoryScopeIds");
            return this;
        }

        public Builder appScopeIds(List<String> appScopeIds) {
            this.appScopeIds = appScopeIds;
            this.changedFields = changedFields.add("appScopeIds");
            return this;
        }

        public Builder appScopeIds(String... appScopeIds) {
            return appScopeIds(Arrays.asList(appScopeIds));
        }

        public Builder appScopeIdsNextLink(String appScopeIdsNextLink) {
            this.appScopeIdsNextLink = appScopeIdsNextLink;
            this.changedFields = changedFields.add("appScopeIds");
            return this;
        }

        public UnifiedRoleAssignmentMultiple build() {
            UnifiedRoleAssignmentMultiple _x = new UnifiedRoleAssignmentMultiple();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unifiedRoleAssignmentMultiple";
            _x.id = id;
            _x.roleDefinitionId = roleDefinitionId;
            _x.condition = condition;
            _x.displayName = displayName;
            _x.description = description;
            _x.principalIds = principalIds;
            _x.principalIdsNextLink = principalIdsNextLink;
            _x.directoryScopeIds = directoryScopeIds;
            _x.directoryScopeIdsNextLink = directoryScopeIdsNextLink;
            _x.appScopeIds = appScopeIds;
            _x.appScopeIdsNextLink = appScopeIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleAssignmentMultiple withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="condition")
    @JsonIgnore
    public Optional<String> getCondition() {
        return Optional.ofNullable(condition);
    }

    public UnifiedRoleAssignmentMultiple withCondition(String condition) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("condition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.condition = condition;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UnifiedRoleAssignmentMultiple withDisplayName(String displayName) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public UnifiedRoleAssignmentMultiple withDescription(String description) {
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignmentMultiple");
        _x.description = description;
        return _x;
    }

    @Property(name="principalIds")
    @JsonIgnore
    public CollectionPage<String> getPrincipalIds() {
        return new CollectionPage<String>(contextPath, String.class, principalIds, Optional.ofNullable(principalIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="principalIds")
    @JsonIgnore
    public CollectionPage<String> getPrincipalIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, principalIds, Optional.ofNullable(principalIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="directoryScopeIds")
    @JsonIgnore
    public CollectionPage<String> getDirectoryScopeIds() {
        return new CollectionPage<String>(contextPath, String.class, directoryScopeIds, Optional.ofNullable(directoryScopeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="directoryScopeIds")
    @JsonIgnore
    public CollectionPage<String> getDirectoryScopeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, directoryScopeIds, Optional.ofNullable(directoryScopeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="appScopeIds")
    @JsonIgnore
    public CollectionPage<String> getAppScopeIds() {
        return new CollectionPage<String>(contextPath, String.class, appScopeIds, Optional.ofNullable(appScopeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appScopeIds")
    @JsonIgnore
    public CollectionPage<String> getAppScopeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, appScopeIds, Optional.ofNullable(appScopeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    @NavigationProperty(name="principals")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getPrincipals() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("principals"));
    }

    @NavigationProperty(name="directoryScopes")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDirectoryScopes() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directoryScopes"));
    }

    @NavigationProperty(name="appScopes")
    @JsonIgnore
    public AppScopeCollectionRequest getAppScopes() {
        return new AppScopeCollectionRequest(
                        contextPath.addSegment("appScopes"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentMultiple patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignmentMultiple put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignmentMultiple _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignmentMultiple _copy() {
        UnifiedRoleAssignmentMultiple _x = new UnifiedRoleAssignmentMultiple();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleDefinitionId = roleDefinitionId;
        _x.condition = condition;
        _x.displayName = displayName;
        _x.description = description;
        _x.principalIds = principalIds;
        _x.directoryScopeIds = directoryScopeIds;
        _x.appScopeIds = appScopeIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignmentMultiple[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("condition=");
        b.append(this.condition);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("principalIds=");
        b.append(this.principalIds);
        b.append(", ");
        b.append("directoryScopeIds=");
        b.append(this.directoryScopeIds);
        b.append(", ");
        b.append("appScopeIds=");
        b.append(this.appScopeIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
