package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "roleDefinitionId", 
    "condition", 
    "principalId", 
    "directoryScopeId", 
    "appScopeId", 
    "resourceScope"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRoleAssignment";
    }

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("condition")
    protected String condition;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("directoryScopeId")
    protected String directoryScopeId;

    @JsonProperty("appScopeId")
    protected String appScopeId;

    @JsonProperty("resourceScope")
    protected String resourceScope;

    protected UnifiedRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnifiedRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String roleDefinitionId;
        private String condition;
        private String principalId;
        private String directoryScopeId;
        private String appScopeId;
        private String resourceScope;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("condition");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder directoryScopeId(String directoryScopeId) {
            this.directoryScopeId = directoryScopeId;
            this.changedFields = changedFields.add("directoryScopeId");
            return this;
        }

        public Builder appScopeId(String appScopeId) {
            this.appScopeId = appScopeId;
            this.changedFields = changedFields.add("appScopeId");
            return this;
        }

        public Builder resourceScope(String resourceScope) {
            this.resourceScope = resourceScope;
            this.changedFields = changedFields.add("resourceScope");
            return this;
        }

        public UnifiedRoleAssignment build() {
            UnifiedRoleAssignment _x = new UnifiedRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unifiedRoleAssignment";
            _x.id = id;
            _x.roleDefinitionId = roleDefinitionId;
            _x.condition = condition;
            _x.principalId = principalId;
            _x.directoryScopeId = directoryScopeId;
            _x.appScopeId = appScopeId;
            _x.resourceScope = resourceScope;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public UnifiedRoleAssignment withRoleDefinitionId(String roleDefinitionId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="condition")
    @JsonIgnore
    public Optional<String> getCondition() {
        return Optional.ofNullable(condition);
    }

    public UnifiedRoleAssignment withCondition(String condition) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("condition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.condition = condition;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public UnifiedRoleAssignment withPrincipalId(String principalId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="directoryScopeId")
    @JsonIgnore
    public Optional<String> getDirectoryScopeId() {
        return Optional.ofNullable(directoryScopeId);
    }

    public UnifiedRoleAssignment withDirectoryScopeId(String directoryScopeId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("directoryScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.directoryScopeId = directoryScopeId;
        return _x;
    }

    @Property(name="appScopeId")
    @JsonIgnore
    public Optional<String> getAppScopeId() {
        return Optional.ofNullable(appScopeId);
    }

    public UnifiedRoleAssignment withAppScopeId(String appScopeId) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("appScopeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.appScopeId = appScopeId;
        return _x;
    }

    @Property(name="resourceScope")
    @JsonIgnore
    public Optional<String> getResourceScope() {
        return Optional.ofNullable(resourceScope);
    }

    public UnifiedRoleAssignment withResourceScope(String resourceScope) {
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourceScope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRoleAssignment");
        _x.resourceScope = resourceScope;
        return _x;
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public UnifiedRoleDefinitionRequest getRoleDefinition() {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    @NavigationProperty(name="principal")
    @JsonIgnore
    public DirectoryObjectRequest getPrincipal() {
        return new DirectoryObjectRequest(contextPath.addSegment("principal"));
    }

    @NavigationProperty(name="directoryScope")
    @JsonIgnore
    public DirectoryObjectRequest getDirectoryScope() {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScope"));
    }

    @NavigationProperty(name="appScope")
    @JsonIgnore
    public AppScopeRequest getAppScope() {
        return new AppScopeRequest(contextPath.addSegment("appScope"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UnifiedRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UnifiedRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UnifiedRoleAssignment _copy() {
        UnifiedRoleAssignment _x = new UnifiedRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roleDefinitionId = roleDefinitionId;
        _x.condition = condition;
        _x.principalId = principalId;
        _x.directoryScopeId = directoryScopeId;
        _x.appScopeId = appScopeId;
        _x.resourceScope = resourceScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("condition=");
        b.append(this.condition);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("directoryScopeId=");
        b.append(this.directoryScopeId);
        b.append(", ");
        b.append("appScopeId=");
        b.append(this.appScopeId);
        b.append(", ");
        b.append("resourceScope=");
        b.append(this.resourceScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
