package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.TrustFrameworkKey;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "keys"})
@JsonInclude(Include.NON_NULL)
public class TrustFrameworkKeySet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.trustFrameworkKeySet";
    }

    @JsonProperty("keys")
    protected List<TrustFrameworkKey> keys;

    @JsonProperty("keys@nextLink")
    protected String keysNextLink;

    protected TrustFrameworkKeySet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTrustFrameworkKeySet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<TrustFrameworkKey> keys;
        private String keysNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder keys(List<TrustFrameworkKey> keys) {
            this.keys = keys;
            this.changedFields = changedFields.add("keys");
            return this;
        }

        public Builder keys(TrustFrameworkKey... keys) {
            return keys(Arrays.asList(keys));
        }

        public Builder keysNextLink(String keysNextLink) {
            this.keysNextLink = keysNextLink;
            this.changedFields = changedFields.add("keys");
            return this;
        }

        public TrustFrameworkKeySet build() {
            TrustFrameworkKeySet _x = new TrustFrameworkKeySet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.trustFrameworkKeySet";
            _x.id = id;
            _x.keys = keys;
            _x.keysNextLink = keysNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="keys")
    @JsonIgnore
    public CollectionPage<TrustFrameworkKey> getKeys() {
        return new CollectionPage<TrustFrameworkKey>(contextPath, TrustFrameworkKey.class, keys, Optional.ofNullable(keysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="keys")
    @JsonIgnore
    public CollectionPage<TrustFrameworkKey> getKeys(HttpRequestOptions options) {
        return new CollectionPage<TrustFrameworkKey>(contextPath, TrustFrameworkKey.class, keys, Optional.ofNullable(keysNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TrustFrameworkKeySet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TrustFrameworkKeySet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TrustFrameworkKeySet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TrustFrameworkKeySet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TrustFrameworkKeySet _copy() {
        TrustFrameworkKeySet _x = new TrustFrameworkKeySet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.keys = keys;
        return _x;
    }

    @Action(name = "generateKey")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> generateKey(String use, String kty, Long nbf, Long exp) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("use", "Edm.String", Checks.checkIsAscii(use))
            .put("kty", "Edm.String", Checks.checkIsAscii(kty))
            .put("nbf", "Edm.Int64", nbf)
            .put("exp", "Edm.Int64", exp)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateKey"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadSecret")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadSecret(String use, String k, Long nbf, Long exp) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("use", "Edm.String", Checks.checkIsAscii(use))
            .put("k", "Edm.String", Checks.checkIsAscii(k))
            .put("nbf", "Edm.Int64", nbf)
            .put("exp", "Edm.Int64", exp)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadSecret"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadCertificate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadCertificate(String key) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadCertificate"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "uploadPkcs12")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> uploadPkcs12(String key, String password) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadPkcs12"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getActiveKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey> getActiveKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<TrustFrameworkKey>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActiveKey"), TrustFrameworkKey.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TrustFrameworkKeySet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("keys=");
        b.append(this.keys);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
