package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.enums.ScheduleChangeRequestActor;
import odata.msgraph.client.beta.enums.ScheduleChangeState;

@JsonPropertyOrder({
    "@odata.type", 
    "startDateTime", 
    "endDateTime", 
    "timeOffReasonId"})
@JsonInclude(Include.NON_NULL)
public class TimeOffRequest extends ScheduleChangeRequest implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeOffRequest";
    }

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("timeOffReasonId")
    protected String timeOffReasonId;

    protected TimeOffRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimeOffRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private ScheduleChangeRequestActor assignedTo;
        private ScheduleChangeState state;
        private String senderMessage;
        private OffsetDateTime senderDateTime;
        private String managerActionMessage;
        private OffsetDateTime managerActionDateTime;
        private String senderUserId;
        private String managerUserId;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private String timeOffReasonId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder assignedTo(ScheduleChangeRequestActor assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder state(ScheduleChangeState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder senderMessage(String senderMessage) {
            this.senderMessage = senderMessage;
            this.changedFields = changedFields.add("senderMessage");
            return this;
        }

        public Builder senderDateTime(OffsetDateTime senderDateTime) {
            this.senderDateTime = senderDateTime;
            this.changedFields = changedFields.add("senderDateTime");
            return this;
        }

        public Builder managerActionMessage(String managerActionMessage) {
            this.managerActionMessage = managerActionMessage;
            this.changedFields = changedFields.add("managerActionMessage");
            return this;
        }

        public Builder managerActionDateTime(OffsetDateTime managerActionDateTime) {
            this.managerActionDateTime = managerActionDateTime;
            this.changedFields = changedFields.add("managerActionDateTime");
            return this;
        }

        public Builder senderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
            this.changedFields = changedFields.add("senderUserId");
            return this;
        }

        public Builder managerUserId(String managerUserId) {
            this.managerUserId = managerUserId;
            this.changedFields = changedFields.add("managerUserId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder timeOffReasonId(String timeOffReasonId) {
            this.timeOffReasonId = timeOffReasonId;
            this.changedFields = changedFields.add("timeOffReasonId");
            return this;
        }

        public TimeOffRequest build() {
            TimeOffRequest _x = new TimeOffRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.timeOffRequest";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.assignedTo = assignedTo;
            _x.state = state;
            _x.senderMessage = senderMessage;
            _x.senderDateTime = senderDateTime;
            _x.managerActionMessage = managerActionMessage;
            _x.managerActionDateTime = managerActionDateTime;
            _x.senderUserId = senderUserId;
            _x.managerUserId = managerUserId;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.timeOffReasonId = timeOffReasonId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public TimeOffRequest withStartDateTime(OffsetDateTime startDateTime) {
        TimeOffRequest _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOffRequest");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public TimeOffRequest withEndDateTime(OffsetDateTime endDateTime) {
        TimeOffRequest _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOffRequest");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="timeOffReasonId")
    @JsonIgnore
    public Optional<String> getTimeOffReasonId() {
        return Optional.ofNullable(timeOffReasonId);
    }

    public TimeOffRequest withTimeOffReasonId(String timeOffReasonId) {
        TimeOffRequest _x = _copy();
        _x.changedFields = changedFields.add("timeOffReasonId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOffRequest");
        _x.timeOffReasonId = timeOffReasonId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeOffRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TimeOffRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeOffRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TimeOffRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TimeOffRequest _copy() {
        TimeOffRequest _x = new TimeOffRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.assignedTo = assignedTo;
        _x.state = state;
        _x.senderMessage = senderMessage;
        _x.senderDateTime = senderDateTime;
        _x.managerActionMessage = managerActionMessage;
        _x.managerActionDateTime = managerActionDateTime;
        _x.senderUserId = senderUserId;
        _x.managerUserId = managerUserId;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.timeOffReasonId = timeOffReasonId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeOffRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("senderMessage=");
        b.append(this.senderMessage);
        b.append(", ");
        b.append("senderDateTime=");
        b.append(this.senderDateTime);
        b.append(", ");
        b.append("managerActionMessage=");
        b.append(this.managerActionMessage);
        b.append(", ");
        b.append("managerActionDateTime=");
        b.append(this.managerActionDateTime);
        b.append(", ");
        b.append("senderUserId=");
        b.append(this.senderUserId);
        b.append(", ");
        b.append("managerUserId=");
        b.append(this.managerUserId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("timeOffReasonId=");
        b.append(this.timeOffReasonId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
