package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.TimeOffItem;

@JsonPropertyOrder({
    "@odata.type", 
    "sharedTimeOff", 
    "draftTimeOff", 
    "userId", 
    "isStagedForDeletion"})
@JsonInclude(Include.NON_NULL)
public class TimeOff extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeOff";
    }

    @JsonProperty("sharedTimeOff")
    protected TimeOffItem sharedTimeOff;

    @JsonProperty("draftTimeOff")
    protected TimeOffItem draftTimeOff;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("isStagedForDeletion")
    protected Boolean isStagedForDeletion;

    protected TimeOff() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimeOff() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private TimeOffItem sharedTimeOff;
        private TimeOffItem draftTimeOff;
        private String userId;
        private Boolean isStagedForDeletion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder sharedTimeOff(TimeOffItem sharedTimeOff) {
            this.sharedTimeOff = sharedTimeOff;
            this.changedFields = changedFields.add("sharedTimeOff");
            return this;
        }

        public Builder draftTimeOff(TimeOffItem draftTimeOff) {
            this.draftTimeOff = draftTimeOff;
            this.changedFields = changedFields.add("draftTimeOff");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder isStagedForDeletion(Boolean isStagedForDeletion) {
            this.isStagedForDeletion = isStagedForDeletion;
            this.changedFields = changedFields.add("isStagedForDeletion");
            return this;
        }

        public TimeOff build() {
            TimeOff _x = new TimeOff();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.timeOff";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.sharedTimeOff = sharedTimeOff;
            _x.draftTimeOff = draftTimeOff;
            _x.userId = userId;
            _x.isStagedForDeletion = isStagedForDeletion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="sharedTimeOff")
    @JsonIgnore
    public Optional<TimeOffItem> getSharedTimeOff() {
        return Optional.ofNullable(sharedTimeOff);
    }

    public TimeOff withSharedTimeOff(TimeOffItem sharedTimeOff) {
        TimeOff _x = _copy();
        _x.changedFields = changedFields.add("sharedTimeOff");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOff");
        _x.sharedTimeOff = sharedTimeOff;
        return _x;
    }

    @Property(name="draftTimeOff")
    @JsonIgnore
    public Optional<TimeOffItem> getDraftTimeOff() {
        return Optional.ofNullable(draftTimeOff);
    }

    public TimeOff withDraftTimeOff(TimeOffItem draftTimeOff) {
        TimeOff _x = _copy();
        _x.changedFields = changedFields.add("draftTimeOff");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOff");
        _x.draftTimeOff = draftTimeOff;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public TimeOff withUserId(String userId) {
        TimeOff _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOff");
        _x.userId = userId;
        return _x;
    }

    @Property(name="isStagedForDeletion")
    @JsonIgnore
    public Optional<Boolean> getIsStagedForDeletion() {
        return Optional.ofNullable(isStagedForDeletion);
    }

    public TimeOff withIsStagedForDeletion(Boolean isStagedForDeletion) {
        TimeOff _x = _copy();
        _x.changedFields = changedFields.add("isStagedForDeletion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeOff");
        _x.isStagedForDeletion = isStagedForDeletion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeOff patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TimeOff _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TimeOff put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TimeOff _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TimeOff _copy() {
        TimeOff _x = new TimeOff();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.sharedTimeOff = sharedTimeOff;
        _x.draftTimeOff = draftTimeOff;
        _x.userId = userId;
        _x.isStagedForDeletion = isStagedForDeletion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeOff[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("sharedTimeOff=");
        b.append(this.sharedTimeOff);
        b.append(", ");
        b.append("draftTimeOff=");
        b.append(this.draftTimeOff);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("isStagedForDeletion=");
        b.append(this.isStagedForDeletion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
