package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.Thumbnail;

@JsonPropertyOrder({
    "@odata.type", 
    "large", 
    "medium", 
    "small", 
    "source"})
@JsonInclude(Include.NON_NULL)
public class ThumbnailSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.thumbnailSet";
    }

    @JsonProperty("large")
    protected Thumbnail large;

    @JsonProperty("medium")
    protected Thumbnail medium;

    @JsonProperty("small")
    protected Thumbnail small;

    @JsonProperty("source")
    protected Thumbnail source;

    protected ThumbnailSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderThumbnailSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Thumbnail large;
        private Thumbnail medium;
        private Thumbnail small;
        private Thumbnail source;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder large(Thumbnail large) {
            this.large = large;
            this.changedFields = changedFields.add("large");
            return this;
        }

        public Builder medium(Thumbnail medium) {
            this.medium = medium;
            this.changedFields = changedFields.add("medium");
            return this;
        }

        public Builder small(Thumbnail small) {
            this.small = small;
            this.changedFields = changedFields.add("small");
            return this;
        }

        public Builder source(Thumbnail source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public ThumbnailSet build() {
            ThumbnailSet _x = new ThumbnailSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.thumbnailSet";
            _x.id = id;
            _x.large = large;
            _x.medium = medium;
            _x.small = small;
            _x.source = source;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="large")
    @JsonIgnore
    public Optional<Thumbnail> getLarge() {
        return Optional.ofNullable(large);
    }

    public ThumbnailSet withLarge(Thumbnail large) {
        ThumbnailSet _x = _copy();
        _x.changedFields = changedFields.add("large");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.thumbnailSet");
        _x.large = large;
        return _x;
    }

    @Property(name="medium")
    @JsonIgnore
    public Optional<Thumbnail> getMedium() {
        return Optional.ofNullable(medium);
    }

    public ThumbnailSet withMedium(Thumbnail medium) {
        ThumbnailSet _x = _copy();
        _x.changedFields = changedFields.add("medium");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.thumbnailSet");
        _x.medium = medium;
        return _x;
    }

    @Property(name="small")
    @JsonIgnore
    public Optional<Thumbnail> getSmall() {
        return Optional.ofNullable(small);
    }

    public ThumbnailSet withSmall(Thumbnail small) {
        ThumbnailSet _x = _copy();
        _x.changedFields = changedFields.add("small");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.thumbnailSet");
        _x.small = small;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<Thumbnail> getSource() {
        return Optional.ofNullable(source);
    }

    public ThumbnailSet withSource(Thumbnail source) {
        ThumbnailSet _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.thumbnailSet");
        _x.source = source;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThumbnailSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ThumbnailSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThumbnailSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ThumbnailSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ThumbnailSet _copy() {
        ThumbnailSet _x = new ThumbnailSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.large = large;
        _x.medium = medium;
        _x.small = small;
        _x.source = source;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ThumbnailSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("large=");
        b.append(this.large);
        b.append(", ");
        b.append("medium=");
        b.append(this.medium);
        b.append(", ");
        b.append("small=");
        b.append(this.small);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
