package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ThreatAssessmentResultType;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "resultType", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class ThreatAssessmentResult extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.threatAssessmentResult";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("resultType")
    protected ThreatAssessmentResultType resultType;

    @JsonProperty("message")
    protected String message;

    protected ThreatAssessmentResult() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderThreatAssessmentResult() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private ThreatAssessmentResultType resultType;
        private String message;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder resultType(ThreatAssessmentResultType resultType) {
            this.resultType = resultType;
            this.changedFields = changedFields.add("resultType");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public ThreatAssessmentResult build() {
            ThreatAssessmentResult _x = new ThreatAssessmentResult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.threatAssessmentResult";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.resultType = resultType;
            _x.message = message;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ThreatAssessmentResult withCreatedDateTime(OffsetDateTime createdDateTime) {
        ThreatAssessmentResult _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentResult");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="resultType")
    @JsonIgnore
    public Optional<ThreatAssessmentResultType> getResultType() {
        return Optional.ofNullable(resultType);
    }

    public ThreatAssessmentResult withResultType(ThreatAssessmentResultType resultType) {
        ThreatAssessmentResult _x = _copy();
        _x.changedFields = changedFields.add("resultType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentResult");
        _x.resultType = resultType;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public ThreatAssessmentResult withMessage(String message) {
        ThreatAssessmentResult _x = _copy();
        _x.changedFields = changedFields.add("message");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentResult");
        _x.message = message;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThreatAssessmentResult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ThreatAssessmentResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThreatAssessmentResult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ThreatAssessmentResult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ThreatAssessmentResult _copy() {
        ThreatAssessmentResult _x = new ThreatAssessmentResult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.resultType = resultType;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ThreatAssessmentResult[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("resultType=");
        b.append(this.resultType);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
