package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentResultCollectionRequest;
import odata.msgraph.client.beta.enums.ThreatAssessmentContentType;
import odata.msgraph.client.beta.enums.ThreatAssessmentRequestSource;
import odata.msgraph.client.beta.enums.ThreatAssessmentStatus;
import odata.msgraph.client.beta.enums.ThreatCategory;
import odata.msgraph.client.beta.enums.ThreatExpectedAssessment;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "contentType", 
    "expectedAssessment", 
    "category", 
    "status", 
    "requestSource", 
    "createdBy"})
@JsonInclude(Include.NON_NULL)
public class ThreatAssessmentRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.threatAssessmentRequest";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("contentType")
    protected ThreatAssessmentContentType contentType;

    @JsonProperty("expectedAssessment")
    protected ThreatExpectedAssessment expectedAssessment;

    @JsonProperty("category")
    protected ThreatCategory category;

    @JsonProperty("status")
    protected ThreatAssessmentStatus status;

    @JsonProperty("requestSource")
    protected ThreatAssessmentRequestSource requestSource;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    protected ThreatAssessmentRequest() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ThreatAssessmentRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<ThreatAssessmentContentType> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public ThreatAssessmentRequest withContentType(ThreatAssessmentContentType contentType) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("contentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="expectedAssessment")
    @JsonIgnore
    public Optional<ThreatExpectedAssessment> getExpectedAssessment() {
        return Optional.ofNullable(expectedAssessment);
    }

    public ThreatAssessmentRequest withExpectedAssessment(ThreatExpectedAssessment expectedAssessment) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("expectedAssessment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.expectedAssessment = expectedAssessment;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<ThreatCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public ThreatAssessmentRequest withCategory(ThreatCategory category) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.category = category;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ThreatAssessmentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ThreatAssessmentRequest withStatus(ThreatAssessmentStatus status) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.status = status;
        return _x;
    }

    @Property(name="requestSource")
    @JsonIgnore
    public Optional<ThreatAssessmentRequestSource> getRequestSource() {
        return Optional.ofNullable(requestSource);
    }

    public ThreatAssessmentRequest withRequestSource(ThreatAssessmentRequestSource requestSource) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.requestSource = requestSource;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public ThreatAssessmentRequest withCreatedBy(IdentitySet createdBy) {
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequest");
        _x.createdBy = createdBy;
        return _x;
    }

    @NavigationProperty(name="results")
    @JsonIgnore
    public ThreatAssessmentResultCollectionRequest getResults() {
        return new ThreatAssessmentResultCollectionRequest(
                        contextPath.addSegment("results"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThreatAssessmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ThreatAssessmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ThreatAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ThreatAssessmentRequest _copy() {
        ThreatAssessmentRequest _x = new ThreatAssessmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.contentType = contentType;
        _x.expectedAssessment = expectedAssessment;
        _x.category = category;
        _x.status = status;
        _x.requestSource = requestSource;
        _x.createdBy = createdBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ThreatAssessmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("expectedAssessment=");
        b.append(this.expectedAssessment);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("requestSource=");
        b.append(this.requestSource);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
