package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SensitiveTypeScope;

@JsonPropertyOrder({
    "@odata.type", 
    "text", 
    "fileExtension", 
    "sensitiveTypeIds", 
    "scopesToRun"})
@JsonInclude(Include.NON_NULL)
public class TextClassificationRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.textClassificationRequest";
    }

    @JsonProperty("text")
    protected String text;

    @JsonProperty("fileExtension")
    protected String fileExtension;

    @JsonProperty("sensitiveTypeIds")
    protected List<String> sensitiveTypeIds;

    @JsonProperty("sensitiveTypeIds@nextLink")
    protected String sensitiveTypeIdsNextLink;

    @JsonProperty("scopesToRun")
    protected SensitiveTypeScope scopesToRun;

    protected TextClassificationRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTextClassificationRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String text;
        private String fileExtension;
        private List<String> sensitiveTypeIds;
        private String sensitiveTypeIdsNextLink;
        private SensitiveTypeScope scopesToRun;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder fileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            this.changedFields = changedFields.add("fileExtension");
            return this;
        }

        public Builder sensitiveTypeIds(List<String> sensitiveTypeIds) {
            this.sensitiveTypeIds = sensitiveTypeIds;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder sensitiveTypeIds(String... sensitiveTypeIds) {
            return sensitiveTypeIds(Arrays.asList(sensitiveTypeIds));
        }

        public Builder sensitiveTypeIdsNextLink(String sensitiveTypeIdsNextLink) {
            this.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder scopesToRun(SensitiveTypeScope scopesToRun) {
            this.scopesToRun = scopesToRun;
            this.changedFields = changedFields.add("scopesToRun");
            return this;
        }

        public TextClassificationRequest build() {
            TextClassificationRequest _x = new TextClassificationRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.textClassificationRequest";
            _x.id = id;
            _x.text = text;
            _x.fileExtension = fileExtension;
            _x.sensitiveTypeIds = sensitiveTypeIds;
            _x.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            _x.scopesToRun = scopesToRun;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public TextClassificationRequest withText(String text) {
        TextClassificationRequest _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textClassificationRequest");
        _x.text = text;
        return _x;
    }

    @Property(name="fileExtension")
    @JsonIgnore
    public Optional<String> getFileExtension() {
        return Optional.ofNullable(fileExtension);
    }

    public TextClassificationRequest withFileExtension(String fileExtension) {
        TextClassificationRequest _x = _copy();
        _x.changedFields = changedFields.add("fileExtension");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textClassificationRequest");
        _x.fileExtension = fileExtension;
        return _x;
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds() {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="scopesToRun")
    @JsonIgnore
    public Optional<SensitiveTypeScope> getScopesToRun() {
        return Optional.ofNullable(scopesToRun);
    }

    public TextClassificationRequest withScopesToRun(SensitiveTypeScope scopesToRun) {
        TextClassificationRequest _x = _copy();
        _x.changedFields = changedFields.add("scopesToRun");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textClassificationRequest");
        _x.scopesToRun = scopesToRun;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TextClassificationRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TextClassificationRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TextClassificationRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TextClassificationRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TextClassificationRequest _copy() {
        TextClassificationRequest _x = new TextClassificationRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.text = text;
        _x.fileExtension = fileExtension;
        _x.sensitiveTypeIds = sensitiveTypeIds;
        _x.scopesToRun = scopesToRun;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TextClassificationRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("fileExtension=");
        b.append(this.fileExtension);
        b.append(", ");
        b.append("sensitiveTypeIds=");
        b.append(this.sensitiveTypeIds);
        b.append(", ");
        b.append("scopesToRun=");
        b.append(this.scopesToRun);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
