package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.request.TermsAndConditionsRequest;


/**
 * <i>“A termsAndConditionsGroupAssignment entity represents the assignment of a given
 * Terms and Conditions (T&amp;C) policy to a given group. Users in the group will be
 * required to accept the terms in order to have devices enrolled into Intune.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "targetGroupId"})
@JsonInclude(Include.NON_NULL)
public class TermsAndConditionsGroupAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termsAndConditionsGroupAssignment";
    }

    @JsonProperty("targetGroupId")
    protected String targetGroupId;

    protected TermsAndConditionsGroupAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTermsAndConditionsGroupAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String targetGroupId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Unique identifier of a group that the T&amp;C policy is assigned to.”</i>
         * 
         * @param targetGroupId
         *            value of {@code targetGroupId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupId(String targetGroupId) {
            this.targetGroupId = targetGroupId;
            this.changedFields = changedFields.add("targetGroupId");
            return this;
        }

        public TermsAndConditionsGroupAssignment build() {
            TermsAndConditionsGroupAssignment _x = new TermsAndConditionsGroupAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.termsAndConditionsGroupAssignment";
            _x.id = id;
            _x.targetGroupId = targetGroupId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Unique identifier of a group that the T&amp;C policy is assigned to.”</i>
     * 
     * @return property targetGroupId
     */
    @Property(name="targetGroupId")
    @JsonIgnore
    public Optional<String> getTargetGroupId() {
        return Optional.ofNullable(targetGroupId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetGroupId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Unique identifier of a group that the T&amp;C policy is assigned to.”</i>
     * 
     * @param targetGroupId
     *            new value of {@code targetGroupId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetGroupId} field changed
     */
    public TermsAndConditionsGroupAssignment withTargetGroupId(String targetGroupId) {
        TermsAndConditionsGroupAssignment _x = _copy();
        _x.changedFields = changedFields.add("targetGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditionsGroupAssignment");
        _x.targetGroupId = targetGroupId;
        return _x;
    }

    /**
     * <i>“Navigation link to the terms and conditions that are assigned.”</i>
     * 
     * @return navigational property termsAndConditions
     */
    @NavigationProperty(name="termsAndConditions")
    @JsonIgnore
    public TermsAndConditionsRequest getTermsAndConditions() {
        return new TermsAndConditionsRequest(contextPath.addSegment("termsAndConditions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditionsGroupAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditionsGroupAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditionsGroupAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditionsGroupAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TermsAndConditionsGroupAssignment _copy() {
        TermsAndConditionsGroupAssignment _x = new TermsAndConditionsGroupAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.targetGroupId = targetGroupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermsAndConditionsGroupAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetGroupId=");
        b.append(this.targetGroupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
