package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.TermsAndConditionsRequest;


/**
 * <i>“A termsAndConditionsAcceptanceStatus entity represents the acceptance status of
 * a given Terms and Conditions (T&amp;C) policy by a given user. Users must accept the
 * most up-to-date version of the terms in order to retain access to the Company
 * Portal.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userDisplayName", 
    "acceptedVersion", 
    "acceptedDateTime", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class TermsAndConditionsAcceptanceStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termsAndConditionsAcceptanceStatus";
    }

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("acceptedVersion")
    protected Integer acceptedVersion;

    @JsonProperty("acceptedDateTime")
    protected OffsetDateTime acceptedDateTime;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected TermsAndConditionsAcceptanceStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTermsAndConditionsAcceptanceStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userDisplayName;
        private Integer acceptedVersion;
        private OffsetDateTime acceptedDateTime;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Display name of the user whose acceptance the entity represents.”</i>
         * 
         * @param userDisplayName
         *            value of {@code userDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        /**
         * <i>“Most recent version number of the T&amp;C accepted by the user.”</i>
         * 
         * @param acceptedVersion
         *            value of {@code acceptedVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder acceptedVersion(Integer acceptedVersion) {
            this.acceptedVersion = acceptedVersion;
            this.changedFields = changedFields.add("acceptedVersion");
            return this;
        }

        /**
         * <i>“DateTime when the terms were last accepted by the user.”</i>
         * 
         * @param acceptedDateTime
         *            value of {@code acceptedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder acceptedDateTime(OffsetDateTime acceptedDateTime) {
            this.acceptedDateTime = acceptedDateTime;
            this.changedFields = changedFields.add("acceptedDateTime");
            return this;
        }

        /**
         * <i>“The userPrincipalName of the User that accepted the term.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public TermsAndConditionsAcceptanceStatus build() {
            TermsAndConditionsAcceptanceStatus _x = new TermsAndConditionsAcceptanceStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.termsAndConditionsAcceptanceStatus";
            _x.id = id;
            _x.userDisplayName = userDisplayName;
            _x.acceptedVersion = acceptedVersion;
            _x.acceptedDateTime = acceptedDateTime;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Display name of the user whose acceptance the entity represents.”</i>
     * 
     * @return property userDisplayName
     */
    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name of the user whose acceptance the entity represents.”</i>
     * 
     * @param userDisplayName
     *            new value of {@code userDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDisplayName} field changed
     */
    public TermsAndConditionsAcceptanceStatus withUserDisplayName(String userDisplayName) {
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditionsAcceptanceStatus");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    /**
     * <i>“Most recent version number of the T&amp;C accepted by the user.”</i>
     * 
     * @return property acceptedVersion
     */
    @Property(name="acceptedVersion")
    @JsonIgnore
    public Optional<Integer> getAcceptedVersion() {
        return Optional.ofNullable(acceptedVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code acceptedVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Most recent version number of the T&amp;C accepted by the user.”</i>
     * 
     * @param acceptedVersion
     *            new value of {@code acceptedVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code acceptedVersion} field changed
     */
    public TermsAndConditionsAcceptanceStatus withAcceptedVersion(Integer acceptedVersion) {
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = changedFields.add("acceptedVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditionsAcceptanceStatus");
        _x.acceptedVersion = acceptedVersion;
        return _x;
    }

    /**
     * <i>“DateTime when the terms were last accepted by the user.”</i>
     * 
     * @return property acceptedDateTime
     */
    @Property(name="acceptedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAcceptedDateTime() {
        return Optional.ofNullable(acceptedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code acceptedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime when the terms were last accepted by the user.”</i>
     * 
     * @param acceptedDateTime
     *            new value of {@code acceptedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code acceptedDateTime} field changed
     */
    public TermsAndConditionsAcceptanceStatus withAcceptedDateTime(OffsetDateTime acceptedDateTime) {
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = changedFields.add("acceptedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditionsAcceptanceStatus");
        _x.acceptedDateTime = acceptedDateTime;
        return _x;
    }

    /**
     * <i>“The userPrincipalName of the User that accepted the term.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The userPrincipalName of the User that accepted the term.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public TermsAndConditionsAcceptanceStatus withUserPrincipalName(String userPrincipalName) {
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termsAndConditionsAcceptanceStatus");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Navigation link to the terms and conditions that are assigned.”</i>
     * 
     * @return navigational property termsAndConditions
     */
    @NavigationProperty(name="termsAndConditions")
    @JsonIgnore
    public TermsAndConditionsRequest getTermsAndConditions() {
        return new TermsAndConditionsRequest(contextPath.addSegment("termsAndConditions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditionsAcceptanceStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TermsAndConditionsAcceptanceStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TermsAndConditionsAcceptanceStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TermsAndConditionsAcceptanceStatus _copy() {
        TermsAndConditionsAcceptanceStatus _x = new TermsAndConditionsAcceptanceStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userDisplayName = userDisplayName;
        _x.acceptedVersion = acceptedVersion;
        _x.acceptedDateTime = acceptedDateTime;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermsAndConditionsAcceptanceStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("acceptedVersion=");
        b.append(this.acceptedVersion);
        b.append(", ");
        b.append("acceptedDateTime=");
        b.append(this.acceptedDateTime);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
