package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“telecomExpenseManagementPartner resources represent the metadata and status of a
 * given TEM service. Once your organization has onboarded with a partner, the
 * partner can be enabled or disabled to switch TEM functionality on or off.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "url", 
    "appAuthorized", 
    "enabled", 
    "lastConnectionDateTime"})
@JsonInclude(Include.NON_NULL)
public class TelecomExpenseManagementPartner extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.telecomExpenseManagementPartner";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("appAuthorized")
    protected Boolean appAuthorized;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("lastConnectionDateTime")
    protected OffsetDateTime lastConnectionDateTime;

    protected TelecomExpenseManagementPartner() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTelecomExpenseManagementPartner() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String url;
        private Boolean appAuthorized;
        private Boolean enabled;
        private OffsetDateTime lastConnectionDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Display name of the TEM partner.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“URL of the TEM partner's administrative control panel, where an administrator
         * can configure their TEM service.”</i>
         * 
         * @param url
         *            value of {@code url} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        /**
         * <i>“Whether the partner's AAD app has been authorized to access Intune.”</i>
         * 
         * @param appAuthorized
         *            value of {@code appAuthorized} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appAuthorized(Boolean appAuthorized) {
            this.appAuthorized = appAuthorized;
            this.changedFields = changedFields.add("appAuthorized");
            return this;
        }

        /**
         * <i>“Whether Intune's connection to the TEM service is currently enabled or disabled.”</i>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
         * 
         * @param lastConnectionDateTime
         *            value of {@code lastConnectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
            this.lastConnectionDateTime = lastConnectionDateTime;
            this.changedFields = changedFields.add("lastConnectionDateTime");
            return this;
        }

        public TelecomExpenseManagementPartner build() {
            TelecomExpenseManagementPartner _x = new TelecomExpenseManagementPartner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.telecomExpenseManagementPartner";
            _x.id = id;
            _x.displayName = displayName;
            _x.url = url;
            _x.appAuthorized = appAuthorized;
            _x.enabled = enabled;
            _x.lastConnectionDateTime = lastConnectionDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Display name of the TEM partner.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name of the TEM partner.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public TelecomExpenseManagementPartner withDisplayName(String displayName) {
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.telecomExpenseManagementPartner");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“URL of the TEM partner's administrative control panel, where an administrator
     * can configure their TEM service.”</i>
     * 
     * @return property url
     */
    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code url} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“URL of the TEM partner's administrative control panel, where an administrator
     * can configure their TEM service.”</i>
     * 
     * @param url
     *            new value of {@code url} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code url} field changed
     */
    public TelecomExpenseManagementPartner withUrl(String url) {
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.telecomExpenseManagementPartner");
        _x.url = url;
        return _x;
    }

    /**
     * <i>“Whether the partner's AAD app has been authorized to access Intune.”</i>
     * 
     * @return property appAuthorized
     */
    @Property(name="appAuthorized")
    @JsonIgnore
    public Optional<Boolean> getAppAuthorized() {
        return Optional.ofNullable(appAuthorized);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appAuthorized}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the partner's AAD app has been authorized to access Intune.”</i>
     * 
     * @param appAuthorized
     *            new value of {@code appAuthorized} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appAuthorized} field changed
     */
    public TelecomExpenseManagementPartner withAppAuthorized(Boolean appAuthorized) {
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("appAuthorized");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.telecomExpenseManagementPartner");
        _x.appAuthorized = appAuthorized;
        return _x;
    }

    /**
     * <i>“Whether Intune's connection to the TEM service is currently enabled or disabled.”</i>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether Intune's connection to the TEM service is currently enabled or disabled.”</i>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public TelecomExpenseManagementPartner withEnabled(Boolean enabled) {
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.telecomExpenseManagementPartner");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
     * 
     * @return property lastConnectionDateTime
     */
    @Property(name="lastConnectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectionDateTime() {
        return Optional.ofNullable(lastConnectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastConnectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Timestamp of the last request sent to Intune by the TEM partner.”</i>
     * 
     * @param lastConnectionDateTime
     *            new value of {@code lastConnectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastConnectionDateTime} field changed
     */
    public TelecomExpenseManagementPartner withLastConnectionDateTime(OffsetDateTime lastConnectionDateTime) {
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = changedFields.add("lastConnectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.telecomExpenseManagementPartner");
        _x.lastConnectionDateTime = lastConnectionDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TelecomExpenseManagementPartner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TelecomExpenseManagementPartner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TelecomExpenseManagementPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TelecomExpenseManagementPartner _copy() {
        TelecomExpenseManagementPartner _x = new TelecomExpenseManagementPartner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.url = url;
        _x.appAuthorized = appAuthorized;
        _x.enabled = enabled;
        _x.lastConnectionDateTime = lastConnectionDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TelecomExpenseManagementPartner[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("appAuthorized=");
        b.append(this.appAuthorized);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("lastConnectionDateTime=");
        b.append(this.lastConnectionDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
