package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "lastActivityDate", 
    "isDeleted", 
    "deletedDate", 
    "assignedProducts", 
    "teamChatMessageCount", 
    "privateChatMessageCount", 
    "callCount", 
    "meetingCount", 
    "hasOtherAction", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class TeamsUserActivityUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsUserActivityUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("teamChatMessageCount")
    protected Long teamChatMessageCount;

    @JsonProperty("privateChatMessageCount")
    protected Long privateChatMessageCount;

    @JsonProperty("callCount")
    protected Long callCount;

    @JsonProperty("meetingCount")
    protected Long meetingCount;

    @JsonProperty("hasOtherAction")
    protected Boolean hasOtherAction;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected TeamsUserActivityUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsUserActivityUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private LocalDate lastActivityDate;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private Long teamChatMessageCount;
        private Long privateChatMessageCount;
        private Long callCount;
        private Long meetingCount;
        private Boolean hasOtherAction;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder teamChatMessageCount(Long teamChatMessageCount) {
            this.teamChatMessageCount = teamChatMessageCount;
            this.changedFields = changedFields.add("teamChatMessageCount");
            return this;
        }

        public Builder privateChatMessageCount(Long privateChatMessageCount) {
            this.privateChatMessageCount = privateChatMessageCount;
            this.changedFields = changedFields.add("privateChatMessageCount");
            return this;
        }

        public Builder callCount(Long callCount) {
            this.callCount = callCount;
            this.changedFields = changedFields.add("callCount");
            return this;
        }

        public Builder meetingCount(Long meetingCount) {
            this.meetingCount = meetingCount;
            this.changedFields = changedFields.add("meetingCount");
            return this;
        }

        public Builder hasOtherAction(Boolean hasOtherAction) {
            this.hasOtherAction = hasOtherAction;
            this.changedFields = changedFields.add("hasOtherAction");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public TeamsUserActivityUserDetail build() {
            TeamsUserActivityUserDetail _x = new TeamsUserActivityUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamsUserActivityUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.lastActivityDate = lastActivityDate;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.teamChatMessageCount = teamChatMessageCount;
            _x.privateChatMessageCount = privateChatMessageCount;
            _x.callCount = callCount;
            _x.meetingCount = meetingCount;
            _x.hasOtherAction = hasOtherAction;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public TeamsUserActivityUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public TeamsUserActivityUserDetail withUserPrincipalName(String userPrincipalName) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public TeamsUserActivityUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public TeamsUserActivityUserDetail withIsDeleted(Boolean isDeleted) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public TeamsUserActivityUserDetail withDeletedDate(LocalDate deletedDate) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="teamChatMessageCount")
    @JsonIgnore
    public Optional<Long> getTeamChatMessageCount() {
        return Optional.ofNullable(teamChatMessageCount);
    }

    public TeamsUserActivityUserDetail withTeamChatMessageCount(Long teamChatMessageCount) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("teamChatMessageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.teamChatMessageCount = teamChatMessageCount;
        return _x;
    }

    @Property(name="privateChatMessageCount")
    @JsonIgnore
    public Optional<Long> getPrivateChatMessageCount() {
        return Optional.ofNullable(privateChatMessageCount);
    }

    public TeamsUserActivityUserDetail withPrivateChatMessageCount(Long privateChatMessageCount) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("privateChatMessageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.privateChatMessageCount = privateChatMessageCount;
        return _x;
    }

    @Property(name="callCount")
    @JsonIgnore
    public Optional<Long> getCallCount() {
        return Optional.ofNullable(callCount);
    }

    public TeamsUserActivityUserDetail withCallCount(Long callCount) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("callCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.callCount = callCount;
        return _x;
    }

    @Property(name="meetingCount")
    @JsonIgnore
    public Optional<Long> getMeetingCount() {
        return Optional.ofNullable(meetingCount);
    }

    public TeamsUserActivityUserDetail withMeetingCount(Long meetingCount) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("meetingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.meetingCount = meetingCount;
        return _x;
    }

    @Property(name="hasOtherAction")
    @JsonIgnore
    public Optional<Boolean> getHasOtherAction() {
        return Optional.ofNullable(hasOtherAction);
    }

    public TeamsUserActivityUserDetail withHasOtherAction(Boolean hasOtherAction) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("hasOtherAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.hasOtherAction = hasOtherAction;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public TeamsUserActivityUserDetail withReportPeriod(String reportPeriod) {
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsUserActivityUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsUserActivityUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsUserActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsUserActivityUserDetail _copy() {
        TeamsUserActivityUserDetail _x = new TeamsUserActivityUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.lastActivityDate = lastActivityDate;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.assignedProducts = assignedProducts;
        _x.teamChatMessageCount = teamChatMessageCount;
        _x.privateChatMessageCount = privateChatMessageCount;
        _x.callCount = callCount;
        _x.meetingCount = meetingCount;
        _x.hasOtherAction = hasOtherAction;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsUserActivityUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("teamChatMessageCount=");
        b.append(this.teamChatMessageCount);
        b.append(", ");
        b.append("privateChatMessageCount=");
        b.append(this.privateChatMessageCount);
        b.append(", ");
        b.append("callCount=");
        b.append(this.callCount);
        b.append(", ");
        b.append("meetingCount=");
        b.append(this.meetingCount);
        b.append(", ");
        b.append("hasOtherAction=");
        b.append(this.hasOtherAction);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
