package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "reportDate", 
    "teamChatMessages", 
    "privateChatMessages", 
    "calls", 
    "meetings", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class TeamsUserActivityCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsUserActivityCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("teamChatMessages")
    protected Long teamChatMessages;

    @JsonProperty("privateChatMessages")
    protected Long privateChatMessages;

    @JsonProperty("calls")
    protected Long calls;

    @JsonProperty("meetings")
    protected Long meetings;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected TeamsUserActivityCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsUserActivityCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private LocalDate reportDate;
        private Long teamChatMessages;
        private Long privateChatMessages;
        private Long calls;
        private Long meetings;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder teamChatMessages(Long teamChatMessages) {
            this.teamChatMessages = teamChatMessages;
            this.changedFields = changedFields.add("teamChatMessages");
            return this;
        }

        public Builder privateChatMessages(Long privateChatMessages) {
            this.privateChatMessages = privateChatMessages;
            this.changedFields = changedFields.add("privateChatMessages");
            return this;
        }

        public Builder calls(Long calls) {
            this.calls = calls;
            this.changedFields = changedFields.add("calls");
            return this;
        }

        public Builder meetings(Long meetings) {
            this.meetings = meetings;
            this.changedFields = changedFields.add("meetings");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public TeamsUserActivityCounts build() {
            TeamsUserActivityCounts _x = new TeamsUserActivityCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamsUserActivityCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.reportDate = reportDate;
            _x.teamChatMessages = teamChatMessages;
            _x.privateChatMessages = privateChatMessages;
            _x.calls = calls;
            _x.meetings = meetings;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public TeamsUserActivityCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public TeamsUserActivityCounts withReportDate(LocalDate reportDate) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="teamChatMessages")
    @JsonIgnore
    public Optional<Long> getTeamChatMessages() {
        return Optional.ofNullable(teamChatMessages);
    }

    public TeamsUserActivityCounts withTeamChatMessages(Long teamChatMessages) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("teamChatMessages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.teamChatMessages = teamChatMessages;
        return _x;
    }

    @Property(name="privateChatMessages")
    @JsonIgnore
    public Optional<Long> getPrivateChatMessages() {
        return Optional.ofNullable(privateChatMessages);
    }

    public TeamsUserActivityCounts withPrivateChatMessages(Long privateChatMessages) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("privateChatMessages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.privateChatMessages = privateChatMessages;
        return _x;
    }

    @Property(name="calls")
    @JsonIgnore
    public Optional<Long> getCalls() {
        return Optional.ofNullable(calls);
    }

    public TeamsUserActivityCounts withCalls(Long calls) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("calls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.calls = calls;
        return _x;
    }

    @Property(name="meetings")
    @JsonIgnore
    public Optional<Long> getMeetings() {
        return Optional.ofNullable(meetings);
    }

    public TeamsUserActivityCounts withMeetings(Long meetings) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("meetings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.meetings = meetings;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public TeamsUserActivityCounts withReportPeriod(String reportPeriod) {
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsUserActivityCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsUserActivityCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsUserActivityCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsUserActivityCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsUserActivityCounts _copy() {
        TeamsUserActivityCounts _x = new TeamsUserActivityCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.reportDate = reportDate;
        _x.teamChatMessages = teamChatMessages;
        _x.privateChatMessages = privateChatMessages;
        _x.calls = calls;
        _x.meetings = meetings;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsUserActivityCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("teamChatMessages=");
        b.append(this.teamChatMessages);
        b.append(", ");
        b.append("privateChatMessages=");
        b.append(this.privateChatMessages);
        b.append(", ");
        b.append("calls=");
        b.append(this.calls);
        b.append(", ");
        b.append("meetings=");
        b.append(this.meetings);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
