package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "lastActivityDate", 
    "isDeleted", 
    "deletedDate", 
    "usedWeb", 
    "usedWindowsPhone", 
    "usediOS", 
    "usedMac", 
    "usedAndroidPhone", 
    "usedWindows", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class TeamsDeviceUsageUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsDeviceUsageUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("usedWeb")
    protected Boolean usedWeb;

    @JsonProperty("usedWindowsPhone")
    protected Boolean usedWindowsPhone;

    @JsonProperty("usediOS")
    protected Boolean usediOS;

    @JsonProperty("usedMac")
    protected Boolean usedMac;

    @JsonProperty("usedAndroidPhone")
    protected Boolean usedAndroidPhone;

    @JsonProperty("usedWindows")
    protected Boolean usedWindows;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected TeamsDeviceUsageUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamsDeviceUsageUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private LocalDate lastActivityDate;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private Boolean usedWeb;
        private Boolean usedWindowsPhone;
        private Boolean usediOS;
        private Boolean usedMac;
        private Boolean usedAndroidPhone;
        private Boolean usedWindows;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder usedWeb(Boolean usedWeb) {
            this.usedWeb = usedWeb;
            this.changedFields = changedFields.add("usedWeb");
            return this;
        }

        public Builder usedWindowsPhone(Boolean usedWindowsPhone) {
            this.usedWindowsPhone = usedWindowsPhone;
            this.changedFields = changedFields.add("usedWindowsPhone");
            return this;
        }

        public Builder usediOS(Boolean usediOS) {
            this.usediOS = usediOS;
            this.changedFields = changedFields.add("usediOS");
            return this;
        }

        public Builder usedMac(Boolean usedMac) {
            this.usedMac = usedMac;
            this.changedFields = changedFields.add("usedMac");
            return this;
        }

        public Builder usedAndroidPhone(Boolean usedAndroidPhone) {
            this.usedAndroidPhone = usedAndroidPhone;
            this.changedFields = changedFields.add("usedAndroidPhone");
            return this;
        }

        public Builder usedWindows(Boolean usedWindows) {
            this.usedWindows = usedWindows;
            this.changedFields = changedFields.add("usedWindows");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public TeamsDeviceUsageUserDetail build() {
            TeamsDeviceUsageUserDetail _x = new TeamsDeviceUsageUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamsDeviceUsageUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.lastActivityDate = lastActivityDate;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.usedWeb = usedWeb;
            _x.usedWindowsPhone = usedWindowsPhone;
            _x.usediOS = usediOS;
            _x.usedMac = usedMac;
            _x.usedAndroidPhone = usedAndroidPhone;
            _x.usedWindows = usedWindows;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public TeamsDeviceUsageUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public TeamsDeviceUsageUserDetail withUserPrincipalName(String userPrincipalName) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public TeamsDeviceUsageUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public TeamsDeviceUsageUserDetail withIsDeleted(Boolean isDeleted) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public TeamsDeviceUsageUserDetail withDeletedDate(LocalDate deletedDate) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="usedWeb")
    @JsonIgnore
    public Optional<Boolean> getUsedWeb() {
        return Optional.ofNullable(usedWeb);
    }

    public TeamsDeviceUsageUserDetail withUsedWeb(Boolean usedWeb) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWeb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usedWeb = usedWeb;
        return _x;
    }

    @Property(name="usedWindowsPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedWindowsPhone() {
        return Optional.ofNullable(usedWindowsPhone);
    }

    public TeamsDeviceUsageUserDetail withUsedWindowsPhone(Boolean usedWindowsPhone) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWindowsPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usedWindowsPhone = usedWindowsPhone;
        return _x;
    }

    @Property(name="usediOS")
    @JsonIgnore
    public Optional<Boolean> getUsediOS() {
        return Optional.ofNullable(usediOS);
    }

    public TeamsDeviceUsageUserDetail withUsediOS(Boolean usediOS) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usediOS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usediOS = usediOS;
        return _x;
    }

    @Property(name="usedMac")
    @JsonIgnore
    public Optional<Boolean> getUsedMac() {
        return Optional.ofNullable(usedMac);
    }

    public TeamsDeviceUsageUserDetail withUsedMac(Boolean usedMac) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedMac");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usedMac = usedMac;
        return _x;
    }

    @Property(name="usedAndroidPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedAndroidPhone() {
        return Optional.ofNullable(usedAndroidPhone);
    }

    public TeamsDeviceUsageUserDetail withUsedAndroidPhone(Boolean usedAndroidPhone) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedAndroidPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usedAndroidPhone = usedAndroidPhone;
        return _x;
    }

    @Property(name="usedWindows")
    @JsonIgnore
    public Optional<Boolean> getUsedWindows() {
        return Optional.ofNullable(usedWindows);
    }

    public TeamsDeviceUsageUserDetail withUsedWindows(Boolean usedWindows) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWindows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.usedWindows = usedWindows;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public TeamsDeviceUsageUserDetail withReportPeriod(String reportPeriod) {
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsDeviceUsageUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsDeviceUsageUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TeamsDeviceUsageUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TeamsDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TeamsDeviceUsageUserDetail _copy() {
        TeamsDeviceUsageUserDetail _x = new TeamsDeviceUsageUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.lastActivityDate = lastActivityDate;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.usedWeb = usedWeb;
        _x.usedWindowsPhone = usedWindowsPhone;
        _x.usediOS = usediOS;
        _x.usedMac = usedMac;
        _x.usedAndroidPhone = usedAndroidPhone;
        _x.usedWindows = usedWindows;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsDeviceUsageUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("usedWeb=");
        b.append(this.usedWeb);
        b.append(", ");
        b.append("usedWindowsPhone=");
        b.append(this.usedWindowsPhone);
        b.append(", ");
        b.append("usediOS=");
        b.append(this.usediOS);
        b.append(", ");
        b.append("usedMac=");
        b.append(this.usedMac);
        b.append(", ");
        b.append("usedAndroidPhone=");
        b.append(this.usedAndroidPhone);
        b.append(", ");
        b.append("usedWindows=");
        b.append(this.usedWindows);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
