package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamDiscoverySettings;
import odata.msgraph.client.beta.complex.TeamFunSettings;
import odata.msgraph.client.beta.complex.TeamGuestSettings;
import odata.msgraph.client.beta.complex.TeamMemberSettings;
import odata.msgraph.client.beta.complex.TeamMessagingSettings;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.entity.collection.request.ChannelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAsyncOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ScheduleRequest;
import odata.msgraph.client.beta.entity.request.TeamsTemplateRequest;
import odata.msgraph.client.beta.enums.ClonableTeamParts;
import odata.msgraph.client.beta.enums.TeamSpecialization;
import odata.msgraph.client.beta.enums.TeamVisibilityType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "internalId", 
    "classification", 
    "specialization", 
    "visibility", 
    "webUrl", 
    "memberSettings", 
    "guestSettings", 
    "messagingSettings", 
    "funSettings", 
    "discoverySettings", 
    "isArchived"})
@JsonInclude(Include.NON_NULL)
public class Team extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.team";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("internalId")
    protected String internalId;

    @JsonProperty("classification")
    protected String classification;

    @JsonProperty("specialization")
    protected TeamSpecialization specialization;

    @JsonProperty("visibility")
    protected TeamVisibilityType visibility;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("memberSettings")
    protected TeamMemberSettings memberSettings;

    @JsonProperty("guestSettings")
    protected TeamGuestSettings guestSettings;

    @JsonProperty("messagingSettings")
    protected TeamMessagingSettings messagingSettings;

    @JsonProperty("funSettings")
    protected TeamFunSettings funSettings;

    @JsonProperty("discoverySettings")
    protected TeamDiscoverySettings discoverySettings;

    @JsonProperty("isArchived")
    protected Boolean isArchived;

    protected Team() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeam() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String internalId;
        private String classification;
        private TeamSpecialization specialization;
        private TeamVisibilityType visibility;
        private String webUrl;
        private TeamMemberSettings memberSettings;
        private TeamGuestSettings guestSettings;
        private TeamMessagingSettings messagingSettings;
        private TeamFunSettings funSettings;
        private TeamDiscoverySettings discoverySettings;
        private Boolean isArchived;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder internalId(String internalId) {
            this.internalId = internalId;
            this.changedFields = changedFields.add("internalId");
            return this;
        }

        public Builder classification(String classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder specialization(TeamSpecialization specialization) {
            this.specialization = specialization;
            this.changedFields = changedFields.add("specialization");
            return this;
        }

        public Builder visibility(TeamVisibilityType visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder memberSettings(TeamMemberSettings memberSettings) {
            this.memberSettings = memberSettings;
            this.changedFields = changedFields.add("memberSettings");
            return this;
        }

        public Builder guestSettings(TeamGuestSettings guestSettings) {
            this.guestSettings = guestSettings;
            this.changedFields = changedFields.add("guestSettings");
            return this;
        }

        public Builder messagingSettings(TeamMessagingSettings messagingSettings) {
            this.messagingSettings = messagingSettings;
            this.changedFields = changedFields.add("messagingSettings");
            return this;
        }

        public Builder funSettings(TeamFunSettings funSettings) {
            this.funSettings = funSettings;
            this.changedFields = changedFields.add("funSettings");
            return this;
        }

        public Builder discoverySettings(TeamDiscoverySettings discoverySettings) {
            this.discoverySettings = discoverySettings;
            this.changedFields = changedFields.add("discoverySettings");
            return this;
        }

        public Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            this.changedFields = changedFields.add("isArchived");
            return this;
        }

        public Team build() {
            Team _x = new Team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.team";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.internalId = internalId;
            _x.classification = classification;
            _x.specialization = specialization;
            _x.visibility = visibility;
            _x.webUrl = webUrl;
            _x.memberSettings = memberSettings;
            _x.guestSettings = guestSettings;
            _x.messagingSettings = messagingSettings;
            _x.funSettings = funSettings;
            _x.discoverySettings = discoverySettings;
            _x.isArchived = isArchived;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Team withDisplayName(String displayName) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Team withDescription(String description) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.description = description;
        return _x;
    }

    @Property(name="internalId")
    @JsonIgnore
    public Optional<String> getInternalId() {
        return Optional.ofNullable(internalId);
    }

    public Team withInternalId(String internalId) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("internalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.internalId = internalId;
        return _x;
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<String> getClassification() {
        return Optional.ofNullable(classification);
    }

    public Team withClassification(String classification) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.classification = classification;
        return _x;
    }

    @Property(name="specialization")
    @JsonIgnore
    public Optional<TeamSpecialization> getSpecialization() {
        return Optional.ofNullable(specialization);
    }

    public Team withSpecialization(TeamSpecialization specialization) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("specialization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.specialization = specialization;
        return _x;
    }

    @Property(name="visibility")
    @JsonIgnore
    public Optional<TeamVisibilityType> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    public Team withVisibility(TeamVisibilityType visibility) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.visibility = visibility;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public Team withWebUrl(String webUrl) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.webUrl = webUrl;
        return _x;
    }

    @Property(name="memberSettings")
    @JsonIgnore
    public Optional<TeamMemberSettings> getMemberSettings() {
        return Optional.ofNullable(memberSettings);
    }

    public Team withMemberSettings(TeamMemberSettings memberSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("memberSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.memberSettings = memberSettings;
        return _x;
    }

    @Property(name="guestSettings")
    @JsonIgnore
    public Optional<TeamGuestSettings> getGuestSettings() {
        return Optional.ofNullable(guestSettings);
    }

    public Team withGuestSettings(TeamGuestSettings guestSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("guestSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.guestSettings = guestSettings;
        return _x;
    }

    @Property(name="messagingSettings")
    @JsonIgnore
    public Optional<TeamMessagingSettings> getMessagingSettings() {
        return Optional.ofNullable(messagingSettings);
    }

    public Team withMessagingSettings(TeamMessagingSettings messagingSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("messagingSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.messagingSettings = messagingSettings;
        return _x;
    }

    @Property(name="funSettings")
    @JsonIgnore
    public Optional<TeamFunSettings> getFunSettings() {
        return Optional.ofNullable(funSettings);
    }

    public Team withFunSettings(TeamFunSettings funSettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("funSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.funSettings = funSettings;
        return _x;
    }

    @Property(name="discoverySettings")
    @JsonIgnore
    public Optional<TeamDiscoverySettings> getDiscoverySettings() {
        return Optional.ofNullable(discoverySettings);
    }

    public Team withDiscoverySettings(TeamDiscoverySettings discoverySettings) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("discoverySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.discoverySettings = discoverySettings;
        return _x;
    }

    @Property(name="isArchived")
    @JsonIgnore
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(isArchived);
    }

    public Team withIsArchived(Boolean isArchived) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("isArchived");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.team");
        _x.isArchived = isArchived;
        return _x;
    }

    @NavigationProperty(name="schedule")
    @JsonIgnore
    public ScheduleRequest getSchedule() {
        return new ScheduleRequest(contextPath.addSegment("schedule"));
    }

    @NavigationProperty(name="group")
    @JsonIgnore
    public GroupRequest getGroup() {
        return new GroupRequest(contextPath.addSegment("group"));
    }

    @NavigationProperty(name="template")
    @JsonIgnore
    public TeamsTemplateRequest getTemplate() {
        return new TeamsTemplateRequest(contextPath.addSegment("template"));
    }

    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"));
    }

    @NavigationProperty(name="owners")
    @JsonIgnore
    public UserCollectionRequest getOwners() {
        return new UserCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"));
    }

    @NavigationProperty(name="channels")
    @JsonIgnore
    public ChannelCollectionRequest getChannels() {
        return new ChannelCollectionRequest(
                        contextPath.addSegment("channels"));
    }

    @NavigationProperty(name="primaryChannel")
    @JsonIgnore
    public ChannelRequest getPrimaryChannel() {
        return new ChannelRequest(contextPath.addSegment("primaryChannel"));
    }

    @NavigationProperty(name="installedApps")
    @JsonIgnore
    public TeamsAppInstallationCollectionRequest getInstalledApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public TeamsAsyncOperationCollectionRequest getOperations() {
        return new TeamsAsyncOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Team _copy() {
        Team _x = new Team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.internalId = internalId;
        _x.classification = classification;
        _x.specialization = specialization;
        _x.visibility = visibility;
        _x.webUrl = webUrl;
        _x.memberSettings = memberSettings;
        _x.guestSettings = guestSettings;
        _x.messagingSettings = messagingSettings;
        _x.funSettings = funSettings;
        _x.discoverySettings = discoverySettings;
        _x.isArchived = isArchived;
        return _x;
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

    @Action(name = "clone")
    @JsonIgnore
    public ActionRequestNoReturn clone(String displayName, String description, String mailNickname, String classification, TeamVisibilityType visibility, ClonableTeamParts partsToClone) {
        Preconditions.checkNotNull(visibility, "visibility cannot be null");
        Preconditions.checkNotNull(partsToClone, "partsToClone cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("classification", "Edm.String", Checks.checkIsAscii(classification))
            .put("visibility", "microsoft.graph.teamVisibilityType", visibility)
            .put("partsToClone", "microsoft.graph.clonableTeamParts", partsToClone)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clone"), _parameters);
    }

    @Action(name = "archive")
    @JsonIgnore
    public ActionRequestNoReturn archive(Boolean shouldSetSpoSiteReadOnlyForMembers) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("shouldSetSpoSiteReadOnlyForMembers", "Edm.Boolean", shouldSetSpoSiteReadOnlyForMembers)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.archive"), _parameters);
    }

    @Action(name = "unarchive")
    @JsonIgnore
    public ActionRequestNoReturn unarchive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unarchive"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Team[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("internalId=");
        b.append(this.internalId);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("specialization=");
        b.append(this.specialization);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("memberSettings=");
        b.append(this.memberSettings);
        b.append(", ");
        b.append("guestSettings=");
        b.append(this.guestSettings);
        b.append(", ");
        b.append("messagingSettings=");
        b.append(this.messagingSettings);
        b.append(", ");
        b.append("funSettings=");
        b.append(this.funSettings);
        b.append(", ");
        b.append("discoverySettings=");
        b.append(this.discoverySettings);
        b.append(", ");
        b.append("isArchived=");
        b.append(this.isArchived);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
