package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.AppManagementLevel;


/**
 * <i>“Policy used to configure detailed management settings targeted to specific
 * security groups”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isAssigned", 
    "targetedAppManagementLevels"})
@JsonInclude(Include.NON_NULL)
public class TargetedManagedAppProtection extends ManagedAppProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.targetedManagedAppProtection";
    }

    @JsonProperty("isAssigned")
    protected Boolean isAssigned;

    @JsonProperty("targetedAppManagementLevels")
    protected AppManagementLevel targetedAppManagementLevels;

    protected TargetedManagedAppProtection() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates if the policy is deployed to any inclusion groups or not.”</i>
     * 
     * @return property isAssigned
     */
    @Property(name="isAssigned")
    @JsonIgnore
    public Optional<Boolean> getIsAssigned() {
        return Optional.ofNullable(isAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isAssigned} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if the policy is deployed to any inclusion groups or not.”</i>
     * 
     * @param isAssigned
     *            new value of {@code isAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isAssigned} field changed
     */
    public TargetedManagedAppProtection withIsAssigned(Boolean isAssigned) {
        TargetedManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("isAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppProtection");
        _x.isAssigned = isAssigned;
        return _x;
    }

    /**
     * <i>“The intended app management levels for this policy”</i>
     * 
     * @return property targetedAppManagementLevels
     */
    @Property(name="targetedAppManagementLevels")
    @JsonIgnore
    public Optional<AppManagementLevel> getTargetedAppManagementLevels() {
        return Optional.ofNullable(targetedAppManagementLevels);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedAppManagementLevels} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The intended app management levels for this policy”</i>
     * 
     * @param targetedAppManagementLevels
     *            new value of {@code targetedAppManagementLevels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedAppManagementLevels} field changed
     */
    public TargetedManagedAppProtection withTargetedAppManagementLevels(AppManagementLevel targetedAppManagementLevels) {
        TargetedManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("targetedAppManagementLevels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppProtection");
        _x.targetedAppManagementLevels = targetedAppManagementLevels;
        return _x;
    }

    /**
     * <i>“Navigation property to list of inclusion and exclusion groups to which the
     * policy is deployed.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public TargetedManagedAppPolicyAssignmentCollectionRequest getAssignments() {
        return new TargetedManagedAppPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TargetedManagedAppProtection _copy() {
        TargetedManagedAppProtection _x = new TargetedManagedAppProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
        _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
        _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
        _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
        _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
        _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
        _x.dataBackupBlocked = dataBackupBlocked;
        _x.deviceComplianceRequired = deviceComplianceRequired;
        _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
        _x.saveAsBlocked = saveAsBlocked;
        _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
        _x.pinRequired = pinRequired;
        _x.maximumPinRetries = maximumPinRetries;
        _x.simplePinBlocked = simplePinBlocked;
        _x.minimumPinLength = minimumPinLength;
        _x.pinCharacterSet = pinCharacterSet;
        _x.periodBeforePinReset = periodBeforePinReset;
        _x.allowedDataStorageLocations = allowedDataStorageLocations;
        _x.contactSyncBlocked = contactSyncBlocked;
        _x.printBlocked = printBlocked;
        _x.fingerprintBlocked = fingerprintBlocked;
        _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
        _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
        _x.minimumWarningOsVersion = minimumWarningOsVersion;
        _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
        _x.minimumWarningAppVersion = minimumWarningAppVersion;
        _x.minimumWipeOsVersion = minimumWipeOsVersion;
        _x.minimumWipeAppVersion = minimumWipeAppVersion;
        _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
        _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
        _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
        _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
        _x.notificationRestriction = notificationRestriction;
        _x.previousPinBlockCount = previousPinBlockCount;
        _x.managedBrowser = managedBrowser;
        _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
        _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
        _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
        _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
        _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
        _x.dialerRestrictionLevel = dialerRestrictionLevel;
        _x.isAssigned = isAssigned;
        _x.targetedAppManagementLevels = targetedAppManagementLevels;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<TargetedManagedAppPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.targetedManagedAppPolicyAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TargetedManagedAppProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("periodOfflineBeforeAccessCheck=");
        b.append(this.periodOfflineBeforeAccessCheck);
        b.append(", ");
        b.append("periodOnlineBeforeAccessCheck=");
        b.append(this.periodOnlineBeforeAccessCheck);
        b.append(", ");
        b.append("allowedInboundDataTransferSources=");
        b.append(this.allowedInboundDataTransferSources);
        b.append(", ");
        b.append("allowedOutboundDataTransferDestinations=");
        b.append(this.allowedOutboundDataTransferDestinations);
        b.append(", ");
        b.append("organizationalCredentialsRequired=");
        b.append(this.organizationalCredentialsRequired);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingLevel=");
        b.append(this.allowedOutboundClipboardSharingLevel);
        b.append(", ");
        b.append("dataBackupBlocked=");
        b.append(this.dataBackupBlocked);
        b.append(", ");
        b.append("deviceComplianceRequired=");
        b.append(this.deviceComplianceRequired);
        b.append(", ");
        b.append("managedBrowserToOpenLinksRequired=");
        b.append(this.managedBrowserToOpenLinksRequired);
        b.append(", ");
        b.append("saveAsBlocked=");
        b.append(this.saveAsBlocked);
        b.append(", ");
        b.append("periodOfflineBeforeWipeIsEnforced=");
        b.append(this.periodOfflineBeforeWipeIsEnforced);
        b.append(", ");
        b.append("pinRequired=");
        b.append(this.pinRequired);
        b.append(", ");
        b.append("maximumPinRetries=");
        b.append(this.maximumPinRetries);
        b.append(", ");
        b.append("simplePinBlocked=");
        b.append(this.simplePinBlocked);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("pinCharacterSet=");
        b.append(this.pinCharacterSet);
        b.append(", ");
        b.append("periodBeforePinReset=");
        b.append(this.periodBeforePinReset);
        b.append(", ");
        b.append("allowedDataStorageLocations=");
        b.append(this.allowedDataStorageLocations);
        b.append(", ");
        b.append("contactSyncBlocked=");
        b.append(this.contactSyncBlocked);
        b.append(", ");
        b.append("printBlocked=");
        b.append(this.printBlocked);
        b.append(", ");
        b.append("fingerprintBlocked=");
        b.append(this.fingerprintBlocked);
        b.append(", ");
        b.append("disableAppPinIfDevicePinIsSet=");
        b.append(this.disableAppPinIfDevicePinIsSet);
        b.append(", ");
        b.append("minimumRequiredOsVersion=");
        b.append(this.minimumRequiredOsVersion);
        b.append(", ");
        b.append("minimumWarningOsVersion=");
        b.append(this.minimumWarningOsVersion);
        b.append(", ");
        b.append("minimumRequiredAppVersion=");
        b.append(this.minimumRequiredAppVersion);
        b.append(", ");
        b.append("minimumWarningAppVersion=");
        b.append(this.minimumWarningAppVersion);
        b.append(", ");
        b.append("minimumWipeOsVersion=");
        b.append(this.minimumWipeOsVersion);
        b.append(", ");
        b.append("minimumWipeAppVersion=");
        b.append(this.minimumWipeAppVersion);
        b.append(", ");
        b.append("appActionIfDeviceComplianceRequired=");
        b.append(this.appActionIfDeviceComplianceRequired);
        b.append(", ");
        b.append("appActionIfMaximumPinRetriesExceeded=");
        b.append(this.appActionIfMaximumPinRetriesExceeded);
        b.append(", ");
        b.append("pinRequiredInsteadOfBiometricTimeout=");
        b.append(this.pinRequiredInsteadOfBiometricTimeout);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingExceptionLength=");
        b.append(this.allowedOutboundClipboardSharingExceptionLength);
        b.append(", ");
        b.append("notificationRestriction=");
        b.append(this.notificationRestriction);
        b.append(", ");
        b.append("previousPinBlockCount=");
        b.append(this.previousPinBlockCount);
        b.append(", ");
        b.append("managedBrowser=");
        b.append(this.managedBrowser);
        b.append(", ");
        b.append("maximumAllowedDeviceThreatLevel=");
        b.append(this.maximumAllowedDeviceThreatLevel);
        b.append(", ");
        b.append("mobileThreatDefenseRemediationAction=");
        b.append(this.mobileThreatDefenseRemediationAction);
        b.append(", ");
        b.append("blockDataIngestionIntoOrganizationDocuments=");
        b.append(this.blockDataIngestionIntoOrganizationDocuments);
        b.append(", ");
        b.append("allowedDataIngestionLocations=");
        b.append(this.allowedDataIngestionLocations);
        b.append(", ");
        b.append("appActionIfUnableToAuthenticateUser=");
        b.append(this.appActionIfUnableToAuthenticateUser);
        b.append(", ");
        b.append("dialerRestrictionLevel=");
        b.append(this.dialerRestrictionLevel);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("targetedAppManagementLevels=");
        b.append(this.targetedAppManagementLevels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
