package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;
import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentSource;


/**
 * <i>“The type for deployment of groups or apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "target", 
    "source", 
    "sourceId"})
@JsonInclude(Include.NON_NULL)
public class TargetedManagedAppPolicyAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.targetedManagedAppPolicyAssignment";
    }

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    @JsonProperty("source")
    protected DeviceAndAppManagementAssignmentSource source;

    @JsonProperty("sourceId")
    protected String sourceId;

    protected TargetedManagedAppPolicyAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTargetedManagedAppPolicyAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceAndAppManagementAssignmentTarget target;
        private DeviceAndAppManagementAssignmentSource source;
        private String sourceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Identifier for deployment to a group or app”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        /**
         * <i>“Type of resource used for deployment to a group, direct or parcel/policySet”</i>
         * 
         * @param source
         *            value of {@code source} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder source(DeviceAndAppManagementAssignmentSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        /**
         * <i>“Identifier for resource used for deployment to a group”</i>
         * 
         * @param sourceId
         *            value of {@code sourceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        public TargetedManagedAppPolicyAssignment build() {
            TargetedManagedAppPolicyAssignment _x = new TargetedManagedAppPolicyAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.targetedManagedAppPolicyAssignment";
            _x.id = id;
            _x.target = target;
            _x.source = source;
            _x.sourceId = sourceId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Identifier for deployment to a group or app”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier for deployment to a group or app”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public TargetedManagedAppPolicyAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        TargetedManagedAppPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppPolicyAssignment");
        _x.target = target;
        return _x;
    }

    /**
     * <i>“Type of resource used for deployment to a group, direct or parcel/policySet”</i>
     * 
     * @return property source
     */
    @Property(name="source")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentSource> getSource() {
        return Optional.ofNullable(source);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code source} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of resource used for deployment to a group, direct or parcel/policySet”</i>
     * 
     * @param source
     *            new value of {@code source} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code source} field changed
     */
    public TargetedManagedAppPolicyAssignment withSource(DeviceAndAppManagementAssignmentSource source) {
        TargetedManagedAppPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppPolicyAssignment");
        _x.source = source;
        return _x;
    }

    /**
     * <i>“Identifier for resource used for deployment to a group”</i>
     * 
     * @return property sourceId
     */
    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sourceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier for resource used for deployment to a group”</i>
     * 
     * @param sourceId
     *            new value of {@code sourceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sourceId} field changed
     */
    public TargetedManagedAppPolicyAssignment withSourceId(String sourceId) {
        TargetedManagedAppPolicyAssignment _x = _copy();
        _x.changedFields = changedFields.add("sourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppPolicyAssignment");
        _x.sourceId = sourceId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppPolicyAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppPolicyAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppPolicyAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppPolicyAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TargetedManagedAppPolicyAssignment _copy() {
        TargetedManagedAppPolicyAssignment _x = new TargetedManagedAppPolicyAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        _x.source = source;
        _x.sourceId = sourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TargetedManagedAppPolicyAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
