package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyDeploymentSummaryRequest;


/**
 * <i>“Configuration used to deliver a set of custom settings as-is to all users in the
 * targeted security group”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deployedAppCount", 
    "isAssigned"})
@JsonInclude(Include.NON_NULL)
public class TargetedManagedAppConfiguration extends ManagedAppConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.targetedManagedAppConfiguration";
    }

    @JsonProperty("deployedAppCount")
    protected Integer deployedAppCount;

    @JsonProperty("isAssigned")
    protected Boolean isAssigned;

    protected TargetedManagedAppConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTargetedManagedAppConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private List<KeyValuePair> customSettings;
        private String customSettingsNextLink;
        private Integer deployedAppCount;
        private Boolean isAssigned;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder customSettings(List<KeyValuePair> customSettings) {
            this.customSettings = customSettings;
            this.changedFields = changedFields.add("customSettings");
            return this;
        }

        public Builder customSettings(KeyValuePair... customSettings) {
            return customSettings(Arrays.asList(customSettings));
        }

        public Builder customSettingsNextLink(String customSettingsNextLink) {
            this.customSettingsNextLink = customSettingsNextLink;
            this.changedFields = changedFields.add("customSettings");
            return this;
        }

        /**
         * <i>“Count of apps to which the current policy is deployed.”</i>
         * 
         * @param deployedAppCount
         *            value of {@code deployedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedAppCount(Integer deployedAppCount) {
            this.deployedAppCount = deployedAppCount;
            this.changedFields = changedFields.add("deployedAppCount");
            return this;
        }

        /**
         * <i>“Indicates if the policy is deployed to any inclusion groups or not.”</i>
         * 
         * @param isAssigned
         *            value of {@code isAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public TargetedManagedAppConfiguration build() {
            TargetedManagedAppConfiguration _x = new TargetedManagedAppConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.targetedManagedAppConfiguration";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.customSettings = customSettings;
            _x.customSettingsNextLink = customSettingsNextLink;
            _x.deployedAppCount = deployedAppCount;
            _x.isAssigned = isAssigned;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @return property deployedAppCount
     */
    @Property(name="deployedAppCount")
    @JsonIgnore
    public Optional<Integer> getDeployedAppCount() {
        return Optional.ofNullable(deployedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @param deployedAppCount
     *            new value of {@code deployedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedAppCount} field changed
     */
    public TargetedManagedAppConfiguration withDeployedAppCount(Integer deployedAppCount) {
        TargetedManagedAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deployedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppConfiguration");
        _x.deployedAppCount = deployedAppCount;
        return _x;
    }

    /**
     * <i>“Indicates if the policy is deployed to any inclusion groups or not.”</i>
     * 
     * @return property isAssigned
     */
    @Property(name="isAssigned")
    @JsonIgnore
    public Optional<Boolean> getIsAssigned() {
        return Optional.ofNullable(isAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isAssigned} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if the policy is deployed to any inclusion groups or not.”</i>
     * 
     * @param isAssigned
     *            new value of {@code isAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isAssigned} field changed
     */
    public TargetedManagedAppConfiguration withIsAssigned(Boolean isAssigned) {
        TargetedManagedAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetedManagedAppConfiguration");
        _x.isAssigned = isAssigned;
        return _x;
    }

    /**
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @return navigational property apps
     */
    @NavigationProperty(name="apps")
    @JsonIgnore
    public ManagedMobileAppCollectionRequest getApps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"));
    }

    /**
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @return navigational property deploymentSummary
     */
    @NavigationProperty(name="deploymentSummary")
    @JsonIgnore
    public ManagedAppPolicyDeploymentSummaryRequest getDeploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"));
    }

    /**
     * <i>“Navigation property to list of inclusion and exclusion groups to which the
     * policy is deployed.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public TargetedManagedAppPolicyAssignmentCollectionRequest getAssignments() {
        return new TargetedManagedAppPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TargetedManagedAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TargetedManagedAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TargetedManagedAppConfiguration _copy() {
        TargetedManagedAppConfiguration _x = new TargetedManagedAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.customSettings = customSettings;
        _x.deployedAppCount = deployedAppCount;
        _x.isAssigned = isAssigned;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<TargetedManagedAppPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.targetedManagedAppPolicyAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "targetApps")
    @JsonIgnore
    public ActionRequestNoReturn targetApps(List<ManagedMobileApp> apps) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("apps", "Collection(microsoft.graph.managedMobileApp)", apps)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.targetApps"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TargetedManagedAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("customSettings=");
        b.append(this.customSettings);
        b.append(", ");
        b.append("deployedAppCount=");
        b.append(this.deployedAppCount);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
