package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MetadataEntry;
import odata.msgraph.client.beta.entity.request.SynchronizationSchemaRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationId", 
    "default", 
    "description", 
    "discoverable", 
    "factoryTag", 
    "metadata"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationTemplate";
    }

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("default")
    protected Boolean default_;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("discoverable")
    protected Boolean discoverable;

    @JsonProperty("factoryTag")
    protected String factoryTag;

    @JsonProperty("metadata")
    protected List<MetadataEntry> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    protected SynchronizationTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSynchronizationTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String applicationId;
        private Boolean default_;
        private String description;
        private Boolean discoverable;
        private String factoryTag;
        private List<MetadataEntry> metadata;
        private String metadataNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        public Builder default_(Boolean default_) {
            this.default_ = default_;
            this.changedFields = changedFields.add("default");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder discoverable(Boolean discoverable) {
            this.discoverable = discoverable;
            this.changedFields = changedFields.add("discoverable");
            return this;
        }

        public Builder factoryTag(String factoryTag) {
            this.factoryTag = factoryTag;
            this.changedFields = changedFields.add("factoryTag");
            return this;
        }

        public Builder metadata(List<MetadataEntry> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(MetadataEntry... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public SynchronizationTemplate build() {
            SynchronizationTemplate _x = new SynchronizationTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronizationTemplate";
            _x.id = id;
            _x.applicationId = applicationId;
            _x.default_ = default_;
            _x.description = description;
            _x.discoverable = discoverable;
            _x.factoryTag = factoryTag;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    public SynchronizationTemplate withApplicationId(String applicationId) {
        SynchronizationTemplate _x = _copy();
        _x.changedFields = changedFields.add("applicationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationTemplate");
        _x.applicationId = applicationId;
        return _x;
    }

    @Property(name="default")
    @JsonIgnore
    public Optional<Boolean> getDefault() {
        return Optional.ofNullable(default_);
    }

    public SynchronizationTemplate withDefault(Boolean default_) {
        SynchronizationTemplate _x = _copy();
        _x.changedFields = changedFields.add("default");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationTemplate");
        _x.default_ = default_;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SynchronizationTemplate withDescription(String description) {
        SynchronizationTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationTemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="discoverable")
    @JsonIgnore
    public Optional<Boolean> getDiscoverable() {
        return Optional.ofNullable(discoverable);
    }

    public SynchronizationTemplate withDiscoverable(Boolean discoverable) {
        SynchronizationTemplate _x = _copy();
        _x.changedFields = changedFields.add("discoverable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationTemplate");
        _x.discoverable = discoverable;
        return _x;
    }

    @Property(name="factoryTag")
    @JsonIgnore
    public Optional<String> getFactoryTag() {
        return Optional.ofNullable(factoryTag);
    }

    public SynchronizationTemplate withFactoryTag(String factoryTag) {
        SynchronizationTemplate _x = _copy();
        _x.changedFields = changedFields.add("factoryTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationTemplate");
        _x.factoryTag = factoryTag;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata() {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="schema")
    @JsonIgnore
    public SynchronizationSchemaRequest getSchema() {
        return new SynchronizationSchemaRequest(contextPath.addSegment("schema"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SynchronizationTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SynchronizationTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SynchronizationTemplate _copy() {
        SynchronizationTemplate _x = new SynchronizationTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.applicationId = applicationId;
        _x.default_ = default_;
        _x.description = description;
        _x.discoverable = discoverable;
        _x.factoryTag = factoryTag;
        _x.metadata = metadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("default=");
        b.append(this.default_);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discoverable=");
        b.append(this.discoverable);
        b.append(", ");
        b.append("factoryTag=");
        b.append(this.factoryTag);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
