package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.StringKeyStringValuePair;
import odata.msgraph.client.beta.complex.SynchronizationJobApplicationParameters;
import odata.msgraph.client.beta.complex.SynchronizationJobRestartCriteria;
import odata.msgraph.client.beta.complex.SynchronizationSchedule;
import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.complex.SynchronizationStatus;
import odata.msgraph.client.beta.entity.request.SynchronizationSchemaRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "schedule", 
    "status", 
    "templateId", 
    "synchronizationJobSettings"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationJob extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationJob";
    }

    @JsonProperty("schedule")
    protected SynchronizationSchedule schedule;

    @JsonProperty("status")
    protected SynchronizationStatus status;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("synchronizationJobSettings")
    protected List<KeyValuePair> synchronizationJobSettings;

    @JsonProperty("synchronizationJobSettings@nextLink")
    protected String synchronizationJobSettingsNextLink;

    protected SynchronizationJob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSynchronizationJob() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private SynchronizationSchedule schedule;
        private SynchronizationStatus status;
        private String templateId;
        private List<KeyValuePair> synchronizationJobSettings;
        private String synchronizationJobSettingsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder schedule(SynchronizationSchedule schedule) {
            this.schedule = schedule;
            this.changedFields = changedFields.add("schedule");
            return this;
        }

        public Builder status(SynchronizationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public Builder synchronizationJobSettings(List<KeyValuePair> synchronizationJobSettings) {
            this.synchronizationJobSettings = synchronizationJobSettings;
            this.changedFields = changedFields.add("synchronizationJobSettings");
            return this;
        }

        public Builder synchronizationJobSettings(KeyValuePair... synchronizationJobSettings) {
            return synchronizationJobSettings(Arrays.asList(synchronizationJobSettings));
        }

        public Builder synchronizationJobSettingsNextLink(String synchronizationJobSettingsNextLink) {
            this.synchronizationJobSettingsNextLink = synchronizationJobSettingsNextLink;
            this.changedFields = changedFields.add("synchronizationJobSettings");
            return this;
        }

        public SynchronizationJob build() {
            SynchronizationJob _x = new SynchronizationJob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronizationJob";
            _x.id = id;
            _x.schedule = schedule;
            _x.status = status;
            _x.templateId = templateId;
            _x.synchronizationJobSettings = synchronizationJobSettings;
            _x.synchronizationJobSettingsNextLink = synchronizationJobSettingsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="schedule")
    @JsonIgnore
    public Optional<SynchronizationSchedule> getSchedule() {
        return Optional.ofNullable(schedule);
    }

    public SynchronizationJob withSchedule(SynchronizationSchedule schedule) {
        SynchronizationJob _x = _copy();
        _x.changedFields = changedFields.add("schedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJob");
        _x.schedule = schedule;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SynchronizationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SynchronizationJob withStatus(SynchronizationStatus status) {
        SynchronizationJob _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJob");
        _x.status = status;
        return _x;
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public SynchronizationJob withTemplateId(String templateId) {
        SynchronizationJob _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJob");
        _x.templateId = templateId;
        return _x;
    }

    @Property(name="synchronizationJobSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getSynchronizationJobSettings() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, synchronizationJobSettings, Optional.ofNullable(synchronizationJobSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="synchronizationJobSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getSynchronizationJobSettings(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, synchronizationJobSettings, Optional.ofNullable(synchronizationJobSettingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="schema")
    @JsonIgnore
    public SynchronizationSchemaRequest getSchema() {
        return new SynchronizationSchemaRequest(contextPath.addSegment("schema"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationJob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SynchronizationJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SynchronizationJob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SynchronizationJob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SynchronizationJob _copy() {
        SynchronizationJob _x = new SynchronizationJob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.schedule = schedule;
        _x.status = status;
        _x.templateId = templateId;
        _x.synchronizationJobSettings = synchronizationJobSettings;
        return _x;
    }

    @Action(name = "pause")
    @JsonIgnore
    public ActionRequestNoReturn pause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pause"), _parameters);
    }

    @Action(name = "provisionOnDemand")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StringKeyStringValuePair> provisionOnDemand(List<SynchronizationJobApplicationParameters> parameters) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parameters", "Collection(microsoft.graph.synchronizationJobApplicationParameters)", parameters)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StringKeyStringValuePair>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.provisionOnDemand"), StringKeyStringValuePair.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "start")
    @JsonIgnore
    public ActionRequestNoReturn start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), _parameters);
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "restart")
    @JsonIgnore
    public ActionRequestNoReturn restart(SynchronizationJobRestartCriteria criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "microsoft.graph.synchronizationJobRestartCriteria", criteria)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restart"), _parameters);
    }

    @Action(name = "validateCredentials")
    @JsonIgnore
    public ActionRequestNoReturn validateCredentials(String applicationIdentifier, String templateId, Boolean useSavedCredentials, List<SynchronizationSecretKeyStringValuePair> credentials) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("applicationIdentifier", "Edm.String", Checks.checkIsAscii(applicationIdentifier))
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .put("useSavedCredentials", "Edm.Boolean", useSavedCredentials)
            .put("credentials", "Collection(microsoft.graph.synchronizationSecretKeyStringValuePair)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateCredentials"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationJob[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("schedule=");
        b.append(this.schedule);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("synchronizationJobSettings=");
        b.append(this.synchronizationJobSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
