package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationTemplateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "secrets"})
@JsonInclude(Include.NON_NULL)
public class Synchronization extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronization";
    }

    @JsonProperty("secrets")
    protected List<SynchronizationSecretKeyStringValuePair> secrets;

    @JsonProperty("secrets@nextLink")
    protected String secretsNextLink;

    protected Synchronization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSynchronization() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SynchronizationSecretKeyStringValuePair> secrets;
        private String secretsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder secrets(List<SynchronizationSecretKeyStringValuePair> secrets) {
            this.secrets = secrets;
            this.changedFields = changedFields.add("secrets");
            return this;
        }

        public Builder secrets(SynchronizationSecretKeyStringValuePair... secrets) {
            return secrets(Arrays.asList(secrets));
        }

        public Builder secretsNextLink(String secretsNextLink) {
            this.secretsNextLink = secretsNextLink;
            this.changedFields = changedFields.add("secrets");
            return this;
        }

        public Synchronization build() {
            Synchronization _x = new Synchronization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronization";
            _x.id = id;
            _x.secrets = secrets;
            _x.secretsNextLink = secretsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="secrets")
    @JsonIgnore
    public CollectionPage<SynchronizationSecretKeyStringValuePair> getSecrets() {
        return new CollectionPage<SynchronizationSecretKeyStringValuePair>(contextPath, SynchronizationSecretKeyStringValuePair.class, secrets, Optional.ofNullable(secretsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="secrets")
    @JsonIgnore
    public CollectionPage<SynchronizationSecretKeyStringValuePair> getSecrets(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationSecretKeyStringValuePair>(contextPath, SynchronizationSecretKeyStringValuePair.class, secrets, Optional.ofNullable(secretsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="jobs")
    @JsonIgnore
    public SynchronizationJobCollectionRequest getJobs() {
        return new SynchronizationJobCollectionRequest(
                        contextPath.addSegment("jobs"));
    }

    @NavigationProperty(name="templates")
    @JsonIgnore
    public SynchronizationTemplateCollectionRequest getTemplates() {
        return new SynchronizationTemplateCollectionRequest(
                        contextPath.addSegment("templates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Synchronization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Synchronization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Synchronization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Synchronization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Synchronization _copy() {
        Synchronization _x = new Synchronization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.secrets = secrets;
        return _x;
    }

    @Function(name = "Ping")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> ping() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Ping"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Synchronization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("secrets=");
        b.append(this.secrets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
